/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.menu;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.util.AttributeSet;
import android.view.ActionProvider;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mozilla.gecko.R;
import org.mozilla.gecko.menu.GeckoMenuItem;
import org.mozilla.gecko.menu.GeckoSubMenu;
import org.mozilla.gecko.menu.MenuItemActionBar;
import org.mozilla.gecko.menu.MenuItemActionView;
import org.mozilla.gecko.menu.MenuItemDefault;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeckoMenu
extends ListView
implements Menu,
AdapterView.OnItemClickListener,
GeckoMenuItem.OnShowAsActionChangedListener {
    private static final String LOGTAG = "GeckoMenu";
    protected static final int NO_ID = 0;
    private List<GeckoMenuItem> mItems;
    private Map<GeckoMenuItem, View> mActionItems;
    private Callback mCallback;
    private MenuPresenter mMenuPresenter;
    private ActionItemBarPresenter mActionItemBarPresenter;
    private MenuItemsAdapter mAdapter;

    public GeckoMenu(Context context) {
        this(context, null);
    }

    public GeckoMenu(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842868);
    }

    public GeckoMenu(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, -1));
        this.mAdapter = new MenuItemsAdapter();
        this.setAdapter((ListAdapter)this.mAdapter);
        this.setOnItemClickListener(this);
        this.mItems = new ArrayList<GeckoMenuItem>();
        this.mActionItems = new HashMap<GeckoMenuItem, View>();
        this.mActionItemBarPresenter = (DefaultActionItemBar)LayoutInflater.from((Context)context).inflate(R.layout.menu_action_bar, null);
    }

    public MenuItem add(CharSequence charSequence) {
        GeckoMenuItem geckoMenuItem = new GeckoMenuItem(this, 0, 0, charSequence);
        this.addItem(geckoMenuItem);
        return geckoMenuItem;
    }

    public MenuItem add(int n, int n2, int n3, int n4) {
        GeckoMenuItem geckoMenuItem = new GeckoMenuItem(this, n2, n3, n4);
        this.addItem(geckoMenuItem);
        return geckoMenuItem;
    }

    public MenuItem add(int n) {
        GeckoMenuItem geckoMenuItem = new GeckoMenuItem(this, 0, 0, n);
        this.addItem(geckoMenuItem);
        return geckoMenuItem;
    }

    public MenuItem add(int n, int n2, int n3, CharSequence charSequence) {
        GeckoMenuItem geckoMenuItem = new GeckoMenuItem(this, n2, n3, charSequence);
        this.addItem(geckoMenuItem);
        return geckoMenuItem;
    }

    private void addItem(GeckoMenuItem geckoMenuItem) {
        geckoMenuItem.setOnShowAsActionChangedListener(this);
        this.mAdapter.addMenuItem(geckoMenuItem);
        this.mItems.add(geckoMenuItem);
    }

    private void addActionItem(final GeckoMenuItem geckoMenuItem) {
        geckoMenuItem.setOnShowAsActionChangedListener(this);
        if (this.mActionItems.size() == 0 && this.mActionItemBarPresenter instanceof DefaultActionItemBar) {
            this.setAdapter(null);
            this.addHeaderView((View)((DefaultActionItemBar)this.mActionItemBarPresenter));
            this.setAdapter((ListAdapter)this.mAdapter);
        }
        View view = geckoMenuItem.getActionView();
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                GeckoMenu.this.handleMenuItemClick(geckoMenuItem);
            }
        });
        this.mActionItems.put(geckoMenuItem, view);
        this.mActionItemBarPresenter.addActionItem(view);
        this.mItems.add(geckoMenuItem);
    }

    public int addIntentOptions(int n, int n2, int n3, ComponentName componentName, Intent[] intentArray, Intent intent, int n4, MenuItem[] menuItemArray) {
        return 0;
    }

    public SubMenu addSubMenu(int n, int n2, int n3, CharSequence charSequence) {
        MenuItem menuItem = this.add(n, n2, n3, charSequence);
        return this.addSubMenu(menuItem);
    }

    public SubMenu addSubMenu(int n, int n2, int n3, int n4) {
        MenuItem menuItem = this.add(n, n2, n3, n4);
        return this.addSubMenu(menuItem);
    }

    public SubMenu addSubMenu(CharSequence charSequence) {
        MenuItem menuItem = this.add(charSequence);
        return this.addSubMenu(menuItem);
    }

    public SubMenu addSubMenu(int n) {
        MenuItem menuItem = this.add(n);
        return this.addSubMenu(menuItem);
    }

    private SubMenu addSubMenu(MenuItem menuItem) {
        GeckoSubMenu geckoSubMenu = new GeckoSubMenu(this.getContext());
        geckoSubMenu.setMenuItem(menuItem);
        geckoSubMenu.setCallback(this.mCallback);
        geckoSubMenu.setMenuPresenter(this.mMenuPresenter);
        ((GeckoMenuItem)menuItem).setSubMenu(geckoSubMenu);
        return geckoSubMenu;
    }

    public void clear() {
        for (GeckoMenuItem geckoMenuItem : this.mItems) {
            if (!geckoMenuItem.hasSubMenu()) continue;
            geckoMenuItem.getSubMenu().clear();
        }
        this.mAdapter.clear();
        this.mItems.clear();
        this.mActionItems.clear();
    }

    public void close() {
        if (this.mMenuPresenter != null) {
            this.mMenuPresenter.closeMenu();
        }
    }

    private void showMenu(View view) {
        if (this.mMenuPresenter != null) {
            this.mMenuPresenter.showMenu(view);
        }
    }

    public MenuItem findItem(int n) {
        for (GeckoMenuItem geckoMenuItem : this.mItems) {
            SubMenu subMenu;
            MenuItem menuItem;
            if (geckoMenuItem.getItemId() == n) {
                return geckoMenuItem;
            }
            if (!geckoMenuItem.hasSubMenu() || geckoMenuItem.hasActionProvider() || (menuItem = (subMenu = geckoMenuItem.getSubMenu()).findItem(n)) == null) continue;
            return menuItem;
        }
        return null;
    }

    public MenuItem getItem(int n) {
        if (n < this.mItems.size()) {
            return this.mItems.get(n);
        }
        return null;
    }

    public boolean hasVisibleItems() {
        for (GeckoMenuItem geckoMenuItem : this.mItems) {
            if (!geckoMenuItem.isVisible()) continue;
            return true;
        }
        return false;
    }

    public boolean isShortcutKey(int n, KeyEvent keyEvent) {
        return true;
    }

    public boolean performIdentifierAction(int n, int n2) {
        return false;
    }

    public boolean performShortcut(int n, KeyEvent keyEvent, int n2) {
        return false;
    }

    public void removeGroup(int n) {
    }

    public void removeItem(int n) {
        GeckoMenuItem geckoMenuItem = (GeckoMenuItem)this.findItem(n);
        if (geckoMenuItem == null) {
            return;
        }
        for (GeckoMenuItem geckoMenuItem2 : this.mItems) {
            SubMenu subMenu;
            if (!geckoMenuItem2.hasSubMenu() || (subMenu = geckoMenuItem2.getSubMenu()) == null || subMenu.findItem(n) == null) continue;
            subMenu.removeItem(n);
            return;
        }
        if (this.mActionItems.containsKey(geckoMenuItem)) {
            if (this.mActionItemBarPresenter != null) {
                this.mActionItemBarPresenter.removeActionItem(this.mActionItems.get(geckoMenuItem));
            }
            this.mActionItems.remove(geckoMenuItem);
            this.mItems.remove(geckoMenuItem);
            if (this.mActionItems.size() == 0 && this.mActionItemBarPresenter instanceof DefaultActionItemBar) {
                this.setAdapter(null);
                this.removeHeaderView((View)((DefaultActionItemBar)this.mActionItemBarPresenter));
                this.setAdapter((ListAdapter)this.mAdapter);
            }
            return;
        }
        this.mAdapter.removeMenuItem(geckoMenuItem);
        this.mItems.remove(geckoMenuItem);
    }

    public void setGroupCheckable(int n, boolean bl, boolean bl2) {
    }

    public void setGroupEnabled(int n, boolean bl) {
    }

    public void setGroupVisible(int n, boolean bl) {
    }

    public void setQwertyMode(boolean bl) {
    }

    public int size() {
        return this.mItems.size();
    }

    @Override
    public boolean hasActionItemBar() {
        return this.mActionItemBarPresenter != null;
    }

    @Override
    public void onShowAsActionChanged(GeckoMenuItem geckoMenuItem, boolean bl) {
        this.removeItem(geckoMenuItem.getItemId());
        if (bl) {
            this.addActionItem(geckoMenuItem);
        } else {
            this.addItem(geckoMenuItem);
        }
    }

    public void onItemChanged(GeckoMenuItem geckoMenuItem) {
        if (geckoMenuItem.isActionItem()) {
            final MenuItemActionBar menuItemActionBar = (MenuItemActionBar)this.mActionItems.get(geckoMenuItem);
            if (menuItemActionBar != null) {
                final GeckoMenuItem geckoMenuItem2 = geckoMenuItem;
                menuItemActionBar.post(new Runnable(){

                    public void run() {
                        if (geckoMenuItem2.isVisible()) {
                            menuItemActionBar.setVisibility(0);
                            menuItemActionBar.initialize(geckoMenuItem2);
                        } else {
                            menuItemActionBar.setVisibility(8);
                        }
                    }
                });
            }
        } else {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
        GeckoMenuItem geckoMenuItem = this.mAdapter.getItem(n -= this.getHeaderViewsCount());
        this.handleMenuItemClick(geckoMenuItem);
    }

    private void handleMenuItemClick(GeckoMenuItem geckoMenuItem) {
        if (!geckoMenuItem.isEnabled()) {
            return;
        }
        if (geckoMenuItem.invoke()) {
            this.close();
        } else if (geckoMenuItem.hasSubMenu()) {
            GeckoSubMenu geckoSubMenu;
            ActionProvider actionProvider = geckoMenuItem.getActionProvider();
            if (actionProvider != null) {
                geckoSubMenu = new GeckoSubMenu(this.getContext());
                actionProvider.onPrepareSubMenu((SubMenu)geckoSubMenu);
                geckoMenuItem.setSubMenu(geckoSubMenu);
            }
            geckoSubMenu = (GeckoSubMenu)geckoMenuItem.getSubMenu();
            this.showMenu((View)geckoSubMenu);
        } else {
            this.close();
            this.mCallback.onMenuItemSelected(geckoMenuItem);
        }
    }

    public Callback getCallback() {
        return this.mCallback;
    }

    public MenuPresenter getMenuPresenter() {
        return this.mMenuPresenter;
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
        for (GeckoMenuItem geckoMenuItem : this.mItems) {
            if (!geckoMenuItem.hasSubMenu()) continue;
            GeckoSubMenu geckoSubMenu = (GeckoSubMenu)geckoMenuItem.getSubMenu();
            geckoSubMenu.setCallback(this.mCallback);
        }
    }

    public void setMenuPresenter(MenuPresenter menuPresenter) {
        this.mMenuPresenter = menuPresenter;
        for (GeckoMenuItem geckoMenuItem : this.mItems) {
            if (!geckoMenuItem.hasSubMenu()) continue;
            GeckoSubMenu geckoSubMenu = (GeckoSubMenu)geckoMenuItem.getSubMenu();
            geckoSubMenu.setMenuPresenter(this.mMenuPresenter);
        }
    }

    public void setActionItemBarPresenter(ActionItemBarPresenter actionItemBarPresenter) {
        this.mActionItemBarPresenter = actionItemBarPresenter;
    }

    private class MenuItemsAdapter
    extends BaseAdapter {
        private static final int VIEW_TYPE_DEFAULT = 0;
        private static final int VIEW_TYPE_ACTION_MODE = 1;
        private List<GeckoMenuItem> mItems = new ArrayList<GeckoMenuItem>();

        public int getCount() {
            if (this.mItems == null) {
                return 0;
            }
            int n = 0;
            for (GeckoMenuItem geckoMenuItem : this.mItems) {
                if (!geckoMenuItem.isVisible()) continue;
                ++n;
            }
            return n;
        }

        public GeckoMenuItem getItem(int n) {
            for (GeckoMenuItem geckoMenuItem : this.mItems) {
                if (!geckoMenuItem.isVisible() || --n >= 0) continue;
                return geckoMenuItem;
            }
            return null;
        }

        public long getItemId(int n) {
            return n;
        }

        public View getView(int n, View view, ViewGroup viewGroup) {
            GeckoMenuItem geckoMenuItem = this.getItem(n);
            GeckoMenuItem.Layout layout2 = null;
            layout2 = view == null && this.getItemViewType(n) == 0 ? new MenuItemDefault(viewGroup.getContext(), null) : (GeckoMenuItem.Layout)view;
            if (layout2 == null || layout2 instanceof MenuItemActionView) {
                layout2 = (MenuItemActionView)geckoMenuItem.getActionView();
                final View view2 = (View)layout2;
                final int n2 = n;
                final long l = this.getItemId(n);
                ((MenuItemActionView)layout2).setMenuItemClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        GeckoMenu geckoMenu = GeckoMenu.this;
                        geckoMenu.performItemClick(view2, n2 + geckoMenu.getHeaderViewsCount(), l);
                    }
                });
            }
            layout2.initialize(geckoMenuItem);
            return (View)layout2;
        }

        public int getItemViewType(int n) {
            return this.getItem(n).getActionProvider() == null ? 0 : 1;
        }

        public int getViewTypeCount() {
            return 2;
        }

        public boolean hasStableIds() {
            return false;
        }

        public boolean areAllItemsEnabled() {
            for (GeckoMenuItem geckoMenuItem : this.mItems) {
                if (geckoMenuItem.isEnabled()) continue;
                return false;
            }
            return true;
        }

        public boolean isEnabled(int n) {
            return this.getItem(n).isEnabled();
        }

        public void addMenuItem(GeckoMenuItem geckoMenuItem) {
            if (this.mItems.contains(geckoMenuItem)) {
                return;
            }
            int n = 0;
            for (GeckoMenuItem geckoMenuItem2 : this.mItems) {
                if (geckoMenuItem2.getOrder() > geckoMenuItem.getOrder()) {
                    this.mItems.add(n, geckoMenuItem);
                    this.notifyDataSetChanged();
                    return;
                }
                ++n;
            }
            this.mItems.add(geckoMenuItem);
            this.notifyDataSetChanged();
        }

        public void removeMenuItem(GeckoMenuItem geckoMenuItem) {
            this.mItems.remove(geckoMenuItem);
            this.notifyDataSetChanged();
        }

        public void clear() {
            this.mItems.clear();
            this.notifyDataSetChanged();
        }

        public GeckoMenuItem getMenuItem(int n) {
            for (GeckoMenuItem geckoMenuItem : this.mItems) {
                if (geckoMenuItem.getItemId() != n) continue;
                return geckoMenuItem;
            }
            return null;
        }
    }

    public static class DefaultActionItemBar
    extends LinearLayout
    implements ActionItemBarPresenter {
        public DefaultActionItemBar(Context context) {
            super(context);
        }

        public DefaultActionItemBar(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public void addActionItem(View view) {
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(view.getLayoutParams());
            layoutParams.weight = 1.0f;
            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.addView(view);
        }

        public void removeActionItem(View view) {
            this.removeView(view);
        }
    }

    public static interface ActionItemBarPresenter {
        public void addActionItem(View var1);

        public void removeActionItem(View var1);
    }

    public static interface MenuPresenter {
        public void openMenu();

        public void showMenu(View var1);

        public void closeMenu();
    }

    public static interface Callback {
        public boolean onMenuItemSelected(MenuItem var1);
    }
}

