/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.menu;

import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.ActionProvider;
import android.view.ContextMenu;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import org.mozilla.gecko.menu.GeckoMenu;
import org.mozilla.gecko.menu.GeckoSubMenu;
import org.mozilla.gecko.menu.MenuItemActionBar;
import org.mozilla.gecko.widget.GeckoActionProvider;

public class GeckoMenuItem
implements MenuItem {
    private static final String LOGTAG = "GeckoMenuItem";
    private int mId;
    private int mOrder;
    private View mActionView;
    private boolean mActionItem = false;
    private CharSequence mTitle;
    private CharSequence mTitleCondensed;
    private boolean mCheckable = false;
    private boolean mChecked = false;
    private boolean mVisible = true;
    private boolean mEnabled = true;
    private Drawable mIcon;
    private int mIconRes;
    private ActionProvider mActionProvider;
    private GeckoMenu mMenu;
    private GeckoSubMenu mSubMenu;
    private MenuItem.OnMenuItemClickListener mMenuItemClickListener = null;
    private OnShowAsActionChangedListener mShowAsActionChangedListener;

    public GeckoMenuItem(GeckoMenu geckoMenu, int n, int n2, int n3) {
        this.mMenu = geckoMenu;
        this.mId = n;
        this.mOrder = n2;
        this.setTitle(n3);
    }

    public GeckoMenuItem(GeckoMenu geckoMenu, int n, int n2, CharSequence charSequence) {
        this.mMenu = geckoMenu;
        this.mId = n;
        this.mOrder = n2;
        this.setTitle(charSequence);
    }

    public boolean collapseActionView() {
        return false;
    }

    public boolean expandActionView() {
        return false;
    }

    public boolean hasActionProvider() {
        if (Build.VERSION.SDK_INT < 14) {
            return false;
        }
        return this.mActionProvider != null;
    }

    public ActionProvider getActionProvider() {
        return this.mActionProvider;
    }

    public View getActionView() {
        if (this.mActionProvider != null && this.mActionProvider instanceof GeckoActionProvider) {
            return ((GeckoActionProvider)this.mActionProvider).getView();
        }
        return this.mActionView;
    }

    public char getAlphabeticShortcut() {
        return '\u0000';
    }

    public int getGroupId() {
        return 0;
    }

    public Drawable getIcon() {
        if (this.mIcon == null) {
            if (this.mIconRes != 0) {
                return this.mMenu.getResources().getDrawable(this.mIconRes);
            }
            return null;
        }
        return this.mIcon;
    }

    public Intent getIntent() {
        return null;
    }

    public int getItemId() {
        return this.mId;
    }

    public ContextMenu.ContextMenuInfo getMenuInfo() {
        return null;
    }

    public char getNumericShortcut() {
        return '\u0000';
    }

    public int getOrder() {
        return this.mOrder;
    }

    public SubMenu getSubMenu() {
        return this.mSubMenu;
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    public CharSequence getTitleCondensed() {
        return this.mTitleCondensed;
    }

    public boolean hasSubMenu() {
        if (this.mActionProvider != null) {
            return this.mActionProvider.hasSubMenu();
        }
        return this.mSubMenu != null;
    }

    public boolean isActionItem() {
        return this.mActionItem;
    }

    public boolean isActionViewExpanded() {
        return false;
    }

    public boolean isCheckable() {
        return this.mCheckable;
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    public MenuItem setActionProvider(ActionProvider actionProvider) {
        this.mActionProvider = actionProvider;
        if (this.mActionProvider != null && this.mActionProvider instanceof GeckoActionProvider) {
            GeckoActionProvider geckoActionProvider = (GeckoActionProvider)this.mActionProvider;
            geckoActionProvider.setOnTargetSelectedListener(new GeckoActionProvider.OnTargetSelectedListener(){

                public void onTargetSelected() {
                    GeckoMenuItem.this.mMenu.close();
                }
            });
        }
        return this;
    }

    public MenuItem setActionView(int n) {
        return this;
    }

    public MenuItem setActionView(View view) {
        return this;
    }

    public MenuItem setAlphabeticShortcut(char c) {
        return this;
    }

    public MenuItem setCheckable(boolean bl) {
        this.mCheckable = bl;
        this.mMenu.onItemChanged(this);
        return this;
    }

    public MenuItem setChecked(boolean bl) {
        this.mChecked = bl;
        this.mMenu.onItemChanged(this);
        return this;
    }

    public MenuItem setEnabled(boolean bl) {
        this.mEnabled = bl;
        this.mMenu.onItemChanged(this);
        return this;
    }

    public MenuItem setIcon(Drawable drawable2) {
        this.mIcon = drawable2;
        this.mMenu.onItemChanged(this);
        return this;
    }

    public MenuItem setIcon(int n) {
        this.mIconRes = n;
        this.mMenu.onItemChanged(this);
        return this;
    }

    public MenuItem setIntent(Intent intent) {
        return this;
    }

    public MenuItem setNumericShortcut(char c) {
        return this;
    }

    public MenuItem setOnActionExpandListener(MenuItem.OnActionExpandListener onActionExpandListener) {
        return this;
    }

    public MenuItem setOnMenuItemClickListener(MenuItem.OnMenuItemClickListener onMenuItemClickListener) {
        this.mMenuItemClickListener = onMenuItemClickListener;
        return this;
    }

    public MenuItem setShortcut(char c, char c2) {
        return this;
    }

    public void setShowAsAction(int n) {
        if (this.mShowAsActionChangedListener == null) {
            return;
        }
        if (this.mActionItem == n > 0) {
            return;
        }
        if (n > 0) {
            if (!this.mShowAsActionChangedListener.hasActionItemBar()) {
                return;
            }
            MenuItemActionBar menuItemActionBar = new MenuItemActionBar(this.mMenu.getContext(), null);
            menuItemActionBar.initialize(this);
            this.mActionView = menuItemActionBar;
            this.mActionItem = n > 0;
        }
        this.mShowAsActionChangedListener.onShowAsActionChanged(this, this.mActionItem);
    }

    public MenuItem setShowAsActionFlags(int n) {
        return this;
    }

    public MenuItem setSubMenu(GeckoSubMenu geckoSubMenu) {
        this.mSubMenu = geckoSubMenu;
        return this;
    }

    public MenuItem setTitle(CharSequence charSequence) {
        this.mTitle = charSequence;
        this.mMenu.onItemChanged(this);
        return this;
    }

    public MenuItem setTitle(int n) {
        this.mTitle = this.mMenu.getResources().getString(n);
        this.mMenu.onItemChanged(this);
        return this;
    }

    public MenuItem setTitleCondensed(CharSequence charSequence) {
        this.mTitleCondensed = charSequence;
        return this;
    }

    public MenuItem setVisible(boolean bl) {
        this.mVisible = bl;
        this.mMenu.onItemChanged(this);
        return this;
    }

    public boolean invoke() {
        if (this.mMenuItemClickListener != null) {
            return this.mMenuItemClickListener.onMenuItemClick((MenuItem)this);
        }
        return false;
    }

    public void setOnShowAsActionChangedListener(OnShowAsActionChangedListener onShowAsActionChangedListener) {
        this.mShowAsActionChangedListener = onShowAsActionChangedListener;
    }

    public static interface OnShowAsActionChangedListener {
        public boolean hasActionItemBar();

        public void onShowAsActionChanged(GeckoMenuItem var1, boolean var2);
    }

    public static interface Layout {
        public void initialize(GeckoMenuItem var1);
    }
}

