/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.menu;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.ImageButton;
import org.mozilla.gecko.R;
import org.mozilla.gecko.menu.GeckoMenuItem;

public class MenuItemActionBar
extends ImageButton
implements GeckoMenuItem.Layout {
    private static final String LOGTAG = "GeckoMenuItemActionBar";

    public MenuItemActionBar(Context context) {
        this(context, null);
    }

    public MenuItemActionBar(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.menuItemActionBarStyle);
    }

    public MenuItemActionBar(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        int n2 = (int)context.getResources().getDimension(R.dimen.browser_toolbar_height);
        this.setLayoutParams(new ViewGroup.LayoutParams(n2, n2));
    }

    public void initialize(GeckoMenuItem geckoMenuItem) {
        if (geckoMenuItem == null) {
            return;
        }
        this.setIcon(geckoMenuItem.getIcon());
        this.setTitle(geckoMenuItem.getTitle());
        this.setEnabled(geckoMenuItem.isEnabled());
        this.setId(geckoMenuItem.getItemId());
    }

    private void setIcon(Drawable drawable2) {
        if (drawable2 != null) {
            this.setImageDrawable(drawable2);
            this.setVisibility(0);
        } else {
            this.setVisibility(8);
        }
    }

    private void setIcon(int n) {
        if (n != 0) {
            this.setImageResource(n);
            this.setVisibility(0);
        } else {
            this.setVisibility(8);
        }
    }

    private void setTitle(CharSequence charSequence) {
        this.setContentDescription(charSequence);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.setColorFilter(bl ? 0 : -6710887);
    }
}

