/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.menu;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import org.mozilla.gecko.R;
import org.mozilla.gecko.menu.GeckoMenuItem;
import org.mozilla.gecko.menu.MenuItemDefault;

public class MenuItemActionView
extends LinearLayout
implements GeckoMenuItem.Layout {
    private static final String LOGTAG = "GeckoMenuItemActionView";
    private MenuItemDefault mMenuItem;
    private ImageButton mActionButton;

    public MenuItemActionView(Context context) {
        this(context, null);
    }

    public MenuItemActionView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.menuItemActionViewStyle);
    }

    @TargetApi(value=11)
    public MenuItemActionView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        Resources resources = context.getResources();
        int n2 = resources.getDimensionPixelSize(R.dimen.menu_item_row_width);
        int n3 = resources.getDimensionPixelSize(R.dimen.menu_item_row_height);
        this.setMinimumWidth(n2);
        this.setMinimumHeight(n3);
        LayoutInflater.from((Context)context).inflate(R.layout.menu_item_action_view, (ViewGroup)this);
        this.mMenuItem = (MenuItemDefault)this.findViewById(R.id.menu_item);
        this.mActionButton = (ImageButton)this.findViewById(R.id.action_button);
    }

    public void initialize(GeckoMenuItem geckoMenuItem) {
        if (geckoMenuItem == null) {
            return;
        }
        this.setTitle(geckoMenuItem.getTitle());
        this.setIcon(geckoMenuItem.getIcon());
        this.setEnabled(geckoMenuItem.isEnabled());
    }

    private void setIcon(Drawable drawable2) {
        this.mMenuItem.setIcon(drawable2);
    }

    private void setIcon(int n) {
        this.mMenuItem.setIcon(n);
    }

    private void setTitle(CharSequence charSequence) {
        this.mMenuItem.setTitle(charSequence);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.mMenuItem.setEnabled(bl);
        if (this.mActionButton != null) {
            this.mActionButton.setEnabled(bl);
            this.mActionButton.setAlpha(bl ? 255 : 99);
        }
    }

    public void setMenuItemClickListener(View.OnClickListener onClickListener) {
        this.mMenuItem.setOnClickListener(onClickListener);
    }

    public void setActionButtonClickListener(View.OnClickListener onClickListener) {
        this.mActionButton.setOnClickListener(onClickListener);
    }

    public void setActionButton(Drawable drawable2) {
        if (drawable2 != null) {
            this.mActionButton.setImageDrawable(drawable2);
            this.mActionButton.setVisibility(0);
        } else {
            this.mActionButton.setVisibility(8);
        }
    }
}

