/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.menu;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import org.mozilla.gecko.R;

public class MenuPopup
extends PopupWindow {
    private Resources mResources;
    private ImageView mArrowTop;
    private ImageView mArrowBottom;
    private RelativeLayout mPanel;
    private int mYOffset;
    private int mArrowMargin;
    private int mPopupWidth;
    private boolean mShowArrow;

    public MenuPopup(Context context) {
        super(context);
        this.mResources = context.getResources();
        this.setFocusable(true);
        this.mYOffset = this.mResources.getDimensionPixelSize(R.dimen.menu_popup_offset);
        this.mArrowMargin = this.mResources.getDimensionPixelSize(R.dimen.menu_popup_arrow_margin);
        this.mPopupWidth = this.mResources.getDimensionPixelSize(R.dimen.menu_popup_width);
        this.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.setWindowLayoutMode(View.MeasureSpec.makeMeasureSpec((int)this.mPopupWidth, (int)Integer.MIN_VALUE), -2);
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        RelativeLayout relativeLayout = (RelativeLayout)layoutInflater.inflate(R.layout.menu_popup, null);
        this.setContentView((View)relativeLayout);
        this.mArrowTop = (ImageView)relativeLayout.findViewById(R.id.menu_arrow_top);
        this.mArrowBottom = (ImageView)relativeLayout.findViewById(R.id.menu_arrow_bottom);
        this.mPanel = (RelativeLayout)relativeLayout.findViewById(R.id.menu_panel);
        this.mShowArrow = true;
        this.setAnimationStyle(R.style.PopupAnimation);
    }

    public void setPanelView(View view) {
        this.mPanel.removeAllViews();
        this.mPanel.addView(view);
        this.mPanel.measure(-2, -2);
    }

    public void showArrowToAnchor(boolean bl) {
        this.mShowArrow = bl;
    }

    public void showAsDropDown(View view) {
        if (!this.mShowArrow) {
            this.mArrowTop.setVisibility(8);
            this.mArrowBottom.setVisibility(8);
            this.showAsDropDown(view, 0, -this.mYOffset);
            return;
        }
        int[] nArray = new int[2];
        view.getLocationOnScreen(nArray);
        int n = this.mResources.getDisplayMetrics().widthPixels;
        int n2 = this.mResources.getDimensionPixelSize(R.dimen.menu_popup_arrow_width);
        int n3 = (view.getWidth() - n2) / 2;
        if (nArray[0] + this.mPopupWidth <= n) {
            ((RelativeLayout.LayoutParams)this.mArrowTop.getLayoutParams()).rightMargin = this.mPopupWidth - view.getWidth() + n3;
            ((RelativeLayout.LayoutParams)this.mArrowBottom.getLayoutParams()).rightMargin = this.mPopupWidth - view.getWidth() + n3;
        } else {
            ((RelativeLayout.LayoutParams)this.mArrowTop.getLayoutParams()).rightMargin = n - nArray[0] - view.getWidth() / 2 - n2 / 2;
            ((RelativeLayout.LayoutParams)this.mArrowBottom.getLayoutParams()).rightMargin = this.mArrowMargin;
        }
        this.mArrowTop.setVisibility(0);
        this.mArrowBottom.setVisibility(8);
        this.showAsDropDown(view, 0, -this.mYOffset);
    }
}

