/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.preferences;

import android.content.Context;
import android.preference.Preference;
import android.preference.PreferenceCategory;
import android.util.AttributeSet;
import android.util.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.preferences.SearchEnginePreference;
import org.mozilla.gecko.util.GeckoEventListener;

public class SearchPreferenceCategory
extends PreferenceCategory
implements GeckoEventListener {
    public static final String LOGTAG = "SearchPrefCategory";
    private SearchEnginePreference mDefaultEngineReference;

    public SearchPreferenceCategory(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    public SearchPreferenceCategory(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public SearchPreferenceCategory(Context context) {
        super(context);
    }

    protected void onAttachedToActivity() {
        super.onAttachedToActivity();
        this.setOrderingAsAdded(true);
        GeckoAppShell.registerEventListener("SearchEngines:Data", this);
        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("SearchEngines:Get", null));
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        if (string2.equals("SearchEngines:Data")) {
            JSONArray jSONArray;
            GeckoAppShell.unregisterEventListener("SearchEngines:Data", this);
            try {
                jSONArray = jSONObject.getJSONArray("searchEngines");
            }
            catch (JSONException jSONException) {
                Log.e((String)LOGTAG, (String)"Unable to decode search engine data from Gecko.", (Throwable)jSONException);
                return;
            }
            for (int i = 0; i < jSONArray.length(); ++i) {
                try {
                    JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                    String string3 = jSONObject2.getString("name");
                    SearchEnginePreference searchEnginePreference = new SearchEnginePreference(this.getContext(), this);
                    searchEnginePreference.setSearchEngineFromJSON(jSONObject2);
                    searchEnginePreference.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener(){

                        public boolean onPreferenceClick(Preference preference) {
                            SearchEnginePreference searchEnginePreference = (SearchEnginePreference)preference;
                            searchEnginePreference.showDialog();
                            return true;
                        }
                    });
                    this.addPreference(searchEnginePreference);
                    if (i != 0) continue;
                    searchEnginePreference.setIsDefaultEngine(true);
                    this.mDefaultEngineReference = searchEnginePreference;
                    continue;
                }
                catch (JSONException jSONException) {
                    Log.e((String)LOGTAG, (String)("JSONException parsing engine at index " + i), (Throwable)jSONException);
                }
            }
        }
    }

    private void setFallbackDefaultEngine() {
        if (this.getPreferenceCount() > 0) {
            SearchEnginePreference searchEnginePreference = (SearchEnginePreference)this.getPreference(0);
            this.setDefault(searchEnginePreference);
        }
    }

    private void sendGeckoEngineEvent(String string2, SearchEnginePreference searchEnginePreference) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("engine", (Object)searchEnginePreference.getTitle());
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"JSONException creating search engine configuration change message for Gecko.", (Throwable)jSONException);
            return;
        }
        GeckoAppShell.notifyGeckoOfEvent(GeckoEvent.createBroadcastEvent(string2, jSONObject.toString()));
    }

    public void uninstall(SearchEnginePreference searchEnginePreference) {
        this.removePreference(searchEnginePreference);
        if (searchEnginePreference == this.mDefaultEngineReference) {
            this.setFallbackDefaultEngine();
        }
        this.sendGeckoEngineEvent("SearchEngines:Remove", searchEnginePreference);
    }

    public void setDefault(SearchEnginePreference searchEnginePreference) {
        searchEnginePreference.setIsDefaultEngine(true);
        this.mDefaultEngineReference.setIsDefaultEngine(false);
        this.mDefaultEngineReference = searchEnginePreference;
        this.sendGeckoEngineEvent("SearchEngines:SetDefault", searchEnginePreference);
    }
}

