/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync;

import android.content.SharedPreferences;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.CryptoRecord;
import org.mozilla.gecko.sync.MetaGlobal;

public class PersistedMetaGlobal {
    public static final String LOG_TAG = "PersistedMetaGlobal";
    public static final String META_GLOBAL_SERVER_RESPONSE_BODY = "metaGlobalServerResponseBody";
    public static final String META_GLOBAL_LAST_MODIFIED = "metaGlobalLastModified";
    protected SharedPreferences prefs;

    public PersistedMetaGlobal(SharedPreferences sharedPreferences) {
        this.prefs = sharedPreferences;
    }

    public MetaGlobal metaGlobal(String string2, String string3) {
        String string4 = this.prefs.getString(META_GLOBAL_SERVER_RESPONSE_BODY, null);
        if (string4 == null) {
            return null;
        }
        MetaGlobal metaGlobal = null;
        try {
            CryptoRecord cryptoRecord = CryptoRecord.fromJSONRecord(string4);
            MetaGlobal metaGlobal2 = new MetaGlobal(string2, string3);
            metaGlobal2.setFromRecord(cryptoRecord);
            metaGlobal = metaGlobal2;
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception decrypting persisted meta/global.", exception);
        }
        return metaGlobal;
    }

    public void persistMetaGlobal(MetaGlobal metaGlobal) {
        if (metaGlobal == null) {
            Logger.debug(LOG_TAG, "Clearing persisted meta/global.");
            this.prefs.edit().remove(META_GLOBAL_SERVER_RESPONSE_BODY).commit();
            return;
        }
        try {
            CryptoRecord cryptoRecord = metaGlobal.asCryptoRecord();
            String string2 = cryptoRecord.toJSONString();
            Logger.debug(LOG_TAG, "Persisting meta/global.");
            this.prefs.edit().putString(META_GLOBAL_SERVER_RESPONSE_BODY, string2).commit();
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception encrypting while persisting meta/global.", exception);
        }
    }

    public long lastModified() {
        return this.prefs.getLong(META_GLOBAL_LAST_MODIFIED, -1L);
    }

    public void persistLastModified(long l) {
        if (l <= 0L) {
            Logger.debug(LOG_TAG, "Clearing persisted meta/global last modified timestamp.");
            this.prefs.edit().remove(META_GLOBAL_LAST_MODIFIED).commit();
            return;
        }
        Logger.debug(LOG_TAG, "Persisting meta/global last modified timestamp " + l + ".");
        this.prefs.edit().putLong(META_GLOBAL_LAST_MODIFIED, l).commit();
    }

    public void purge() {
        this.persistLastModified(-1L);
        this.persistMetaGlobal(null);
    }
}

