/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync;

import android.content.SharedPreferences;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.CollectionKeys;
import org.mozilla.gecko.sync.CredentialsSource;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.InfoCollections;
import org.mozilla.gecko.sync.MetaGlobal;
import org.mozilla.gecko.sync.PersistedMetaGlobal;
import org.mozilla.gecko.sync.PrefsSource;
import org.mozilla.gecko.sync.crypto.KeyBundle;
import org.mozilla.gecko.sync.crypto.PersistedCrypto5Keys;
import org.mozilla.gecko.sync.stage.GlobalSyncStage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncConfiguration
implements CredentialsSource {
    public static final String DEFAULT_USER_API = "https://auth.services.mozilla.com/user/1.0/";
    private static final String LOG_TAG = "SyncConfiguration";
    public String userAPI;
    public URI serverURL;
    public URI clusterURL;
    public String username;
    public KeyBundle syncKeyBundle;
    public CollectionKeys collectionKeys;
    public InfoCollections infoCollections;
    public MetaGlobal metaGlobal;
    public String password;
    public String syncID;
    public Set<String> enabledEngineNames;
    public Collection<String> stagesToSync;
    public Map<String, Boolean> userSelectedEngines;
    public long userSelectedEnginesTimestamp;
    public String prefsPath;
    public PrefsSource prefsSource;
    public static final String PREF_PREFS_VERSION = "prefs.version";
    public static final long CURRENT_PREFS_VERSION = 1L;
    public static final String CLIENTS_COLLECTION_TIMESTAMP = "serverClientsTimestamp";
    public static final String CLIENT_RECORD_TIMESTAMP = "serverClientRecordTimestamp";
    public static final String PREF_CLUSTER_URL = "clusterURL";
    public static final String PREF_SYNC_ID = "syncID";
    public static final String PREF_ENABLED_ENGINE_NAMES = "enabledEngineNames";
    public static final String PREF_USER_SELECTED_ENGINES_TO_SYNC = "userSelectedEngines";
    public static final String PREF_USER_SELECTED_ENGINES_TO_SYNC_TIMESTAMP = "userSelectedEnginesTimestamp";
    public static final String PREF_EARLIEST_NEXT_SYNC = "earliestnextsync";
    public static final String PREF_CLUSTER_URL_IS_STALE = "clusterurlisstale";
    public static final String PREF_ACCOUNT_GUID = "account.guid";
    public static final String PREF_CLIENT_NAME = "account.clientName";
    public static final String PREF_NUM_CLIENTS = "account.numClients";

    public SyncConfiguration(String string2, PrefsSource prefsSource) {
        this.prefsPath = string2;
        this.prefsSource = prefsSource;
        this.loadFromPrefs(this.getPrefs());
    }

    public SharedPreferences getPrefs() {
        Logger.trace(LOG_TAG, "Returning prefs for " + this.prefsPath);
        return this.prefsSource.getPrefs(this.prefsPath, 0);
    }

    public static Set<String> validEngineNames() {
        HashSet<String> hashSet = new HashSet<String>();
        for (GlobalSyncStage.Stage stage : GlobalSyncStage.Stage.getNamedStages()) {
            hashSet.add(stage.getRepositoryName());
        }
        return hashSet;
    }

    public ConfigurationBranch getBranch(String string2) {
        return new ConfigurationBranch(this, string2);
    }

    public static Set<String> getEnabledEngineNames(SharedPreferences sharedPreferences) {
        String string2 = sharedPreferences.getString(PREF_ENABLED_ENGINE_NAMES, null);
        if (string2 == null) {
            return null;
        }
        try {
            ExtendedJSONObject extendedJSONObject = ExtendedJSONObject.parseJSONObject(string2);
            return new HashSet<String>(extendedJSONObject.keySet());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Map<String, Boolean> getUserSelectedEngines(SharedPreferences sharedPreferences) {
        String string2 = sharedPreferences.getString(PREF_USER_SELECTED_ENGINES_TO_SYNC, null);
        if (string2 == null) {
            return null;
        }
        try {
            ExtendedJSONObject extendedJSONObject = ExtendedJSONObject.parseJSONObject(string2);
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            for (Map.Entry<String, Object> entry : extendedJSONObject.entrySet()) {
                String string3 = entry.getKey();
                Boolean bl = (Boolean)entry.getValue();
                hashMap.put(string3, bl);
                if (!"history".equals(string3)) continue;
                hashMap.put("forms", bl);
            }
            if (!hashMap.containsKey("history")) {
                hashMap.remove("forms");
            }
            return hashMap;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void storeSelectedEnginesToPrefs(SharedPreferences sharedPreferences, Map<String, Boolean> map) {
        ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
        for (Map.Entry<String, Boolean> entry : map.entrySet()) {
            extendedJSONObject.put(entry.getKey(), entry.getValue());
        }
        String string2 = extendedJSONObject.toJSONString();
        long l = System.currentTimeMillis();
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(PREF_USER_SELECTED_ENGINES_TO_SYNC, string2);
        editor.putLong(PREF_USER_SELECTED_ENGINES_TO_SYNC_TIMESTAMP, l);
        Logger.error(LOG_TAG, "Storing user-selected engines at [" + l + "].");
        editor.commit();
    }

    public void loadFromPrefs(SharedPreferences sharedPreferences) {
        if (sharedPreferences.contains(PREF_CLUSTER_URL)) {
            String string2 = sharedPreferences.getString(PREF_CLUSTER_URL, null);
            try {
                this.clusterURL = new URI(string2);
                Logger.trace(LOG_TAG, "Set clusterURL from bundle: " + string2);
            }
            catch (URISyntaxException uRISyntaxException) {
                Logger.warn(LOG_TAG, "Ignoring bundle clusterURL (" + string2 + "): invalid URI.", uRISyntaxException);
            }
        }
        if (sharedPreferences.contains(PREF_SYNC_ID)) {
            this.syncID = sharedPreferences.getString(PREF_SYNC_ID, null);
            Logger.trace(LOG_TAG, "Set syncID from bundle: " + this.syncID);
        }
        this.enabledEngineNames = SyncConfiguration.getEnabledEngineNames(sharedPreferences);
        this.userSelectedEngines = SyncConfiguration.getUserSelectedEngines(sharedPreferences);
        this.userSelectedEnginesTimestamp = sharedPreferences.getLong(PREF_USER_SELECTED_ENGINES_TO_SYNC_TIMESTAMP, 0L);
    }

    public void persistToPrefs() {
        this.persistToPrefs(this.getPrefs());
    }

    public void persistToPrefs(SharedPreferences sharedPreferences) {
        SharedPreferences.Editor editor = sharedPreferences.edit();
        if (this.clusterURL == null) {
            editor.remove(PREF_CLUSTER_URL);
        } else {
            editor.putString(PREF_CLUSTER_URL, this.clusterURL.toASCIIString());
        }
        if (this.syncID != null) {
            editor.putString(PREF_SYNC_ID, this.syncID);
        }
        if (this.enabledEngineNames == null) {
            editor.remove(PREF_ENABLED_ENGINE_NAMES);
        } else {
            ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
            for (String string2 : this.enabledEngineNames) {
                extendedJSONObject.put(string2, 0);
            }
            editor.putString(PREF_ENABLED_ENGINE_NAMES, extendedJSONObject.toJSONString());
        }
        if (this.userSelectedEngines == null) {
            editor.remove(PREF_USER_SELECTED_ENGINES_TO_SYNC);
            editor.remove(PREF_USER_SELECTED_ENGINES_TO_SYNC_TIMESTAMP);
        }
        editor.commit();
    }

    @Override
    public String credentials() {
        return this.username + ":" + this.password;
    }

    public CollectionKeys getCollectionKeys() {
        return this.collectionKeys;
    }

    public void setCollectionKeys(CollectionKeys collectionKeys) {
        this.collectionKeys = collectionKeys;
    }

    public String nodeWeaveURL() {
        return this.nodeWeaveURL(this.serverURL == null ? null : this.serverURL.toASCIIString());
    }

    public String nodeWeaveURL(String string2) {
        String string3 = this.username + "/node/weave";
        if (string2 == null) {
            return DEFAULT_USER_API + string3;
        }
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        return string2 + "user/1.0/" + string3;
    }

    protected String infoBaseURL() {
        return this.clusterURL + "1.1" + "/" + this.username + "/info/";
    }

    public String infoCollectionsURL() {
        return this.infoBaseURL() + "collections";
    }

    public String infoCollectionCountsURL() {
        return this.infoBaseURL() + "collection_counts";
    }

    public String metaURL() {
        return this.clusterURL + "1.1" + "/" + this.username + "/storage/meta/global";
    }

    public String storageURL(boolean bl) {
        return this.clusterURL + "1.1" + "/" + this.username + (bl ? "/storage/" : "/storage");
    }

    public URI collectionURI(String string2) throws URISyntaxException {
        return new URI(this.storageURL(true) + string2);
    }

    public URI collectionURI(String string2, boolean bl) throws URISyntaxException {
        CharSequence charSequence;
        boolean bl2 = bl;
        String string3 = "";
        if (bl2) {
            charSequence = new StringBuilder("?");
            if (bl) {
                charSequence.append("full=1");
            }
            string3 = charSequence.toString();
        }
        charSequence = this.storageURL(true) + string2 + string3;
        return new URI((String)charSequence);
    }

    public URI wboURI(String string2, String string3) throws URISyntaxException {
        return new URI(this.storageURL(true) + string2 + "/" + string3);
    }

    public URI keysURI() throws URISyntaxException {
        return this.wboURI("crypto", "keys");
    }

    public URI getClusterURL() {
        return this.clusterURL;
    }

    public String getClusterURLString() {
        if (this.clusterURL == null) {
            return null;
        }
        return this.clusterURL.toASCIIString();
    }

    protected void setAndPersistClusterURL(URI uRI, SharedPreferences sharedPreferences) {
        boolean bl = sharedPreferences != null && this.clusterURL == null;
        Logger.trace(LOG_TAG, "Setting cluster URL to " + uRI.toASCIIString() + (bl ? ". Persisting." : ". Not persisting."));
        this.clusterURL = uRI;
        if (bl) {
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString(PREF_CLUSTER_URL, this.clusterURL.toASCIIString());
            editor.commit();
        }
    }

    protected void setClusterURL(URI uRI, SharedPreferences sharedPreferences) {
        if (uRI == null) {
            Logger.warn(LOG_TAG, "Refusing to set cluster URL to null.");
            return;
        }
        URI uRI2 = uRI.normalize();
        if (uRI2.toASCIIString().endsWith("/")) {
            this.setAndPersistClusterURL(uRI, sharedPreferences);
            return;
        }
        this.setAndPersistClusterURL(uRI2.resolve("/"), sharedPreferences);
        Logger.trace(LOG_TAG, "Set cluster URL to " + this.clusterURL.toASCIIString() + ", given input " + uRI.toASCIIString());
    }

    public void setClusterURL(URI uRI) {
        this.setClusterURL(uRI, this.getPrefs());
    }

    public SharedPreferences.Editor getEditor() {
        return this.getPrefs().edit();
    }

    public void persistServerClientRecordTimestamp(long l) {
        this.getEditor().putLong(CLIENT_RECORD_TIMESTAMP, l).commit();
    }

    public long getPersistedServerClientRecordTimestamp() {
        return this.getPrefs().getLong(CLIENT_RECORD_TIMESTAMP, 0L);
    }

    public void persistServerClientsTimestamp(long l) {
        this.getEditor().putLong(CLIENTS_COLLECTION_TIMESTAMP, l).commit();
    }

    public long getPersistedServerClientsTimestamp() {
        return this.getPrefs().getLong(CLIENTS_COLLECTION_TIMESTAMP, 0L);
    }

    public void purgeCryptoKeys() {
        if (this.collectionKeys != null) {
            this.collectionKeys.clear();
        }
        this.persistedCryptoKeys().purge();
    }

    public void purgeMetaGlobal() {
        this.metaGlobal = null;
        this.persistedMetaGlobal().purge();
    }

    public PersistedCrypto5Keys persistedCryptoKeys() {
        return new PersistedCrypto5Keys(this.getPrefs(), this.syncKeyBundle);
    }

    public PersistedMetaGlobal persistedMetaGlobal() {
        return new PersistedMetaGlobal(this.getPrefs());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ConfigurationBranch
    implements SharedPreferences {
        private SyncConfiguration config;
        private String prefix;

        public ConfigurationBranch(SyncConfiguration syncConfiguration2, String string2) {
            if (!string2.endsWith(".")) {
                throw new IllegalArgumentException("No trailing period in prefix.");
            }
            this.config = syncConfiguration2;
            this.prefix = string2;
        }

        public boolean contains(String string2) {
            return this.config.getPrefs().contains(this.prefix + string2);
        }

        public SharedPreferences.Editor edit() {
            return new EditorBranch(this.config, this.prefix);
        }

        public Map<String, ?> getAll() {
            return null;
        }

        public boolean getBoolean(String string2, boolean bl) {
            return this.config.getPrefs().getBoolean(this.prefix + string2, bl);
        }

        public float getFloat(String string2, float f) {
            return this.config.getPrefs().getFloat(this.prefix + string2, f);
        }

        public int getInt(String string2, int n) {
            return this.config.getPrefs().getInt(this.prefix + string2, n);
        }

        public long getLong(String string2, long l) {
            return this.config.getPrefs().getLong(this.prefix + string2, l);
        }

        public String getString(String string2, String string3) {
            return this.config.getPrefs().getString(this.prefix + string2, string3);
        }

        public Set<String> getStringSet(String string2, Set<String> set) {
            throw new RuntimeException("getStringSet not available.");
        }

        public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener onSharedPreferenceChangeListener) {
            this.config.getPrefs().registerOnSharedPreferenceChangeListener(onSharedPreferenceChangeListener);
        }

        public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener onSharedPreferenceChangeListener) {
            this.config.getPrefs().unregisterOnSharedPreferenceChangeListener(onSharedPreferenceChangeListener);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EditorBranch
    implements SharedPreferences.Editor {
        private String prefix;
        private SharedPreferences.Editor editor;

        public EditorBranch(SyncConfiguration syncConfiguration2, String string2) {
            if (!string2.endsWith(".")) {
                throw new IllegalArgumentException("No trailing period in prefix.");
            }
            this.prefix = string2;
            this.editor = syncConfiguration2.getEditor();
        }

        public void apply() {
            this.editor.commit();
        }

        public SharedPreferences.Editor clear() {
            this.editor = this.editor.clear();
            return this;
        }

        public boolean commit() {
            return this.editor.commit();
        }

        public SharedPreferences.Editor putBoolean(String string2, boolean bl) {
            this.editor = this.editor.putBoolean(this.prefix + string2, bl);
            return this;
        }

        public SharedPreferences.Editor putFloat(String string2, float f) {
            this.editor = this.editor.putFloat(this.prefix + string2, f);
            return this;
        }

        public SharedPreferences.Editor putInt(String string2, int n) {
            this.editor = this.editor.putInt(this.prefix + string2, n);
            return this;
        }

        public SharedPreferences.Editor putLong(String string2, long l) {
            this.editor = this.editor.putLong(this.prefix + string2, l);
            return this;
        }

        public SharedPreferences.Editor putString(String string2, String string3) {
            this.editor = this.editor.putString(this.prefix + string2, string3);
            return this;
        }

        public SharedPreferences.Editor putStringSet(String string2, Set<String> set) {
            throw new RuntimeException("putStringSet not available.");
        }

        public SharedPreferences.Editor remove(String string2) {
            this.editor = this.editor.remove(this.prefix + string2);
            return this;
        }
    }
}

