/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.config;

import java.net.URI;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.net.BaseResource;
import org.mozilla.gecko.sync.net.SyncStorageRecordRequest;
import org.mozilla.gecko.sync.net.SyncStorageRequestDelegate;
import org.mozilla.gecko.sync.net.SyncStorageResponse;

public class ClientRecordTerminator {
    public static final String LOG_TAG = "ClientRecTerminator";

    protected ClientRecordTerminator() {
    }

    public static void deleteClientRecord(final String string2, final String string3, String string4, final String string5) throws Exception {
        URI uRI = new URI(string4 + "1.1" + "/" + string2 + "/storage/" + "clients" + "/" + string5);
        SyncStorageRecordRequest syncStorageRecordRequest = new SyncStorageRecordRequest(uRI);
        syncStorageRecordRequest.delegate = new SyncStorageRequestDelegate(){

            public String credentials() {
                return string2 + ":" + string3;
            }

            public String ifUnmodifiedSince() {
                return null;
            }

            public void handleRequestSuccess(SyncStorageResponse syncStorageResponse) {
                Logger.info(ClientRecordTerminator.LOG_TAG, "Deleted client record with GUID " + string5 + " from server.");
                BaseResource.consumeEntity(syncStorageResponse);
            }

            public void handleRequestFailure(SyncStorageResponse syncStorageResponse) {
                Logger.warn(ClientRecordTerminator.LOG_TAG, "Failed to delete client record with GUID " + string5 + " from server.");
                try {
                    Logger.warn(ClientRecordTerminator.LOG_TAG, "Server error message was: " + syncStorageResponse.getErrorMessage());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BaseResource.consumeEntity(syncStorageResponse);
            }

            public void handleRequestError(Exception exception) {
                Logger.error(ClientRecordTerminator.LOG_TAG, "Got exception trying to delete client record with GUID " + string5 + " from server; ignoring.", exception);
            }
        };
        syncStorageRecordRequest.delete();
    }
}

