/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.net;

import ch.boye.httpclientandroidlib.conn.ssl.SSLSocketFactory;
import ch.boye.httpclientandroidlib.params.HttpParams;
import java.io.IOException;
import java.net.Socket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import org.mozilla.gecko.background.common.log.Logger;

public class TLSSocketFactory
extends SSLSocketFactory {
    private static final String LOG_TAG = "TLSSocketFactory";
    private static final String[] DEFAULT_CIPHER_SUITES = new String[]{"SSL_RSA_WITH_RC4_128_SHA"};
    private static final String[] DEFAULT_PROTOCOLS = new String[]{"SSLv3", "TLSv1"};
    private static String[] cipherSuites = DEFAULT_CIPHER_SUITES;

    public TLSSocketFactory(SSLContext sSLContext) {
        super(sSLContext);
    }

    public static synchronized void setEnabledCipherSuites(SSLSocket sSLSocket) {
        try {
            sSLSocket.setEnabledCipherSuites(cipherSuites);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            cipherSuites = sSLSocket.getSupportedCipherSuites();
            Logger.warn(LOG_TAG, "Setting enabled cipher suites failed: " + illegalArgumentException.getMessage());
            Logger.warn(LOG_TAG, "Using " + cipherSuites.length + " supported suites.");
            sSLSocket.setEnabledCipherSuites(cipherSuites);
        }
    }

    public Socket createSocket(HttpParams httpParams) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)super.createSocket(httpParams);
        sSLSocket.setEnabledProtocols(DEFAULT_PROTOCOLS);
        TLSSocketFactory.setEnabledCipherSuites(sSLSocket);
        return sSLSocket;
    }
}

