/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.receivers;

import android.accounts.AccountManager;
import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.config.AccountPickler;
import org.mozilla.gecko.sync.config.ClientRecordTerminator;
import org.mozilla.gecko.sync.setup.SyncAccounts;

public class SyncAccountDeletedService
extends IntentService {
    public static final String LOG_TAG = "SyncAccountDeletedService";

    public SyncAccountDeletedService() {
        super(LOG_TAG);
    }

    protected void onHandleIntent(Intent intent) {
        SyncAccounts.SyncAccountParameters syncAccountParameters;
        long l;
        SyncAccountDeletedService syncAccountDeletedService = this;
        long l2 = intent.getLongExtra("version", 0L);
        if (l2 != (l = 1L)) {
            Logger.warn(LOG_TAG, "Intent malformed: version " + l2 + " given but version " + l + "expected. " + "Not cleaning up after deleted Account.");
            return;
        }
        String string2 = intent.getStringExtra("account");
        if (string2 == null) {
            Logger.warn(LOG_TAG, "Intent malformed: no account name given. Not cleaning up after deleted Account.");
            return;
        }
        Logger.info(LOG_TAG, "Sync account named " + string2 + " being removed; " + "deleting saved pickle file '" + "sync.account.json" + "'.");
        SyncAccountDeletedService.deletePickle((Context)syncAccountDeletedService);
        try {
            String string3 = intent.getStringExtra("payload");
            if (string3 == null) {
                Logger.warn(LOG_TAG, "Intent malformed: no payload given. Not deleting client record.");
                return;
            }
            ExtendedJSONObject extendedJSONObject = ExtendedJSONObject.parseJSONObject(string3);
            syncAccountParameters = new SyncAccounts.SyncAccountParameters((Context)syncAccountDeletedService, AccountManager.get((Context)syncAccountDeletedService), extendedJSONObject);
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception fetching account parameters from intent data; not deleting client record.");
            return;
        }
        Logger.info(LOG_TAG, "Account named " + string2 + " being removed; " + "deleting client record from server.");
        SyncAccountDeletedService.deleteClientRecord((Context)syncAccountDeletedService, string2, syncAccountParameters.password, syncAccountParameters.serverURL);
    }

    public static void deletePickle(Context context) {
        try {
            AccountPickler.deletePickle(context, "sync.account.json");
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception deleting saved pickle file; ignoring.", exception);
        }
    }

    public static void deleteClientRecord(Context context, String string2, String string3, String string4) {
        SharedPreferences sharedPreferences;
        String string5;
        try {
            string5 = Utils.usernameFromAccount(string2);
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception deleting client record from server; ignoring.", exception);
            return;
        }
        if (string2 == null || string5 == null || string3 == null || string4 == null) {
            Logger.warn(LOG_TAG, "Account parameters were null; not deleting client record from server.");
            return;
        }
        try {
            sharedPreferences = Utils.getSharedPreferences(context, "org.mozilla.fennec", string5, string4, "default", 1L);
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Caught exception fetching preferences; not deleting client record from server.", exception);
            return;
        }
        String string6 = sharedPreferences.getString("account.guid", null);
        String string7 = sharedPreferences.getString("clusterURL", null);
        sharedPreferences.edit().clear().commit();
        if (string6 == null) {
            Logger.warn(LOG_TAG, "Client GUID was null; not deleting client record from server.");
            return;
        }
        if (string7 == null) {
            Logger.warn(LOG_TAG, "Cluster URL was null; not deleting client record from server.");
            return;
        }
        try {
            ClientRecordTerminator.deleteClientRecord(string5, string3, string7, string6);
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception deleting client record from server; ignoring.", exception);
        }
    }
}

