/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories;

import android.content.Context;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.mozilla.gecko.sync.CredentialsSource;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.repositories.Repository;
import org.mozilla.gecko.sync.repositories.Server11RepositorySession;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionCreationDelegate;

public class Server11Repository
extends Repository {
    private String serverURI;
    private String username;
    protected String collection;
    private String collectionPath;
    private URI collectionPathURI;
    public CredentialsSource credentialsSource;
    public static final String VERSION_PATH_FRAGMENT = "1.1/";

    public Server11Repository(String string2, String string3, String string4, CredentialsSource credentialsSource) throws URISyntaxException {
        this.serverURI = string2;
        this.username = string3;
        this.collection = string4;
        this.collectionPath = this.serverURI + VERSION_PATH_FRAGMENT + this.username + "/storage/" + this.collection;
        this.collectionPathURI = new URI(this.collectionPath);
        this.credentialsSource = credentialsSource;
    }

    public void createSession(RepositorySessionCreationDelegate repositorySessionCreationDelegate, Context context) {
        repositorySessionCreationDelegate.onSessionCreated(new Server11RepositorySession(this));
    }

    public URI collectionURI() {
        return this.collectionPathURI;
    }

    public URI collectionURI(boolean bl, long l, long l2, String string2, String string3) throws URISyntaxException {
        CharSequence charSequence;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            arrayList.add("full=1");
        }
        if (l >= 0L) {
            charSequence = Utils.millisecondsToDecimalSecondsString(l);
            arrayList.add("newer=" + (String)charSequence);
        }
        if (l2 > 0L) {
            arrayList.add("limit=" + l2);
        }
        if (string2 != null) {
            arrayList.add("sort=" + string2);
        }
        if (string3 != null) {
            arrayList.add("ids=" + string3);
        }
        if (arrayList.size() == 0) {
            return this.collectionPathURI;
        }
        charSequence = new StringBuilder();
        int n = 63;
        for (String string4 : arrayList) {
            ((StringBuilder)charSequence).append((char)n);
            n = 38;
            ((StringBuilder)charSequence).append(string4);
        }
        String string5 = this.collectionPath + ((StringBuilder)charSequence).toString();
        return new URI(string5);
    }

    public URI wboURI(String string2) throws URISyntaxException {
        return new URI(this.collectionPath + "/" + string2);
    }

    protected long getDefaultFetchLimit() {
        return -1L;
    }

    protected String getDefaultSort() {
        return null;
    }
}

