/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories;

import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.entity.ContentProducer;
import ch.boye.httpclientandroidlib.entity.EntityTemplate;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.CryptoRecord;
import org.mozilla.gecko.sync.DelayedWorkTracker;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.HTTPFailureException;
import org.mozilla.gecko.sync.Server11PreviousPostFailedException;
import org.mozilla.gecko.sync.Server11RecordPostFailedException;
import org.mozilla.gecko.sync.UnexpectedJSONException;
import org.mozilla.gecko.sync.crypto.KeyBundle;
import org.mozilla.gecko.sync.net.SyncStorageCollectionRequest;
import org.mozilla.gecko.sync.net.SyncStorageRequest;
import org.mozilla.gecko.sync.net.SyncStorageRequestDelegate;
import org.mozilla.gecko.sync.net.SyncStorageResponse;
import org.mozilla.gecko.sync.net.WBOCollectionRequestDelegate;
import org.mozilla.gecko.sync.repositories.InactiveSessionException;
import org.mozilla.gecko.sync.repositories.InvalidSessionTransitionException;
import org.mozilla.gecko.sync.repositories.NoStoreDelegateException;
import org.mozilla.gecko.sync.repositories.Repository;
import org.mozilla.gecko.sync.repositories.RepositorySession;
import org.mozilla.gecko.sync.repositories.Server11Repository;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionBeginDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionFetchRecordsDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionGuidsSinceDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionStoreDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionWipeDelegate;
import org.mozilla.gecko.sync.repositories.domain.Record;

public class Server11RepositorySession
extends RepositorySession {
    private static byte[] recordsStart;
    private static byte[] recordSeparator;
    private static byte[] recordsEnd;
    public static final String LOG_TAG = "Server11Session";
    private static final int UPLOAD_BYTE_THRESHOLD = 0x100000;
    private static final int UPLOAD_ITEM_THRESHOLD = 50;
    private static final int PER_RECORD_OVERHEAD = 2;
    private static final int PER_BATCH_OVERHEAD = 3;
    private Set<SyncStorageCollectionRequest> pending = Collections.synchronizedSet(new HashSet());
    Server11Repository serverRepository;
    AtomicLong uploadTimestamp = new AtomicLong(0L);
    protected Object recordsBufferMonitor = new Object();
    protected ArrayList<byte[]> recordsBuffer = new ArrayList();
    protected ArrayList<String> recordGuidsBuffer = new ArrayList();
    protected int byteCount = 3;
    protected volatile boolean recordUploadFailed;

    public static long getNormalizedTimestamp(SyncStorageResponse syncStorageResponse) {
        long l = -1L;
        try {
            l = syncStorageResponse.normalizedWeaveTimestamp();
        }
        catch (NumberFormatException numberFormatException) {
            Logger.warn(LOG_TAG, "Malformed X-Weave-Timestamp header received.", numberFormatException);
        }
        if (-1L == l) {
            Logger.warn(LOG_TAG, "Computing stand-in timestamp from local clock. Clock drift could cause records to be skipped.");
            l = System.currentTimeMillis();
        }
        return l;
    }

    public void abort() {
        super.abort();
        for (SyncStorageCollectionRequest syncStorageCollectionRequest : this.pending) {
            syncStorageCollectionRequest.abort();
        }
        this.pending.clear();
    }

    private void bumpUploadTimestamp(long l) {
        long l2;
        do {
            if ((l2 = this.uploadTimestamp.get()) <= l) continue;
            return;
        } while (!this.uploadTimestamp.compareAndSet(l2, l));
    }

    public Server11RepositorySession(Repository repository) {
        super(repository);
        this.serverRepository = (Server11Repository)repository;
    }

    private String flattenIDs(String[] stringArray) {
        if (stringArray.length == 0) {
            return "";
        }
        if (stringArray.length == 1) {
            return stringArray[0];
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray) {
            stringBuilder.append(string2);
            stringBuilder.append(",");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    public void guidsSince(long l, RepositorySessionGuidsSinceDelegate repositorySessionGuidsSinceDelegate) {
    }

    protected void fetchWithParameters(long l, long l2, boolean bl, String string2, String string3, RequestFetchDelegateAdapter requestFetchDelegateAdapter) throws URISyntaxException {
        URI uRI = this.serverRepository.collectionURI(bl, l, l2, string2, string3);
        SyncStorageCollectionRequest syncStorageCollectionRequest = new SyncStorageCollectionRequest(uRI);
        syncStorageCollectionRequest.delegate = requestFetchDelegateAdapter;
        requestFetchDelegateAdapter.setRequest(syncStorageCollectionRequest);
        this.pending.add(syncStorageCollectionRequest);
        syncStorageCollectionRequest.get();
    }

    public void fetchSince(long l, long l2, String string2, RepositorySessionFetchRecordsDelegate repositorySessionFetchRecordsDelegate) {
        try {
            this.fetchWithParameters(l, l2, true, string2, null, new RequestFetchDelegateAdapter(repositorySessionFetchRecordsDelegate));
        }
        catch (URISyntaxException uRISyntaxException) {
            repositorySessionFetchRecordsDelegate.onFetchFailed(uRISyntaxException, null);
        }
    }

    public void fetchSince(long l, RepositorySessionFetchRecordsDelegate repositorySessionFetchRecordsDelegate) {
        try {
            long l2 = this.serverRepository.getDefaultFetchLimit();
            String string2 = this.serverRepository.getDefaultSort();
            this.fetchWithParameters(l, l2, true, string2, null, new RequestFetchDelegateAdapter(repositorySessionFetchRecordsDelegate));
        }
        catch (URISyntaxException uRISyntaxException) {
            repositorySessionFetchRecordsDelegate.onFetchFailed(uRISyntaxException, null);
        }
    }

    public void fetchAll(RepositorySessionFetchRecordsDelegate repositorySessionFetchRecordsDelegate) {
        this.fetchSince(-1L, repositorySessionFetchRecordsDelegate);
    }

    public void fetch(String[] stringArray, RepositorySessionFetchRecordsDelegate repositorySessionFetchRecordsDelegate) {
        try {
            String string2 = this.flattenIDs(stringArray);
            this.fetchWithParameters(-1L, -1L, true, "index", string2, new RequestFetchDelegateAdapter(repositorySessionFetchRecordsDelegate));
        }
        catch (URISyntaxException uRISyntaxException) {
            repositorySessionFetchRecordsDelegate.onFetchFailed(uRISyntaxException, null);
        }
    }

    public void wipe(RepositorySessionWipeDelegate repositorySessionWipeDelegate) {
        if (!this.isActive()) {
            repositorySessionWipeDelegate.onWipeFailed(new InactiveSessionException(null));
            return;
        }
    }

    public void store(Record record) throws NoStoreDelegateException {
        if (this.delegate == null) {
            throw new NoStoreDelegateException();
        }
        this.enqueue(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueue(Record record) {
        byte[] byArray = record.toJSONBytes();
        int n = byArray.length;
        Object object = this.recordsBufferMonitor;
        synchronized (object) {
            if (n + this.byteCount > 0x100000 || this.recordsBuffer.size() >= 50) {
                this.flush();
            }
            this.recordsBuffer.add(byArray);
            this.recordGuidsBuffer.add(record.guid);
            this.byteCount += 2 + n;
        }
    }

    protected void flush() {
        if (this.recordsBuffer.size() > 0) {
            ArrayList<byte[]> arrayList = this.recordsBuffer;
            ArrayList<String> arrayList2 = this.recordGuidsBuffer;
            RepositorySessionStoreDelegate repositorySessionStoreDelegate = this.delegate;
            this.storeWorkQueue.execute(new RecordUploadRunnable(repositorySessionStoreDelegate, arrayList, arrayList2, this.byteCount));
            this.recordsBuffer = new ArrayList();
            this.recordGuidsBuffer = new ArrayList();
            this.byteCount = 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeDone() {
        Logger.debug(LOG_TAG, "storeDone().");
        Object object = this.recordsBufferMonitor;
        synchronized (object) {
            this.flush();
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = Server11RepositorySession.this.recordsBufferMonitor;
                    synchronized (object) {
                        long l = Server11RepositorySession.this.uploadTimestamp.get();
                        Logger.debug(Server11RepositorySession.LOG_TAG, "Calling storeDone with " + l);
                        Server11RepositorySession.this.storeDone(l);
                    }
                }
            };
            this.storeWorkQueue.execute(runnable);
        }
    }

    public void begin(RepositorySessionBeginDelegate repositorySessionBeginDelegate) throws InvalidSessionTransitionException {
        this.recordUploadFailed = false;
        super.begin(repositorySessionBeginDelegate);
    }

    static {
        try {
            recordsStart = "[\n".getBytes("UTF-8");
            recordSeparator = ",\n".getBytes("UTF-8");
            recordsEnd = "\n]\n".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RecordUploadRunnable
    implements Runnable,
    SyncStorageRequestDelegate {
        public final String LOG_TAG = "RecordUploadRunnable";
        private ArrayList<byte[]> outgoing;
        private ArrayList<String> outgoingGuids;
        private long byteCount;

        public RecordUploadRunnable(RepositorySessionStoreDelegate repositorySessionStoreDelegate, ArrayList<byte[]> arrayList, ArrayList<String> arrayList2, long l) {
            Logger.debug("RecordUploadRunnable", "Preparing record upload for " + arrayList.size() + " records (" + l + " bytes).");
            this.outgoing = arrayList;
            this.outgoingGuids = arrayList2;
            this.byteCount = l;
        }

        @Override
        public String credentials() {
            return Server11RepositorySession.this.serverRepository.credentialsSource.credentials();
        }

        @Override
        public String ifUnmodifiedSince() {
            return null;
        }

        @Override
        public void handleRequestSuccess(SyncStorageResponse syncStorageResponse) {
            Long l;
            ExtendedJSONObject extendedJSONObject;
            Logger.trace("RecordUploadRunnable", "POST of " + this.outgoing.size() + " records done.");
            try {
                extendedJSONObject = syncStorageResponse.jsonObjectBody();
            }
            catch (Exception exception) {
                Logger.error("RecordUploadRunnable", "Got exception parsing POST success body.", exception);
                this.handleRequestError(exception);
                return;
            }
            if (extendedJSONObject.containsKey("modified")) {
                l = extendedJSONObject.getTimestamp("modified");
                if (l != null) {
                    Logger.trace("RecordUploadRunnable", "POST request success. Modified timestamp: " + l);
                } else {
                    Logger.warn("RecordUploadRunnable", "POST success body contains malformed 'modified': " + extendedJSONObject.toJSONString());
                }
            } else {
                Logger.warn("RecordUploadRunnable", "POST success body does not contain key 'modified': " + extendedJSONObject.toJSONString());
            }
            try {
                Object object;
                l = extendedJSONObject.getArray("success");
                if (l != null && l.size() > 0) {
                    Logger.trace("RecordUploadRunnable", "Successful records: " + l.toString());
                    Iterator iterator = l.iterator();
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        try {
                            Server11RepositorySession.this.delegate.onRecordStoreSucceeded((String)object);
                        }
                        catch (ClassCastException classCastException) {
                            Logger.error("RecordUploadRunnable", "Got exception parsing POST success guid.", classCastException);
                        }
                    }
                    long l2 = Server11RepositorySession.getNormalizedTimestamp(syncStorageResponse);
                    Logger.trace("RecordUploadRunnable", "Passing back upload X-Weave-Timestamp: " + l2);
                    Server11RepositorySession.this.bumpUploadTimestamp(l2);
                }
                l = null;
                ExtendedJSONObject extendedJSONObject2 = extendedJSONObject.getObject("failed");
                if (extendedJSONObject2 != null && extendedJSONObject2.object.size() > 0) {
                    Logger.debug("RecordUploadRunnable", "Failed records: " + extendedJSONObject2.object.toString());
                    object = new Server11RecordPostFailedException();
                    for (String string2 : extendedJSONObject2.keySet()) {
                        Server11RepositorySession.this.delegate.onRecordStoreFailed((Exception)object, string2);
                    }
                }
                extendedJSONObject2 = null;
            }
            catch (UnexpectedJSONException unexpectedJSONException) {
                Logger.error("RecordUploadRunnable", "Got exception processing success/failed in POST success body.", unexpectedJSONException);
                return;
            }
            Logger.debug("RecordUploadRunnable", "POST of " + this.outgoing.size() + " records handled.");
        }

        @Override
        public void handleRequestFailure(SyncStorageResponse syncStorageResponse) {
            this.handleRequestError(new HTTPFailureException(syncStorageResponse));
        }

        @Override
        public void handleRequestError(Exception exception) {
            Logger.warn("RecordUploadRunnable", "Got request error.", exception);
            Server11RepositorySession.this.recordUploadFailed = true;
            ArrayList<String> arrayList = this.outgoingGuids;
            this.outgoingGuids = null;
            for (String string2 : arrayList) {
                Server11RepositorySession.this.delegate.onRecordStoreFailed(exception, string2);
            }
        }

        public ByteArraysEntity getBodyEntity() {
            ByteArraysEntity byteArraysEntity = new ByteArraysEntity(this.outgoing, this.byteCount);
            return byteArraysEntity;
        }

        @Override
        public void run() {
            if (Server11RepositorySession.this.recordUploadFailed) {
                Logger.info("RecordUploadRunnable", "Previous record upload failed.  Failing all records and not retrying.");
                Server11PreviousPostFailedException server11PreviousPostFailedException = new Server11PreviousPostFailedException();
                for (String string2 : this.outgoingGuids) {
                    Server11RepositorySession.this.delegate.onRecordStoreFailed(server11PreviousPostFailedException, string2);
                }
                return;
            }
            if (this.outgoing == null || this.outgoing.size() == 0) {
                Logger.debug("RecordUploadRunnable", "No items: RecordUploadRunnable returning immediately.");
                return;
            }
            URI uRI = Server11RepositorySession.this.serverRepository.collectionURI();
            SyncStorageRequest syncStorageRequest = new SyncStorageRequest(uRI);
            syncStorageRequest.delegate = this;
            ByteArraysEntity byteArraysEntity = this.getBodyEntity();
            syncStorageRequest.post((HttpEntity)byteArraysEntity);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ByteArraysEntity
        extends EntityTemplate {
            private long count;

            public ByteArraysEntity(ArrayList<byte[]> arrayList, long l) {
                super((ContentProducer)new ByteArraysContentProducer(arrayList));
                this.count = l;
                this.setContentType("application/json");
            }

            public long getContentLength() {
                return this.count;
            }

            public boolean isRepeatable() {
                return true;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ByteArraysContentProducer
        implements ContentProducer {
            ArrayList<byte[]> outgoing;

            public ByteArraysContentProducer(ArrayList<byte[]> arrayList) {
                this.outgoing = arrayList;
            }

            public void writeTo(OutputStream outputStream) throws IOException {
                int n = this.outgoing.size();
                outputStream.write(recordsStart);
                outputStream.write(this.outgoing.get(0));
                for (int i = 1; i < n; ++i) {
                    outputStream.write(recordSeparator);
                    outputStream.write(this.outgoing.get(i));
                }
                outputStream.write(recordsEnd);
            }
        }
    }

    public class RequestFetchDelegateAdapter
    extends WBOCollectionRequestDelegate {
        RepositorySessionFetchRecordsDelegate delegate;
        private DelayedWorkTracker workTracker = new DelayedWorkTracker();
        private SyncStorageCollectionRequest request;

        public void setRequest(SyncStorageCollectionRequest syncStorageCollectionRequest) {
            this.request = syncStorageCollectionRequest;
        }

        private void removeRequestFromPending() {
            if (this.request == null) {
                return;
            }
            Server11RepositorySession.this.pending.remove(this.request);
            this.request = null;
        }

        public RequestFetchDelegateAdapter(RepositorySessionFetchRecordsDelegate repositorySessionFetchRecordsDelegate) {
            this.delegate = repositorySessionFetchRecordsDelegate;
        }

        public String credentials() {
            return Server11RepositorySession.this.serverRepository.credentialsSource.credentials();
        }

        public String ifUnmodifiedSince() {
            return null;
        }

        public void handleRequestSuccess(SyncStorageResponse syncStorageResponse) {
            Logger.debug(Server11RepositorySession.LOG_TAG, "Fetch done.");
            this.removeRequestFromPending();
            final long l = Server11RepositorySession.getNormalizedTimestamp(syncStorageResponse);
            Logger.debug(Server11RepositorySession.LOG_TAG, "Fetch completed. Timestamp is " + l);
            this.workTracker.delayWorkItem(new Runnable(){

                public void run() {
                    Logger.debug(Server11RepositorySession.LOG_TAG, "Delayed onFetchCompleted running.");
                    RequestFetchDelegateAdapter.this.delegate.onFetchCompleted(l);
                }
            });
        }

        public void handleRequestFailure(SyncStorageResponse syncStorageResponse) {
            this.handleRequestError(new HTTPFailureException(syncStorageResponse));
        }

        public void handleRequestError(final Exception exception) {
            this.removeRequestFromPending();
            Logger.warn(Server11RepositorySession.LOG_TAG, "Got request error.", exception);
            this.workTracker.delayWorkItem(new Runnable(){

                public void run() {
                    Logger.debug(Server11RepositorySession.LOG_TAG, "Running onFetchFailed.");
                    RequestFetchDelegateAdapter.this.delegate.onFetchFailed(exception, null);
                }
            });
        }

        public void handleWBO(CryptoRecord cryptoRecord) {
            this.workTracker.incrementOutstanding();
            try {
                this.delegate.onFetchedRecord(cryptoRecord);
            }
            catch (Exception exception) {
                Logger.warn(Server11RepositorySession.LOG_TAG, "Got exception calling onFetchedRecord with WBO.", exception);
                throw new RuntimeException(exception);
            }
            finally {
                this.workTracker.decrementOutstanding();
            }
        }

        public KeyBundle keyBundle() {
            return null;
        }
    }
}

