/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories.android;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.repositories.domain.BookmarkRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookmarksInsertionManager {
    public static final String LOG_TAG = "BookmarkInsert";
    public static boolean DEBUG = false;
    protected final int flushThreshold;
    protected final BookmarkInserter inserter;
    private final Set<String> insertedFolders = new HashSet<String>();
    private final Set<BookmarkRecord> nonFoldersToWrite = new LinkedHashSet<BookmarkRecord>();
    private final Map<String, Set<BookmarkRecord>> recordsWaitingForParent = new HashMap<String, Set<BookmarkRecord>>();

    public BookmarksInsertionManager(int n, Collection<String> collection, BookmarkInserter bookmarkInserter) {
        this.flushThreshold = n;
        this.insertedFolders.addAll(collection);
        this.inserter = bookmarkInserter;
    }

    protected void addRecordWithUnwrittenParent(BookmarkRecord bookmarkRecord) {
        Set<BookmarkRecord> set = this.recordsWaitingForParent.get(bookmarkRecord.parentID);
        if (set == null) {
            set = new LinkedHashSet<BookmarkRecord>();
            this.recordsWaitingForParent.put(bookmarkRecord.parentID, set);
        }
        set.add(bookmarkRecord);
    }

    protected void recursivelyEnqueueRecordAndChildren(BookmarkRecord bookmarkRecord) {
        if (bookmarkRecord.isFolder()) {
            if (!this.inserter.insertFolder(bookmarkRecord)) {
                Logger.warn(LOG_TAG, "Folder with known parent with guid " + bookmarkRecord.parentID + " failed to insert!");
                return;
            }
            Logger.debug(LOG_TAG, "Folder with known parent with guid " + bookmarkRecord.parentID + " inserted; adding to inserted folders.");
            this.insertedFolders.add(bookmarkRecord.guid);
        } else {
            Logger.debug(LOG_TAG, "Non-folder has known parent with guid " + bookmarkRecord.parentID + "; adding to insertion queue.");
            this.nonFoldersToWrite.add(bookmarkRecord);
        }
        Set<BookmarkRecord> set = this.recordsWaitingForParent.remove(bookmarkRecord.guid);
        if (set == null) {
            return;
        }
        for (BookmarkRecord bookmarkRecord2 : set) {
            this.recursivelyEnqueueRecordAndChildren(bookmarkRecord2);
        }
    }

    protected void enqueueFolder(BookmarkRecord bookmarkRecord) {
        Logger.debug(LOG_TAG, "Inserting folder with guid " + bookmarkRecord.guid);
        if (!this.insertedFolders.contains(bookmarkRecord.parentID)) {
            Logger.debug(LOG_TAG, "Folder has unknown parent with guid " + bookmarkRecord.parentID + "; keeping until we see the parent.");
            this.addRecordWithUnwrittenParent(bookmarkRecord);
            return;
        }
        this.recursivelyEnqueueRecordAndChildren(bookmarkRecord);
        this.flushNonFoldersIfNecessary();
    }

    protected void enqueueNonFolder(BookmarkRecord bookmarkRecord) {
        Logger.debug(LOG_TAG, "Inserting non-folder with guid " + bookmarkRecord.guid);
        if (!this.insertedFolders.contains(bookmarkRecord.parentID)) {
            Logger.debug(LOG_TAG, "Non-folder has unknown parent with guid " + bookmarkRecord.parentID + "; keeping until we see the parent.");
            this.addRecordWithUnwrittenParent(bookmarkRecord);
            return;
        }
        Logger.debug(LOG_TAG, "Non-folder has known parent with guid " + bookmarkRecord.parentID + "; adding to insertion queue.");
        this.nonFoldersToWrite.add(bookmarkRecord);
        this.flushNonFoldersIfNecessary();
    }

    public void enqueueRecord(BookmarkRecord bookmarkRecord) {
        if (bookmarkRecord.isFolder()) {
            this.enqueueFolder(bookmarkRecord);
        } else {
            this.enqueueNonFolder(bookmarkRecord);
        }
        if (DEBUG) {
            this.dumpState();
        }
    }

    protected void flushNonFolders() {
        this.inserter.bulkInsertNonFolders(this.nonFoldersToWrite);
        this.nonFoldersToWrite.clear();
    }

    protected void flushNonFoldersIfNecessary() {
        int n = this.nonFoldersToWrite.size();
        if (n < this.flushThreshold) {
            Logger.debug(LOG_TAG, "Incremental flush called with " + n + " < " + this.flushThreshold + " non-folders; not flushing.");
            return;
        }
        Logger.debug(LOG_TAG, "Incremental flush called with " + n + " non-folders; flushing.");
        this.flushNonFolders();
    }

    public void finishUp() {
        int n = 0;
        int n2 = 0;
        for (Set<BookmarkRecord> set : this.recordsWaitingForParent.values()) {
            for (BookmarkRecord bookmarkRecord : set) {
                if (!bookmarkRecord.isFolder()) {
                    ++n2;
                    this.nonFoldersToWrite.add(bookmarkRecord);
                    continue;
                }
                ++n;
                if (!this.inserter.insertFolder(bookmarkRecord)) {
                    Logger.warn(LOG_TAG, "Folder with known parent with guid " + bookmarkRecord.parentID + " failed to insert!");
                    continue;
                }
                Logger.debug(LOG_TAG, "Folder with known parent with guid " + bookmarkRecord.parentID + " inserted; adding to inserted folders.");
                this.insertedFolders.add(bookmarkRecord.guid);
            }
        }
        this.recordsWaitingForParent.clear();
        this.flushNonFolders();
        Logger.debug(LOG_TAG, "finishUp inserted " + n + " folders without known parents and " + n2 + " non-folders without known parents.");
        if (DEBUG) {
            this.dumpState();
        }
    }

    public void clear() {
        this.insertedFolders.clear();
        this.nonFoldersToWrite.clear();
        this.recordsWaitingForParent.clear();
    }

    public boolean isClear() {
        return this.nonFoldersToWrite.isEmpty() && this.recordsWaitingForParent.isEmpty();
    }

    public void dumpState() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (BookmarkRecord object22 : this.nonFoldersToWrite) {
            arrayList.add(object22.guid);
        }
        String string2 = Utils.toCommaSeparatedString(new ArrayList<String>(arrayList));
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Set<BookmarkRecord> set : this.recordsWaitingForParent.values()) {
            for (BookmarkRecord bookmarkRecord : set) {
                arrayList2.add(bookmarkRecord.guid);
            }
        }
        String string3 = Utils.toCommaSeparatedString(arrayList2);
        String string4 = Utils.toCommaSeparatedString(this.insertedFolders);
        Logger.debug(LOG_TAG, "Q=(" + (String)string2 + "), W = (" + (String)string3 + "), P=(" + string4 + ")");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface BookmarkInserter {
        public boolean insertFolder(BookmarkRecord var1);

        public void bulkInsertNonFolders(Collection<BookmarkRecord> var1);
    }
}

