/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.setup.auth;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.client.ClientProtocolException;
import ch.boye.httpclientandroidlib.client.methods.HttpRequestBase;
import ch.boye.httpclientandroidlib.impl.client.DefaultHttpClient;
import ch.boye.httpclientandroidlib.message.BasicHeader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import org.mozilla.apache.commons.codec.binary.Base64;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.net.BaseResource;
import org.mozilla.gecko.sync.net.BaseResourceDelegate;
import org.mozilla.gecko.sync.setup.auth.AccountAuthenticator;
import org.mozilla.gecko.sync.setup.auth.AuthenticationResult;
import org.mozilla.gecko.sync.setup.auth.AuthenticatorStage;

public class AuthenticateAccountStage
implements AuthenticatorStage {
    private final String LOG_TAG = "AuthAccountStage";
    private HttpRequestBase httpRequest = null;

    public void execute(final AccountAuthenticator accountAuthenticator) throws URISyntaxException, UnsupportedEncodingException {
        AuthenticateAccountStageDelegate authenticateAccountStageDelegate = new AuthenticateAccountStageDelegate(){

            public void handleSuccess(boolean bl) {
                accountAuthenticator.isSuccess = bl;
                accountAuthenticator.runNextStage();
            }

            public void handleFailure(HttpResponse httpResponse) {
                Logger.debug("AuthAccountStage", "handleFailure");
                accountAuthenticator.abort(AuthenticationResult.FAILURE_OTHER, new Exception(httpResponse.getStatusLine().getStatusCode() + " error."));
                if (httpResponse.getEntity() == null) {
                    return;
                }
                try {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpResponse.getEntity().getContent(), "UTF-8"));
                    BaseResource.consumeReader(bufferedReader);
                }
                catch (IllegalStateException illegalStateException) {
                    Logger.debug("AuthAccountStage", "Error reading content.", illegalStateException);
                }
                catch (RuntimeException runtimeException) {
                    Logger.debug("AuthAccountStage", "Unexpected exception.", runtimeException);
                    if (AuthenticateAccountStage.this.httpRequest != null) {
                        AuthenticateAccountStage.this.httpRequest.abort();
                    }
                }
                catch (IOException iOException) {
                    Logger.debug("AuthAccountStage", "Error reading content.", iOException);
                }
            }

            public void handleError(Exception exception) {
                Logger.debug("AuthAccountStage", "handleError", exception);
                accountAuthenticator.abort(AuthenticationResult.FAILURE_OTHER, exception);
            }
        };
        String string2 = this.makeAuthHeader(accountAuthenticator.username, accountAuthenticator.password);
        String string3 = this.makeAuthRequestUrl(accountAuthenticator.authServer, accountAuthenticator.username);
        Logger.pii("AuthAccountStage", "Making auth request to: " + string3);
        this.authenticateAccount(authenticateAccountStageDelegate, string3, string2);
    }

    public void authenticateAccount(final AuthenticateAccountStageDelegate authenticateAccountStageDelegate, final String string2, final String string3) throws URISyntaxException {
        final BaseResource baseResource = new BaseResource(string2);
        baseResource.delegate = new BaseResourceDelegate(baseResource){

            public void addHeaders(HttpRequestBase httpRequestBase, DefaultHttpClient defaultHttpClient) {
                AuthenticateAccountStage.this.httpRequest = httpRequestBase;
                defaultHttpClient.log.enableDebug(true);
                httpRequestBase.setHeader((Header)new BasicHeader("User-Agent", "Firefox AndroidSync 1.27.0a1.0 (Nightly)"));
                try {
                    URI uRI = new URI(string2);
                    httpRequestBase.setHeader((Header)new BasicHeader("Host", uRI.getHost()));
                }
                catch (URISyntaxException uRISyntaxException) {
                    Logger.error("AuthAccountStage", "Malformed uri, will be caught elsewhere.", uRISyntaxException);
                }
                httpRequestBase.setHeader((Header)new BasicHeader("Authorization", string3));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void handleHttpResponse(HttpResponse httpResponse) {
                int n = httpResponse.getStatusLine().getStatusCode();
                try {
                    switch (n) {
                        case 200: {
                            authenticateAccountStageDelegate.handleSuccess(true);
                            return;
                        }
                        case 401: {
                            authenticateAccountStageDelegate.handleSuccess(false);
                            return;
                        }
                        default: {
                            authenticateAccountStageDelegate.handleFailure(httpResponse);
                            return;
                        }
                    }
                }
                finally {
                    BaseResource.consumeEntity(httpResponse.getEntity());
                    Logger.info("AuthAccountStage", "Released entity.");
                }
            }

            public void handleHttpProtocolException(ClientProtocolException clientProtocolException) {
                Logger.error("AuthAccountStage", "Client protocol error.", clientProtocolException);
                authenticateAccountStageDelegate.handleError((Exception)((Object)clientProtocolException));
            }

            public void handleHttpIOException(IOException iOException) {
                Logger.error("AuthAccountStage", "I/O exception.");
                authenticateAccountStageDelegate.handleError(iOException);
            }

            public void handleTransportException(GeneralSecurityException generalSecurityException) {
                Logger.error("AuthAccountStage", "Transport exception.");
                authenticateAccountStageDelegate.handleError(generalSecurityException);
            }
        };
        AccountAuthenticator.runOnThread(new Runnable(){

            public void run() {
                baseResource.get();
            }
        });
    }

    public String makeAuthHeader(String string2, String string3) {
        try {
            return "Basic " + Base64.encodeBase64String((byte[])(string2 + ":" + string3).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.debug("AuthAccountStage", "Unsupported encoding: UTF-8.");
            return null;
        }
    }

    public String makeAuthRequestUrl(String string2, String string3) {
        return string2 + "1.1/" + string3 + "/" + "info/collections/";
    }

    public static interface AuthenticateAccountStageDelegate {
        public void handleSuccess(boolean var1);

        public void handleFailure(HttpResponse var1);

        public void handleError(Exception var1);
    }
}

