/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.stage;

import java.net.URISyntaxException;
import org.mozilla.gecko.sync.MetaGlobalException;
import org.mozilla.gecko.sync.repositories.ConstrainedServer11Repository;
import org.mozilla.gecko.sync.repositories.RecordFactory;
import org.mozilla.gecko.sync.repositories.Repository;
import org.mozilla.gecko.sync.repositories.android.AndroidBrowserHistoryRepository;
import org.mozilla.gecko.sync.repositories.domain.HistoryRecordFactory;
import org.mozilla.gecko.sync.stage.ServerSyncStage;

public class AndroidBrowserHistoryServerSyncStage
extends ServerSyncStage {
    protected static final String LOG_TAG = "HistoryStage";
    private static final String HISTORY_SORT = "index";
    private static final long HISTORY_REQUEST_LIMIT = 250L;

    protected String getCollection() {
        return "history";
    }

    protected String getEngineName() {
        return "history";
    }

    public Integer getStorageVersion() {
        return 1;
    }

    protected Repository getLocalRepository() {
        return new AndroidBrowserHistoryRepository();
    }

    protected Repository getRemoteRepository() throws URISyntaxException {
        return new ConstrainedServer11Repository(this.session.config.getClusterURLString(), this.session.config.username, this.getCollection(), this.session, 250L, HISTORY_SORT);
    }

    protected RecordFactory getRecordFactory() {
        return new HistoryRecordFactory();
    }

    protected boolean isEnabled() throws MetaGlobalException {
        if (this.session == null || this.session.getContext() == null) {
            return false;
        }
        return super.isEnabled();
    }
}

