/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.stage;

import java.net.URISyntaxException;
import org.mozilla.gecko.sync.CryptoRecord;
import org.mozilla.gecko.sync.repositories.ConstrainedServer11Repository;
import org.mozilla.gecko.sync.repositories.RecordFactory;
import org.mozilla.gecko.sync.repositories.Repository;
import org.mozilla.gecko.sync.repositories.android.FormHistoryRepositorySession;
import org.mozilla.gecko.sync.repositories.domain.FormHistoryRecord;
import org.mozilla.gecko.sync.repositories.domain.Record;
import org.mozilla.gecko.sync.stage.ServerSyncStage;

public class FormHistoryServerSyncStage
extends ServerSyncStage {
    private static final String FORM_HISTORY_SORT = "index";
    private static final long FORM_HISTORY_REQUEST_LIMIT = 5000L;

    protected String getCollection() {
        return "forms";
    }

    protected String getEngineName() {
        return "forms";
    }

    public Integer getStorageVersion() {
        return 1;
    }

    protected Repository getRemoteRepository() throws URISyntaxException {
        return new ConstrainedServer11Repository(this.session.config.getClusterURLString(), this.session.config.username, this.getCollection(), this.session, 5000L, FORM_HISTORY_SORT);
    }

    protected Repository getLocalRepository() {
        return new FormHistoryRepositorySession.FormHistoryRepository();
    }

    protected RecordFactory getRecordFactory() {
        return new FormHistoryRecordFactory();
    }

    public class FormHistoryRecordFactory
    extends RecordFactory {
        public Record createRecord(Record record) {
            FormHistoryRecord formHistoryRecord = new FormHistoryRecord();
            formHistoryRecord.initFromEnvelope((CryptoRecord)record);
            return formHistoryRecord;
        }
    }
}

