/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.stage;

import android.content.Context;
import java.net.URISyntaxException;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.CredentialsSource;
import org.mozilla.gecko.sync.InfoCounts;
import org.mozilla.gecko.sync.JSONRecordFetcher;
import org.mozilla.gecko.sync.repositories.ConstrainedServer11Repository;
import org.mozilla.gecko.sync.repositories.Repository;
import org.mozilla.gecko.sync.repositories.Server11RepositorySession;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionCreationDelegate;

public class SafeConstrainedServer11Repository
extends ConstrainedServer11Repository {
    private JSONRecordFetcher countFetcher;

    public SafeConstrainedServer11Repository(String string2, String string3, String string4, CredentialsSource credentialsSource, long l, String string5, JSONRecordFetcher jSONRecordFetcher) throws URISyntaxException {
        super(string2, string3, string4, credentialsSource, l, string5);
        this.countFetcher = jSONRecordFetcher;
    }

    public void createSession(RepositorySessionCreationDelegate repositorySessionCreationDelegate, Context context) {
        repositorySessionCreationDelegate.onSessionCreated(new CountCheckingServer11RepositorySession(this, this.getDefaultFetchLimit()));
    }

    public class CountCheckingServer11RepositorySession
    extends Server11RepositorySession {
        private long fetchLimit;

        public CountCheckingServer11RepositorySession(Repository repository, long l) {
            super(repository);
            this.fetchLimit = l;
        }

        public boolean shouldSkip() {
            if (this.lastSyncTimestamp <= 0L) {
                InfoCounts infoCounts;
                try {
                    infoCounts = new InfoCounts(SafeConstrainedServer11Repository.this.countFetcher.fetchBlocking());
                }
                catch (Exception exception) {
                    Logger.warn("Server11Session", "Skipping " + SafeConstrainedServer11Repository.this.collection + " until we can fetch counts.", exception);
                    return true;
                }
                Integer n = infoCounts.getCount(SafeConstrainedServer11Repository.this.collection);
                if (n == null) {
                    return false;
                }
                Logger.info("Server11Session", "First sync for " + SafeConstrainedServer11Repository.this.collection + ": " + n + " items.");
                if ((long)n.intValue() > this.fetchLimit) {
                    Logger.warn("Server11Session", "Too many items to sync safely. Skipping.");
                    return true;
                }
            }
            return super.shouldSkip();
        }
    }
}

