/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import org.mozilla.gecko.GeckoApp;
import org.mozilla.gecko.R;
import org.mozilla.gecko.util.HardwareUtils;

public class ArrowPopup
extends PopupWindow {
    protected final GeckoApp mActivity;
    private View mAnchor;
    private ImageView mArrow;
    private int mArrowWidth;
    private int mYOffset;
    protected LinearLayout mContent;
    protected boolean mInflated;

    public ArrowPopup(GeckoApp geckoApp, View view) {
        super((Context)geckoApp);
        this.mActivity = geckoApp;
        this.mAnchor = view;
        this.mInflated = false;
        this.mArrowWidth = geckoApp.getResources().getDimensionPixelSize(R.dimen.menu_popup_arrow_width);
        this.mYOffset = geckoApp.getResources().getDimensionPixelSize(R.dimen.menu_popup_offset);
        this.setAnimationStyle(R.style.PopupAnimation);
    }

    public void setAnchor(View view) {
        this.mAnchor = view;
    }

    protected void init() {
        this.setBackgroundDrawable((Drawable)new BitmapDrawable());
        this.setOutsideTouchable(true);
        this.setWindowLayoutMode(HardwareUtils.isTablet() ? -2 : -1, -2);
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.mActivity);
        RelativeLayout relativeLayout = (RelativeLayout)layoutInflater.inflate(R.layout.arrow_popup, null);
        this.setContentView((View)relativeLayout);
        this.mArrow = (ImageView)relativeLayout.findViewById(R.id.arrow);
        this.mContent = (LinearLayout)relativeLayout.findViewById(R.id.content);
        this.mInflated = true;
    }

    public void show() {
        int[] nArray = new int[2];
        if (this.mAnchor != null) {
            this.mAnchor.getLocationInWindow(nArray);
        }
        if (this.mAnchor == null || nArray[1] < 0) {
            View view = this.mActivity.getView();
            if (Build.VERSION.SDK_INT < 11) {
                this.setWidth(view.getWidth());
                this.setHeight(view.getHeight());
            }
            this.showAtLocation(view, 48, 0, 0);
            return;
        }
        int n = this.mAnchor.getWidth() - this.mAnchor.getPaddingLeft() - this.mAnchor.getPaddingRight();
        int n2 = (n - this.mArrowWidth) / 2 + this.mAnchor.getPaddingLeft();
        int n3 = 0;
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.mArrow.getLayoutParams();
        if (HardwareUtils.isTablet()) {
            n3 = n2 - layoutParams.leftMargin;
        } else {
            int n4 = nArray[0] + n2;
            layoutParams.setMargins(n4, 0, 0, 0);
        }
        this.showAsDropDown(this.mAnchor, n3, -this.mYOffset);
    }
}

