/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;
import org.mozilla.gecko.R;
import org.mozilla.gecko.favicons.Favicons;

public class FaviconView
extends ImageView {
    private Bitmap mIconBitmap;
    private Bitmap mUnscaledBitmap;
    private String mIconKey;
    private int mActualWidth;
    private int mActualHeight;
    private boolean mScalingExpected;

    public FaviconView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setScaleType(ImageView.ScaleType.CENTER);
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        if (n == this.mActualHeight && n2 == this.mActualWidth) {
            return;
        }
        this.mActualWidth = n;
        this.mActualHeight = n2;
        this.formatImage();
    }

    private void formatImage() {
        if (this.mIconBitmap == null || this.mActualWidth == 0 || this.mActualHeight == 0) {
            this.showNoImage();
            return;
        }
        if (this.mScalingExpected && this.mActualWidth != this.mIconBitmap.getWidth()) {
            this.scaleBitmap();
            this.mScalingExpected = false;
        }
        this.setImageBitmap(this.mIconBitmap);
        if (Math.abs(this.mIconBitmap.getWidth() - this.mActualWidth) > 3) {
            this.showBackground();
        } else {
            this.hideBackground();
        }
    }

    private void scaleBitmap() {
        int n = this.mIconBitmap.getWidth() * 2;
        this.mIconBitmap = this.mActualWidth > n ? Bitmap.createScaledBitmap((Bitmap)this.mIconBitmap, (int)n, (int)n, (boolean)true) : Bitmap.createScaledBitmap((Bitmap)this.mIconBitmap, (int)this.mActualWidth, (int)this.mActualWidth, (boolean)true);
    }

    private void showBackground() {
        int n = Favicons.getFaviconColor(this.mIconKey);
        if (n == -1) {
            this.hideBackground();
            return;
        }
        n = Color.argb((int)70, (int)Color.red((int)n), (int)Color.green((int)n), (int)Color.blue((int)n));
        Drawable drawable2 = this.getResources().getDrawable(R.drawable.favicon_bg);
        drawable2.setColorFilter(n, PorterDuff.Mode.SRC_ATOP);
        this.setBackgroundDrawable(drawable2);
    }

    private void hideBackground() {
        this.setBackgroundResource(0);
    }

    private void updateImageInternal(Bitmap bitmap, String string2, boolean bl) {
        if (bitmap == null) {
            this.showDefaultFavicon();
            return;
        }
        if (this.mUnscaledBitmap == bitmap) {
            return;
        }
        this.mUnscaledBitmap = bitmap;
        this.mIconBitmap = bitmap;
        this.mIconKey = string2;
        this.mScalingExpected = bl;
        this.formatImage();
    }

    public void showDefaultFavicon() {
        this.setImageResource(R.drawable.favicon);
        this.hideBackground();
    }

    private void showNoImage() {
        this.setImageBitmap(null);
        this.hideBackground();
    }

    public void clearImage() {
        this.showNoImage();
        this.mUnscaledBitmap = null;
        this.mIconBitmap = null;
        this.mIconKey = null;
        this.mScalingExpected = false;
    }

    public void updateAndScaleImage(Bitmap bitmap, String string2) {
        this.updateImageInternal(bitmap, string2, true);
    }

    public void updateImage(Bitmap bitmap, String string2) {
        this.updateImageInternal(bitmap, string2, false);
    }

    public Bitmap getBitmap() {
        return this.mIconBitmap;
    }
}

