/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.LinearLayout;
import org.mozilla.gecko.GeckoActivity;
import org.mozilla.gecko.LightweightTheme;
import org.mozilla.gecko.R;

public class GeckoLinearLayout
extends LinearLayout
implements LightweightTheme.OnChangeListener {
    private GeckoActivity mActivity;
    private static final int[] STATE_PRIVATE_MODE = new int[]{R.attr.state_private};
    private static final int[] STATE_LIGHT = new int[]{R.attr.state_light};
    private static final int[] STATE_DARK = new int[]{R.attr.state_dark};
    private boolean mIsPrivate = false;
    private boolean mIsLight = false;
    private boolean mIsDark = false;
    private boolean mAutoUpdateTheme = true;

    public GeckoLinearLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mActivity = (GeckoActivity)context;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.LightweightTheme);
        this.mAutoUpdateTheme = typedArray.getBoolean(2, true);
        typedArray.recycle();
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mAutoUpdateTheme) {
            this.mActivity.getLightweightTheme().addListener(this);
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mAutoUpdateTheme) {
            this.mActivity.getLightweightTheme().removeListener(this);
        }
    }

    public int[] onCreateDrawableState(int n) {
        int[] nArray = super.onCreateDrawableState(n + 1);
        if (this.mIsPrivate) {
            GeckoLinearLayout.mergeDrawableStates((int[])nArray, (int[])STATE_PRIVATE_MODE);
        } else if (this.mIsLight) {
            GeckoLinearLayout.mergeDrawableStates((int[])nArray, (int[])STATE_LIGHT);
        } else if (this.mIsDark) {
            GeckoLinearLayout.mergeDrawableStates((int[])nArray, (int[])STATE_DARK);
        }
        return nArray;
    }

    public void onLightweightThemeChanged() {
        if (this.mAutoUpdateTheme && this.mActivity.getLightweightTheme().isEnabled()) {
            this.setTheme(this.mActivity.getLightweightTheme().isLightTheme());
        }
    }

    public void onLightweightThemeReset() {
        if (this.mAutoUpdateTheme) {
            this.resetTheme();
        }
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        this.onLightweightThemeChanged();
    }

    public boolean isPrivateMode() {
        return this.mIsPrivate;
    }

    public void setPrivateMode(boolean bl) {
        if (this.mIsPrivate != bl) {
            this.mIsPrivate = bl;
            this.refreshDrawableState();
        }
    }

    public void setTheme(boolean bl) {
        if (bl && this.mIsLight != bl || !bl && this.mIsDark == bl) {
            if (bl) {
                this.mIsLight = true;
                this.mIsDark = false;
            } else {
                this.mIsLight = false;
                this.mIsDark = true;
            }
            this.refreshDrawableState();
        }
    }

    public void resetTheme() {
        if (this.mIsLight || this.mIsDark) {
            this.mIsLight = false;
            this.mIsDark = false;
            this.refreshDrawableState();
        }
    }

    public void setAutoUpdateTheme(boolean bl) {
        if (this.mAutoUpdateTheme != bl) {
            this.mAutoUpdateTheme = bl;
            if (this.mAutoUpdateTheme) {
                this.mActivity.getLightweightTheme().addListener(this);
            } else {
                this.mActivity.getLightweightTheme().removeListener(this);
            }
        }
    }
}

