/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import org.mozilla.gecko.menu.GeckoMenu;
import org.mozilla.gecko.menu.GeckoMenuInflater;
import org.mozilla.gecko.menu.MenuPanel;
import org.mozilla.gecko.menu.MenuPopup;

public class GeckoPopupMenu
implements GeckoMenu.Callback,
GeckoMenu.MenuPresenter {
    private View mAnchor;
    private MenuPopup mMenuPopup;
    private MenuPanel mMenuPanel;
    private GeckoMenu mMenu;
    private GeckoMenuInflater mMenuInflater;
    private OnDismissListener mDismissListener;
    private OnMenuItemClickListener mClickListener;

    public GeckoPopupMenu(Context context) {
        this.initialize(context, null);
    }

    public GeckoPopupMenu(Context context, View view) {
        this.initialize(context, view);
    }

    private void initialize(Context context, View view) {
        this.mMenu = new GeckoMenu(context, null);
        this.mMenu.setCallback(this);
        this.mMenu.setMenuPresenter(this);
        this.mMenuInflater = new GeckoMenuInflater(context);
        this.mMenuPopup = new MenuPopup(context);
        this.mMenuPanel = new MenuPanel(context, null);
        this.setAnchor(view);
    }

    public Menu getMenu() {
        return this.mMenu;
    }

    public MenuInflater getMenuInflater() {
        return this.mMenuInflater;
    }

    public void inflate(int n) {
        if (n > 0) {
            this.mMenuInflater.inflate(n, this.mMenu);
        }
        this.mMenuPanel.addView((View)this.mMenu);
        this.mMenuPopup.setPanelView((View)this.mMenuPanel);
    }

    public void setAnchor(View view) {
        this.mAnchor = view;
    }

    public void setOnDismissListener(OnDismissListener onDismissListener) {
        this.mDismissListener = onDismissListener;
    }

    public void setOnMenuItemClickListener(OnMenuItemClickListener onMenuItemClickListener) {
        this.mClickListener = onMenuItemClickListener;
    }

    public void show() {
        if (!this.mMenuPopup.isShowing()) {
            this.mMenuPopup.showAsDropDown(this.mAnchor);
        }
    }

    public void dismiss() {
        if (this.mMenuPopup.isShowing()) {
            this.mMenuPopup.dismiss();
            if (this.mDismissListener != null) {
                this.mDismissListener.onDismiss(this.mMenu);
            }
        }
    }

    public void showArrowToAnchor(boolean bl) {
        this.mMenuPopup.showArrowToAnchor(bl);
    }

    public boolean onMenuItemSelected(MenuItem menuItem) {
        if (this.mClickListener != null) {
            return this.mClickListener.onMenuItemClick(menuItem);
        }
        return false;
    }

    public void openMenu() {
        this.show();
    }

    public void showMenu(View view) {
        this.mMenuPanel.removeAllViews();
        this.mMenuPanel.addView(view);
        this.openMenu();
    }

    public void closeMenu() {
        this.dismiss();
    }

    public static interface OnMenuItemClickListener {
        public boolean onMenuItemClick(MenuItem var1);
    }

    public static interface OnDismissListener {
        public boolean onDismiss(GeckoMenu var1);
    }
}

