/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.videoengine;

import android.graphics.PixelFormat;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.Build;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.util.ThreadUtils;
import org.webrtc.videoengine.CaptureCapabilityAndroid;
import org.webrtc.videoengine.VideoCaptureDeviceInfoAndroid;

public class VideoCaptureAndroid
implements Camera.PreviewCallback,
SurfaceHolder.Callback {
    private static final String TAG = "WEBRTC-JC";
    private Camera camera;
    private int cameraId;
    private VideoCaptureDeviceInfoAndroid.AndroidVideoCaptureDevice currentDevice = null;
    public ReentrantLock previewBufferLock = new ReentrantLock();
    private ReentrantLock captureLock = new ReentrantLock();
    private int PIXEL_FORMAT = 17;
    PixelFormat pixelFormat = new PixelFormat();
    private boolean isCaptureStarted = false;
    private boolean isCaptureRunning = false;
    private boolean isSurfaceReady = false;
    private SurfaceHolder surfaceHolder = null;
    private SurfaceTexture surfaceTexture = null;
    private SurfaceTexture dummySurfaceTexture = null;
    private final int numCaptureBuffers = 3;
    private int expectedFrameSize = 0;
    private int orientation = 0;
    private int id = 0;
    private long context = 0L;
    private SurfaceHolder localPreview = null;
    private boolean ownsBuffers = false;
    private int mCaptureWidth = -1;
    private int mCaptureHeight = -1;
    private int mCaptureFPS = -1;
    private int mCaptureRotation = 0;
    private GeckoAppShell.AppStateListener mAppStateListener = null;

    public static void DeleteVideoCaptureAndroid(VideoCaptureAndroid videoCaptureAndroid) {
        Log.d((String)TAG, (String)"DeleteVideoCaptureAndroid");
        GeckoAppShell.getGeckoInterface().removeAppStateListener(videoCaptureAndroid.mAppStateListener);
        videoCaptureAndroid.StopCapture();
        if (videoCaptureAndroid.camera != null) {
            videoCaptureAndroid.camera.release();
            videoCaptureAndroid.camera = null;
        }
        videoCaptureAndroid.context = 0L;
        View view = GeckoAppShell.getGeckoInterface().getCameraView();
        if (view instanceof SurfaceView) {
            ((SurfaceView)view).getHolder().removeCallback((SurfaceHolder.Callback)videoCaptureAndroid);
        } else if (view instanceof TextureView) {
            // empty if block
        }
        ThreadUtils.getUiHandler().post(new Runnable(){

            public void run() {
                try {
                    GeckoAppShell.getGeckoInterface().disableCameraView();
                }
                catch (Exception exception) {
                    Log.e((String)VideoCaptureAndroid.TAG, (String)("VideoCaptureAndroid disableCameraView exception: " + exception.getLocalizedMessage()));
                }
            }
        });
    }

    public VideoCaptureAndroid(int n, long l, Camera camera, VideoCaptureDeviceInfoAndroid.AndroidVideoCaptureDevice androidVideoCaptureDevice, int n2) {
        this.id = n;
        this.context = l;
        this.camera = camera;
        this.cameraId = n2;
        this.currentDevice = androidVideoCaptureDevice;
        this.mCaptureRotation = this.GetRotateAmount();
        try {
            View view = GeckoAppShell.getGeckoInterface().getCameraView();
            if (view instanceof SurfaceView) {
                ((SurfaceView)view).getHolder().addCallback((SurfaceHolder.Callback)this);
            } else if (view instanceof TextureView) {
                MySurfaceTextureListener mySurfaceTextureListener = new MySurfaceTextureListener();
                ((TextureView)view).setSurfaceTextureListener((TextureView.SurfaceTextureListener)mySurfaceTextureListener);
            }
            ThreadUtils.getUiHandler().post(new Runnable(){

                public void run() {
                    try {
                        GeckoAppShell.getGeckoInterface().enableCameraView();
                    }
                    catch (Exception exception) {
                        Log.e((String)VideoCaptureAndroid.TAG, (String)("VideoCaptureAndroid enableCameraView exception: " + exception.getLocalizedMessage()));
                    }
                }
            });
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("VideoCaptureAndroid constructor exception: " + exception.getLocalizedMessage()));
        }
        this.mAppStateListener = new GeckoAppShell.AppStateListener(){

            public void onPause() {
                VideoCaptureAndroid.this.StopCapture();
                if (VideoCaptureAndroid.this.camera != null) {
                    VideoCaptureAndroid.this.camera.release();
                    VideoCaptureAndroid.this.camera = null;
                }
            }

            public void onResume() {
                try {
                    if (Build.VERSION.SDK_INT > 8) {
                        VideoCaptureAndroid.this.camera = Camera.open((int)VideoCaptureAndroid.this.cameraId);
                    } else {
                        VideoCaptureAndroid.this.camera = Camera.open();
                    }
                }
                catch (Exception exception) {
                    Log.e((String)VideoCaptureAndroid.TAG, (String)("Error reopening to the camera: " + exception.getMessage()));
                }
                VideoCaptureAndroid.this.captureLock.lock();
                VideoCaptureAndroid.this.isCaptureStarted = true;
                VideoCaptureAndroid.this.tryStartCapture(VideoCaptureAndroid.this.mCaptureWidth, VideoCaptureAndroid.this.mCaptureHeight, VideoCaptureAndroid.this.mCaptureFPS);
                VideoCaptureAndroid.this.captureLock.unlock();
            }

            public void onOrientationChanged() {
                VideoCaptureAndroid.this.mCaptureRotation = VideoCaptureAndroid.this.GetRotateAmount();
            }
        };
        GeckoAppShell.getGeckoInterface().addAppStateListener(this.mAppStateListener);
    }

    public int GetRotateAmount() {
        int n = GeckoAppShell.getGeckoInterface().getActivity().getWindowManager().getDefaultDisplay().getRotation();
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 90;
                break;
            }
            case 2: {
                n2 = 180;
                break;
            }
            case 3: {
                n2 = 270;
            }
        }
        if (Build.VERSION.SDK_INT > 8) {
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            Camera.getCameraInfo((int)this.cameraId, (Camera.CameraInfo)cameraInfo);
            int n3 = cameraInfo.facing == 1 ? (cameraInfo.orientation + n2) % 360 : (cameraInfo.orientation - n2 + 360) % 360;
            return n3;
        }
        int n4 = 90;
        int n5 = (n4 - n2 + 360) % 360;
        return n5;
    }

    private int tryStartCapture(int n, int n2, int n3) {
        if (this.camera == null) {
            Log.e((String)TAG, (String)("Camera not initialized %d" + this.id));
            return -1;
        }
        Log.d((String)TAG, (String)("tryStartCapture " + n + " height " + n2 + " frame rate " + n3 + " isCaptureRunning " + this.isCaptureRunning + " isSurfaceReady " + this.isSurfaceReady + " isCaptureStarted " + this.isCaptureStarted));
        if (this.isCaptureRunning || !this.isSurfaceReady || !this.isCaptureStarted) {
            return 0;
        }
        try {
            if (this.surfaceHolder != null) {
                this.camera.setPreviewDisplay(this.surfaceHolder);
            }
            if (this.surfaceTexture != null) {
                this.camera.setPreviewTexture(this.surfaceTexture);
            }
            if (this.surfaceHolder == null && this.surfaceTexture == null) {
                try {
                    this.dummySurfaceTexture = new SurfaceTexture(42);
                    this.camera.setPreviewTexture(this.dummySurfaceTexture);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
            CaptureCapabilityAndroid captureCapabilityAndroid = new CaptureCapabilityAndroid();
            captureCapabilityAndroid.width = n;
            captureCapabilityAndroid.height = n2;
            captureCapabilityAndroid.maxFPS = n3;
            PixelFormat.getPixelFormatInfo((int)this.PIXEL_FORMAT, (PixelFormat)this.pixelFormat);
            Camera.Parameters parameters = this.camera.getParameters();
            parameters.setPreviewSize(captureCapabilityAndroid.width, captureCapabilityAndroid.height);
            parameters.setPreviewFormat(this.PIXEL_FORMAT);
            parameters.setPreviewFrameRate(captureCapabilityAndroid.maxFPS);
            this.camera.setParameters(parameters);
            int n4 = n * n2 * this.pixelFormat.bitsPerPixel / 8;
            byte[] byArray = null;
            for (int i = 0; i < 3; ++i) {
                byArray = new byte[n4];
                this.camera.addCallbackBuffer(byArray);
            }
            this.camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
            this.ownsBuffers = true;
            this.camera.startPreview();
            this.previewBufferLock.lock();
            this.expectedFrameSize = n4;
            this.isCaptureRunning = true;
            this.previewBufferLock.unlock();
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Failed to start camera: " + exception.getMessage()));
            return -1;
        }
        this.isCaptureRunning = true;
        return 0;
    }

    public int StartCapture(int n, int n2, int n3) {
        Log.d((String)TAG, (String)("StartCapture width " + n + " height " + n2 + " frame rate " + n3));
        this.captureLock.lock();
        this.isCaptureStarted = true;
        this.mCaptureWidth = n;
        this.mCaptureHeight = n2;
        this.mCaptureFPS = n3;
        int n4 = this.tryStartCapture(this.mCaptureWidth, this.mCaptureHeight, this.mCaptureFPS);
        this.captureLock.unlock();
        return n4;
    }

    public int DetachCamera() {
        try {
            this.previewBufferLock.lock();
            this.isCaptureRunning = false;
            this.previewBufferLock.unlock();
            if (this.camera != null) {
                this.camera.setPreviewCallbackWithBuffer(null);
                this.camera.stopPreview();
            }
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Failed to stop camera: " + exception.getMessage()));
            return -1;
        }
        return 0;
    }

    public int StopCapture() {
        Log.d((String)TAG, (String)"StopCapture");
        this.isCaptureStarted = false;
        return this.DetachCamera();
    }

    native void ProvideCameraFrame(byte[] var1, int var2, int var3, long var4);

    public void onPreviewFrame(byte[] byArray, Camera camera) {
        this.previewBufferLock.lock();
        String string = "does not exist";
        if (byArray != null) {
            string = Integer.toString(byArray.length);
        }
        Log.v((String)TAG, (String)("preview frame length " + string + " context" + this.context));
        if (this.isCaptureRunning && byArray != null && byArray.length == this.expectedFrameSize) {
            this.ProvideCameraFrame(byArray, this.expectedFrameSize, this.mCaptureRotation, this.context);
            if (this.ownsBuffers) {
                camera.addCallbackBuffer(byArray);
            }
        }
        this.previewBufferLock.unlock();
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        Log.d((String)TAG, (String)"VideoCaptureAndroid::surfaceChanged");
        this.captureLock.lock();
        this.isSurfaceReady = true;
        this.surfaceHolder = surfaceHolder;
        this.tryStartCapture(this.mCaptureWidth, this.mCaptureHeight, this.mCaptureFPS);
        this.captureLock.unlock();
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        Log.d((String)TAG, (String)"VideoCaptureAndroid::surfaceCreated");
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        Log.d((String)TAG, (String)"VideoCaptureAndroid::surfaceDestroyed");
        this.isSurfaceReady = false;
        this.DetachCamera();
    }

    public class MySurfaceTextureListener
    implements TextureView.SurfaceTextureListener {
        public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
            Log.d((String)VideoCaptureAndroid.TAG, (String)"VideoCaptureAndroid::onSurfaceTextureAvailable");
            VideoCaptureAndroid.this.captureLock.lock();
            VideoCaptureAndroid.this.isSurfaceReady = true;
            VideoCaptureAndroid.this.surfaceTexture = surfaceTexture;
            VideoCaptureAndroid.this.tryStartCapture(VideoCaptureAndroid.this.mCaptureWidth, VideoCaptureAndroid.this.mCaptureHeight, VideoCaptureAndroid.this.mCaptureFPS);
            VideoCaptureAndroid.this.captureLock.unlock();
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
            Log.d((String)VideoCaptureAndroid.TAG, (String)"VideoCaptureAndroid::onSurfaceTextureDestroyed");
            VideoCaptureAndroid.this.isSurfaceReady = false;
            VideoCaptureAndroid.this.DetachCamera();
            return true;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        }
    }
}

