/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import android.view.ViewConfiguration;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HardwareUtils {
    private static final String LOGTAG = "GeckoHardwareUtils";
    private static final int LOW_MEMORY_THRESHOLD_KB = 393216;
    private static final String PROC_MEMINFO_FILE = "/proc/meminfo";
    private static final Pattern PROC_MEMTOTAL_FORMAT = Pattern.compile("^MemTotal:[ \t]*([0-9]*)[ \t]kB");
    private static Context sContext;
    private static Boolean sIsLargeTablet;
    private static Boolean sIsSmallTablet;
    private static Boolean sIsTelevision;
    private static Boolean sHasMenuButton;
    private static Boolean sIsLowMemoryPlatform;

    private HardwareUtils() {
    }

    public static void init(Context context) {
        if (sContext != null) {
            Log.w((String)LOGTAG, (String)"HardwareUtils.init called twice!");
        }
        sContext = context;
    }

    public static boolean isTablet() {
        return HardwareUtils.isLargeTablet() || HardwareUtils.isSmallTablet();
    }

    public static boolean isLargeTablet() {
        if (sIsLargeTablet == null) {
            int n = HardwareUtils.sContext.getResources().getConfiguration().screenLayout;
            sIsLargeTablet = Build.VERSION.SDK_INT >= 11 && (n & 0xF) == 4;
        }
        return sIsLargeTablet;
    }

    public static boolean isSmallTablet() {
        if (sIsSmallTablet == null) {
            int n = HardwareUtils.sContext.getResources().getConfiguration().screenLayout;
            sIsSmallTablet = Build.VERSION.SDK_INT >= 11 && (n & 0xF) == 3;
        }
        return sIsSmallTablet;
    }

    public static boolean isTelevision() {
        if (sIsTelevision == null) {
            sIsTelevision = sContext.getPackageManager().hasSystemFeature("android.hardware.type.television");
        }
        return sIsTelevision;
    }

    public static boolean hasMenuButton() {
        if (sHasMenuButton == null) {
            sHasMenuButton = Boolean.TRUE;
            if (Build.VERSION.SDK_INT >= 11) {
                sHasMenuButton = Boolean.FALSE;
            }
            if (Build.VERSION.SDK_INT >= 14) {
                sHasMenuButton = ViewConfiguration.get((Context)sContext).hasPermanentMenuKey();
            }
        }
        return sHasMenuButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLowMemoryPlatform() {
        if (sIsLowMemoryPlatform == null) {
            RandomAccessFile randomAccessFile = null;
            try {
                randomAccessFile = new RandomAccessFile(PROC_MEMINFO_FILE, "r");
                long l = 393216L;
                String string = null;
                while ((string = randomAccessFile.readLine()) != null) {
                    Matcher matcher = PROC_MEMTOTAL_FORMAT.matcher(string);
                    if (!matcher.find()) continue;
                    l = Long.parseLong(matcher.group(1));
                    break;
                }
                sIsLowMemoryPlatform = l < 393216L;
            }
            catch (IOException iOException) {
                Log.w((String)LOGTAG, (String)"Could not read /proc/meminfo.Falling back to isLowMemoryPlatform = false", (Throwable)iOException);
                sIsLowMemoryPlatform = false;
            }
            finally {
                if (randomAccessFile != null) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return sIsLowMemoryPlatform;
    }
}

