/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.mozglue;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.mozilla.gecko.mozglue.ByteBufferInputStream;
import org.mozilla.gecko.mozglue.NativeReference;

public class NativeZip
implements NativeReference {
    private static final int DEFLATE = 8;
    private static final int STORE = 0;
    private volatile long mObj;
    private InputStream mInput;

    public NativeZip(String string) {
        this.mObj = NativeZip.getZip(string);
        this.mInput = null;
    }

    public NativeZip(InputStream inputStream) {
        if (!(inputStream instanceof ByteBufferInputStream)) {
            throw new IllegalArgumentException("Got " + inputStream.getClass() + ", but expected ByteBufferInputStream!");
        }
        ByteBufferInputStream byteBufferInputStream = (ByteBufferInputStream)inputStream;
        this.mObj = NativeZip.getZipFromByteBuffer(byteBufferInputStream.mBuf);
        this.mInput = inputStream;
    }

    public void finalize() {
        this.release();
    }

    public void close() {
        this.release();
    }

    public void release() {
        if (this.mObj != 0L) {
            NativeZip._release(this.mObj);
            this.mObj = 0L;
        }
        this.mInput = null;
    }

    public boolean isReleased() {
        return this.mObj == 0L;
    }

    public InputStream getInputStream(String string) {
        if (this.isReleased()) {
            throw new IllegalStateException("Can't get path \"" + string + "\" because NativeZip is closed!");
        }
        return this._getInputStream(this.mObj, string);
    }

    private static native long getZip(String var0);

    private static native long getZipFromByteBuffer(ByteBuffer var0);

    private static native void _release(long var0);

    private native InputStream _getInputStream(long var1, String var3);

    private InputStream createInputStream(ByteBuffer byteBuffer, int n) {
        if (n != 0 && n != 8) {
            throw new IllegalArgumentException("Unexpected compression: " + n);
        }
        InputStream inputStream = new ByteBufferInputStream(byteBuffer, this);
        if (n == 8) {
            Inflater inflater = new Inflater(true);
            inputStream = new InflaterInputStream(inputStream, inflater);
        }
        return inputStream;
    }
}

