/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.message;

import ch.boye.httpclientandroidlib.HeaderElement;
import ch.boye.httpclientandroidlib.NameValuePair;
import ch.boye.httpclientandroidlib.ParseException;
import ch.boye.httpclientandroidlib.message.BasicHeaderElement;
import ch.boye.httpclientandroidlib.message.BasicNameValuePair;
import ch.boye.httpclientandroidlib.message.HeaderValueParser;
import ch.boye.httpclientandroidlib.message.ParserCursor;
import ch.boye.httpclientandroidlib.protocol.HTTP;
import ch.boye.httpclientandroidlib.util.CharArrayBuffer;
import java.util.ArrayList;

public class BasicHeaderValueParser
implements HeaderValueParser {
    public static final BasicHeaderValueParser DEFAULT = new BasicHeaderValueParser();
    private static final char PARAM_DELIMITER = ';';
    private static final char ELEM_DELIMITER = ',';
    private static final char[] ALL_DELIMITERS = new char[]{';', ','};

    public static final HeaderElement[] parseElements(String string, HeaderValueParser headerValueParser) throws ParseException {
        if (string == null) {
            throw new IllegalArgumentException("Value to parse may not be null");
        }
        if (headerValueParser == null) {
            headerValueParser = DEFAULT;
        }
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(string.length());
        charArrayBuffer.append(string);
        ParserCursor parserCursor = new ParserCursor(0, string.length());
        return headerValueParser.parseElements(charArrayBuffer, parserCursor);
    }

    public HeaderElement[] parseElements(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        if (charArrayBuffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (parserCursor == null) {
            throw new IllegalArgumentException("Parser cursor may not be null");
        }
        ArrayList<HeaderElement> arrayList = new ArrayList<HeaderElement>();
        while (!parserCursor.atEnd()) {
            HeaderElement headerElement = this.parseHeaderElement(charArrayBuffer, parserCursor);
            if (headerElement.getName().length() == 0 && headerElement.getValue() == null) continue;
            arrayList.add(headerElement);
        }
        return arrayList.toArray(new HeaderElement[arrayList.size()]);
    }

    public static final HeaderElement parseHeaderElement(String string, HeaderValueParser headerValueParser) throws ParseException {
        if (string == null) {
            throw new IllegalArgumentException("Value to parse may not be null");
        }
        if (headerValueParser == null) {
            headerValueParser = DEFAULT;
        }
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(string.length());
        charArrayBuffer.append(string);
        ParserCursor parserCursor = new ParserCursor(0, string.length());
        return headerValueParser.parseHeaderElement(charArrayBuffer, parserCursor);
    }

    public HeaderElement parseHeaderElement(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        char c;
        if (charArrayBuffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (parserCursor == null) {
            throw new IllegalArgumentException("Parser cursor may not be null");
        }
        NameValuePair nameValuePair = this.parseNameValuePair(charArrayBuffer, parserCursor);
        NameValuePair[] nameValuePairArray = null;
        if (!parserCursor.atEnd() && (c = charArrayBuffer.charAt(parserCursor.getPos() - 1)) != ',') {
            nameValuePairArray = this.parseParameters(charArrayBuffer, parserCursor);
        }
        return this.createHeaderElement(nameValuePair.getName(), nameValuePair.getValue(), nameValuePairArray);
    }

    protected HeaderElement createHeaderElement(String string, String string2, NameValuePair[] nameValuePairArray) {
        return new BasicHeaderElement(string, string2, nameValuePairArray);
    }

    public static final NameValuePair[] parseParameters(String string, HeaderValueParser headerValueParser) throws ParseException {
        if (string == null) {
            throw new IllegalArgumentException("Value to parse may not be null");
        }
        if (headerValueParser == null) {
            headerValueParser = DEFAULT;
        }
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(string.length());
        charArrayBuffer.append(string);
        ParserCursor parserCursor = new ParserCursor(0, string.length());
        return headerValueParser.parseParameters(charArrayBuffer, parserCursor);
    }

    public NameValuePair[] parseParameters(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        char c;
        int n;
        if (charArrayBuffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (parserCursor == null) {
            throw new IllegalArgumentException("Parser cursor may not be null");
        }
        int n2 = parserCursor.getUpperBound();
        for (n = parserCursor.getPos(); n < n2 && HTTP.isWhitespace(c = charArrayBuffer.charAt(n)); ++n) {
        }
        parserCursor.updatePos(n);
        if (parserCursor.atEnd()) {
            return new NameValuePair[0];
        }
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
        while (!parserCursor.atEnd()) {
            NameValuePair nameValuePair = this.parseNameValuePair(charArrayBuffer, parserCursor);
            arrayList.add(nameValuePair);
            char c2 = charArrayBuffer.charAt(parserCursor.getPos() - 1);
            if (c2 != ',') continue;
            break;
        }
        return arrayList.toArray(new NameValuePair[arrayList.size()]);
    }

    public static final NameValuePair parseNameValuePair(String string, HeaderValueParser headerValueParser) throws ParseException {
        if (string == null) {
            throw new IllegalArgumentException("Value to parse may not be null");
        }
        if (headerValueParser == null) {
            headerValueParser = DEFAULT;
        }
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(string.length());
        charArrayBuffer.append(string);
        ParserCursor parserCursor = new ParserCursor(0, string.length());
        return headerValueParser.parseNameValuePair(charArrayBuffer, parserCursor);
    }

    public NameValuePair parseNameValuePair(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        return this.parseNameValuePair(charArrayBuffer, parserCursor, ALL_DELIMITERS);
    }

    private static boolean isOneOf(char c, char[] cArray) {
        if (cArray != null) {
            for (int i = 0; i < cArray.length; ++i) {
                if (c != cArray[i]) continue;
                return true;
            }
        }
        return false;
    }

    public NameValuePair parseNameValuePair(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor, char[] cArray) {
        int n;
        char c;
        int n2;
        if (charArrayBuffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (parserCursor == null) {
            throw new IllegalArgumentException("Parser cursor may not be null");
        }
        boolean bl = false;
        int n3 = parserCursor.getPos();
        int n4 = parserCursor.getUpperBound();
        String string = null;
        for (n2 = parserCursor.getPos(); n2 < n4 && (c = charArrayBuffer.charAt(n2)) != '='; ++n2) {
            if (!BasicHeaderValueParser.isOneOf(c, cArray)) continue;
            bl = true;
            break;
        }
        if (n2 == n4) {
            bl = true;
            string = charArrayBuffer.substringTrimmed(n3, n4);
        } else {
            string = charArrayBuffer.substringTrimmed(n3, n2);
            ++n2;
        }
        if (bl) {
            parserCursor.updatePos(n2);
            return this.createNameValuePair(string, null);
        }
        String string2 = null;
        int n5 = n2;
        boolean bl2 = false;
        boolean bl3 = false;
        while (n2 < n4) {
            n = charArrayBuffer.charAt(n2);
            if (n == 34 && !bl3) {
                boolean bl4 = bl2 = !bl2;
            }
            if (!bl2 && !bl3 && BasicHeaderValueParser.isOneOf((char)n, cArray)) {
                bl = true;
                break;
            }
            bl3 = bl3 ? false : bl2 && n == 92;
            ++n2;
        }
        n = n2;
        while (n5 < n && HTTP.isWhitespace(charArrayBuffer.charAt(n5))) {
            ++n5;
        }
        while (n > n5 && HTTP.isWhitespace(charArrayBuffer.charAt(n - 1))) {
            --n;
        }
        if (n - n5 >= 2 && charArrayBuffer.charAt(n5) == '\"' && charArrayBuffer.charAt(n - 1) == '\"') {
            ++n5;
            --n;
        }
        string2 = charArrayBuffer.substring(n5, n);
        if (bl) {
            ++n2;
        }
        parserCursor.updatePos(n2);
        return this.createNameValuePair(string, string2);
    }

    protected NameValuePair createNameValuePair(String string, String string2) {
        return new BasicNameValuePair(string, string2);
    }
}

