/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background;

import android.app.AlarmManager;
import android.app.IntentService;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.mozilla.gecko.background.common.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BackgroundService
extends IntentService {
    private static final String LOG_TAG = BackgroundService.class.getSimpleName();

    protected BackgroundService() {
        super(LOG_TAG);
    }

    protected BackgroundService(String string2) {
        super(string2);
    }

    public static void runIntentInService(Context context, Intent intent, Class<? extends BackgroundService> clazz) {
        Intent intent2 = new Intent(context, clazz);
        intent2.setAction(intent.getAction());
        intent2.putExtras(intent);
        context.startService(intent2);
    }

    protected boolean backgroundDataIsEnabled() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getSystemService("connectivity");
        if (Build.VERSION.SDK_INT < 14) {
            return connectivityManager.getBackgroundDataSetting();
        }
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null) {
            return false;
        }
        return networkInfo.isAvailable();
    }

    protected AlarmManager getAlarmManager() {
        return BackgroundService.getAlarmManager(this.getApplicationContext());
    }

    protected static AlarmManager getAlarmManager(Context context) {
        return (AlarmManager)context.getSystemService("alarm");
    }

    protected void scheduleAlarm(long l, PendingIntent pendingIntent) {
        Logger.info(LOG_TAG, "Setting inexact repeating alarm for interval " + l);
        if (l <= 0L) {
            throw new IllegalArgumentException("pollInterval " + l + " must be positive");
        }
        AlarmManager alarmManager = this.getAlarmManager();
        long l2 = System.currentTimeMillis();
        alarmManager.setInexactRepeating(1, l2, l, pendingIntent);
    }

    protected void cancelAlarm(PendingIntent pendingIntent) {
        AlarmManager alarmManager = this.getAlarmManager();
        alarmManager.cancel(pendingIntent);
        pendingIntent.cancel();
    }

    protected static void reflectContextToFennec(Context context, String string2, String string3) {
        try {
            Class<?> clazz = Class.forName(string2);
            Method method = clazz.getMethod(string3, Context.class);
            method.invoke(null, context);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.error(LOG_TAG, "Class " + string2 + " not found!");
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Logger.error(LOG_TAG, "Method " + string2 + "/" + string3 + " not found!");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.error(LOG_TAG, "Got exception invoking " + string3 + ".");
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.error(LOG_TAG, "Got exception invoking " + string3 + ".");
        }
        catch (InvocationTargetException invocationTargetException) {
            Logger.error(LOG_TAG, "Got exception invoking " + string3 + ".");
        }
    }
}

