/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.fxa;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.crypto.HKDF;
import org.mozilla.gecko.sync.crypto.KeyBundle;

public class FxAccountUtils {
    public static final int SALT_LENGTH_BYTES = 32;
    public static final int SALT_LENGTH_HEX = 64;
    public static final int HASH_LENGTH_BYTES = 16;
    public static final int HASH_LENGTH_HEX = 32;
    public static final String KW_VERSION_STRING = "identity.mozilla.com/picl/v1/";

    public static String bytes(String string2) throws UnsupportedEncodingException {
        return Utils.byte2Hex(string2.getBytes("UTF-8"));
    }

    public static byte[] KW(String string2) throws UnsupportedEncodingException {
        return Utils.concatAll(KW_VERSION_STRING.getBytes("UTF-8"), new byte[][]{string2.getBytes("UTF-8")});
    }

    public static byte[] KWE(String string2, byte[] byArray) throws UnsupportedEncodingException {
        return Utils.concatAll(KW_VERSION_STRING.getBytes("UTF-8"), string2.getBytes("UTF-8"), ":".getBytes("UTF-8"), byArray);
    }

    public static BigInteger srpVerifierLowercaseX(byte[] byArray, byte[] byArray2, byte[] byArray3) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        byte[] byArray4 = Utils.sha256(Utils.concatAll(byArray, ":".getBytes("UTF-8"), byArray2));
        byte[] byArray5 = Utils.sha256(Utils.concatAll(byArray3, new byte[][]{byArray4}));
        return new BigInteger(1, byArray5);
    }

    public static BigInteger srpVerifierLowercaseV(byte[] byArray, byte[] byArray2, byte[] byArray3, BigInteger bigInteger, BigInteger bigInteger2) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        BigInteger bigInteger3 = FxAccountUtils.srpVerifierLowercaseX(byArray, byArray2, byArray3);
        BigInteger bigInteger4 = bigInteger.modPow(bigInteger3, bigInteger2);
        return bigInteger4;
    }

    public static String hexModN(BigInteger bigInteger, BigInteger bigInteger2) {
        int n = (bigInteger2.bitLength() + 7) / 8;
        int n2 = 2 * n;
        return Utils.byte2Hex(Utils.hex2Byte(bigInteger.mod(bigInteger2).toString(16), n), n2);
    }

    public static KeyBundle generateSyncKeyBundle(byte[] byArray) throws InvalidKeyException, NoSuchAlgorithmException, UnsupportedEncodingException {
        byte[] byArray2 = new byte[32];
        byte[] byArray3 = new byte[32];
        byte[] byArray4 = HKDF.derive(byArray, new byte[0], FxAccountUtils.KW("oldsync"), 64);
        System.arraycopy(byArray4, 0, byArray2, 0, 32);
        System.arraycopy(byArray4, 32, byArray3, 0, 32);
        return new KeyBundle(byArray2, byArray3);
    }
}

