/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.favicons;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mozilla.gecko.AboutPages;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.favicons.LoadFaviconTask;
import org.mozilla.gecko.favicons.OnFaviconLoadedListener;
import org.mozilla.gecko.favicons.cache.FaviconCache;
import org.mozilla.gecko.util.GeckoJarReader;
import org.mozilla.gecko.util.NonEvictingLruCache;
import org.mozilla.gecko.util.ThreadUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Favicons {
    private static final String LOGTAG = "GeckoFavicons";
    private static final String BUILT_IN_FAVICON_URL = "about:favicon";
    public static final int FAVICON_CACHE_SIZE_BYTES = 524288;
    public static final int NUM_PAGE_URL_MAPPINGS_TO_STORE = 128;
    public static final int NOT_LOADING = 0;
    public static final int LOADED = 1;
    public static final int FLAG_PERSIST = 2;
    public static final int FLAG_SCALE = 4;
    protected static Context sContext;
    public static Bitmap sDefaultFavicon;
    public static int sDefaultFaviconSize;
    private static final Map<Integer, LoadFaviconTask> sLoadTasks;
    private static final NonEvictingLruCache<String, String> sPageURLMappings;
    private static FaviconCache sFaviconsCache;

    public static String getFaviconURLForPageURLFromCache(String string2) {
        return (String)sPageURLMappings.get((Object)string2);
    }

    public static void putFaviconURLForPageURLInCache(String string2, String string3) {
        sPageURLMappings.put((Object)string2, (Object)string3);
    }

    static int dispatchResult(final String string2, final String string3, final Bitmap bitmap, final OnFaviconLoadedListener onFaviconLoadedListener) {
        if (onFaviconLoadedListener == null) {
            return 0;
        }
        if (ThreadUtils.isOnUiThread()) {
            onFaviconLoadedListener.onFaviconLoaded(string2, string3, bitmap);
            return 1;
        }
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            public void run() {
                onFaviconLoadedListener.onFaviconLoaded(string2, string3, bitmap);
            }
        });
        return 0;
    }

    public static Bitmap getCachedFaviconForSize(String string2, int n) {
        String string3 = (String)sPageURLMappings.get((Object)string2);
        if (string3 == null) {
            return null;
        }
        return Favicons.getSizedFaviconFromCache(string3, n);
    }

    public static int getFaviconForSize(String string2, String string3, int n, int n2, OnFaviconLoadedListener onFaviconLoadedListener) {
        String string4 = string3;
        if (string4 == null) {
            string4 = (String)sPageURLMappings.get((Object)string2);
        }
        if (string4 == null) {
            string4 = Favicons.guessDefaultFaviconURL(string2);
        }
        if (string4 == null) {
            return Favicons.dispatchResult(string2, null, sDefaultFavicon, onFaviconLoadedListener);
        }
        Bitmap bitmap = Favicons.getSizedFaviconFromCache(string4, n);
        if (bitmap != null) {
            return Favicons.dispatchResult(string2, string4, bitmap, onFaviconLoadedListener);
        }
        if (sFaviconsCache.isFailedFavicon(string4)) {
            return Favicons.dispatchResult(string2, string4, sDefaultFavicon, onFaviconLoadedListener);
        }
        return Favicons.loadUncachedFavicon(string2, string3, n2, n, onFaviconLoadedListener);
    }

    public static Bitmap getSizedFaviconFromCache(String string2, int n) {
        return sFaviconsCache.getFaviconForDimensions(string2, n);
    }

    public static int getSizedFaviconForPageFromLocal(String string2, int n, OnFaviconLoadedListener onFaviconLoadedListener) {
        Object object;
        String string3 = (String)sPageURLMappings.get((Object)string2);
        if (string3 != null) {
            if (sFaviconsCache.isFailedFavicon(string3)) {
                return Favicons.dispatchResult(string2, string3, null, onFaviconLoadedListener);
            }
            object = Favicons.getSizedFaviconFromCache(string3, n);
            if (object != null) {
                return Favicons.dispatchResult(string2, string3, (Bitmap)object, onFaviconLoadedListener);
            }
        }
        object = new LoadFaviconTask(ThreadUtils.getBackgroundHandler(), string2, string3, 0, onFaviconLoadedListener, n, true);
        int n2 = ((LoadFaviconTask)((Object)object)).getId();
        sLoadTasks.put(n2, (LoadFaviconTask)((Object)object));
        object.execute((Object[])new Void[0]);
        return n2;
    }

    public static int getSizedFaviconForPageFromLocal(String string2, OnFaviconLoadedListener onFaviconLoadedListener) {
        return Favicons.getSizedFaviconForPageFromLocal(string2, sDefaultFaviconSize, onFaviconLoadedListener);
    }

    public static String getFaviconUrlForPageUrl(String string2) {
        String string3;
        Tab tab = Tabs.getInstance().getTabForUrl(string2);
        if (tab != null && (string3 = tab.getFaviconURL()) != null) {
            return string3;
        }
        string3 = BrowserDB.getFaviconUrlForHistoryUrl(sContext.getContentResolver(), string2);
        if (string3 == null) {
            string3 = Favicons.guessDefaultFaviconURL(string2);
        }
        return string3;
    }

    private static int loadUncachedFavicon(String string2, String string3, int n, int n2, OnFaviconLoadedListener onFaviconLoadedListener) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            Favicons.dispatchResult(null, null, null, onFaviconLoadedListener);
            return 0;
        }
        LoadFaviconTask loadFaviconTask = new LoadFaviconTask(ThreadUtils.getBackgroundHandler(), string2, string3, n, onFaviconLoadedListener, n2, false);
        int n3 = loadFaviconTask.getId();
        sLoadTasks.put(n3, loadFaviconTask);
        loadFaviconTask.execute(new Void[0]);
        return n3;
    }

    public static void putFaviconInMemCache(String string2, Bitmap bitmap) {
        sFaviconsCache.putSingleFavicon(string2, bitmap);
    }

    public static void putFaviconsInMemCache(String string2, Iterator<Bitmap> iterator, boolean bl) {
        sFaviconsCache.putFavicons(string2, iterator, bl);
    }

    public static void clearMemCache() {
        sFaviconsCache.evictAll();
        sPageURLMappings.evictAll();
    }

    public static void putFaviconInFailedCache(String string2) {
        sFaviconsCache.putFailed(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean cancelFaviconLoad(int n) {
        boolean bl;
        if (n == 0) {
            return false;
        }
        Map<Integer, LoadFaviconTask> map = sLoadTasks;
        synchronized (map) {
            if (!sLoadTasks.containsKey(n)) {
                return false;
            }
            Log.d((String)LOGTAG, (String)("Cancelling favicon load (" + n + ")"));
            LoadFaviconTask loadFaviconTask = sLoadTasks.get(n);
            bl = loadFaviconTask.cancel(false);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close() {
        Log.d((String)LOGTAG, (String)"Closing Favicons database");
        Map<Integer, LoadFaviconTask> map = sLoadTasks;
        synchronized (map) {
            Set<Integer> set = sLoadTasks.keySet();
            for (int n : set) {
                Favicons.cancelFaviconLoad(n);
            }
            sLoadTasks.clear();
        }
        LoadFaviconTask.closeHTTPClient();
    }

    public static int getFaviconColor(String string2) {
        return sFaviconsCache.getDominantColor(string2);
    }

    public static void attachToContext(Context context) throws Exception {
        Resources resources = context.getResources();
        sContext = context;
        sDefaultFavicon = BitmapFactory.decodeResource((Resources)resources, (int)R.drawable.favicon);
        if (sDefaultFavicon == null) {
            throw new Exception("Null default favicon was returned from the resources system!");
        }
        sDefaultFaviconSize = resources.getDimensionPixelSize(R.dimen.favicon_bg);
        sFaviconsCache = new FaviconCache(524288, resources.getDimensionPixelSize(R.dimen.favicon_largest_interesting_size));
        for (String string2 : AboutPages.getDefaultIconPages()) {
            sPageURLMappings.putWithoutEviction((Object)string2, (Object)BUILT_IN_FAVICON_URL);
        }
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(Favicons.loadBrandingBitmap(context, "favicon64.png"));
        arrayList.add(Favicons.loadBrandingBitmap(context, "favicon32.png"));
        Favicons.putFaviconsInMemCache(BUILT_IN_FAVICON_URL, arrayList.iterator(), true);
    }

    private static String getBrandingBitmapPath(Context context, String string2) {
        String string3 = context.getPackageResourcePath();
        return "jar:jar:" + new File(string3).toURI() + "!/" + "assets/omni.ja" + "!/" + "chrome/chrome/content/branding/" + string2;
    }

    private static Bitmap loadBrandingBitmap(Context context, String string2) {
        Bitmap bitmap = GeckoJarReader.getBitmap((Resources)context.getResources(), (String)Favicons.getBrandingBitmapPath(context, string2));
        if (bitmap == null) {
            throw new IllegalStateException("Bitmap " + string2 + " missing from JAR!");
        }
        return bitmap;
    }

    public static String guessDefaultFaviconURL(String string2) {
        if (AboutPages.isAboutPage(string2) || string2.startsWith("jar:")) {
            return string2;
        }
        try {
            URI uRI = new URI(string2);
            return new URI(uRI.getScheme(), uRI.getAuthority(), "/favicon.ico", null, null).toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            Log.e((String)LOGTAG, (String)"URISyntaxException getting default favicon URL", (Throwable)uRISyntaxException);
            return null;
        }
    }

    public static void removeLoadTask(int n) {
        sLoadTasks.remove(n);
    }

    static boolean isFailedFavicon(String string2) {
        return sFaviconsCache.isFailedFavicon(string2);
    }

    public static void getLargestFaviconForPage(String string2, OnFaviconLoadedListener onFaviconLoadedListener) {
        Favicons.loadUncachedFavicon(string2, null, 0, -1, onFaviconLoadedListener);
    }

    static {
        sLoadTasks = Collections.synchronizedMap(new HashMap());
        sPageURLMappings = new NonEvictingLruCache(128);
    }
}

