/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.sync;

import android.content.Context;
import ch.boye.httpclientandroidlib.HttpResponse;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountClient;
import org.mozilla.gecko.browserid.BrowserIDKeyPair;
import org.mozilla.gecko.browserid.JSONWebTokenUtils;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.HTTPFailureException;
import org.mozilla.gecko.sync.net.AuthHeaderProvider;
import org.mozilla.gecko.sync.net.HawkAuthHeaderProvider;
import org.mozilla.gecko.sync.net.SyncStorageResponse;
import org.mozilla.gecko.tokenserver.TokenServerClient;
import org.mozilla.gecko.tokenserver.TokenServerClientDelegate;
import org.mozilla.gecko.tokenserver.TokenServerException;
import org.mozilla.gecko.tokenserver.TokenServerToken;

public class FxAccount {
    protected static final String LOG_TAG = FxAccount.class.getSimpleName();
    protected final String email;
    protected final byte[] sessionTokenBytes;
    protected final byte[] kA;
    protected final byte[] kB;
    protected final String idpEndpoint;
    protected final String authEndpoint;
    protected final Executor executor;

    public FxAccount(String string2, byte[] byArray, byte[] byArray2, byte[] byArray3, String string3, String string4) {
        this.email = string2;
        this.sessionTokenBytes = byArray;
        this.kA = byArray2;
        this.kB = byArray3;
        this.idpEndpoint = string3;
        this.authEndpoint = string4;
        this.executor = Executors.newSingleThreadExecutor();
    }

    public void login(Context context, String string2, BrowserIDKeyPair browserIDKeyPair, Delegate delegate) {
        ExtendedJSONObject extendedJSONObject;
        try {
            extendedJSONObject = new ExtendedJSONObject(browserIDKeyPair.getPublic().serialize());
        }
        catch (Exception exception) {
            delegate.handleError(exception);
            return;
        }
        FxAccountClient fxAccountClient = new FxAccountClient(this.idpEndpoint, this.executor);
        fxAccountClient.sign(this.sessionTokenBytes, extendedJSONObject, 3600000L, new InnerFxAccountClientRequestDelegate(this.executor, this.authEndpoint, string2, browserIDKeyPair, delegate));
    }

    protected static class InnerTokenServerClientDelegate
    implements TokenServerClientDelegate {
        protected final Delegate delegate;

        public InnerTokenServerClientDelegate(Delegate delegate) {
            this.delegate = delegate;
        }

        public void handleSuccess(TokenServerToken tokenServerToken) {
            HawkAuthHeaderProvider hawkAuthHeaderProvider;
            try {
                hawkAuthHeaderProvider = new HawkAuthHeaderProvider(tokenServerToken.id, tokenServerToken.key.getBytes("UTF-8"), false);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Logger.error(LOG_TAG, "Failed to sync.", unsupportedEncodingException);
                this.delegate.handleError(unsupportedEncodingException);
                return;
            }
            this.delegate.handleSuccess(tokenServerToken.uid, tokenServerToken.endpoint, hawkAuthHeaderProvider);
        }

        public void handleFailure(TokenServerException tokenServerException) {
            Logger.error(LOG_TAG, "Failed fetching server token.", tokenServerException);
            this.delegate.handleError(tokenServerException);
        }

        public void handleError(Exception exception) {
            Logger.error(LOG_TAG, "Got error fetching token server token.", exception);
            this.delegate.handleError(exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class InnerFxAccountClientRequestDelegate
    implements FxAccountClient.RequestDelegate<String> {
        protected final Executor executor;
        protected final String audience;
        protected final String tokenServerEndpoint;
        protected final BrowserIDKeyPair keyPair;
        protected final Delegate delegate;

        protected InnerFxAccountClientRequestDelegate(Executor executor, String string2, String string3, BrowserIDKeyPair browserIDKeyPair, Delegate delegate) {
            this.executor = executor;
            this.audience = string2;
            this.tokenServerEndpoint = string3;
            this.keyPair = browserIDKeyPair;
            this.delegate = delegate;
        }

        @Override
        public void handleError(Exception exception) {
            Logger.error(LOG_TAG, "Failed to sign.", exception);
            this.delegate.handleError(exception);
        }

        @Override
        public void handleFailure(int n, HttpResponse httpResponse) {
            HTTPFailureException hTTPFailureException = new HTTPFailureException(new SyncStorageResponse(httpResponse));
            Logger.error(LOG_TAG, "Failed to sign.", hTTPFailureException);
            this.delegate.handleError(hTTPFailureException);
        }

        @Override
        public void handleSuccess(String string2) {
            Logger.pii(LOG_TAG, "Got certificate " + string2);
            try {
                String string3 = JSONWebTokenUtils.createAssertion(this.keyPair.getPrivate(), string2, this.audience);
                if (Logger.LOG_PERSONAL_INFORMATION) {
                    Logger.pii(LOG_TAG, "Generated assertion " + string3);
                    JSONWebTokenUtils.dumpAssertion(string3);
                }
                TokenServerClient tokenServerClient = new TokenServerClient(new URI(this.tokenServerEndpoint), this.executor);
                tokenServerClient.getTokenFromBrowserIDAssertion(string3, true, new InnerTokenServerClientDelegate(this.delegate));
            }
            catch (Exception exception) {
                Logger.error(LOG_TAG, "Got error doing stuff.", exception);
                this.delegate.handleError(exception);
            }
        }
    }

    public static interface Delegate {
        public void handleSuccess(String var1, String var2, AuthHeaderProvider var3);

        public void handleError(Exception var1);
    }
}

