/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.preferences;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.preference.Preference;
import android.text.SpannableString;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.R;
import org.mozilla.gecko.gfx.BitmapUtils;
import org.mozilla.gecko.preferences.SearchPreferenceCategory;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.widget.FaviconView;

public class SearchEnginePreference
extends Preference
implements View.OnLongClickListener {
    private static final String LOGTAG = "SearchEnginePreference";
    public static final int INDEX_SET_DEFAULT_BUTTON = 0;
    public static final int INDEX_REMOVE_BUTTON = 1;
    public final String LABEL_IS_DEFAULT;
    private boolean mIsDefaultEngine;
    private String[] mDialogItems;
    private AlertDialog mDialog;
    private final SearchPreferenceCategory mParentCategory;
    private BitmapDrawable mPromptIcon;
    private Bitmap mIconBitmap;
    private FaviconView mFaviconView;

    public SearchEnginePreference(Context context, SearchPreferenceCategory searchPreferenceCategory) {
        super(context);
        this.mParentCategory = searchPreferenceCategory;
        Resources resources = this.getContext().getResources();
        this.setLayoutResource(R.layout.preference_search_engine);
        this.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener(){

            public boolean onPreferenceClick(Preference preference) {
                SearchEnginePreference searchEnginePreference = (SearchEnginePreference)preference;
                searchEnginePreference.showDialog();
                return true;
            }
        });
        this.LABEL_IS_DEFAULT = resources.getString(R.string.pref_search_default);
        this.mDialogItems = new String[]{resources.getString(R.string.pref_search_set_default), resources.getString(R.string.pref_search_remove)};
    }

    protected void onBindView(View view) {
        super.onBindView(view);
        this.mFaviconView = (FaviconView)view.findViewById(R.id.search_engine_icon);
        this.mFaviconView.updateAndScaleImage(this.mIconBitmap, ((Object)this.getTitle()).toString());
    }

    public boolean onLongClick(View view) {
        this.showDialog();
        return true;
    }

    public void setSearchEngineFromJSON(JSONObject jSONObject) throws JSONException {
        String string2 = jSONObject.getString("name");
        SpannableString spannableString = new SpannableString((CharSequence)string2);
        this.setTitle((CharSequence)spannableString);
        String string3 = jSONObject.getString("iconURI");
        try {
            this.mIconBitmap = BitmapUtils.getBitmapFromDataURI(string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.e((String)LOGTAG, (String)"IllegalArgumentException creating Bitmap. Most likely a zero-length bitmap.", (Throwable)illegalArgumentException);
        }
        catch (NullPointerException nullPointerException) {
            Log.e((String)LOGTAG, (String)"NullPointerException creating Bitmap. Most likely a zero-length bitmap.", (Throwable)nullPointerException);
        }
    }

    public void setIsDefaultEngine(boolean bl) {
        this.mIsDefaultEngine = bl;
        if (bl) {
            this.setOrder(0);
            this.setSummary(this.LABEL_IS_DEFAULT);
        } else {
            this.setOrder(1);
            this.setSummary("");
        }
    }

    public void showDialog() {
        if (this.mParentCategory.getPreferenceCount() == 1) {
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                public void run() {
                    Toast.makeText((Context)SearchEnginePreference.this.getContext(), (int)R.string.pref_search_last_toast, (int)0).show();
                }
            });
            return;
        }
        final AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
        builder.setTitle((CharSequence)((Object)this.getTitle()).toString());
        builder.setItems((CharSequence[])this.mDialogItems, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                SearchEnginePreference.this.hideDialog();
                switch (n) {
                    case 0: {
                        SearchEnginePreference.this.mParentCategory.setDefault(SearchEnginePreference.this);
                        break;
                    }
                    case 1: {
                        SearchEnginePreference.this.mParentCategory.uninstall(SearchEnginePreference.this);
                        break;
                    }
                    default: {
                        Log.w((String)SearchEnginePreference.LOGTAG, (String)"Selected index out of range.");
                    }
                }
            }
        });
        if (this.mPromptIcon == null && this.mIconBitmap != null) {
            this.mPromptIcon = new BitmapDrawable(this.mFaviconView.getBitmap());
        }
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            public void run() {
                SearchEnginePreference.this.mDialog = builder.create();
                SearchEnginePreference.this.mDialog.setOnShowListener(new DialogInterface.OnShowListener(){

                    public void onShow(DialogInterface dialogInterface) {
                        SearchEnginePreference.this.configureShownDialog();
                    }
                });
                SearchEnginePreference.this.mDialog.show();
            }
        });
    }

    public void hideDialog() {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            public void run() {
                if (SearchEnginePreference.this.mDialog != null && SearchEnginePreference.this.mDialog.isShowing()) {
                    SearchEnginePreference.this.mDialog.dismiss();
                }
            }
        });
    }

    private void configureShownDialog() {
        TextView textView = (TextView)this.mDialog.getListView().getChildAt(0);
        if (this.mIsDefaultEngine) {
            textView.setEnabled(false);
            textView.setOnClickListener(null);
        }
    }
}

