/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.Utils;

public class InfoCollections {
    private static final String LOG_TAG = "InfoCollections";
    final Map<String, Long> timestamps;

    public InfoCollections(ExtendedJSONObject extendedJSONObject) {
        Logger.debug(LOG_TAG, "info/collections is " + extendedJSONObject.toJSONString());
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        Set set = extendedJSONObject.object.entrySet();
        for (Map.Entry entry : set) {
            String string2 = (String)entry.getKey();
            Object v = entry.getValue();
            if (v instanceof Double) {
                hashMap.put(string2, Utils.decimalSecondsToMilliseconds((Double)v));
                continue;
            }
            if (v instanceof Long) {
                hashMap.put(string2, Utils.decimalSecondsToMilliseconds((Long)v));
                continue;
            }
            if (v instanceof Integer) {
                hashMap.put(string2, Utils.decimalSecondsToMilliseconds((Integer)v));
                continue;
            }
            Logger.warn(LOG_TAG, "Skipping info/collections entry for " + string2);
        }
        this.timestamps = Collections.unmodifiableMap(hashMap);
    }

    public Long getTimestamp(String string2) {
        if (this.timestamps == null) {
            return null;
        }
        return this.timestamps.get(string2);
    }

    public boolean updateNeeded(String string2, long l) {
        Logger.trace(LOG_TAG, "Testing " + string2 + " for updateNeeded. Local last modified is " + l + ".");
        if (l <= 0L) {
            return true;
        }
        Long l2 = this.getTimestamp(string2);
        if (l2 == null) {
            return true;
        }
        return l2 > l;
    }
}

