/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.browserid;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import org.mozilla.gecko.browserid.ASNUtils;
import org.mozilla.gecko.browserid.BrowserIDKeyPair;
import org.mozilla.gecko.browserid.SigningPrivateKey;
import org.mozilla.gecko.browserid.VerifyingPublicKey;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.Utils;

public class DSACryptoImplementation {
    public static final String SIGNATURE_ALGORITHM = "SHA1withDSA";
    public static final int SIGNATURE_LENGTH_BYTES = 40;

    public static BrowserIDKeyPair generateKeypair(int n) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DSA");
        keyPairGenerator.initialize(n);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)keyPair.getPrivate();
        DSAPublicKey dSAPublicKey = (DSAPublicKey)keyPair.getPublic();
        return new BrowserIDKeyPair(new DSASigningPrivateKey(dSAPrivateKey), new DSAVerifyingPublicKey(dSAPublicKey));
    }

    public static SigningPrivateKey createPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (bigInteger == null) {
            throw new IllegalArgumentException("x must not be null");
        }
        if (bigInteger2 == null) {
            throw new IllegalArgumentException("p must not be null");
        }
        if (bigInteger3 == null) {
            throw new IllegalArgumentException("q must not be null");
        }
        if (bigInteger4 == null) {
            throw new IllegalArgumentException("g must not be null");
        }
        DSAPrivateKeySpec dSAPrivateKeySpec = new DSAPrivateKeySpec(bigInteger, bigInteger2, bigInteger3, bigInteger4);
        KeyFactory keyFactory = KeyFactory.getInstance("DSA");
        DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)keyFactory.generatePrivate(dSAPrivateKeySpec);
        return new DSASigningPrivateKey(dSAPrivateKey);
    }

    public static VerifyingPublicKey createPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (bigInteger == null) {
            throw new IllegalArgumentException("n must not be null");
        }
        if (bigInteger2 == null) {
            throw new IllegalArgumentException("p must not be null");
        }
        if (bigInteger3 == null) {
            throw new IllegalArgumentException("q must not be null");
        }
        if (bigInteger4 == null) {
            throw new IllegalArgumentException("g must not be null");
        }
        DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(bigInteger, bigInteger2, bigInteger3, bigInteger4);
        KeyFactory keyFactory = KeyFactory.getInstance("DSA");
        DSAPublicKey dSAPublicKey = (DSAPublicKey)keyFactory.generatePublic(dSAPublicKeySpec);
        return new DSAVerifyingPublicKey(dSAPublicKey);
    }

    protected static class DSASigningPrivateKey
    implements SigningPrivateKey {
        protected final DSAPrivateKey privateKey;

        public DSASigningPrivateKey(DSAPrivateKey dSAPrivateKey) {
            this.privateKey = dSAPrivateKey;
        }

        public String getAlgorithm() {
            return "DS" + (this.privateKey.getParams().getP().bitLength() + 7) / 8;
        }

        public String serialize() {
            DSAParams dSAParams = this.privateKey.getParams();
            ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
            extendedJSONObject.put("algorithm", "DS");
            extendedJSONObject.put("x", this.privateKey.getX().toString(16));
            extendedJSONObject.put("g", dSAParams.getG().toString(16));
            extendedJSONObject.put("p", dSAParams.getP().toString(16));
            extendedJSONObject.put("q", dSAParams.getQ().toString(16));
            return extendedJSONObject.toJSONString();
        }

        public byte[] signMessage(byte[] byArray) throws GeneralSecurityException {
            if (byArray == null) {
                throw new IllegalArgumentException("bytes must not be null");
            }
            Signature signature = Signature.getInstance(DSACryptoImplementation.SIGNATURE_ALGORITHM);
            signature.initSign(this.privateKey);
            signature.update(byArray);
            byte[] byArray2 = signature.sign();
            byte[][] byArray3 = ASNUtils.decodeTwoArraysFromASN1(byArray2);
            BigInteger bigInteger = new BigInteger(byArray3[0]);
            BigInteger bigInteger2 = new BigInteger(byArray3[1]);
            byte[] byArray4 = Utils.concatAll(Utils.hex2Byte(bigInteger.toString(16), 20), new byte[][]{Utils.hex2Byte(bigInteger2.toString(16), 20)});
            return byArray4;
        }
    }

    protected static class DSAVerifyingPublicKey
    implements VerifyingPublicKey {
        protected final DSAPublicKey publicKey;

        public DSAVerifyingPublicKey(DSAPublicKey dSAPublicKey) {
            this.publicKey = dSAPublicKey;
        }

        public String serialize() {
            DSAParams dSAParams = this.publicKey.getParams();
            ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
            extendedJSONObject.put("algorithm", "DS");
            extendedJSONObject.put("y", this.publicKey.getY().toString(16));
            extendedJSONObject.put("g", dSAParams.getG().toString(16));
            extendedJSONObject.put("p", dSAParams.getP().toString(16));
            extendedJSONObject.put("q", dSAParams.getQ().toString(16));
            return extendedJSONObject.toJSONString();
        }

        public boolean verifyMessage(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
            if (byArray == null) {
                throw new IllegalArgumentException("bytes must not be null");
            }
            if (byArray2 == null) {
                throw new IllegalArgumentException("signature must not be null");
            }
            if (byArray2.length != 40) {
                return false;
            }
            byte[] byArray3 = new byte[byArray2.length / 2];
            byte[] byArray4 = new byte[byArray2.length / 2];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
            System.arraycopy(byArray2, byArray3.length, byArray4, 0, byArray4.length);
            BigInteger bigInteger = new BigInteger(Utils.byte2Hex(byArray3), 16);
            BigInteger bigInteger2 = new BigInteger(Utils.byte2Hex(byArray4), 16);
            byte[] byArray5 = ASNUtils.encodeTwoArraysToASN1(Utils.hex2Byte(bigInteger.toString(16), 21), Utils.hex2Byte(bigInteger2.toString(16), 21));
            Signature signature = Signature.getInstance(DSACryptoImplementation.SIGNATURE_ALGORITHM);
            signature.initVerify(this.publicKey);
            signature.update(byArray);
            return signature.verify(byArray5);
        }
    }
}

