/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.opengl.GLES20;
import android.os.SystemClock;
import android.util.Log;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.microedition.khronos.egl.EGLConfig;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.gfx.ImmutableViewportMetrics;
import org.mozilla.gecko.gfx.IntSize;
import org.mozilla.gecko.gfx.Layer;
import org.mozilla.gecko.gfx.LayerView;
import org.mozilla.gecko.gfx.PanningPerfAPI;
import org.mozilla.gecko.gfx.RectUtils;
import org.mozilla.gecko.gfx.RenderTask;
import org.mozilla.gecko.gfx.ScrollbarLayer;
import org.mozilla.gecko.gfx.TextLayer;
import org.mozilla.gecko.gfx.TextureGenerator;
import org.mozilla.gecko.gfx.TextureReaper;
import org.mozilla.gecko.mozglue.DirectBufferAllocator;
import org.mozilla.gecko.mozglue.JNITarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerRenderer
implements Tabs.OnTabsChangedListener {
    private static final String LOGTAG = "GeckoLayerRenderer";
    private static final String PROFTAG = "GeckoLayerRendererProf";
    private static final int MAX_FRAME_TIME = 16;
    private static final int FRAME_RATE_METER_WIDTH = 128;
    private static final int FRAME_RATE_METER_HEIGHT = 32;
    private static final long NANOS_PER_MS = 1000000L;
    private static final int NANOS_PER_SECOND = 1000000000;
    private final LayerView mView;
    private TextLayer mFrameRateLayer;
    private final ScrollbarLayer mHorizScrollLayer;
    private final ScrollbarLayer mVertScrollLayer;
    private final FadeRunnable mFadeRunnable;
    private ByteBuffer mCoordByteBuffer;
    private FloatBuffer mCoordBuffer;
    private Layer.RenderContext mLastPageContext;
    private int mMaxTextureSize;
    private int mBackgroundColor;
    private long mLastFrameTime;
    private final CopyOnWriteArrayList<RenderTask> mTasks;
    private CopyOnWriteArrayList<Layer> mExtraLayers = new CopyOnWriteArrayList();
    private int[] mFrameTimings;
    private int mCurrentFrame;
    private int mFrameTimingsSum;
    private int mDroppedFrames;
    private int mFramesRendered;
    private float mCompleteFramesRendered;
    private boolean mProfileRender;
    private long mProfileOutputTime;
    private IntBuffer mPixelBuffer;
    private int mProgram;
    private int mPositionHandle;
    private int mTextureHandle;
    private int mSampleHandle;
    private int mTMatrixHandle;
    public static final float[] DEFAULT_TEXTURE_MATRIX = new float[]{2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f, -1.0f, -1.0f, 0.0f, 1.0f};
    private static final int COORD_BUFFER_SIZE = 20;
    public static final String DEFAULT_VERTEX_SHADER = "uniform mat4 uTMatrix;\nattribute vec4 vPosition;\nattribute vec2 aTexCoord;\nvarying vec2 vTexCoord;\nvoid main() {\n    gl_Position = uTMatrix * vPosition;\n    vTexCoord.x = aTexCoord.x;\n    vTexCoord.y = 1.0 - aTexCoord.y;\n}\n";
    public static final String DEFAULT_FRAGMENT_SHADER = "precision highp float;\nvarying vec2 vTexCoord;\nuniform sampler2D sTexture;\nvoid main() {\n    gl_FragColor = texture2D(sTexture, vTexCoord);\n}\n";

    public LayerRenderer(LayerView layerView) {
        this.mView = layerView;
        Bitmap bitmap = layerView.getScrollbarImage();
        IntSize intSize = new IntSize(bitmap.getWidth(), bitmap.getHeight());
        bitmap = this.expandCanvasToPowerOfTwo(bitmap, intSize);
        this.mTasks = new CopyOnWriteArrayList();
        this.mLastFrameTime = System.nanoTime();
        this.mVertScrollLayer = new ScrollbarLayer(this, bitmap, intSize, true);
        this.mHorizScrollLayer = new ScrollbarLayer(this, this.diagonalFlip(bitmap), new IntSize(intSize.height, intSize.width), false);
        this.mFadeRunnable = new FadeRunnable();
        this.mFrameTimings = new int[60];
        this.mDroppedFrames = 0;
        this.mFrameTimingsSum = 0;
        this.mCurrentFrame = 0;
        this.mCoordByteBuffer = DirectBufferAllocator.allocate((int)80);
        this.mCoordByteBuffer.order(ByteOrder.nativeOrder());
        this.mCoordBuffer = this.mCoordByteBuffer.asFloatBuffer();
        Tabs.registerOnTabsChangedListener(this);
    }

    private Bitmap expandCanvasToPowerOfTwo(Bitmap bitmap, IntSize intSize) {
        IntSize intSize2 = intSize.nextPowerOfTwo();
        if (intSize.equals(intSize2)) {
            return bitmap;
        }
        Bitmap bitmap2 = Bitmap.createBitmap((int)intSize2.width, (int)intSize2.height, (Bitmap.Config)bitmap.getConfig());
        new Canvas(bitmap2).drawBitmap(bitmap, new Matrix(), null);
        return bitmap2;
    }

    private Bitmap diagonalFlip(Bitmap bitmap) {
        Matrix matrix = new Matrix();
        matrix.setValues(new float[]{0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        return bitmap2;
    }

    public void destroy() {
        DirectBufferAllocator.free((ByteBuffer)this.mCoordByteBuffer);
        this.mCoordByteBuffer = null;
        this.mCoordBuffer = null;
        this.mHorizScrollLayer.destroy();
        this.mVertScrollLayer.destroy();
        if (this.mFrameRateLayer != null) {
            this.mFrameRateLayer.destroy();
        }
        Tabs.unregisterOnTabsChangedListener(this);
    }

    void onSurfaceCreated(EGLConfig eGLConfig) {
        this.checkMonitoringEnabled();
        this.createDefaultProgram();
        this.activateDefaultProgram();
    }

    public void createDefaultProgram() {
        int n = LayerRenderer.loadShader(35633, DEFAULT_VERTEX_SHADER);
        int n2 = LayerRenderer.loadShader(35632, DEFAULT_FRAGMENT_SHADER);
        this.mProgram = GLES20.glCreateProgram();
        GLES20.glAttachShader((int)this.mProgram, (int)n);
        GLES20.glAttachShader((int)this.mProgram, (int)n2);
        GLES20.glLinkProgram((int)this.mProgram);
        this.mPositionHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"vPosition");
        this.mTextureHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"aTexCoord");
        this.mSampleHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"sTexture");
        this.mTMatrixHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"uTMatrix");
        int[] nArray = new int[1];
        GLES20.glGetIntegerv((int)3379, (int[])nArray, (int)0);
        this.mMaxTextureSize = nArray[0];
    }

    public void activateDefaultProgram() {
        GLES20.glUseProgram((int)this.mProgram);
        GLES20.glUniformMatrix4fv((int)this.mTMatrixHandle, (int)1, (boolean)false, (float[])DEFAULT_TEXTURE_MATRIX, (int)0);
        GLES20.glEnableVertexAttribArray((int)this.mPositionHandle);
        GLES20.glEnableVertexAttribArray((int)this.mTextureHandle);
        GLES20.glUniform1i((int)this.mSampleHandle, (int)0);
    }

    public void deactivateDefaultProgram() {
        GLES20.glDisableVertexAttribArray((int)this.mTextureHandle);
        GLES20.glDisableVertexAttribArray((int)this.mPositionHandle);
        GLES20.glUseProgram((int)0);
    }

    public int getMaxTextureSize() {
        return this.mMaxTextureSize;
    }

    public void postRenderTask(RenderTask renderTask) {
        this.mTasks.add(renderTask);
        this.mView.requestRender();
    }

    public void removeRenderTask(RenderTask renderTask) {
        this.mTasks.remove(renderTask);
    }

    private void runRenderTasks(CopyOnWriteArrayList<RenderTask> copyOnWriteArrayList, boolean bl, long l) {
        for (RenderTask renderTask : copyOnWriteArrayList) {
            boolean bl2;
            if (renderTask.runAfter != bl || (bl2 = renderTask.run(l - this.mLastFrameTime, l))) continue;
            copyOnWriteArrayList.remove(renderTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayer(Layer layer) {
        CopyOnWriteArrayList<Layer> copyOnWriteArrayList = this.mExtraLayers;
        synchronized (copyOnWriteArrayList) {
            if (this.mExtraLayers.contains(layer)) {
                this.mExtraLayers.remove(layer);
            }
            this.mExtraLayers.add(layer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLayer(Layer layer) {
        CopyOnWriteArrayList<Layer> copyOnWriteArrayList = this.mExtraLayers;
        synchronized (copyOnWriteArrayList) {
            this.mExtraLayers.remove(layer);
        }
    }

    private void printCheckerboardStats() {
        Log.d((String)PROFTAG, (String)("Frames rendered over last 1000ms: " + this.mCompleteFramesRendered + "/" + this.mFramesRendered));
        this.mFramesRendered = 0;
        this.mCompleteFramesRendered = 0.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IntBuffer getPixels() {
        IntBuffer intBuffer;
        IntBuffer intBuffer2 = intBuffer = IntBuffer.allocate(this.mView.getWidth() * this.mView.getHeight());
        synchronized (intBuffer2) {
            this.mPixelBuffer = intBuffer;
            this.mView.requestRender();
            try {
                intBuffer.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.mPixelBuffer = null;
        }
        return intBuffer;
    }

    private Layer.RenderContext createScreenContext(ImmutableViewportMetrics immutableViewportMetrics, PointF pointF) {
        RectF rectF = new RectF(0.0f, 0.0f, immutableViewportMetrics.getWidth(), immutableViewportMetrics.getHeight());
        RectF rectF2 = immutableViewportMetrics.getPageRect();
        return this.createContext(rectF, rectF2, 1.0f, pointF);
    }

    private Layer.RenderContext createPageContext(ImmutableViewportMetrics immutableViewportMetrics, PointF pointF) {
        RectF rectF = immutableViewportMetrics.getViewport();
        RectF rectF2 = immutableViewportMetrics.getPageRect();
        float f = immutableViewportMetrics.zoomFactor;
        return this.createContext(new RectF(RectUtils.round(rectF)), rectF2, f, pointF);
    }

    private Layer.RenderContext createContext(RectF rectF, RectF rectF2, float f, PointF pointF) {
        return new Layer.RenderContext(rectF, rectF2, f, pointF, this.mPositionHandle, this.mTextureHandle, this.mCoordBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDroppedFrames(long l) {
        int n = (int)((System.nanoTime() - l) / 1000000L);
        this.mFrameTimingsSum -= this.mFrameTimings[this.mCurrentFrame];
        this.mFrameTimingsSum += n;
        this.mDroppedFrames -= (this.mFrameTimings[this.mCurrentFrame] + 1) / 16;
        this.mDroppedFrames += (n + 1) / 16;
        this.mFrameTimings[this.mCurrentFrame] = n;
        this.mCurrentFrame = (this.mCurrentFrame + 1) % this.mFrameTimings.length;
        int n2 = this.mFrameTimingsSum / this.mFrameTimings.length;
        this.mFrameRateLayer.beginTransaction();
        try {
            this.mFrameRateLayer.setText(n2 + " ms/" + this.mDroppedFrames);
        }
        finally {
            this.mFrameRateLayer.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveFrameRateLayer(int n, int n2) {
        this.mFrameRateLayer.beginTransaction();
        try {
            Rect rect = new Rect(n - 128 - 8, n2 - 32 + 8, n - 8, n2 + 8);
            this.mFrameRateLayer.setPosition(rect);
        }
        finally {
            this.mFrameRateLayer.endTransaction();
        }
    }

    void checkMonitoringEnabled() {
        new Thread(new Runnable(){

            public void run() {
                Context context = LayerRenderer.this.mView.getContext();
                SharedPreferences sharedPreferences = context.getSharedPreferences("GeckoApp", 0);
                if (sharedPreferences.getBoolean("showFrameRate", false)) {
                    IntSize intSize = new IntSize(128, 32);
                    LayerRenderer.this.mFrameRateLayer = TextLayer.create(intSize, "-- ms/--");
                    LayerRenderer.this.moveFrameRateLayer(LayerRenderer.this.mView.getWidth(), LayerRenderer.this.mView.getHeight());
                }
                LayerRenderer.this.mProfileRender = Log.isLoggable((String)LayerRenderer.PROFTAG, (int)3);
            }
        }).start();
    }

    public static int loadShader(int n, String string2) {
        int n2 = GLES20.glCreateShader((int)n);
        GLES20.glShaderSource((int)n2, (String)string2);
        GLES20.glCompileShader((int)n2);
        return n2;
    }

    public Frame createFrame(ImmutableViewportMetrics immutableViewportMetrics) {
        return new Frame(immutableViewportMetrics);
    }

    @Override
    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, Object object) {
        if (tabEvents == Tabs.TabEvents.SELECTED && this.mView != null) {
            if (this.mView.getChildAt(0) != null) {
                this.mView.getChildAt(0).setBackgroundColor(tab.getBackgroundColor());
            }
            this.mView.setPaintState(0);
        }
    }

    public class Frame {
        private long mFrameStartTime;
        private ImmutableViewportMetrics mFrameMetrics;
        private Layer.RenderContext mPageContext;
        private Layer.RenderContext mScreenContext;
        private boolean mUpdated;
        private final Rect mPageRect;
        private final Rect mAbsolutePageRect;
        private final PointF mRenderOffset;

        public Frame(ImmutableViewportMetrics immutableViewportMetrics) {
            this.mFrameMetrics = immutableViewportMetrics;
            Layer layer = LayerRenderer.this.mView.getLayerClient().getRoot();
            this.mRenderOffset = this.mFrameMetrics.getMarginOffset();
            this.mPageContext = LayerRenderer.this.createPageContext(immutableViewportMetrics, this.mRenderOffset);
            this.mScreenContext = LayerRenderer.this.createScreenContext(immutableViewportMetrics, this.mRenderOffset);
            RectF rectF = this.mFrameMetrics.getPageRect();
            this.mAbsolutePageRect = RectUtils.round(rectF);
            PointF pointF = this.mFrameMetrics.getOrigin();
            rectF.offset(-pointF.x, -pointF.y);
            this.mPageRect = RectUtils.round(rectF);
        }

        private void setScissorRect() {
            Rect rect = this.transformToScissorRect(this.mPageRect);
            GLES20.glEnable((int)3089);
            GLES20.glScissor((int)rect.left, (int)rect.top, (int)rect.width(), (int)rect.height());
        }

        private Rect transformToScissorRect(Rect rect) {
            IntSize intSize = new IntSize(this.mFrameMetrics.getSize());
            int n = Math.max(0, rect.left);
            int n2 = Math.max(0, rect.top);
            int n3 = Math.min(intSize.width, rect.right);
            int n4 = Math.min(intSize.height, rect.bottom);
            Rect rect2 = new Rect(n, intSize.height - n4, n3, intSize.height - n4 + (n4 - n2));
            rect2.offset(Math.round(-this.mRenderOffset.x), Math.round(-this.mRenderOffset.y));
            return rect2;
        }

        @JNITarget
        public void beginDrawing() {
            boolean bl;
            this.mFrameStartTime = System.nanoTime();
            TextureReaper.get().reap();
            TextureGenerator.get().fill();
            this.mUpdated = true;
            Layer layer = LayerRenderer.this.mView.getLayerClient().getRoot();
            LayerRenderer.this.runRenderTasks(LayerRenderer.this.mTasks, false, this.mFrameStartTime);
            if (!this.mPageContext.fuzzyEquals(LayerRenderer.this.mLastPageContext) && !LayerRenderer.this.mView.isFullScreen()) {
                LayerRenderer.this.mVertScrollLayer.unfade();
                LayerRenderer.this.mHorizScrollLayer.unfade();
                LayerRenderer.this.mFadeRunnable.scheduleStartFade(500L);
            } else if (LayerRenderer.this.mFadeRunnable.timeToFade() && (bl = LayerRenderer.this.mVertScrollLayer.fade() | LayerRenderer.this.mHorizScrollLayer.fade())) {
                LayerRenderer.this.mFadeRunnable.scheduleNextFadeFrame();
            }
            LayerRenderer.this.mLastPageContext = this.mPageContext;
            if (layer != null) {
                this.mUpdated &= layer.update(this.mPageContext);
            }
            if (LayerRenderer.this.mFrameRateLayer != null) {
                this.mUpdated &= LayerRenderer.this.mFrameRateLayer.update(this.mScreenContext);
            }
            this.mUpdated &= LayerRenderer.this.mVertScrollLayer.update(this.mPageContext);
            this.mUpdated &= LayerRenderer.this.mHorizScrollLayer.update(this.mPageContext);
            for (Layer layer2 : LayerRenderer.this.mExtraLayers) {
                this.mUpdated &= layer2.update(this.mPageContext);
            }
        }

        private Rect getMaskForLayer(Layer layer) {
            if (layer == null) {
                return null;
            }
            RectF rectF = RectUtils.contract(layer.getBounds(this.mPageContext), 1.0f, 1.0f);
            Rect rect = RectUtils.roundIn(rectF);
            if (rect.top <= 2) {
                rect.top = -1;
            }
            if (rect.left <= 2) {
                rect.left = -1;
            }
            int n = this.mPageRect.width();
            int n2 = this.mPageRect.height();
            if (rect.right >= n - 2) {
                rect.right = n + 1;
            }
            if (rect.bottom >= n2 - 2) {
                rect.bottom = n2 + 1;
            }
            return rect;
        }

        private void clear(int n) {
            GLES20.glClearColor((float)((float)(n >> 16 & 0xFF) / 255.0f), (float)((float)(n >> 8 & 0xFF) / 255.0f), (float)((float)(n & 0xFF) / 255.0f), (float)0.0f);
            GLES20.glClear((int)16640);
        }

        @JNITarget
        public void drawBackground() {
            GLES20.glDisable((int)3089);
            LayerRenderer.this.mBackgroundColor = LayerRenderer.this.mView.getBackgroundColor();
            this.setScissorRect();
            this.clear(LayerRenderer.this.mBackgroundColor);
            GLES20.glDisable((int)3089);
        }

        void drawRootLayer() {
            Layer layer = LayerRenderer.this.mView.getLayerClient().getRoot();
            if (layer == null) {
                return;
            }
            layer.draw(this.mPageContext);
        }

        @JNITarget
        public void drawForeground() {
            Object object;
            if (LayerRenderer.this.mExtraLayers.size() > 0) {
                object = LayerRenderer.this.mExtraLayers.iterator();
                while (object.hasNext()) {
                    Layer layer = (Layer)object.next();
                    layer.draw(this.mPageContext);
                }
            }
            if ((float)this.mPageRect.height() > this.mFrameMetrics.getHeight()) {
                LayerRenderer.this.mVertScrollLayer.draw(this.mPageContext);
            }
            if ((float)this.mPageRect.width() > this.mFrameMetrics.getWidth()) {
                LayerRenderer.this.mHorizScrollLayer.draw(this.mPageContext);
            }
            if ((object = LayerRenderer.this.mView.getLayerClient().getRoot()) != null && (LayerRenderer.this.mProfileRender || PanningPerfAPI.isRecordingCheckerboard())) {
                float f = 1.0f - GeckoAppShell.computeRenderIntegrity();
                PanningPerfAPI.recordCheckerboard(f);
                if (f < 0.0f || f > 1.0f) {
                    Log.e((String)LayerRenderer.LOGTAG, (String)("Checkerboard value out of bounds: " + f));
                }
                LayerRenderer.this.mCompleteFramesRendered += 1.0f - f;
                LayerRenderer.this.mFramesRendered++;
                if (this.mFrameStartTime - LayerRenderer.this.mProfileOutputTime > 1000000000L) {
                    LayerRenderer.this.mProfileOutputTime = this.mFrameStartTime;
                    LayerRenderer.this.printCheckerboardStats();
                }
            }
            LayerRenderer.this.runRenderTasks(LayerRenderer.this.mTasks, true, this.mFrameStartTime);
            if (LayerRenderer.this.mFrameRateLayer != null) {
                LayerRenderer.this.updateDroppedFrames(this.mFrameStartTime);
                GLES20.glEnable((int)3042);
                GLES20.glBlendFunc((int)770, (int)771);
                LayerRenderer.this.mFrameRateLayer.draw(this.mScreenContext);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JNITarget
        public void endDrawing() {
            if (!this.mUpdated) {
                LayerRenderer.this.mView.requestRender();
            }
            PanningPerfAPI.recordFrameTime();
            IntBuffer intBuffer = LayerRenderer.this.mPixelBuffer;
            if (this.mUpdated && intBuffer != null) {
                IntBuffer intBuffer2 = intBuffer;
                synchronized (intBuffer2) {
                    intBuffer.position(0);
                    GLES20.glReadPixels((int)0, (int)0, (int)((int)this.mScreenContext.viewport.width()), (int)((int)this.mScreenContext.viewport.height()), (int)6408, (int)5121, (Buffer)intBuffer);
                    intBuffer.notify();
                }
            }
            if (LayerRenderer.this.mView.getPaintState() == 1) {
                LayerRenderer.this.mView.post(new Runnable(){

                    public void run() {
                        LayerRenderer.this.mView.getChildAt(0).setBackgroundColor(0);
                    }
                });
                LayerRenderer.this.mView.setPaintState(2);
            }
            LayerRenderer.this.mLastFrameTime = this.mFrameStartTime;
        }
    }

    class FadeRunnable
    implements Runnable {
        private boolean mStarted;
        private long mRunAt;

        FadeRunnable() {
        }

        void scheduleStartFade(long l) {
            this.mRunAt = SystemClock.elapsedRealtime() + l;
            if (!this.mStarted) {
                LayerRenderer.this.mView.postDelayed(this, l);
                this.mStarted = true;
            }
        }

        void scheduleNextFadeFrame() {
            if (this.mStarted) {
                Log.e((String)LayerRenderer.LOGTAG, (String)"scheduleNextFadeFrame() called while scheduled for starting fade");
            }
            LayerRenderer.this.mView.postDelayed(this, 16L);
        }

        boolean timeToFade() {
            return !this.mStarted;
        }

        public void run() {
            long l = this.mRunAt - SystemClock.elapsedRealtime();
            if (l > 0L) {
                LayerRenderer.this.mView.postDelayed(this, l);
            } else {
                this.mStarted = false;
                LayerRenderer.this.mView.requestRender();
            }
        }
    }
}

