/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.home.HomeFragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HomeAdapter
extends FragmentStatePagerAdapter {
    private final Context mContext;
    private final ArrayList<PageInfo> mPageInfos;
    private final HashMap<String, Fragment> mPages;
    private boolean mCanLoadHint;
    private OnAddPageListener mAddPageListener;

    public HomeAdapter(Context context, FragmentManager fragmentManager) {
        super(fragmentManager);
        this.mContext = context;
        this.mCanLoadHint = false;
        this.mPageInfos = new ArrayList();
        this.mPages = new HashMap();
    }

    public int getCount() {
        return this.mPageInfos.size();
    }

    public Fragment getItem(int n) {
        PageInfo pageInfo = this.mPageInfos.get(n);
        return Fragment.instantiate((Context)this.mContext, (String)pageInfo.getClassName(), (Bundle)pageInfo.getArgs());
    }

    public CharSequence getPageTitle(int n) {
        if (this.mPageInfos.size() > 0) {
            PageInfo pageInfo = this.mPageInfos.get(n);
            return pageInfo.getTitle().toUpperCase();
        }
        return null;
    }

    public Object instantiateItem(ViewGroup viewGroup, int n) {
        Fragment fragment = (Fragment)super.instantiateItem(viewGroup, n);
        this.mPages.put(this.mPageInfos.get(n).getId(), fragment);
        return fragment;
    }

    public void destroyItem(ViewGroup viewGroup, int n, Object object) {
        super.destroyItem(viewGroup, n, object);
        this.mPages.remove(this.mPageInfos.get(n).getId());
    }

    public void setOnAddPageListener(OnAddPageListener onAddPageListener) {
        this.mAddPageListener = onAddPageListener;
    }

    public int getItemPosition(String string2) {
        for (int i = 0; i < this.mPageInfos.size(); ++i) {
            String string3 = this.mPageInfos.get(i).getId();
            if (!string3.equals(string2)) continue;
            return i;
        }
        return -1;
    }

    public String getPageIdAtPosition(int n) {
        if (this.mPageInfos.isEmpty()) {
            return null;
        }
        return this.mPageInfos.get(n).getId();
    }

    private void addPage(PageInfo pageInfo) {
        this.mPageInfos.add(pageInfo);
        if (this.mAddPageListener != null) {
            this.mAddPageListener.onAddPage(pageInfo.getTitle());
        }
    }

    public void update(List<HomeConfig.PageEntry> list) {
        this.mPages.clear();
        this.mPageInfos.clear();
        if (list != null) {
            for (HomeConfig.PageEntry pageEntry : list) {
                PageInfo pageInfo = new PageInfo(pageEntry);
                this.addPage(pageInfo);
            }
        }
        this.notifyDataSetChanged();
    }

    public boolean getCanLoadHint() {
        return this.mCanLoadHint;
    }

    public void setCanLoadHint(boolean bl) {
        this.mCanLoadHint = bl;
        for (Fragment fragment : this.mPages.values()) {
            HomeFragment homeFragment = (HomeFragment)fragment;
            homeFragment.setCanLoadHint(bl);
        }
    }

    private final class PageInfo {
        private final HomeConfig.PageEntry mPageEntry;

        PageInfo(HomeConfig.PageEntry pageEntry) {
            this.mPageEntry = pageEntry;
        }

        public String getId() {
            return this.mPageEntry.getId();
        }

        public String getTitle() {
            return this.mPageEntry.getTitle();
        }

        public String getClassName() {
            HomeConfig.PageType pageType = this.mPageEntry.getType();
            return pageType.getPageClass().getName();
        }

        public Bundle getArgs() {
            Bundle bundle = new Bundle();
            bundle.putBoolean("canLoad", HomeAdapter.this.mCanLoadHint);
            if (this.mPageEntry.getType() == HomeConfig.PageType.LIST) {
                bundle.putParcelable("pageEntry", (Parcelable)this.mPageEntry);
            }
            return bundle;
        }
    }

    static interface OnAddPageListener {
        public void onAddPage(String var1);
    }
}

