/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.EnumSet;
import java.util.List;
import org.mozilla.gecko.home.BookmarksPage;
import org.mozilla.gecko.home.HistoryPage;
import org.mozilla.gecko.home.HomeConfigMemBackend;
import org.mozilla.gecko.home.ListPage;
import org.mozilla.gecko.home.ReadingListPage;
import org.mozilla.gecko.home.TopSitesPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HomeConfig {
    private final HomeConfigBackend mBackend;

    public HomeConfig(HomeConfigBackend homeConfigBackend) {
        this.mBackend = homeConfigBackend;
    }

    public List<PageEntry> load() {
        return this.mBackend.load();
    }

    public void save(List<PageEntry> list) {
        this.mBackend.save(list);
    }

    public void setOnChangeListener(OnChangeListener onChangeListener) {
        this.mBackend.setOnChangeListener(onChangeListener);
    }

    public static HomeConfig getDefault(Context context) {
        return new HomeConfig(new HomeConfigMemBackend(context));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface HomeConfigBackend {
        public List<PageEntry> load();

        public void save(List<PageEntry> var1);

        public void setOnChangeListener(OnChangeListener var1);
    }

    public static interface OnChangeListener {
        public void onChange();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PageEntry
    implements Parcelable {
        private final PageType mType;
        private final String mTitle;
        private final String mId;
        private final EnumSet<Flags> mFlags;
        public static final Parcelable.Creator<PageEntry> CREATOR = new Parcelable.Creator<PageEntry>(){

            public PageEntry createFromParcel(Parcel parcel) {
                return new PageEntry(parcel);
            }

            public PageEntry[] newArray(int n) {
                return new PageEntry[n];
            }
        };

        public PageEntry(Parcel parcel) {
            this.mType = (PageType)parcel.readParcelable(this.getClass().getClassLoader());
            this.mTitle = parcel.readString();
            this.mId = parcel.readString();
            this.mFlags = (EnumSet)parcel.readSerializable();
        }

        public PageEntry(PageType pageType, String string2) {
            this(pageType, string2, EnumSet.noneOf(Flags.class));
        }

        public PageEntry(PageType pageType, String string2, EnumSet<Flags> enumSet) {
            this(pageType, string2, pageType.toString(), enumSet);
        }

        public PageEntry(PageType pageType, String string2, String string3) {
            this(pageType, string2, string3, EnumSet.noneOf(Flags.class));
        }

        public PageEntry(PageType pageType, String string2, String string3, EnumSet<Flags> enumSet) {
            if (pageType == null) {
                throw new IllegalArgumentException("Can't create PageEntry with null type");
            }
            this.mType = pageType;
            if (string2 == null) {
                throw new IllegalArgumentException("Can't create PageEntry with null title");
            }
            this.mTitle = string2;
            if (string3 == null) {
                throw new IllegalArgumentException("Can't create PageEntry with null id");
            }
            this.mId = string3;
            if (enumSet == null) {
                throw new IllegalArgumentException("Can't create PageEntry with null flags");
            }
            this.mFlags = enumSet;
        }

        public PageType getType() {
            return this.mType;
        }

        public String getTitle() {
            return this.mTitle;
        }

        public String getId() {
            return this.mId;
        }

        public boolean isDefault() {
            return this.mFlags.contains((Object)Flags.DEFAULT_PAGE);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeParcelable((Parcelable)this.mType, 0);
            parcel.writeString(this.mTitle);
            parcel.writeString(this.mId);
            parcel.writeSerializable(this.mFlags);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Flags {
            DEFAULT_PAGE;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PageType implements Parcelable
    {
        TOP_SITES("top_sites", TopSitesPage.class),
        BOOKMARKS("bookmarks", BookmarksPage.class),
        HISTORY("history", HistoryPage.class),
        READING_LIST("reading_list", ReadingListPage.class),
        LIST("list", ListPage.class);

        private final String mId;
        private final Class<?> mPageClass;
        public static final Parcelable.Creator<PageType> CREATOR;

        private PageType(String string3, Class<?> clazz) {
            this.mId = string3;
            this.mPageClass = clazz;
        }

        public static PageType fromId(String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("Could not convert null String to PageType");
            }
            for (PageType pageType : PageType.values()) {
                if (!TextUtils.equals((CharSequence)pageType.mId, (CharSequence)string2.toLowerCase())) continue;
                return pageType;
            }
            throw new IllegalArgumentException("Could not convert String id to PageType");
        }

        public String toString() {
            return this.mId;
        }

        public Class<?> getPageClass() {
            return this.mPageClass;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.ordinal());
        }

        static {
            CREATOR = new Parcelable.Creator<PageType>(){

                public PageType createFromParcel(Parcel parcel) {
                    return PageType.values()[parcel.readInt()];
                }

                public PageType[] newArray(int n) {
                    return new PageType[n];
                }
            };
        }
    }
}

