/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.support.v4.content.AsyncTaskLoader;
import java.util.List;
import org.mozilla.gecko.home.HomeConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HomeConfigLoader
extends AsyncTaskLoader<List<HomeConfig.PageEntry>> {
    private final HomeConfig mConfig;
    private List<HomeConfig.PageEntry> mPageEntries;

    public HomeConfigLoader(Context context, HomeConfig homeConfig) {
        super(context);
        this.mConfig = homeConfig;
    }

    public List<HomeConfig.PageEntry> loadInBackground() {
        return this.mConfig.load();
    }

    public void deliverResult(List<HomeConfig.PageEntry> list) {
        if (this.isReset()) {
            this.mPageEntries = null;
            return;
        }
        this.mPageEntries = list;
        this.mConfig.setOnChangeListener(new ForceLoadChangeListener());
        if (this.isStarted()) {
            super.deliverResult(list);
        }
    }

    protected void onStartLoading() {
        if (this.mPageEntries != null) {
            this.deliverResult(this.mPageEntries);
        }
        if (this.takeContentChanged() || this.mPageEntries == null) {
            this.forceLoad();
        }
    }

    protected void onStopLoading() {
        this.cancelLoad();
    }

    public void onCanceled(List<HomeConfig.PageEntry> list) {
        this.mPageEntries = null;
    }

    protected void onReset() {
        super.onReset();
        this.onStopLoading();
        this.mPageEntries = null;
        this.mConfig.setOnChangeListener(null);
    }

    private class ForceLoadChangeListener
    implements HomeConfig.OnChangeListener {
        private ForceLoadChangeListener() {
        }

        public void onChange() {
            HomeConfigLoader.this.onContentChanged();
        }
    }
}

