/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.mozilla.gecko.R;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.home.ListManager;
import org.mozilla.gecko.util.HardwareUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HomeConfigMemBackend
implements HomeConfig.HomeConfigBackend {
    private static final String LOGTAG = "GeckoHomeConfigMemBackend";
    private final Context mContext;
    private final ListManager mListManager;

    public HomeConfigMemBackend(Context context) {
        this.mContext = context;
        this.mListManager = new ListManager(context);
    }

    @Override
    public List<HomeConfig.PageEntry> load() {
        ArrayList<HomeConfig.PageEntry> arrayList = new ArrayList<HomeConfig.PageEntry>();
        arrayList.add(new HomeConfig.PageEntry(HomeConfig.PageType.TOP_SITES, this.mContext.getString(R.string.home_top_sites_title), EnumSet.of(HomeConfig.PageEntry.Flags.DEFAULT_PAGE)));
        arrayList.add(new HomeConfig.PageEntry(HomeConfig.PageType.BOOKMARKS, this.mContext.getString(R.string.bookmarks_title)));
        if (!HardwareUtils.isLowMemoryPlatform()) {
            arrayList.add(new HomeConfig.PageEntry(HomeConfig.PageType.READING_LIST, this.mContext.getString(R.string.reading_list_title)));
        }
        HomeConfig.PageEntry pageEntry = new HomeConfig.PageEntry(HomeConfig.PageType.HISTORY, this.mContext.getString(R.string.home_history_title));
        if (HardwareUtils.isTablet()) {
            arrayList.add(pageEntry);
        } else {
            arrayList.add(0, pageEntry);
        }
        List<ListManager.ListInfo> list = this.mListManager.getListInfos();
        for (ListManager.ListInfo listInfo : list) {
            arrayList.add(new HomeConfig.PageEntry(HomeConfig.PageType.LIST, listInfo.title, listInfo.id));
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public void save(List<HomeConfig.PageEntry> list) {
    }

    @Override
    public void setOnChangeListener(HomeConfig.OnChangeListener onChangeListener) {
    }
}

