/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories.domain;

import org.json.simple.JSONArray;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.NonArrayJSONException;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.repositories.android.RepoUtils;
import org.mozilla.gecko.sync.repositories.domain.Record;

public class ClientRecord
extends Record {
    private static final String LOG_TAG = "ClientRecord";
    public static final String CLIENT_TYPE = "mobile";
    public static final String COLLECTION_NAME = "clients";
    public static final long CLIENTS_TTL = 1814400L;
    public static final String DEFAULT_CLIENT_NAME = "Default Name";
    public String name = "Default Name";
    public String type = "mobile";
    public String version = null;
    public JSONArray commands;

    public ClientRecord(String string2, String string3, long l, boolean bl) {
        super(string2, string3, l, bl);
        this.ttl = 1814400L;
    }

    public ClientRecord(String string2, String string3, long l) {
        this(string2, string3, l, false);
    }

    public ClientRecord(String string2, String string3) {
        this(string2, string3, 0L, false);
    }

    public ClientRecord(String string2) {
        this(string2, COLLECTION_NAME, 0L, false);
    }

    public ClientRecord() {
        this(Utils.generateGuid(), COLLECTION_NAME, 0L, false);
    }

    protected void initFromPayload(ExtendedJSONObject extendedJSONObject) {
        this.name = (String)extendedJSONObject.get("name");
        this.type = (String)extendedJSONObject.get("type");
        try {
            this.version = (String)extendedJSONObject.get("version");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.commands = extendedJSONObject.getArray("commands");
        }
        catch (NonArrayJSONException nonArrayJSONException) {
            Logger.debug(LOG_TAG, "Got non-array commands in client record " + this.guid, nonArrayJSONException);
            this.commands = null;
        }
    }

    protected void populatePayload(ExtendedJSONObject extendedJSONObject) {
        this.putPayload(extendedJSONObject, "id", this.guid);
        this.putPayload(extendedJSONObject, "name", this.name);
        this.putPayload(extendedJSONObject, "type", this.type);
        this.putPayload(extendedJSONObject, "version", this.version);
        if (this.commands != null) {
            extendedJSONObject.put("commands", this.commands);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof ClientRecord) || !super.equals(object)) {
            return false;
        }
        return this.equalPayloads(object);
    }

    public boolean equalPayloads(Object object) {
        if (!(object instanceof ClientRecord) || !super.equalPayloads(object)) {
            return false;
        }
        ClientRecord clientRecord = (ClientRecord)object;
        return RepoUtils.stringsEqual(clientRecord.name, this.name) && RepoUtils.stringsEqual(clientRecord.type, this.type);
    }

    public Record copyWithIDs(String string2, long l) {
        ClientRecord clientRecord = new ClientRecord(string2, this.collection, this.lastModified, this.deleted);
        clientRecord.androidID = l;
        clientRecord.sortIndex = this.sortIndex;
        clientRecord.ttl = this.ttl;
        clientRecord.name = this.name;
        clientRecord.type = this.type;
        clientRecord.version = this.version;
        return clientRecord;
    }
}

