/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tokenserver;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.client.ClientProtocolException;
import ch.boye.httpclientandroidlib.client.methods.HttpRequestBase;
import ch.boye.httpclientandroidlib.impl.client.DefaultHttpClient;
import ch.boye.httpclientandroidlib.message.BasicHeader;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import org.json.simple.JSONObject;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.NonArrayJSONException;
import org.mozilla.gecko.sync.NonObjectJSONException;
import org.mozilla.gecko.sync.net.AuthHeaderProvider;
import org.mozilla.gecko.sync.net.BaseResource;
import org.mozilla.gecko.sync.net.BaseResourceDelegate;
import org.mozilla.gecko.sync.net.BrowserIDAuthHeaderProvider;
import org.mozilla.gecko.sync.net.SyncResponse;
import org.mozilla.gecko.tokenserver.TokenServerClientDelegate;
import org.mozilla.gecko.tokenserver.TokenServerException;
import org.mozilla.gecko.tokenserver.TokenServerToken;

public class TokenServerClient {
    protected static final String LOG_TAG = "TokenServerClient";
    public static final String JSON_KEY_API_ENDPOINT = "api_endpoint";
    public static final String JSON_KEY_CONDITION_URLS = "condition_urls";
    public static final String JSON_KEY_DURATION = "duration";
    public static final String JSON_KEY_ERRORS = "errors";
    public static final String JSON_KEY_ID = "id";
    public static final String JSON_KEY_KEY = "key";
    public static final String JSON_KEY_UID = "uid";
    protected final Executor executor;
    protected final URI uri;

    public TokenServerClient(URI uRI, Executor executor) {
        if (uRI == null) {
            throw new IllegalArgumentException("uri must not be null");
        }
        if (executor == null) {
            throw new IllegalArgumentException("executor must not be null");
        }
        this.uri = uRI;
        this.executor = executor;
    }

    protected void invokeHandleSuccess(final TokenServerClientDelegate tokenServerClientDelegate, final TokenServerToken tokenServerToken) {
        this.executor.execute(new Runnable(){

            public void run() {
                tokenServerClientDelegate.handleSuccess(tokenServerToken);
            }
        });
    }

    protected void invokeHandleFailure(final TokenServerClientDelegate tokenServerClientDelegate, final TokenServerException tokenServerException) {
        this.executor.execute(new Runnable(){

            public void run() {
                tokenServerClientDelegate.handleFailure(tokenServerException);
            }
        });
    }

    protected void invokeHandleError(final TokenServerClientDelegate tokenServerClientDelegate, final Exception exception) {
        this.executor.execute(new Runnable(){

            public void run() {
                tokenServerClientDelegate.handleError(exception);
            }
        });
    }

    public TokenServerToken processResponse(HttpResponse httpResponse) throws TokenServerException {
        Object object;
        ExtendedJSONObject extendedJSONObject;
        SyncResponse syncResponse = new SyncResponse(httpResponse);
        int n = syncResponse.getStatusCode();
        Logger.debug(LOG_TAG, "Got token response with status code " + n + ".");
        String string2 = httpResponse.getEntity().getContentType().getValue();
        if (string2 != "application/json" && !string2.startsWith("application/json;")) {
            Logger.warn(LOG_TAG, "Got non-JSON response with Content-Type " + string2 + ". Misconfigured server?");
            throw new TokenServerException.TokenServerMalformedResponseException(null, "Non-JSON response Content-Type.");
        }
        try {
            extendedJSONObject = syncResponse.jsonObjectBody();
        }
        catch (Exception exception) {
            Logger.debug(LOG_TAG, "Malformed token response.", exception);
            throw new TokenServerException.TokenServerMalformedResponseException(null, (Throwable)exception);
        }
        if (syncResponse.getStatusCode() != 200) {
            ArrayList<ExtendedJSONObject> arrayList = new ArrayList<ExtendedJSONObject>();
            if (extendedJSONObject.containsKey(JSON_KEY_ERRORS)) {
                try {
                    for (Object object2 : extendedJSONObject.getArray(JSON_KEY_ERRORS)) {
                        Logger.warn(LOG_TAG, "" + object2);
                        if (!(object2 instanceof JSONObject)) continue;
                        arrayList.add(new ExtendedJSONObject((JSONObject)object2));
                    }
                }
                catch (NonArrayJSONException nonArrayJSONException) {
                    Logger.warn(LOG_TAG, "Got non-JSON array '" + extendedJSONObject.getString(JSON_KEY_ERRORS) + "'.", nonArrayJSONException);
                }
            }
            if (n == 400) {
                throw new TokenServerException.TokenServerMalformedRequestException(arrayList, extendedJSONObject.toJSONString());
            }
            if (n == 401) {
                throw new TokenServerException.TokenServerInvalidCredentialsException(arrayList, extendedJSONObject.toJSONString());
            }
            if (n == 403) {
                try {
                    Object object2;
                    if (arrayList == null || arrayList.isEmpty()) {
                        throw new TokenServerException.TokenServerMalformedResponseException(arrayList, "403 response without proper fields.");
                    }
                    ExtendedJSONObject extendedJSONObject2 = (ExtendedJSONObject)arrayList.get(0);
                    object2 = extendedJSONObject2.getObject(JSON_KEY_CONDITION_URLS);
                    if (object2 != null) {
                        throw new TokenServerException.TokenServerConditionsRequiredException((ExtendedJSONObject)object2);
                    }
                }
                catch (NonObjectJSONException nonObjectJSONException) {
                    Logger.warn(LOG_TAG, "Got non-JSON error object.");
                }
                throw new TokenServerException.TokenServerMalformedResponseException(arrayList, "403 response without proper fields.");
            }
            if (n == 404) {
                throw new TokenServerException.TokenServerUnknownServiceException(arrayList);
            }
            throw new TokenServerException(arrayList);
        }
        for (String string3 : new String[]{JSON_KEY_ID, JSON_KEY_KEY, JSON_KEY_API_ENDPOINT}) {
            object = extendedJSONObject.get(string3);
            if (object == null) {
                throw new TokenServerException.TokenServerMalformedResponseException(null, "Expected key not present in result: " + string3);
            }
            if (object instanceof String) continue;
            throw new TokenServerException.TokenServerMalformedResponseException(null, "Value for key not a string in result: " + string3);
        }
        for (String string3 : new String[]{JSON_KEY_UID}) {
            object = extendedJSONObject.get(string3);
            if (object == null) {
                throw new TokenServerException.TokenServerMalformedResponseException(null, "Expected key not present in result: " + string3);
            }
            if (object instanceof Long) continue;
            throw new TokenServerException.TokenServerMalformedResponseException(null, "Value for key not a string in result: " + string3);
        }
        Logger.debug(LOG_TAG, "Successful token response: " + extendedJSONObject.getString(JSON_KEY_ID));
        return new TokenServerToken(extendedJSONObject.getString(JSON_KEY_ID), extendedJSONObject.getString(JSON_KEY_KEY), extendedJSONObject.get(JSON_KEY_UID).toString(), extendedJSONObject.getString(JSON_KEY_API_ENDPOINT));
    }

    public void getTokenFromBrowserIDAssertion(final String string2, final boolean bl, final TokenServerClientDelegate tokenServerClientDelegate) {
        BaseResource baseResource = new BaseResource(this.uri);
        baseResource.delegate = new BaseResourceDelegate(baseResource){

            public void handleHttpResponse(HttpResponse httpResponse) {
                try {
                    TokenServerToken tokenServerToken = TokenServerClient.this.processResponse(httpResponse);
                    TokenServerClient.this.invokeHandleSuccess(tokenServerClientDelegate, tokenServerToken);
                }
                catch (TokenServerException tokenServerException) {
                    TokenServerClient.this.invokeHandleFailure(tokenServerClientDelegate, tokenServerException);
                }
            }

            public void handleTransportException(GeneralSecurityException generalSecurityException) {
                TokenServerClient.this.invokeHandleError(tokenServerClientDelegate, generalSecurityException);
            }

            public void handleHttpProtocolException(ClientProtocolException clientProtocolException) {
                TokenServerClient.this.invokeHandleError(tokenServerClientDelegate, (Exception)((Object)clientProtocolException));
            }

            public void handleHttpIOException(IOException iOException) {
                TokenServerClient.this.invokeHandleError(tokenServerClientDelegate, iOException);
            }

            public AuthHeaderProvider getAuthHeaderProvider() {
                return new BrowserIDAuthHeaderProvider(string2);
            }

            public void addHeaders(HttpRequestBase httpRequestBase, DefaultHttpClient defaultHttpClient) {
                String string22 = httpRequestBase.getURI().getHost();
                httpRequestBase.setHeader((Header)new BasicHeader("Host", string22));
                if (bl) {
                    httpRequestBase.addHeader("X-Conditions-Accepted", "1");
                }
            }
        };
        baseResource.get();
    }
}

