/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.view.ActionProvider;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import org.mozilla.gecko.menu.MenuItemActionView;
import org.mozilla.gecko.widget.ActivityChooserModel;

public class GeckoActionProvider
extends ActionProvider {
    private final Context mContext;
    public static final String DEFAULT_HISTORY_FILE_NAME = "history.xml";
    private String mHistoryFileName = "history.xml";
    private OnTargetSelectedListener mOnTargetListener;
    private final Callbacks mCallbacks = new Callbacks();

    public GeckoActionProvider(Context context) {
        super(context);
        this.mContext = context;
    }

    public View onCreateActionView() {
        ActivityChooserModel activityChooserModel = ActivityChooserModel.get(this.mContext, this.mHistoryFileName);
        MenuItemActionView menuItemActionView = new MenuItemActionView(this.mContext, null);
        menuItemActionView.setActionButtonClickListener(this.mCallbacks);
        PackageManager packageManager = this.mContext.getPackageManager();
        int n = activityChooserModel.getDistinctActivityCountInHistory();
        if (n > 2) {
            n = 2;
        }
        if (n > activityChooserModel.getActivityCount()) {
            return menuItemActionView;
        }
        for (int i = 0; i < n; ++i) {
            menuItemActionView.addActionButton(activityChooserModel.getActivity(i).loadIcon(packageManager));
        }
        return menuItemActionView;
    }

    public View getView() {
        return this.onCreateActionView();
    }

    public boolean hasSubMenu() {
        return true;
    }

    public void onPrepareSubMenu(SubMenu subMenu) {
        subMenu.clear();
        ActivityChooserModel activityChooserModel = ActivityChooserModel.get(this.mContext, this.mHistoryFileName);
        PackageManager packageManager = this.mContext.getPackageManager();
        int n = activityChooserModel.getActivityCount();
        for (int i = 0; i < n; ++i) {
            ResolveInfo resolveInfo = activityChooserModel.getActivity(i);
            subMenu.add(0, i, i, resolveInfo.loadLabel(packageManager)).setIcon(resolveInfo.loadIcon(packageManager)).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)this.mCallbacks);
        }
    }

    public void setHistoryFileName(String string2) {
        this.mHistoryFileName = string2;
    }

    public Intent getIntent() {
        ActivityChooserModel activityChooserModel = ActivityChooserModel.get(this.mContext, this.mHistoryFileName);
        return activityChooserModel.getIntent();
    }

    public void setIntent(Intent intent) {
        ActivityChooserModel activityChooserModel = ActivityChooserModel.get(this.mContext, this.mHistoryFileName);
        activityChooserModel.setIntent(intent);
        if (this.mOnTargetListener != null) {
            this.mOnTargetListener.onTargetSelected();
        }
    }

    public void setOnTargetSelectedListener(OnTargetSelectedListener onTargetSelectedListener) {
        this.mOnTargetListener = onTargetSelectedListener;
    }

    private class Callbacks
    implements MenuItem.OnMenuItemClickListener,
    View.OnClickListener {
        private Callbacks() {
        }

        private void chooseActivity(int n) {
            ActivityChooserModel activityChooserModel = ActivityChooserModel.get(GeckoActionProvider.this.mContext, GeckoActionProvider.this.mHistoryFileName);
            Intent intent = activityChooserModel.chooseActivity(n);
            if (intent != null) {
                intent.addFlags(524288);
                GeckoActionProvider.this.mContext.startActivity(intent);
            }
            if (GeckoActionProvider.this.mOnTargetListener != null) {
                GeckoActionProvider.this.mOnTargetListener.onTargetSelected();
            }
        }

        public boolean onMenuItemClick(MenuItem menuItem) {
            this.chooseActivity(menuItem.getItemId());
            return true;
        }

        public void onClick(View view) {
            Integer n = (Integer)view.getTag();
            ActivityChooserModel activityChooserModel = ActivityChooserModel.get(GeckoActionProvider.this.mContext, GeckoActionProvider.this.mHistoryFileName);
            this.chooseActivity(n);
        }
    }

    public static interface OnTargetSelectedListener {
        public void onTargetSelected();
    }
}

