/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.browserid;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import org.mozilla.gecko.browserid.BrowserIDKeyPair;
import org.mozilla.gecko.browserid.SigningPrivateKey;
import org.mozilla.gecko.browserid.VerifyingPublicKey;
import org.mozilla.gecko.sync.ExtendedJSONObject;

public class RSACryptoImplementation {
    public static final String SIGNATURE_ALGORITHM = "SHA256withRSA";

    public static BrowserIDKeyPair generateKeypair(int n) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(n);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAPublicKey rSAPublicKey = (RSAPublicKey)keyPair.getPublic();
        return new BrowserIDKeyPair(new RSASigningPrivateKey(rSAPrivateKey), new RSAVerifyingPublicKey(rSAPublicKey));
    }

    public static SigningPrivateKey createPrivateKey(BigInteger bigInteger, BigInteger bigInteger2) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (bigInteger == null) {
            throw new IllegalArgumentException("n must not be null");
        }
        if (bigInteger2 == null) {
            throw new IllegalArgumentException("d must not be null");
        }
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        RSAPrivateKeySpec rSAPrivateKeySpec = new RSAPrivateKeySpec(bigInteger, bigInteger2);
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)keyFactory.generatePrivate(rSAPrivateKeySpec);
        return new RSASigningPrivateKey(rSAPrivateKey);
    }

    public static VerifyingPublicKey createPublicKey(BigInteger bigInteger, BigInteger bigInteger2) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (bigInteger == null) {
            throw new IllegalArgumentException("n must not be null");
        }
        if (bigInteger2 == null) {
            throw new IllegalArgumentException("e must not be null");
        }
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(bigInteger, bigInteger2);
        RSAPublicKey rSAPublicKey = (RSAPublicKey)keyFactory.generatePublic(rSAPublicKeySpec);
        return new RSAVerifyingPublicKey(rSAPublicKey);
    }

    protected static class RSASigningPrivateKey
    implements SigningPrivateKey {
        protected final RSAPrivateKey privateKey;

        public RSASigningPrivateKey(RSAPrivateKey rSAPrivateKey) {
            this.privateKey = rSAPrivateKey;
        }

        public String getAlgorithm() {
            return "RS" + (this.privateKey.getModulus().bitLength() + 7) / 8;
        }

        public String serialize() {
            ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
            extendedJSONObject.put("algorithm", "RS");
            extendedJSONObject.put("n", this.privateKey.getModulus().toString(10));
            extendedJSONObject.put("e", this.privateKey.getPrivateExponent().toString(10));
            return extendedJSONObject.toJSONString();
        }

        public byte[] signMessage(byte[] byArray) throws GeneralSecurityException {
            Signature signature = Signature.getInstance(RSACryptoImplementation.SIGNATURE_ALGORITHM);
            signature.initSign(this.privateKey);
            signature.update(byArray);
            return signature.sign();
        }
    }

    protected static class RSAVerifyingPublicKey
    implements VerifyingPublicKey {
        protected final RSAPublicKey publicKey;

        public RSAVerifyingPublicKey(RSAPublicKey rSAPublicKey) {
            this.publicKey = rSAPublicKey;
        }

        public String serialize() {
            ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
            extendedJSONObject.put("algorithm", "RS");
            extendedJSONObject.put("n", this.publicKey.getModulus().toString(10));
            extendedJSONObject.put("e", this.publicKey.getPublicExponent().toString(10));
            return extendedJSONObject.toJSONString();
        }

        public boolean verifyMessage(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
            Signature signature = Signature.getInstance(RSACryptoImplementation.SIGNATURE_ALGORITHM);
            signature.initVerify(this.publicKey);
            signature.update(byArray);
            return signature.verify(byArray2);
        }
    }
}

