/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.authenticator;

import android.accounts.AbstractAccountAuthenticator;
import android.accounts.Account;
import android.accounts.AccountAuthenticatorResponse;
import android.accounts.AccountManager;
import android.accounts.NetworkErrorException;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.fxa.activities.FxAccountSetupActivity;
import org.mozilla.gecko.fxa.sync.FxAccount;
import org.mozilla.gecko.sync.Utils;

public class FxAccountAuthenticator
extends AbstractAccountAuthenticator {
    public static final String LOG_TAG = FxAccountAuthenticator.class.getSimpleName();
    public static final String JSON_KEY_UID = "uid";
    public static final String JSON_KEY_SESSION_TOKEN = "session_token";
    public static final String JSON_KEY_KA = "kA";
    public static final String JSON_KEY_KB = "kB";
    public static final String JSON_KEY_IDP_ENDPOINT = "idp_endpoint";
    public static final String JSON_KEY_AUTH_ENDPOINT = "auth_endpoint";
    protected final Context context;
    protected final AccountManager accountManager;

    public FxAccountAuthenticator(Context context) {
        super(context);
        this.context = context;
        this.accountManager = AccountManager.get((Context)context);
    }

    protected static void enableSyncing(Context context, Account account) {
        for (String string2 : new String[]{"org.mozilla.fennec.db.browser", "org.mozilla.fennec.db.formhistory", "org.mozilla.fennec.db.tabs", "org.mozilla.fennec.db.passwords"}) {
            ContentResolver.setSyncAutomatically((Account)account, (String)string2, (boolean)true);
            ContentResolver.setIsSyncable((Account)account, (String)string2, (int)1);
        }
    }

    public static Account addAccount(Context context, String string2, String string3, String string4, String string5, String string6) {
        AccountManager accountManager = AccountManager.get((Context)context);
        Account account = new Account(string2, "org.mozilla.fennec_account");
        Bundle bundle = new Bundle();
        bundle.putString(JSON_KEY_UID, string3);
        bundle.putString(JSON_KEY_SESSION_TOKEN, string4);
        bundle.putString(JSON_KEY_KA, string5);
        bundle.putString(JSON_KEY_KB, string6);
        bundle.putString(JSON_KEY_IDP_ENDPOINT, "https://api-accounts.dev.lcip.org");
        bundle.putString(JSON_KEY_AUTH_ENDPOINT, "http://auth.oldsync.dev.lcip.org");
        if (!accountManager.addAccountExplicitly(account, string4, bundle)) {
            Logger.warn(LOG_TAG, "Error adding account named " + account.name + " of type " + account.type);
            return null;
        }
        FxAccountAuthenticator.enableSyncing(context, account);
        return account;
    }

    public Bundle addAccount(AccountAuthenticatorResponse accountAuthenticatorResponse, String string2, String string3, String[] stringArray, Bundle bundle) throws NetworkErrorException {
        Logger.debug(LOG_TAG, "addAccount");
        Bundle bundle2 = new Bundle();
        if (!"org.mozilla.fennec_account".equals(string2)) {
            bundle2.putInt("errorCode", -1);
            bundle2.putString("errorMessage", "Not adding unknown account type.");
            return bundle2;
        }
        Intent intent = new Intent(this.context, FxAccountSetupActivity.class);
        bundle2.putParcelable("intent", (Parcelable)intent);
        return bundle2;
    }

    public Bundle confirmCredentials(AccountAuthenticatorResponse accountAuthenticatorResponse, Account account, Bundle bundle) throws NetworkErrorException {
        Logger.debug(LOG_TAG, "confirmCredentials");
        return null;
    }

    public Bundle editProperties(AccountAuthenticatorResponse accountAuthenticatorResponse, String string2) {
        Logger.debug(LOG_TAG, "editProperties");
        return null;
    }

    public Bundle getAuthToken(AccountAuthenticatorResponse accountAuthenticatorResponse, Account account, String string2, Bundle bundle) throws NetworkErrorException {
        Logger.debug(LOG_TAG, "getAuthToken");
        Logger.warn(LOG_TAG, "Returning null bundle for getAuthToken.");
        return null;
    }

    public String getAuthTokenLabel(String string2) {
        Logger.debug(LOG_TAG, "getAuthTokenLabel");
        return null;
    }

    public Bundle hasFeatures(AccountAuthenticatorResponse accountAuthenticatorResponse, Account account, String[] stringArray) throws NetworkErrorException {
        Logger.debug(LOG_TAG, "hasFeatures");
        return null;
    }

    public Bundle updateCredentials(AccountAuthenticatorResponse accountAuthenticatorResponse, Account account, String string2, Bundle bundle) throws NetworkErrorException {
        Logger.debug(LOG_TAG, "updateCredentials");
        return null;
    }

    public static FxAccount fromAndroidAccount(Context context, Account account) {
        AccountManager accountManager = AccountManager.get((Context)context);
        byte[] byArray = Utils.hex2Byte(accountManager.getUserData(account, JSON_KEY_SESSION_TOKEN));
        byte[] byArray2 = Utils.hex2Byte(accountManager.getUserData(account, JSON_KEY_KA), 16);
        byte[] byArray3 = Utils.hex2Byte(accountManager.getUserData(account, JSON_KEY_KB), 16);
        String string2 = accountManager.getUserData(account, JSON_KEY_IDP_ENDPOINT);
        String string3 = accountManager.getUserData(account, JSON_KEY_AUTH_ENDPOINT);
        return new FxAccount(account.name, byArray, byArray2, byArray3, string2, string3);
    }
}

