/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.util.GeckoEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListManager
implements GeckoEventListener {
    private static final String LOGTAG = "GeckoListManager";
    private final Context mContext;

    public ListManager(Context context) {
        this.mContext = context;
        GeckoAppShell.getEventDispatcher().registerEventListener("HomeLists:Added", (GeckoEventListener)this);
    }

    public List<ListInfo> getListInfos() {
        ArrayList<ListInfo> arrayList = new ArrayList<ListInfo>();
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.mContext);
        String string2 = sharedPreferences.getString("home_lists", "");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                JSONArray jSONArray = new JSONArray(string2);
                for (int i = 0; i < jSONArray.length(); ++i) {
                    JSONObject jSONObject = jSONArray.getJSONObject(i);
                    ListInfo listInfo = new ListInfo(jSONObject.getString("id"), jSONObject.getString("title"));
                    arrayList.add(listInfo);
                }
            }
            catch (JSONException jSONException) {
                Log.e((String)LOGTAG, (String)"Exception getting list info", (Throwable)jSONException);
            }
        }
        return arrayList;
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        try {
            ListInfo listInfo = new ListInfo(jSONObject.getString("id"), jSONObject.getString("title"));
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)("Exception handling " + string2 + " message"), (Throwable)jSONException);
        }
    }

    public class ListInfo {
        public final String id;
        public final String title;

        public ListInfo(String string2, String string3) {
            this.id = string2;
            this.title = string3;
        }
    }
}

