/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.preferences;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.preference.PreferenceActivity;
import android.preference.PreferenceFragment;
import android.preference.PreferenceGroup;
import android.preference.PreferenceScreen;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.ViewConfiguration;
import java.lang.reflect.Field;
import org.mozilla.gecko.PrefsHelper;
import org.mozilla.gecko.R;
import org.mozilla.gecko.preferences.GeckoPreferences;

public class GeckoPreferenceFragment
extends PreferenceFragment {
    private static final String LOGTAG = "GeckoPreferenceFragment";
    private int mPrefsRequestId = 0;

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        int n = this.getResource();
        if (n == R.xml.preferences_search) {
            this.setHasOptionsMenu(true);
        }
        this.addPreferencesFromResource(n);
        PreferenceScreen preferenceScreen = this.getPreferenceScreen();
        this.setPreferenceScreen(preferenceScreen);
        this.mPrefsRequestId = ((GeckoPreferences)this.getActivity()).setupPreferences((PreferenceGroup)preferenceScreen);
    }

    private int getResource() {
        int n = 0;
        String string2 = this.getArguments().getString("resource");
        if (string2 != null) {
            n = this.getActivity().getResources().getIdentifier(string2, "xml", this.getActivity().getPackageName());
        }
        if (n == 0) {
            Log.e((String)LOGTAG, (String)("Failed to find resource: " + string2 + ". Displaying default settings."));
            boolean bl = ((PreferenceActivity)this.getActivity()).onIsMultiPane();
            n = bl ? R.xml.preferences_customize_tablet : R.xml.preferences;
        }
        return n;
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater menuInflater) {
        super.onCreateOptionsMenu(menu2, menuInflater);
        menuInflater.inflate(R.menu.preferences_search_menu, menu2);
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mPrefsRequestId > 0) {
            PrefsHelper.removeObserver(this.mPrefsRequestId);
        }
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.showOverflowMenu(activity);
    }

    private void showOverflowMenu(Activity activity) {
        try {
            ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)activity);
            Field field = ViewConfiguration.class.getDeclaredField("sHasPermanentMenuKey");
            if (field != null) {
                field.setAccessible(true);
                field.setBoolean(viewConfiguration, false);
            }
        }
        catch (Exception exception) {
            Log.d((String)LOGTAG, (String)"Failed to force overflow menu, ignoring.");
        }
    }
}

