/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.os.SystemClock;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import android.util.Log;
import android.view.ContextMenu;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import android.view.inputmethod.InputMethodManager;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import java.util.Arrays;
import java.util.List;
import org.json.JSONObject;
import org.mozilla.gecko.AboutPages;
import org.mozilla.gecko.BrowserApp;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoApplication;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.LightweightTheme;
import org.mozilla.gecko.PrefsHelper;
import org.mozilla.gecko.R;
import org.mozilla.gecko.SiteIdentity;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.animation.ViewHelper;
import org.mozilla.gecko.menu.GeckoMenu;
import org.mozilla.gecko.menu.MenuPanel;
import org.mozilla.gecko.menu.MenuPopup;
import org.mozilla.gecko.toolbar.AutocompleteHandler;
import org.mozilla.gecko.toolbar.BackButton;
import org.mozilla.gecko.toolbar.ForwardButton;
import org.mozilla.gecko.toolbar.PageActionLayout;
import org.mozilla.gecko.toolbar.ShapedButton;
import org.mozilla.gecko.toolbar.SiteIdentityPopup;
import org.mozilla.gecko.toolbar.TabCounter;
import org.mozilla.gecko.toolbar.ToolbarEditLayout;
import org.mozilla.gecko.util.Clipboard;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.HardwareUtils;
import org.mozilla.gecko.util.StringUtils;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.widget.GeckoImageButton;
import org.mozilla.gecko.widget.GeckoImageView;
import org.mozilla.gecko.widget.GeckoRelativeLayout;
import org.mozilla.gecko.widget.GeckoTextView;

public class BrowserToolbar
extends GeckoRelativeLayout
implements Tabs.OnTabsChangedListener,
GeckoMenu.ActionItemBarPresenter,
Animation.AnimationListener,
GeckoEventListener {
    private static final String LOGTAG = "GeckoToolbar";
    public static final String PREF_TITLEBAR_MODE = "browser.chrome.titlebarMode";
    public static final String PREF_TRIM_URLS = "browser.urlbar.trimURLs";
    private View mUrlDisplayContainer;
    private ToolbarEditLayout mUrlEditLayout;
    private View mUrlBarEntry;
    private ImageView mUrlBarRightEdge;
    private GeckoTextView mTitle;
    private int mTitlePadding;
    private boolean mSiteSecurityVisible;
    private boolean mSwitchingTabs;
    private ShapedButton mTabs;
    private ImageButton mBack;
    private ImageButton mForward;
    private ImageButton mStop;
    private Bitmap mLastFavicon;
    private ImageButton mFavicon;
    private ImageButton mSiteSecurity;
    private PageActionLayout mPageActionLayout;
    private Animation mProgressSpinner;
    private TabCounter mTabsCounter;
    private GeckoImageButton mMenu;
    private GeckoImageView mMenuIcon;
    private LinearLayout mActionItemBar;
    private MenuPopup mMenuPopup;
    private List<? extends View> mFocusOrder;
    private OnActivateListener mActivateListener;
    private OnCommitListener mCommitListener;
    private OnDismissListener mDismissListener;
    private OnFilterListener mFilterListener;
    private OnStartEditingListener mStartEditingListener;
    private OnStopEditingListener mStopEditingListener;
    private SiteIdentityPopup mSiteIdentityPopup;
    private final BrowserApp mActivity;
    private boolean mHasSoftMenuButton;
    private boolean mShowSiteSecurity;
    private boolean mSpinnerVisible;
    private boolean mIsEditing;
    private boolean mAnimatingEntry;
    private AlphaAnimation mLockFadeIn;
    private TranslateAnimation mTitleSlideLeft;
    private TranslateAnimation mTitleSlideRight;
    private int mUrlBarViewOffset;
    private int mDefaultForwardMargin;
    private PropertyAnimator mForwardAnim = null;
    private int mFaviconSize;
    private PropertyAnimator mVisibilityAnimator;
    private static final Interpolator sButtonsInterpolator = new AccelerateInterpolator();
    private static final int TABS_CONTRACTED = 1;
    private static final int TABS_EXPANDED = 2;
    private static final int FORWARD_ANIMATION_DURATION = 450;
    private final ForegroundColorSpan mUrlColor;
    private final ForegroundColorSpan mBlockedColor;
    private final ForegroundColorSpan mDomainColor;
    private final ForegroundColorSpan mPrivateDomainColor;
    private final LightweightTheme mTheme;
    private boolean mShowUrl;
    private boolean mTrimURLs;
    private Integer mPrefObserverId;

    public BrowserToolbar(Context context) {
        this(context, null);
    }

    public BrowserToolbar(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mTheme = ((GeckoApplication)context.getApplicationContext()).getLightweightTheme();
        this.mActivity = (BrowserApp)context;
        LayoutInflater.from((Context)context).inflate(R.layout.browser_toolbar, (ViewGroup)this);
        Tabs.registerOnTabsChangedListener(this);
        this.mSwitchingTabs = true;
        this.mAnimatingEntry = false;
        this.mShowUrl = false;
        this.mTrimURLs = true;
        String[] stringArray = new String[]{PREF_TITLEBAR_MODE, PREF_TRIM_URLS};
        this.mPrefObserverId = PrefsHelper.getPrefs(stringArray, (PrefsHelper.PrefHandler)new PrefsHelper.PrefHandlerBase(){

            public void prefValue(String string2, String string3) {
                boolean bl;
                int n = Integer.parseInt(string3);
                boolean bl2 = bl = n == 1;
                if (bl == BrowserToolbar.this.mShowUrl) {
                    return;
                }
                BrowserToolbar.this.mShowUrl = bl;
                this.triggerTitleUpdate();
            }

            public void prefValue(String string2, boolean bl) {
                if (bl == BrowserToolbar.this.mTrimURLs) {
                    return;
                }
                BrowserToolbar.this.mTrimURLs = bl;
                this.triggerTitleUpdate();
            }

            public boolean isObserver() {
                return true;
            }

            private void triggerTitleUpdate() {
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    public void run() {
                        BrowserToolbar.this.updateTitle();
                    }
                });
            }
        });
        Resources resources = this.getResources();
        this.mUrlColor = new ForegroundColorSpan(resources.getColor(R.color.url_bar_urltext));
        this.mBlockedColor = new ForegroundColorSpan(resources.getColor(R.color.url_bar_blockedtext));
        this.mDomainColor = new ForegroundColorSpan(resources.getColor(R.color.url_bar_domaintext));
        this.mPrivateDomainColor = new ForegroundColorSpan(resources.getColor(R.color.url_bar_domaintext_private));
        this.registerEventListener("Reader:Click");
        this.registerEventListener("Reader:LongClick");
        this.mShowSiteSecurity = false;
        this.mAnimatingEntry = false;
        this.mUrlBarViewOffset = resources.getDimensionPixelSize(R.dimen.url_bar_offset_left);
        this.mDefaultForwardMargin = resources.getDimensionPixelSize(R.dimen.forward_default_offset);
        this.mUrlDisplayContainer = this.findViewById(R.id.url_display_container);
        this.mUrlBarEntry = this.findViewById(R.id.url_bar_entry);
        this.mUrlEditLayout = (ToolbarEditLayout)this.findViewById(R.id.edit_layout);
        this.mUrlBarRightEdge = (ImageView)this.findViewById(R.id.url_bar_right_edge);
        if (this.mUrlBarRightEdge != null) {
            this.mUrlBarRightEdge.getDrawable().setLevel(6000);
        }
        this.mTitle = (GeckoTextView)this.findViewById(R.id.url_bar_title);
        this.mTitlePadding = this.mTitle.getPaddingRight();
        this.mTabs = (ShapedButton)this.findViewById(R.id.tabs);
        this.mTabsCounter = (TabCounter)this.findViewById(R.id.tabs_counter);
        this.mBack = (ImageButton)this.findViewById(R.id.back);
        this.setButtonEnabled(this.mBack, false);
        this.mForward = (ImageButton)this.findViewById(R.id.forward);
        this.setButtonEnabled(this.mForward, false);
        this.mFavicon = (ImageButton)this.findViewById(R.id.favicon);
        if (Build.VERSION.SDK_INT >= 11) {
            if (Build.VERSION.SDK_INT >= 16) {
                this.mFavicon.setImportantForAccessibility(2);
            }
            this.mFavicon.setLayerType(2, null);
        }
        this.mFaviconSize = Math.round(resources.getDimension(R.dimen.browser_toolbar_favicon_size));
        this.mSiteSecurity = (ImageButton)this.findViewById(R.id.site_security);
        this.mSiteSecurityVisible = this.mSiteSecurity.getVisibility() == 0;
        this.mSiteIdentityPopup = new SiteIdentityPopup(this.mActivity);
        this.mSiteIdentityPopup.setAnchor((View)this.mSiteSecurity);
        this.mProgressSpinner = AnimationUtils.loadAnimation((Context)this.mActivity, (int)R.anim.progress_spinner);
        this.mStop = (ImageButton)this.findViewById(R.id.stop);
        this.mPageActionLayout = (PageActionLayout)this.findViewById(R.id.page_action_layout);
        this.mMenu = (GeckoImageButton)this.findViewById(R.id.menu);
        this.mMenuIcon = (GeckoImageView)this.findViewById(R.id.menu_icon);
        this.mActionItemBar = (LinearLayout)this.findViewById(R.id.menu_items);
        this.mHasSoftMenuButton = !HardwareUtils.hasMenuButton();
        this.mFocusOrder = HardwareUtils.isTablet() ? Arrays.asList(new View[]{this.mTabs, this.mBack, this.mForward, this, this.mSiteSecurity, this.mPageActionLayout, this.mStop, this.mActionItemBar, this.mMenu}) : Arrays.asList(new View[]{this, this.mSiteSecurity, this.mPageActionLayout, this.mStop, this.mTabs, this.mMenu});
        this.setIsEditing(false);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (BrowserToolbar.this.mActivateListener != null) {
                    BrowserToolbar.this.mActivateListener.onActivate();
                }
            }
        });
        this.setOnCreateContextMenuListener(new View.OnCreateContextMenuListener(){

            public void onCreateContextMenu(ContextMenu contextMenu, View view, ContextMenu.ContextMenuInfo contextMenuInfo) {
                Tab tab;
                if (BrowserToolbar.this.isEditing()) {
                    return;
                }
                MenuInflater menuInflater = BrowserToolbar.this.mActivity.getMenuInflater();
                menuInflater.inflate(R.menu.titlebar_contextmenu, (Menu)contextMenu);
                String string2 = Clipboard.getText();
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    contextMenu.findItem(R.id.pasteandgo).setVisible(false);
                    contextMenu.findItem(R.id.paste).setVisible(false);
                }
                if ((tab = Tabs.getInstance().getSelectedTab()) != null) {
                    String string3 = tab.getURL();
                    if (string3 == null) {
                        contextMenu.findItem(R.id.copyurl).setVisible(false);
                        contextMenu.findItem(R.id.share).setVisible(false);
                        contextMenu.findItem(R.id.add_to_launcher).setVisible(false);
                    }
                    contextMenu.findItem(R.id.subscribe).setVisible(tab.hasFeeds());
                    contextMenu.findItem(R.id.add_search_engine).setVisible(tab.hasOpenSearch());
                } else {
                    contextMenu.findItem(R.id.copyurl).setVisible(false);
                    contextMenu.findItem(R.id.share).setVisible(false);
                    contextMenu.findItem(R.id.add_to_launcher).setVisible(false);
                    contextMenu.findItem(R.id.subscribe).setVisible(false);
                    contextMenu.findItem(R.id.add_search_engine).setVisible(false);
                }
                contextMenu.findItem(R.id.share).setVisible(!GeckoProfile.get(BrowserToolbar.this.getContext()).inGuestMode());
            }
        });
        this.mUrlEditLayout.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean bl) {
                BrowserToolbar.this.setSelected(bl);
            }
        });
        this.mTabs.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                BrowserToolbar.this.toggleTabs();
            }
        });
        this.mTabs.setImageLevel(0);
        this.mBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Tabs.getInstance().getSelectedTab().doBack();
            }
        });
        this.mBack.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                return Tabs.getInstance().getSelectedTab().showBackHistory();
            }
        });
        this.mForward.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Tabs.getInstance().getSelectedTab().doForward();
            }
        });
        this.mForward.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                return Tabs.getInstance().getSelectedTab().showForwardHistory();
            }
        });
        View.OnClickListener onClickListener = new View.OnClickListener(){

            public void onClick(View view) {
                if (BrowserToolbar.this.mSiteSecurity.getVisibility() != 0) {
                    return;
                }
                Tab tab = Tabs.getInstance().getSelectedTab();
                SiteIdentity siteIdentity = tab.getSiteIdentity();
                if (siteIdentity.getSecurityMode() == SiteIdentity.SecurityMode.UNKNOWN) {
                    Log.e((String)BrowserToolbar.LOGTAG, (String)"Selected tab has no identity data");
                    return;
                }
                BrowserToolbar.this.mSiteIdentityPopup.updateIdentity(siteIdentity);
                BrowserToolbar.this.mSiteIdentityPopup.show();
            }
        };
        this.mFavicon.setOnClickListener(onClickListener);
        this.mSiteSecurity.setOnClickListener(onClickListener);
        this.mStop.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Tab tab = Tabs.getInstance().getSelectedTab();
                if (tab != null) {
                    tab.doStop();
                }
                BrowserToolbar.this.setProgressVisibility(false);
            }
        });
        float f = this.getResources().getDimension(R.dimen.browser_toolbar_lock_width);
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.mSiteSecurity.getLayoutParams();
        float f2 = this.getResources().getDisplayMetrics().density;
        this.mLockFadeIn = new AlphaAnimation(0.0f, 1.0f);
        this.mLockFadeIn.setAnimationListener((Animation.AnimationListener)this);
        this.mTitleSlideLeft = new TranslateAnimation(f += (float)(layoutParams.leftMargin + layoutParams.rightMargin) * f2 + 0.5f, 0.0f, 0.0f, 0.0f);
        this.mTitleSlideLeft.setAnimationListener((Animation.AnimationListener)this);
        this.mTitleSlideRight = new TranslateAnimation(-f, 0.0f, 0.0f, 0.0f);
        this.mTitleSlideRight.setAnimationListener((Animation.AnimationListener)this);
        this.mLockFadeIn.setDuration(300L);
        this.mTitleSlideLeft.setDuration(300L);
        this.mTitleSlideRight.setDuration(300L);
        if (this.mHasSoftMenuButton) {
            this.mMenu.setVisibility(0);
            this.mMenuIcon.setVisibility(0);
            this.mMenu.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    BrowserToolbar.this.mActivity.openOptionsMenu();
                }
            });
        }
    }

    public void refresh() {
        this.dismissSiteIdentityPopup();
    }

    public boolean onBackPressed() {
        return this.dismissSiteIdentityPopup();
    }

    public boolean onKey(int n, KeyEvent keyEvent) {
        if (keyEvent.getAction() != 0) {
            return false;
        }
        if (n > KeyEvent.getMaxKeyCode()) {
            return true;
        }
        if (n == 4 || n == 82 || n == 19 || n == 20 || n == 21 || n == 22 || n == 23 || n == 67 || n == 24 || n == 25) {
            return false;
        }
        if (this.isEditing()) {
            return this.mUrlEditLayout.onKey(n, keyEvent);
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (motionEvent != null && motionEvent.getY() > (float)this.getHeight() + ViewHelper.getTranslationY((View)this)) {
            return false;
        }
        return super.onTouchEvent(motionEvent);
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        if (n2 != n4) {
            this.post(new Runnable(){

                public void run() {
                    BrowserToolbar.this.mActivity.refreshToolbarHeight();
                }
            });
        }
    }

    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, Object object) {
        Log.d((String)LOGTAG, (String)("onTabChanged: " + (Object)((Object)tabEvents)));
        Tabs tabs = Tabs.getInstance();
        switch (tabEvents) {
            case ADDED: 
            case CLOSED: {
                this.updateTabCount(tabs.getDisplayCount());
                break;
            }
            case RESTORED: 
            case SELECTED: {
                this.dismissSiteIdentityPopup();
                this.updateTabCount(tabs.getDisplayCount());
                this.mSwitchingTabs = true;
            }
        }
        if (tabs.isSelectedTab(tab)) {
            switch (tabEvents) {
                case TITLE: {
                    this.updateTitle();
                    break;
                }
                case START: {
                    this.updateBackButton(tab);
                    this.updateForwardButton(tab);
                    if (tab.getState() == 1) {
                        this.setProgressVisibility(true);
                    }
                    this.setSecurityMode(tab.getSecurityMode());
                    this.setPageActionVisibility(this.mStop.getVisibility() == 0);
                    break;
                }
                case STOP: {
                    this.updateBackButton(tab);
                    this.updateForwardButton(tab);
                    this.setProgressVisibility(false);
                    this.updateTitle();
                    break;
                }
                case SELECTED: 
                case LOAD_ERROR: {
                    this.updateTitle();
                }
                case LOCATION_CHANGE: {
                    this.refreshState();
                    break;
                }
                case ADDED: 
                case CLOSED: {
                    this.updateBackButton(tab);
                    this.updateForwardButton(tab);
                    break;
                }
                case FAVICON: {
                    this.setFavicon(tab.getFavicon());
                    break;
                }
                case SECURITY_CHANGE: {
                    this.setSecurityMode(tab.getSecurityMode());
                    break;
                }
                case READER_ENABLED: {
                    this.setPageActionVisibility(this.mStop.getVisibility() == 0);
                }
            }
        }
        switch (tabEvents) {
            case SELECTED: 
            case LOAD_ERROR: 
            case LOCATION_CHANGE: {
                this.mSwitchingTabs = false;
            }
        }
    }

    public boolean isVisible() {
        return ViewHelper.getTranslationY((View)this) == 0.0f;
    }

    public void setNextFocusDownId(int n) {
        super.setNextFocusDownId(n);
        this.mTabs.setNextFocusDownId(n);
        this.mBack.setNextFocusDownId(n);
        this.mForward.setNextFocusDownId(n);
        this.mFavicon.setNextFocusDownId(n);
        this.mStop.setNextFocusDownId(n);
        this.mSiteSecurity.setNextFocusDownId(n);
        this.mPageActionLayout.setNextFocusDownId(n);
        this.mMenu.setNextFocusDownId(n);
    }

    public void onAnimationStart(Animation animation) {
        if (animation.equals(this.mLockFadeIn)) {
            if (this.mSiteSecurityVisible) {
                this.mSiteSecurity.setVisibility(0);
            }
        } else if (animation.equals(this.mTitleSlideLeft)) {
            this.mSiteSecurity.setVisibility(8);
        } else if (animation.equals(this.mTitleSlideRight)) {
            this.mSiteSecurity.setVisibility(4);
        }
    }

    public void onAnimationRepeat(Animation animation) {
    }

    public void onAnimationEnd(Animation animation) {
        if (animation.equals(this.mTitleSlideRight)) {
            this.mSiteSecurity.startAnimation((Animation)this.mLockFadeIn);
        }
    }

    private boolean dismissSiteIdentityPopup() {
        if (this.mSiteIdentityPopup != null && this.mSiteIdentityPopup.isShowing()) {
            this.mSiteIdentityPopup.dismiss();
            return true;
        }
        return false;
    }

    private int getUrlBarEntryTranslation() {
        return this.getWidth() - this.mUrlBarEntry.getRight();
    }

    private int getUrlBarCurveTranslation() {
        return this.getWidth() - this.mTabs.getLeft();
    }

    private boolean canDoBack(Tab tab) {
        return tab.canDoBack() && !this.mIsEditing;
    }

    private boolean canDoForward(Tab tab) {
        return tab.canDoForward() && !this.mIsEditing;
    }

    private void addTab() {
        this.mActivity.addTab();
    }

    private void toggleTabs() {
        if (this.mActivity.areTabsShown()) {
            if (this.mActivity.hasTabsSideBar()) {
                this.mActivity.hideTabs();
            }
        } else {
            InputMethodManager inputMethodManager = (InputMethodManager)this.mActivity.getSystemService("input_method");
            inputMethodManager.hideSoftInputFromWindow(this.mTabs.getWindowToken(), 0);
            Tab tab = Tabs.getInstance().getSelectedTab();
            if (tab != null) {
                if (!tab.isPrivate()) {
                    this.mActivity.showNormalTabs();
                } else {
                    this.mActivity.showPrivateTabs();
                }
            }
        }
    }

    public void updateTabCountAndAnimate(int n) {
        if (!this.isVisible()) {
            this.updateTabCount(n);
            return;
        }
        if (!this.isEditing() || HardwareUtils.isTablet()) {
            this.mTabsCounter.setCount(n);
            this.mTabs.setContentDescription(n > 1 ? this.mActivity.getString(R.string.num_tabs, new Object[]{n}) : this.mActivity.getString(R.string.one_tab));
        }
    }

    public void updateTabCount(int n) {
        if (this.isEditing() && !HardwareUtils.isTablet()) {
            return;
        }
        if (this.isVisible() && ViewHelper.getAlpha((View)this.mTabsCounter) != 0.0f) {
            this.mTabsCounter.setCountWithAnimation(n);
        } else {
            this.mTabsCounter.setCount(n);
        }
        this.mTabs.setContentDescription(n > 1 ? this.mActivity.getString(R.string.num_tabs, new Object[]{n}) : this.mActivity.getString(R.string.one_tab));
    }

    public void setProgressVisibility(boolean bl) {
        Log.d((String)LOGTAG, (String)("setProgressVisibility: " + bl));
        if (bl) {
            this.mFavicon.setImageResource(R.drawable.progress_spinner);
            this.mLastFavicon = null;
            if (!this.mSpinnerVisible) {
                this.setPageActionVisibility(true);
                this.mFavicon.setAnimation(this.mProgressSpinner);
                this.mProgressSpinner.start();
                this.mSpinnerVisible = true;
            }
            Log.i((String)LOGTAG, (String)("zerdatime " + SystemClock.uptimeMillis() + " - Throbber start"));
        } else {
            Tab tab = Tabs.getInstance().getSelectedTab();
            if (tab != null) {
                this.setFavicon(tab.getFavicon());
            }
            if (this.mSpinnerVisible) {
                this.setPageActionVisibility(false);
                this.mFavicon.setAnimation(null);
                this.mProgressSpinner.cancel();
                this.mSpinnerVisible = false;
            }
            Log.i((String)LOGTAG, (String)("zerdatime " + SystemClock.uptimeMillis() + " - Throbber stop"));
        }
    }

    public void setPageActionVisibility(boolean bl) {
        this.mStop.setVisibility(bl ? 0 : 8);
        this.setSiteSecurityVisibility(this.mShowSiteSecurity && !bl);
        this.mPageActionLayout.setVisibility(!bl ? 0 : 8);
        this.mTitle.setPadding(0, 0, !bl ? this.mTitlePadding : 0, 0);
        this.updateFocusOrder();
    }

    private void setSiteSecurityVisibility(boolean bl) {
        if (bl == this.mSiteSecurityVisible) {
            return;
        }
        this.mSiteSecurityVisible = bl;
        if (this.mSwitchingTabs) {
            this.mSiteSecurity.setVisibility(bl ? 0 : 8);
            return;
        }
        this.mTitle.clearAnimation();
        this.mSiteSecurity.clearAnimation();
        this.mLockFadeIn.reset();
        this.mTitleSlideLeft.reset();
        this.mTitleSlideRight.reset();
        if (this.mForwardAnim != null) {
            long l = this.mForwardAnim.getRemainingTime();
            this.mTitleSlideRight.setStartOffset(l);
            this.mTitleSlideLeft.setStartOffset(l);
        } else {
            this.mTitleSlideRight.setStartOffset(0L);
            this.mTitleSlideLeft.setStartOffset(0L);
        }
        this.mTitle.startAnimation((Animation)(bl ? this.mTitleSlideRight : this.mTitleSlideLeft));
    }

    private void updateFocusOrder() {
        View view = null;
        boolean bl = false;
        for (View view2 : this.mFocusOrder) {
            if (view2.getVisibility() != 0 || !view2.isEnabled()) {
                if (!view2.hasFocus()) continue;
                bl = true;
                continue;
            }
            if (view2 == this.mActionItemBar) {
                int n = this.mActionItemBar.getChildCount();
                for (int i = 0; i < n; ++i) {
                    View view3 = this.mActionItemBar.getChildAt(i);
                    if (view != null) {
                        view3.setNextFocusLeftId(view.getId());
                        view.setNextFocusRightId(view3.getId());
                    }
                    view = view3;
                }
                continue;
            }
            if (view != null) {
                view2.setNextFocusLeftId(view.getId());
                view.setNextFocusRightId(view2.getId());
            }
            view = view2;
        }
        if (bl) {
            this.requestFocus();
        }
    }

    public void onEditSuggestion(String string2) {
        if (!this.isEditing()) {
            return;
        }
        this.mUrlEditLayout.onEditSuggestion(string2);
    }

    public void setTitle(CharSequence charSequence) {
        this.mTitle.setText(charSequence);
        this.setContentDescription(charSequence != null ? charSequence : this.mTitle.getHint());
    }

    private void updateTitle() {
        String string2;
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab == null || tab.isEnteringReaderMode()) {
            return;
        }
        String string3 = tab.getURL();
        if (!this.isEditing()) {
            this.mUrlEditLayout.setText(string3);
        }
        if (AboutPages.isTitlelessAboutPage(string3)) {
            this.setTitle(null);
            return;
        }
        if (tab.getErrorType() == Tab.ErrorType.BLOCKED) {
            String string4 = tab.getDisplayTitle();
            SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)string4);
            spannableStringBuilder.setSpan((Object)this.mBlockedColor, 0, string4.length(), 18);
            this.setTitle((CharSequence)spannableStringBuilder);
            return;
        }
        if (!this.mShowUrl || string3 == null) {
            this.setTitle(tab.getDisplayTitle());
            return;
        }
        String string5 = string3;
        if (this.mTrimURLs) {
            string5 = StringUtils.stripCommonSubdomains((String)StringUtils.stripScheme((String)string3));
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = tab.getBaseDomain()))) {
            SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)string5);
            int n = string5.toString().indexOf(string2);
            if (n > -1) {
                spannableStringBuilder.setSpan((Object)this.mUrlColor, 0, string5.length(), 18);
                spannableStringBuilder.setSpan((Object)(tab.isPrivate() ? this.mPrivateDomainColor : this.mDomainColor), n, n + string2.length(), 18);
                string5 = spannableStringBuilder;
            }
        }
        this.setTitle(string5);
    }

    public void showDefaultFavicon() {
        this.mFavicon.setImageResource(R.drawable.favicon);
        this.mLastFavicon = null;
    }

    private void setFavicon(Bitmap bitmap) {
        Log.d((String)LOGTAG, (String)("setFavicon(" + bitmap + ")"));
        if (Tabs.getInstance().getSelectedTab().getState() == 1) {
            return;
        }
        if (bitmap == this.mLastFavicon) {
            Log.d((String)LOGTAG, (String)"Ignoring favicon set: new favicon is identical to previous favicon.");
            return;
        }
        this.mLastFavicon = bitmap;
        if (bitmap != null) {
            bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)this.mFaviconSize, (int)this.mFaviconSize, (boolean)false);
            this.mFavicon.setImageBitmap(bitmap);
        } else {
            this.mFavicon.setImageDrawable(null);
        }
    }

    private void setSecurityMode(SiteIdentity.SecurityMode securityMode) {
        this.mSiteSecurity.setImageLevel(securityMode.ordinal());
        this.mShowSiteSecurity = securityMode != SiteIdentity.SecurityMode.UNKNOWN;
        this.setPageActionVisibility(this.mStop.getVisibility() == 0);
    }

    public void prepareTabsAnimation(PropertyAnimator propertyAnimator, boolean bl) {
        if (!bl) {
            PropertyAnimator propertyAnimator2 = new PropertyAnimator(propertyAnimator.getDuration(), sButtonsInterpolator);
            propertyAnimator2.attach((View)this.mTabsCounter, PropertyAnimator.Property.ALPHA, 1.0f);
            if (this.mHasSoftMenuButton && !HardwareUtils.isTablet()) {
                propertyAnimator2.attach((View)this.mMenuIcon, PropertyAnimator.Property.ALPHA, 1.0f);
            }
            propertyAnimator2.start();
            return;
        }
        ViewHelper.setAlpha((View)this.mTabsCounter, 0.0f);
        if (this.mHasSoftMenuButton && !HardwareUtils.isTablet()) {
            ViewHelper.setAlpha((View)this.mMenuIcon, 0.0f);
        }
    }

    public void finishTabsAnimation(boolean bl) {
        if (bl) {
            return;
        }
        PropertyAnimator propertyAnimator = new PropertyAnimator(150L);
        propertyAnimator.attach((View)this.mTabsCounter, PropertyAnimator.Property.ALPHA, 1.0f);
        if (this.mHasSoftMenuButton && !HardwareUtils.isTablet()) {
            propertyAnimator.attach((View)this.mMenuIcon, PropertyAnimator.Property.ALPHA, 1.0f);
        }
        propertyAnimator.start();
    }

    public void setOnActivateListener(OnActivateListener onActivateListener) {
        this.mActivateListener = onActivateListener;
    }

    public void setOnCommitListener(OnCommitListener onCommitListener) {
        this.mCommitListener = onCommitListener;
        this.mUrlEditLayout.setOnCommitListener(onCommitListener);
    }

    public void setOnDismissListener(OnDismissListener onDismissListener) {
        this.mDismissListener = onDismissListener;
        this.mUrlEditLayout.setOnDismissListener(onDismissListener);
    }

    public void setOnFilterListener(OnFilterListener onFilterListener) {
        this.mFilterListener = onFilterListener;
        this.mUrlEditLayout.setOnFilterListener(onFilterListener);
    }

    public void setOnStartEditingListener(OnStartEditingListener onStartEditingListener) {
        this.mStartEditingListener = onStartEditingListener;
    }

    public void setOnStopEditingListener(OnStopEditingListener onStopEditingListener) {
        this.mStopEditingListener = onStopEditingListener;
    }

    private void showUrlEditLayout() {
        this.setUrlEditLayoutVisibility(true, null);
    }

    private void showUrlEditLayout(PropertyAnimator propertyAnimator) {
        this.setUrlEditLayoutVisibility(true, propertyAnimator);
    }

    private void hideUrlEditLayout() {
        this.setUrlEditLayoutVisibility(false, null);
    }

    private void hideUrlEditLayout(PropertyAnimator propertyAnimator) {
        this.setUrlEditLayoutVisibility(false, propertyAnimator);
    }

    private void setUrlEditLayoutVisibility(boolean bl, PropertyAnimator propertyAnimator) {
        Object object;
        ToolbarEditLayout toolbarEditLayout = bl ? this.mUrlEditLayout : this.mUrlDisplayContainer;
        Object object2 = object = bl ? this.mUrlDisplayContainer : this.mUrlEditLayout;
        if (bl) {
            this.mUrlEditLayout.prepareShowAnimation(propertyAnimator);
        }
        if (propertyAnimator == null) {
            object.setVisibility(8);
            toolbarEditLayout.setVisibility(0);
            return;
        }
        ViewHelper.setAlpha((View)toolbarEditLayout, 0.0f);
        propertyAnimator.attach((View)toolbarEditLayout, PropertyAnimator.Property.ALPHA, 1.0f);
        propertyAnimator.attach((View)object, PropertyAnimator.Property.ALPHA, 0.0f);
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener((View)toolbarEditLayout, (View)object){
            final /* synthetic */ View val$viewToShow;
            final /* synthetic */ View val$viewToHide;
            {
                this.val$viewToShow = view;
                this.val$viewToHide = view2;
            }

            public void onPropertyAnimationStart() {
                this.val$viewToShow.setVisibility(0);
            }

            public void onPropertyAnimationEnd() {
                this.val$viewToHide.setVisibility(8);
                ViewHelper.setAlpha(this.val$viewToHide, 1.0f);
            }
        });
    }

    private void updateChildrenForEditing() {
        if (!HardwareUtils.isTablet()) {
            return;
        }
        boolean bl = !this.mIsEditing;
        float f = bl ? 1.0f : 0.24f;
        this.mTabs.setEnabled(bl);
        ViewHelper.setAlpha((View)this.mTabsCounter, f);
        this.mMenu.setEnabled(bl);
        ViewHelper.setAlpha((View)this.mMenuIcon, f);
        int n = this.mActionItemBar.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.mActionItemBar.getChildAt(i).setEnabled(bl);
        }
        ViewHelper.setAlpha((View)this.mActionItemBar, f);
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab != null) {
            this.setButtonEnabled(this.mBack, this.canDoBack(tab));
            this.setButtonEnabled(this.mForward, this.canDoForward(tab));
            if (!this.mIsEditing) {
                this.animateForwardButton(this.canDoForward(tab) ? ForwardButtonAnimation.SHOW : ForwardButtonAnimation.HIDE);
            }
        }
    }

    public void setIsEditing(boolean bl) {
        this.mIsEditing = bl;
        this.mUrlEditLayout.setEnabled(bl);
    }

    public boolean isEditing() {
        return this.mIsEditing;
    }

    public void startEditing(String string2, PropertyAnimator propertyAnimator) {
        if (this.isEditing()) {
            return;
        }
        this.mUrlEditLayout.setText(string2 != null ? string2 : "");
        this.setIsEditing(true);
        this.updateChildrenForEditing();
        if (this.mStartEditingListener != null) {
            this.mStartEditingListener.onStartEditing();
        }
        if (this.mUrlBarRightEdge != null) {
            this.mUrlBarRightEdge.setVisibility(0);
        }
        int n = this.getUrlBarEntryTranslation();
        int n2 = this.getUrlBarCurveTranslation();
        if (HardwareUtils.isTablet() || Build.VERSION.SDK_INT < 11) {
            this.showUrlEditLayout();
            if (!HardwareUtils.isTablet()) {
                if (this.mUrlBarRightEdge != null) {
                    ViewHelper.setTranslationX((View)this.mUrlBarRightEdge, n);
                }
                ViewHelper.setTranslationX((View)this.mTabs, n2);
                ViewHelper.setTranslationX((View)this.mTabsCounter, n2);
                ViewHelper.setTranslationX((View)this.mActionItemBar, n2);
                if (this.mHasSoftMenuButton) {
                    ViewHelper.setTranslationX((View)this.mMenu, n2);
                    ViewHelper.setTranslationX((View)this.mMenuIcon, n2);
                }
            }
            return;
        }
        if (this.mAnimatingEntry) {
            return;
        }
        this.setSelected(true);
        ViewHelper.setAlpha((View)this.mPageActionLayout, 0.0f);
        ViewHelper.setAlpha((View)this.mStop, 0.0f);
        if (this.mUrlBarRightEdge != null) {
            propertyAnimator.attach((View)this.mUrlBarRightEdge, PropertyAnimator.Property.TRANSLATION_X, n);
        }
        propertyAnimator.attach((View)this.mTabs, PropertyAnimator.Property.TRANSLATION_X, n2);
        propertyAnimator.attach((View)this.mTabsCounter, PropertyAnimator.Property.TRANSLATION_X, n2);
        propertyAnimator.attach((View)this.mActionItemBar, PropertyAnimator.Property.TRANSLATION_X, n2);
        if (this.mHasSoftMenuButton) {
            propertyAnimator.attach((View)this.mMenu, PropertyAnimator.Property.TRANSLATION_X, n2);
            propertyAnimator.attach((View)this.mMenuIcon, PropertyAnimator.Property.TRANSLATION_X, n2);
        }
        this.showUrlEditLayout(propertyAnimator);
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            public void onPropertyAnimationStart() {
            }

            public void onPropertyAnimationEnd() {
                BrowserToolbar.this.mAnimatingEntry = false;
            }
        });
        this.mAnimatingEntry = true;
    }

    public String cancelEdit() {
        return this.stopEditing();
    }

    public String commitEdit() {
        String string2 = this.stopEditing();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.setTitle(string2);
        }
        return string2;
    }

    private String stopEditing() {
        String string2 = this.mUrlEditLayout.getText();
        if (!this.isEditing()) {
            return string2;
        }
        this.setIsEditing(false);
        this.updateChildrenForEditing();
        if (this.mStopEditingListener != null) {
            this.mStopEditingListener.onStopEditing();
        }
        if (HardwareUtils.isTablet() || Build.VERSION.SDK_INT < 11) {
            this.hideUrlEditLayout();
            if (!HardwareUtils.isTablet()) {
                this.updateTabCountAndAnimate(Tabs.getInstance().getDisplayCount());
                if (this.mUrlBarRightEdge != null) {
                    ViewHelper.setTranslationX((View)this.mUrlBarRightEdge, 0.0f);
                }
                ViewHelper.setTranslationX((View)this.mTabs, 0.0f);
                ViewHelper.setTranslationX((View)this.mTabsCounter, 0.0f);
                ViewHelper.setTranslationX((View)this.mActionItemBar, 0.0f);
                if (this.mHasSoftMenuButton) {
                    ViewHelper.setTranslationX((View)this.mMenu, 0.0f);
                    ViewHelper.setTranslationX((View)this.mMenuIcon, 0.0f);
                }
            }
            return string2;
        }
        PropertyAnimator propertyAnimator = new PropertyAnimator(250L);
        propertyAnimator.setUseHardwareLayer(false);
        if (this.mUrlBarRightEdge != null) {
            propertyAnimator.attach((View)this.mUrlBarRightEdge, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
        }
        propertyAnimator.attach((View)this.mTabs, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
        propertyAnimator.attach((View)this.mTabsCounter, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
        propertyAnimator.attach((View)this.mActionItemBar, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
        if (this.mHasSoftMenuButton) {
            propertyAnimator.attach((View)this.mMenu, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
            propertyAnimator.attach((View)this.mMenuIcon, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
        }
        this.hideUrlEditLayout(propertyAnimator);
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            public void onPropertyAnimationStart() {
            }

            public void onPropertyAnimationEnd() {
                if (BrowserToolbar.this.mUrlBarRightEdge != null) {
                    BrowserToolbar.this.mUrlBarRightEdge.setVisibility(4);
                }
                PropertyAnimator propertyAnimator = new PropertyAnimator(300L);
                propertyAnimator.attach((View)BrowserToolbar.this.mPageActionLayout, PropertyAnimator.Property.ALPHA, 1.0f);
                propertyAnimator.attach((View)BrowserToolbar.this.mStop, PropertyAnimator.Property.ALPHA, 1.0f);
                propertyAnimator.start();
                BrowserToolbar.this.mAnimatingEntry = false;
                BrowserToolbar.this.updateTabCountAndAnimate(Tabs.getInstance().getDisplayCount());
            }
        });
        this.mAnimatingEntry = true;
        propertyAnimator.start();
        return string2;
    }

    public void setButtonEnabled(ImageButton imageButton, boolean bl) {
        Drawable drawable2 = imageButton.getDrawable();
        if (drawable2 != null) {
            drawable2.setAlpha(bl ? 255 : 61);
        }
        imageButton.setEnabled(bl);
    }

    public void updateBackButton(Tab tab) {
        this.setButtonEnabled(this.mBack, this.canDoBack(tab));
    }

    private void animateForwardButton(ForwardButtonAnimation forwardButtonAnimation) {
        if (this.mForward.getVisibility() != 0) {
            return;
        }
        final boolean bl = forwardButtonAnimation == ForwardButtonAnimation.SHOW;
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)this.mForward.getLayoutParams();
        if (marginLayoutParams.leftMargin > this.mDefaultForwardMargin && bl || marginLayoutParams.leftMargin == this.mDefaultForwardMargin && !bl) {
            return;
        }
        this.mForwardAnim = new PropertyAnimator(this.mSwitchingTabs ? 10L : 450L);
        final int n = this.mForward.getWidth() / 2;
        this.mForwardAnim.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            public void onPropertyAnimationStart() {
                if (!bl) {
                    ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbar.this.mUrlDisplayContainer.getLayoutParams();
                    marginLayoutParams.leftMargin = 0;
                    marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbar.this.mUrlEditLayout.getLayoutParams();
                    marginLayoutParams.leftMargin = 0;
                    BrowserToolbar.this.requestLayout();
                }
            }

            public void onPropertyAnimationEnd() {
                ViewGroup.MarginLayoutParams marginLayoutParams;
                if (bl) {
                    marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbar.this.mUrlDisplayContainer.getLayoutParams();
                    marginLayoutParams.leftMargin = BrowserToolbar.this.mUrlBarViewOffset;
                    marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbar.this.mUrlEditLayout.getLayoutParams();
                    marginLayoutParams.leftMargin = BrowserToolbar.this.mUrlBarViewOffset;
                    ViewHelper.setTranslationX((View)BrowserToolbar.this.mTitle, 0.0f);
                    ViewHelper.setTranslationX((View)BrowserToolbar.this.mFavicon, 0.0f);
                    ViewHelper.setTranslationX((View)BrowserToolbar.this.mSiteSecurity, 0.0f);
                }
                marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbar.this.mForward.getLayoutParams();
                marginLayoutParams.leftMargin = BrowserToolbar.this.mDefaultForwardMargin + (bl ? n : 0);
                ViewHelper.setTranslationX((View)BrowserToolbar.this.mForward, 0.0f);
                BrowserToolbar.this.requestLayout();
                BrowserToolbar.this.mForwardAnim = null;
            }
        });
        this.prepareForwardAnimation(this.mForwardAnim, forwardButtonAnimation, n);
        this.mForwardAnim.start();
    }

    public void updateForwardButton(Tab tab) {
        boolean bl = this.canDoForward(tab);
        if (this.mForward.isEnabled() == bl) {
            return;
        }
        this.setButtonEnabled(this.mForward, bl);
        this.animateForwardButton(bl ? ForwardButtonAnimation.SHOW : ForwardButtonAnimation.HIDE);
    }

    private void prepareForwardAnimation(PropertyAnimator propertyAnimator, ForwardButtonAnimation forwardButtonAnimation, int n) {
        if (forwardButtonAnimation == ForwardButtonAnimation.HIDE) {
            propertyAnimator.attach((View)this.mForward, PropertyAnimator.Property.TRANSLATION_X, -n);
            propertyAnimator.attach((View)this.mForward, PropertyAnimator.Property.ALPHA, 0.0f);
            propertyAnimator.attach((View)this.mTitle, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
            propertyAnimator.attach((View)this.mFavicon, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
            propertyAnimator.attach((View)this.mSiteSecurity, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
            ViewHelper.setTranslationX((View)this.mTitle, this.mUrlBarViewOffset);
            ViewHelper.setTranslationX((View)this.mFavicon, this.mUrlBarViewOffset);
            ViewHelper.setTranslationX((View)this.mSiteSecurity, this.mUrlBarViewOffset);
        } else {
            propertyAnimator.attach((View)this.mForward, PropertyAnimator.Property.TRANSLATION_X, n);
            propertyAnimator.attach((View)this.mForward, PropertyAnimator.Property.ALPHA, 1.0f);
            propertyAnimator.attach((View)this.mTitle, PropertyAnimator.Property.TRANSLATION_X, this.mUrlBarViewOffset);
            propertyAnimator.attach((View)this.mFavicon, PropertyAnimator.Property.TRANSLATION_X, this.mUrlBarViewOffset);
            propertyAnimator.attach((View)this.mSiteSecurity, PropertyAnimator.Property.TRANSLATION_X, this.mUrlBarViewOffset);
        }
    }

    public boolean addActionItem(View view) {
        this.mActionItemBar.addView(view);
        return true;
    }

    public void removeActionItem(View view) {
        this.mActionItemBar.removeView(view);
    }

    public void show() {
        this.setVisibility(0);
    }

    public void hide() {
        this.setVisibility(8);
    }

    private void refreshState() {
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab != null) {
            this.setFavicon(tab.getFavicon());
            this.setProgressVisibility(tab.getState() == 1);
            this.setSecurityMode(tab.getSecurityMode());
            this.setPageActionVisibility(this.mStop.getVisibility() == 0);
            this.updateBackButton(tab);
            this.updateForwardButton(tab);
            boolean bl = tab.isPrivate();
            this.setPrivateMode(bl);
            this.mTabs.setPrivateMode(bl);
            this.mTitle.setPrivateMode(bl);
            this.mMenu.setPrivateMode(bl);
            this.mMenuIcon.setPrivateMode(bl);
            this.mUrlEditLayout.setPrivateMode(bl);
            if (this.mBack instanceof BackButton) {
                ((BackButton)this.mBack).setPrivateMode(bl);
            }
            if (this.mForward instanceof ForwardButton) {
                ((ForwardButton)this.mForward).setPrivateMode(bl);
            }
        }
    }

    public View getDoorHangerAnchor() {
        return this.mFavicon;
    }

    public void onDestroy() {
        if (this.mPrefObserverId != null) {
            PrefsHelper.removeObserver(this.mPrefObserverId);
            this.mPrefObserverId = null;
        }
        Tabs.unregisterOnTabsChangedListener(this);
        this.unregisterEventListener("Reader:Click");
        this.unregisterEventListener("Reader:LongClick");
    }

    public boolean openOptionsMenu() {
        if (!this.mHasSoftMenuButton) {
            return false;
        }
        if (this.mMenuPopup == null) {
            MenuPanel menuPanel = this.mActivity.getMenuPanel();
            this.mMenuPopup = new MenuPopup((Context)this.mActivity);
            this.mMenuPopup.setPanelView((View)menuPanel);
            this.mMenuPopup.setOnDismissListener(new PopupWindow.OnDismissListener(){

                public void onDismiss() {
                    BrowserToolbar.this.mActivity.onOptionsMenuClosed(null);
                }
            });
        }
        GeckoAppShell.getGeckoInterface().invalidateOptionsMenu();
        if (!this.mMenuPopup.isShowing()) {
            this.mMenuPopup.showAsDropDown((View)this.mMenu);
        }
        return true;
    }

    public boolean closeOptionsMenu() {
        if (!this.mHasSoftMenuButton) {
            return false;
        }
        if (this.mMenuPopup != null && this.mMenuPopup.isShowing()) {
            this.mMenuPopup.dismiss();
        }
        return true;
    }

    protected void registerEventListener(String string2) {
        GeckoAppShell.getEventDispatcher().registerEventListener(string2, (GeckoEventListener)this);
    }

    protected void unregisterEventListener(String string2) {
        GeckoAppShell.getEventDispatcher().unregisterEventListener(string2, (GeckoEventListener)this);
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        Tab tab;
        Log.d((String)LOGTAG, (String)("handleMessage: " + string2));
        if (string2.equals("Reader:Click")) {
            Tab tab2 = Tabs.getInstance().getSelectedTab();
            if (tab2 != null) {
                tab2.toggleReaderMode();
            }
        } else if (string2.equals("Reader:LongClick") && (tab = Tabs.getInstance().getSelectedTab()) != null) {
            tab.addToReadingList();
        }
    }

    public void onLightweightThemeChanged() {
        Drawable drawable2 = this.mTheme.getDrawable((View)this);
        if (drawable2 == null) {
            return;
        }
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(PRIVATE_STATE_SET, (Drawable)this.getColorDrawable(R.color.background_private));
        stateListDrawable.addState(EMPTY_STATE_SET, drawable2);
        this.setBackgroundDrawable((Drawable)stateListDrawable);
    }

    public void onLightweightThemeReset() {
        this.setBackgroundResource(R.drawable.url_bar_bg);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ForwardButtonAnimation {
        SHOW,
        HIDE;

    }

    public static interface OnStopEditingListener {
        public void onStopEditing();
    }

    public static interface OnStartEditingListener {
        public void onStartEditing();
    }

    public static interface OnFilterListener {
        public void onFilter(String var1, AutocompleteHandler var2);
    }

    public static interface OnDismissListener {
        public void onDismiss();
    }

    public static interface OnCommitListener {
        public void onCommit();
    }

    public static interface OnActivateListener {
        public void onActivate();
    }
}

