/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.ContentProvider;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.OperationApplicationException;
import android.content.UriMatcher;
import android.content.res.Resources;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.MatrixCursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteQueryBuilder;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.Distribution;
import org.mozilla.gecko.R;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.db.DBUtils;
import org.mozilla.gecko.db.PerProfileDatabases;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.gfx.BitmapUtils;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.util.GeckoJarReader;
import org.mozilla.gecko.util.ThreadUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserProvider
extends ContentProvider {
    private static final String LOGTAG = "GeckoBrowserProvider";
    private Context mContext;
    private PerProfileDatabases<BrowserDatabaseHelper> mDatabases;
    static final String DATABASE_NAME = "browser.db";
    static final int DATABASE_VERSION = 17;
    static final long MAX_AGE_OF_DELETED_RECORDS = 1728000000L;
    static final long DELETED_RECORDS_PURGE_LIMIT = 5L;
    static final int MAX_POSITION_UPDATES_PER_QUERY = 100;
    static final int DEFAULT_EXPIRY_RETAIN_COUNT = 2000;
    static final int AGGRESSIVE_EXPIRY_RETAIN_COUNT = 500;
    static final long DEFAULT_EXPIRY_PRESERVE_WINDOW = 2419200000L;
    static final int DEFAULT_EXPIRY_THUMBNAIL_COUNT = 15;
    static final String TABLE_BOOKMARKS = "bookmarks";
    static final String TABLE_HISTORY = "history";
    static final String TABLE_FAVICONS = "favicons";
    static final String TABLE_THUMBNAILS = "thumbnails";
    static final String TABLE_BOOKMARKS_TMP = "bookmarks_tmp";
    static final String TABLE_HISTORY_TMP = "history_tmp";
    static final String TABLE_IMAGES_TMP = "images_tmp";
    static final String VIEW_COMBINED = "combined";
    static final String VIEW_BOOKMARKS_WITH_FAVICONS = "bookmarks_with_favicons";
    static final String VIEW_HISTORY_WITH_FAVICONS = "history_with_favicons";
    static final String VIEW_COMBINED_WITH_FAVICONS = "combined_with_favicons";
    static final int BOOKMARKS = 100;
    static final int BOOKMARKS_ID = 101;
    static final int BOOKMARKS_FOLDER_ID = 102;
    static final int BOOKMARKS_PARENT = 103;
    static final int BOOKMARKS_POSITIONS = 104;
    static final int HISTORY = 200;
    static final int HISTORY_ID = 201;
    static final int HISTORY_OLD = 202;
    static final int FAVICONS = 300;
    static final int FAVICON_ID = 301;
    static final int SCHEMA = 400;
    static final int COMBINED = 500;
    static final int CONTROL = 600;
    static final int SEARCH_SUGGEST = 700;
    static final int THUMBNAILS = 800;
    static final int THUMBNAIL_ID = 801;
    static final String DEFAULT_BOOKMARKS_SORT_ORDER = "type ASC, position ASC, _id ASC";
    static final String DEFAULT_HISTORY_SORT_ORDER = "date DESC";
    static final String TABLE_BOOKMARKS_JOIN_FAVICONS = "bookmarks LEFT OUTER JOIN favicons ON " + BrowserProvider.qualifyColumn("bookmarks", "favicon_id") + " = " + BrowserProvider.qualifyColumn("favicons", "_id");
    static final String TABLE_HISTORY_JOIN_FAVICONS = "history LEFT OUTER JOIN favicons ON " + BrowserProvider.qualifyColumn("history", "favicon_id") + " = " + BrowserProvider.qualifyColumn("favicons", "_id");
    static final UriMatcher URI_MATCHER = new UriMatcher(-1);
    static final Map<String, String> BOOKMARKS_PROJECTION_MAP;
    static final Map<String, String> HISTORY_PROJECTION_MAP;
    static final Map<String, String> COMBINED_PROJECTION_MAP;
    static final Map<String, String> SCHEMA_PROJECTION_MAP;
    static final Map<String, String> SEARCH_SUGGEST_PROJECTION_MAP;
    static final Map<String, String> FAVICONS_PROJECTION_MAP;
    static final Map<String, String> THUMBNAILS_PROJECTION_MAP;
    private static boolean logDebug;
    private static boolean logVerbose;
    private static final String[] mobileIdColumns;
    private static final String[] mobileIdSelectionArgs;

    static final String qualifyColumn(String string2, String string3) {
        return string2 + "." + string3;
    }

    private static boolean hasFaviconsInProjection(String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("favicon") && !stringArray[i].equals("favicon_url")) continue;
            return true;
        }
        return false;
    }

    protected static void trace(String string2) {
        if (logVerbose) {
            Log.v((String)LOGTAG, (String)string2);
        }
    }

    protected static void debug(String string2) {
        if (logDebug) {
            Log.d((String)LOGTAG, (String)string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getMobileFolderId(SQLiteDatabase sQLiteDatabase) {
        Cursor cursor = null;
        try {
            cursor = sQLiteDatabase.query(TABLE_BOOKMARKS, mobileIdColumns, "guid = ?", mobileIdSelectionArgs, null, null, null);
            if (cursor == null || !cursor.moveToFirst()) {
                Integer n = null;
                return n;
            }
            Integer n = cursor.getInt(cursor.getColumnIndex("_id"));
            return n;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    private SQLiteDatabase getReadableDatabase(Uri uri) {
        BrowserProvider.trace("Getting readable database for URI: " + uri);
        String string2 = null;
        if (uri != null) {
            string2 = uri.getQueryParameter("profile");
        }
        return this.mDatabases.getDatabaseHelperForProfile(string2, this.isTest(uri)).getReadableDatabase();
    }

    private SQLiteDatabase getWritableDatabase(Uri uri) {
        BrowserProvider.trace("Getting writable database for URI: " + uri);
        String string2 = null;
        if (uri != null) {
            string2 = uri.getQueryParameter("profile");
        }
        return this.mDatabases.getDatabaseHelperForProfile(string2, this.isTest(uri)).getWritableDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupSomeDeletedRecords(Uri uri, Uri uri2, String string2) {
        Log.d((String)LOGTAG, (String)("Cleaning up deleted records from " + string2));
        Uri.Builder builder = uri2.buildUpon().appendQueryParameter("limit", String.valueOf(5L)).appendQueryParameter("show_deleted", "1").appendQueryParameter("sync", "1");
        String string3 = uri.getQueryParameter("profile");
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            builder = builder.appendQueryParameter("profile", string3);
        }
        if (this.isTest(uri)) {
            builder = builder.appendQueryParameter("test", "1");
        }
        Uri uri3 = builder.build();
        Cursor cursor = null;
        try {
            long l = System.currentTimeMillis();
            String string4 = "deleted = 1 AND modified <= " + (l - 1728000000L);
            cursor = this.query(uri3, new String[]{"_id"}, string4, null, null);
            while (cursor.moveToNext()) {
                Uri uri4 = ContentUris.withAppendedId((Uri)uri3, (long)cursor.getLong(0));
                this.delete(uri4, null, null);
                BrowserProvider.debug("Removed old deleted item with URI: " + uri4);
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    private void expireHistory(SQLiteDatabase sQLiteDatabase, int n, long l) {
        Log.d((String)LOGTAG, (String)"Expiring history.");
        long l2 = DatabaseUtils.queryNumEntries((SQLiteDatabase)sQLiteDatabase, (String)TABLE_HISTORY);
        if ((long)n >= l2) {
            BrowserProvider.debug("Not expiring history: only have " + l2 + " rows.");
            return;
        }
        String string2 = BrowserContract.getFrecencySortOrder(false, true);
        long l3 = l2 - (long)n;
        BrowserProvider.debug("Expiring at most " + l3 + " rows earlier than " + l + ".");
        String string3 = l > 0L ? "DELETE FROM history WHERE MAX(date, modified) < " + l + " " + " AND " + "_id" + " IN ( SELECT " + "_id" + " FROM " + TABLE_HISTORY + " " + "ORDER BY " + string2 + " LIMIT " + l3 + ")" : "DELETE FROM history WHERE _id IN ( SELECT _id FROM history ORDER BY " + string2 + " LIMIT " + l3 + ")";
        BrowserProvider.trace("Deleting using query: " + string3);
        sQLiteDatabase.execSQL(string3);
    }

    private void expireThumbnails(SQLiteDatabase sQLiteDatabase) {
        Log.d((String)LOGTAG, (String)"Expiring thumbnails.");
        String string2 = BrowserContract.getFrecencySortOrder(true, false);
        String string3 = "DELETE FROM thumbnails WHERE url NOT IN (  SELECT url FROM combined ORDER BY " + string2 + " LIMIT " + 15 + ") AND " + "url" + " NOT IN ( " + " SELECT " + "url" + " FROM " + TABLE_BOOKMARKS + " WHERE " + "parent" + " = " + -3 + ")";
        BrowserProvider.trace("Clear thumbs using query: " + string3);
        sQLiteDatabase.execSQL(string3);
    }

    private boolean isCallerSync(Uri uri) {
        String string2 = uri.getQueryParameter("sync");
        return !TextUtils.isEmpty((CharSequence)string2);
    }

    private boolean isTest(Uri uri) {
        String string2 = uri.getQueryParameter("test");
        return !TextUtils.isEmpty((CharSequence)string2);
    }

    private boolean shouldShowDeleted(Uri uri) {
        String string2 = uri.getQueryParameter("show_deleted");
        return !TextUtils.isEmpty((CharSequence)string2);
    }

    private boolean shouldUpdateOrInsert(Uri uri) {
        String string2 = uri.getQueryParameter("insert_if_needed");
        return Boolean.parseBoolean(string2);
    }

    private boolean shouldIncrementVisits(Uri uri) {
        String string2 = uri.getQueryParameter("increment_visits");
        return Boolean.parseBoolean(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onCreate() {
        BrowserProvider.debug("Creating BrowserProvider");
        BrowserProvider browserProvider = this;
        synchronized (browserProvider) {
            this.mContext = this.getContext();
            this.mDatabases = new PerProfileDatabases<BrowserDatabaseHelper>(this.getContext(), DATABASE_NAME, new PerProfileDatabases.DatabaseHelperFactory<BrowserDatabaseHelper>(){

                @Override
                public BrowserDatabaseHelper makeDatabaseHelper(Context context, String string2) {
                    return new BrowserDatabaseHelper(context, string2);
                }
            });
        }
        return true;
    }

    public String getType(Uri uri) {
        int n = URI_MATCHER.match(uri);
        BrowserProvider.trace("Getting URI type: " + uri);
        switch (n) {
            case 100: {
                BrowserProvider.trace("URI is BOOKMARKS: " + uri);
                return "vnd.android.cursor.dir/bookmark";
            }
            case 101: {
                BrowserProvider.trace("URI is BOOKMARKS_ID: " + uri);
                return "vnd.android.cursor.item/bookmark";
            }
            case 200: {
                BrowserProvider.trace("URI is HISTORY: " + uri);
                return "vnd.android.cursor.dir/browser-history";
            }
            case 201: {
                BrowserProvider.trace("URI is HISTORY_ID: " + uri);
                return "vnd.android.cursor.item/browser-history";
            }
            case 700: {
                BrowserProvider.trace("URI is SEARCH_SUGGEST: " + uri);
                return "vnd.android.cursor.dir/vnd.android.search.suggest";
            }
        }
        BrowserProvider.debug("URI has unrecognized type: " + uri);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(Uri uri, String string2, String[] stringArray) {
        BrowserProvider.trace("Calling delete on URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        int n = 0;
        if (Build.VERSION.SDK_INT >= 11) {
            BrowserProvider.trace("Beginning delete transaction: " + uri);
            sQLiteDatabase.beginTransaction();
            try {
                n = this.deleteInTransaction(sQLiteDatabase, uri, string2, stringArray);
                sQLiteDatabase.setTransactionSuccessful();
                BrowserProvider.trace("Successful delete transaction: " + uri);
            }
            finally {
                sQLiteDatabase.endTransaction();
            }
        } else {
            n = this.deleteInTransaction(sQLiteDatabase, uri, string2, stringArray);
        }
        if (n > 0) {
            this.getContext().getContentResolver().notifyChange(uri, null);
        }
        return n;
    }

    public int deleteInTransaction(SQLiteDatabase sQLiteDatabase, Uri uri, String string2, String[] stringArray) {
        BrowserProvider.trace("Calling delete in transaction on URI: " + uri);
        int n = URI_MATCHER.match(uri);
        int n2 = 0;
        switch (n) {
            case 101: {
                BrowserProvider.trace("Delete on BOOKMARKS_ID: " + uri);
                string2 = DBUtils.concatenateWhere(string2, "bookmarks._id = ?");
                stringArray = DBUtils.appendSelectionArgs(stringArray, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 100: {
                BrowserProvider.trace("Deleting bookmarks: " + uri);
                n2 = this.deleteBookmarks(uri, string2, stringArray);
                this.deleteUnusedImages(uri);
                break;
            }
            case 201: {
                BrowserProvider.trace("Delete on HISTORY_ID: " + uri);
                string2 = DBUtils.concatenateWhere(string2, "history._id = ?");
                stringArray = DBUtils.appendSelectionArgs(stringArray, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 200: {
                BrowserProvider.trace("Deleting history: " + uri);
                n2 = this.deleteHistory(uri, string2, stringArray);
                this.deleteUnusedImages(uri);
                break;
            }
            case 202: {
                String string3 = uri.getQueryParameter("priority");
                long l = System.currentTimeMillis() - 2419200000L;
                int n3 = 2000;
                if (BrowserContract.ExpirePriority.AGGRESSIVE.toString().equals(string3)) {
                    l = 0L;
                    n3 = 500;
                }
                this.expireHistory(sQLiteDatabase, n3, l);
                this.expireThumbnails(sQLiteDatabase);
                this.deleteUnusedImages(uri);
                break;
            }
            case 301: {
                BrowserProvider.debug("Delete on FAVICON_ID: " + uri);
                string2 = DBUtils.concatenateWhere(string2, "favicons._id = ?");
                stringArray = DBUtils.appendSelectionArgs(stringArray, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 300: {
                BrowserProvider.trace("Deleting favicons: " + uri);
                n2 = this.deleteFavicons(uri, string2, stringArray);
                break;
            }
            case 801: {
                BrowserProvider.debug("Delete on THUMBNAIL_ID: " + uri);
                string2 = DBUtils.concatenateWhere(string2, "thumbnails._id = ?");
                stringArray = DBUtils.appendSelectionArgs(stringArray, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 800: {
                BrowserProvider.trace("Deleting thumbnails: " + uri);
                n2 = this.deleteThumbnails(uri, string2, stringArray);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown delete URI " + uri);
            }
        }
        BrowserProvider.debug("Deleted " + n2 + " rows for URI: " + uri);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Uri insert(Uri uri, ContentValues contentValues) {
        Uri uri2;
        block8: {
            BrowserProvider.trace("Calling insert on URI: " + uri);
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
            uri2 = null;
            try {
                if (Build.VERSION.SDK_INT >= 11) {
                    BrowserProvider.trace("Beginning insert transaction: " + uri);
                    sQLiteDatabase.beginTransaction();
                    try {
                        uri2 = this.insertInTransaction(uri, contentValues);
                        sQLiteDatabase.setTransactionSuccessful();
                        BrowserProvider.trace("Successful insert transaction: " + uri);
                        break block8;
                    }
                    finally {
                        sQLiteDatabase.endTransaction();
                    }
                }
                uri2 = this.insertInTransaction(uri, contentValues);
            }
            catch (SQLException sQLException) {
                Log.e((String)LOGTAG, (String)"exception in DB operation", (Throwable)sQLException);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Log.e((String)LOGTAG, (String)"don't know how to perform that insert", (Throwable)unsupportedOperationException);
            }
        }
        if (uri2 != null) {
            this.getContext().getContentResolver().notifyChange(uri, null);
        }
        return uri2;
    }

    public Uri insertInTransaction(Uri uri, ContentValues contentValues) {
        BrowserProvider.trace("Calling insert in transaction on URI: " + uri);
        int n = URI_MATCHER.match(uri);
        long l = -1L;
        switch (n) {
            case 100: {
                BrowserProvider.trace("Insert on BOOKMARKS: " + uri);
                l = this.insertBookmark(uri, contentValues);
                break;
            }
            case 200: {
                BrowserProvider.trace("Insert on HISTORY: " + uri);
                l = this.insertHistory(uri, contentValues);
                break;
            }
            case 300: {
                BrowserProvider.trace("Insert on FAVICONS: " + uri);
                l = this.insertFavicon(uri, contentValues);
                break;
            }
            case 800: {
                BrowserProvider.trace("Insert on THUMBNAILS: " + uri);
                l = this.insertThumbnail(uri, contentValues);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown insert URI " + uri);
            }
        }
        BrowserProvider.debug("Inserted ID in database: " + l);
        if (l >= 0L) {
            return ContentUris.withAppendedId((Uri)uri, (long)l);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        BrowserProvider.trace("Calling update on URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        int n = 0;
        if (Build.VERSION.SDK_INT >= 11) {
            BrowserProvider.trace("Beginning update transaction: " + uri);
            sQLiteDatabase.beginTransaction();
            try {
                n = this.updateInTransaction(uri, contentValues, string2, stringArray);
                sQLiteDatabase.setTransactionSuccessful();
                BrowserProvider.trace("Successful update transaction: " + uri);
            }
            finally {
                sQLiteDatabase.endTransaction();
            }
        } else {
            n = this.updateInTransaction(uri, contentValues, string2, stringArray);
        }
        if (n > 0) {
            this.getContext().getContentResolver().notifyChange(uri, null);
        }
        return n;
    }

    public int updateInTransaction(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        BrowserProvider.trace("Calling update in transaction on URI: " + uri);
        int n = URI_MATCHER.match(uri);
        int n2 = 0;
        switch (n) {
            case 104: {
                BrowserProvider.debug("Update on BOOKMARKS_POSITIONS: " + uri);
                n2 = this.updateBookmarkPositions(uri, stringArray);
                break;
            }
            case 103: {
                BrowserProvider.debug("Update on BOOKMARKS_PARENT: " + uri);
                n2 = this.updateBookmarkParents(uri, contentValues, string2, stringArray);
                break;
            }
            case 101: {
                BrowserProvider.debug("Update on BOOKMARKS_ID: " + uri);
                string2 = DBUtils.concatenateWhere(string2, "bookmarks._id = ?");
                stringArray = DBUtils.appendSelectionArgs(stringArray, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 100: {
                BrowserProvider.debug("Updating bookmark: " + uri);
                if (this.shouldUpdateOrInsert(uri)) {
                    n2 = this.updateOrInsertBookmark(uri, contentValues, string2, stringArray);
                    break;
                }
                n2 = this.updateBookmarks(uri, contentValues, string2, stringArray);
                break;
            }
            case 201: {
                BrowserProvider.debug("Update on HISTORY_ID: " + uri);
                string2 = DBUtils.concatenateWhere(string2, "history._id = ?");
                stringArray = DBUtils.appendSelectionArgs(stringArray, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 200: {
                BrowserProvider.debug("Updating history: " + uri);
                if (this.shouldUpdateOrInsert(uri)) {
                    n2 = this.updateOrInsertHistory(uri, contentValues, string2, stringArray);
                    break;
                }
                n2 = this.updateHistory(uri, contentValues, string2, stringArray);
                break;
            }
            case 300: {
                BrowserProvider.debug("Update on FAVICONS: " + uri);
                String string3 = contentValues.getAsString("url");
                String string4 = null;
                String[] stringArray2 = null;
                if (!TextUtils.isEmpty((CharSequence)string3)) {
                    string4 = "url = ?";
                    stringArray2 = new String[]{string3};
                }
                if (this.shouldUpdateOrInsert(uri)) {
                    n2 = this.updateOrInsertFavicon(uri, contentValues, string4, stringArray2);
                    break;
                }
                n2 = this.updateExistingFavicon(uri, contentValues, string4, stringArray2);
                break;
            }
            case 800: {
                BrowserProvider.debug("Update on THUMBNAILS: " + uri);
                String string5 = contentValues.getAsString("url");
                if (TextUtils.isEmpty((CharSequence)contentValues.getAsString("url"))) {
                    n2 = this.updateExistingThumbnail(uri, contentValues, null, null);
                    break;
                }
                if (this.shouldUpdateOrInsert(uri)) {
                    n2 = this.updateOrInsertThumbnail(uri, contentValues, "url = ?", new String[]{string5});
                    break;
                }
                n2 = this.updateExistingThumbnail(uri, contentValues, "url = ?", new String[]{string5});
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown update URI " + uri);
            }
        }
        BrowserProvider.debug("Updated " + n2 + " rows for URI: " + uri);
        return n2;
    }

    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        String string4;
        SQLiteDatabase sQLiteDatabase = this.getReadableDatabase(uri);
        int n = URI_MATCHER.match(uri);
        SQLiteQueryBuilder sQLiteQueryBuilder = new SQLiteQueryBuilder();
        String string5 = uri.getQueryParameter("limit");
        String string6 = null;
        switch (n) {
            case 100: 
            case 101: 
            case 102: {
                BrowserProvider.debug("Query is on bookmarks: " + uri);
                if (n == 101) {
                    string2 = DBUtils.concatenateWhere(string2, "_id = ?");
                    stringArray2 = DBUtils.appendSelectionArgs(stringArray2, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
                } else if (n == 102) {
                    string2 = DBUtils.concatenateWhere(string2, "parent = ?");
                    stringArray2 = DBUtils.appendSelectionArgs(stringArray2, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
                }
                if (!this.shouldShowDeleted(uri)) {
                    string2 = DBUtils.concatenateWhere("deleted = 0", string2);
                }
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    string3 = DEFAULT_BOOKMARKS_SORT_ORDER;
                } else {
                    BrowserProvider.debug("Using sort order " + string3 + ".");
                }
                sQLiteQueryBuilder.setProjectionMap(BOOKMARKS_PROJECTION_MAP);
                if (BrowserProvider.hasFaviconsInProjection(stringArray)) {
                    sQLiteQueryBuilder.setTables(VIEW_BOOKMARKS_WITH_FAVICONS);
                    break;
                }
                sQLiteQueryBuilder.setTables(TABLE_BOOKMARKS);
                break;
            }
            case 201: {
                string2 = DBUtils.concatenateWhere(string2, "_id = ?");
                stringArray2 = DBUtils.appendSelectionArgs(stringArray2, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 200: {
                BrowserProvider.debug("Query is on history: " + uri);
                if (!this.shouldShowDeleted(uri)) {
                    string2 = DBUtils.concatenateWhere("deleted = 0", string2);
                }
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    string3 = DEFAULT_HISTORY_SORT_ORDER;
                }
                sQLiteQueryBuilder.setProjectionMap(HISTORY_PROJECTION_MAP);
                if (BrowserProvider.hasFaviconsInProjection(stringArray)) {
                    sQLiteQueryBuilder.setTables(VIEW_HISTORY_WITH_FAVICONS);
                    break;
                }
                sQLiteQueryBuilder.setTables(TABLE_HISTORY);
                break;
            }
            case 301: {
                string2 = DBUtils.concatenateWhere(string2, "_id = ?");
                stringArray2 = DBUtils.appendSelectionArgs(stringArray2, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 300: {
                BrowserProvider.debug("Query is on favicons: " + uri);
                sQLiteQueryBuilder.setProjectionMap(FAVICONS_PROJECTION_MAP);
                sQLiteQueryBuilder.setTables(TABLE_FAVICONS);
                break;
            }
            case 801: {
                string2 = DBUtils.concatenateWhere(string2, "_id = ?");
                stringArray2 = DBUtils.appendSelectionArgs(stringArray2, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 800: {
                BrowserProvider.debug("Query is on thumbnails: " + uri);
                sQLiteQueryBuilder.setProjectionMap(THUMBNAILS_PROJECTION_MAP);
                sQLiteQueryBuilder.setTables(TABLE_THUMBNAILS);
                break;
            }
            case 400: {
                BrowserProvider.debug("Query is on schema.");
                MatrixCursor matrixCursor = new MatrixCursor(new String[]{"version"});
                matrixCursor.newRow().add((Object)17);
                return matrixCursor;
            }
            case 500: {
                BrowserProvider.debug("Query is on combined: " + uri);
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    string3 = DEFAULT_HISTORY_SORT_ORDER;
                }
                string6 = "url";
                sQLiteQueryBuilder.setProjectionMap(COMBINED_PROJECTION_MAP);
                if (BrowserProvider.hasFaviconsInProjection(stringArray)) {
                    sQLiteQueryBuilder.setTables(VIEW_COMBINED_WITH_FAVICONS);
                    break;
                }
                sQLiteQueryBuilder.setTables(VIEW_COMBINED);
                break;
            }
            case 700: {
                BrowserProvider.debug("Query is on search suggest: " + uri);
                string2 = DBUtils.concatenateWhere(string2, "(url LIKE ? OR title LIKE ?)");
                string4 = uri.getLastPathSegment();
                if (string4 == null) {
                    string4 = "";
                }
                stringArray2 = DBUtils.appendSelectionArgs(stringArray2, new String[]{"%" + string4 + "%", "%" + string4 + "%"});
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    string3 = DEFAULT_HISTORY_SORT_ORDER;
                }
                sQLiteQueryBuilder.setProjectionMap(SEARCH_SUGGEST_PROJECTION_MAP);
                sQLiteQueryBuilder.setTables(VIEW_COMBINED_WITH_FAVICONS);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown query URI " + uri);
            }
        }
        BrowserProvider.trace("Running built query.");
        string4 = sQLiteQueryBuilder.query(sQLiteDatabase, stringArray, string2, stringArray2, string6, null, string3, string5);
        string4.setNotificationUri(this.getContext().getContentResolver(), BrowserContract.AUTHORITY_URI);
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getUrlCount(SQLiteDatabase sQLiteDatabase, String string2, String string3) {
        Cursor cursor = sQLiteDatabase.query(string2, new String[]{"COUNT(*)"}, "url = ?", new String[]{string3}, null, null, null);
        int n = 0;
        try {
            if (cursor.moveToFirst()) {
                n = cursor.getInt(0);
            }
        }
        finally {
            cursor.close();
        }
        return n;
    }

    int updateBookmarkPositions(Uri uri, String[] stringArray) {
        if (stringArray == null) {
            return 0;
        }
        int n = stringArray.length;
        if (n == 0) {
            return 0;
        }
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        int n2 = 0;
        sQLiteDatabase.beginTransaction();
        for (int i = 0; i < n; i += 100) {
            try {
                n2 += this.updateBookmarkPositionsInTransaction(sQLiteDatabase, stringArray, i, 100);
                continue;
            }
            catch (SQLException sQLException) {
                Log.e((String)LOGTAG, (String)("Got SQLite exception updating bookmark positions at offset " + i), (Throwable)sQLException);
                sQLiteDatabase.setTransactionSuccessful();
                sQLiteDatabase.endTransaction();
                sQLiteDatabase.beginTransaction();
            }
        }
        sQLiteDatabase.setTransactionSuccessful();
        sQLiteDatabase.endTransaction();
        return n2;
    }

    int updateBookmarkPositionsInTransaction(SQLiteDatabase sQLiteDatabase, String[] stringArray, int n, int n2) {
        int n3;
        int n4 = stringArray.length;
        int n5 = Math.min(n2, n4 - n);
        Object[] objectArray = new String[n5 * 2];
        System.arraycopy(stringArray, n, objectArray, 0, n5);
        System.arraycopy(stringArray, n, objectArray, n5, n5);
        StringBuilder stringBuilder = new StringBuilder("UPDATE bookmarks SET position = CASE guid");
        int n6 = n + n5;
        for (n3 = n; n3 < n6; ++n3) {
            if (stringArray[n3] == null) {
                BrowserProvider.debug("updateBookmarkPositions called with null GUID at index " + n3);
                return 0;
            }
            stringBuilder.append(" WHEN ? THEN " + n3);
        }
        stringBuilder.append(" END WHERE guid IN (");
        n3 = 1;
        while (n3++ < n5) {
            stringBuilder.append("?, ");
        }
        stringBuilder.append("?)");
        sQLiteDatabase.execSQL(stringBuilder.toString(), objectArray);
        return n5;
    }

    int updateBookmarkParents(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        BrowserProvider.trace("Updating bookmark parents of " + string2 + " (" + stringArray[0] + ")");
        String string3 = "_id IN ( SELECT DISTINCT parent FROM bookmarks WHERE " + string2 + " )";
        return this.getWritableDatabase(uri).update(TABLE_BOOKMARKS, contentValues, string3, stringArray);
    }

    long insertBookmark(Uri uri, ContentValues contentValues) {
        long l = System.currentTimeMillis();
        if (!contentValues.containsKey("created")) {
            contentValues.put("created", Long.valueOf(l));
        }
        if (!contentValues.containsKey("modified")) {
            contentValues.put("modified", Long.valueOf(l));
        }
        if (!contentValues.containsKey("guid")) {
            contentValues.put("guid", Utils.generateGuid());
        }
        if (!contentValues.containsKey("position")) {
            BrowserProvider.debug("Inserting bookmark with no position for URI");
            contentValues.put("position", Long.toString(Long.MIN_VALUE));
        }
        String string2 = contentValues.getAsString("url");
        Integer n = contentValues.getAsInteger("type");
        BrowserProvider.debug("Inserting bookmark in database with URL: " + string2);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        return sQLiteDatabase.insertOrThrow(TABLE_BOOKMARKS, "title", contentValues);
    }

    int updateOrInsertBookmark(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        int n = this.updateBookmarks(uri, contentValues, string2, stringArray);
        if (n > 0) {
            return n;
        }
        if (0L <= this.insertBookmark(uri, contentValues)) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int updateBookmarks(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        BrowserProvider.trace("Updating bookmarks on URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        int n = 0;
        String[] stringArray2 = new String[]{"_id", "url"};
        BrowserProvider.trace("Quering bookmarks to update on URI: " + uri);
        Cursor cursor = sQLiteDatabase.query(TABLE_BOOKMARKS, stringArray2, string2, stringArray, null, null, null);
        try {
            if (!contentValues.containsKey("modified")) {
                contentValues.put("modified", Long.valueOf(System.currentTimeMillis()));
            }
            boolean bl = contentValues.containsKey("url");
            String string3 = null;
            if (bl) {
                string3 = contentValues.getAsString("url");
            }
            while (cursor.moveToNext()) {
                long l = cursor.getLong(0);
                BrowserProvider.trace("Updating bookmark with ID: " + l);
                n += sQLiteDatabase.update(TABLE_BOOKMARKS, contentValues, "_id = ?", new String[]{Long.toString(l)});
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return n;
    }

    long insertHistory(Uri uri, ContentValues contentValues) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        long l = System.currentTimeMillis();
        contentValues.put("created", Long.valueOf(l));
        contentValues.put("modified", Long.valueOf(l));
        if (!contentValues.containsKey("guid")) {
            contentValues.put("guid", Utils.generateGuid());
        }
        String string2 = contentValues.getAsString("url");
        BrowserProvider.debug("Inserting history in database with URL: " + string2);
        return sQLiteDatabase.insertOrThrow(TABLE_HISTORY, "visits", contentValues);
    }

    int updateOrInsertHistory(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        int n = this.updateHistory(uri, contentValues, string2, stringArray);
        if (n > 0) {
            return n;
        }
        if (!contentValues.containsKey("visits")) {
            contentValues.put("visits", Integer.valueOf(1));
        }
        if (!contentValues.containsKey("title")) {
            contentValues.put("title", contentValues.getAsString("url"));
        }
        if (0L <= this.insertHistory(uri, contentValues)) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int updateHistory(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        BrowserProvider.trace("Updating history on URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        int n = 0;
        String[] stringArray2 = new String[]{"_id", "url", "visits"};
        Cursor cursor = sQLiteDatabase.query(TABLE_HISTORY, stringArray2, string2, stringArray, null, null, null);
        try {
            if (!contentValues.containsKey("modified")) {
                contentValues.put("modified", Long.valueOf(System.currentTimeMillis()));
            }
            boolean bl = contentValues.containsKey("url");
            String string3 = null;
            if (bl) {
                string3 = contentValues.getAsString("url");
            }
            while (cursor.moveToNext()) {
                long l = cursor.getLong(0);
                BrowserProvider.trace("Updating history entry with ID: " + l);
                if (this.shouldIncrementVisits(uri)) {
                    long l2 = cursor.getLong(2);
                    Long l3 = contentValues.getAsLong("visits");
                    contentValues.put("visits", Long.valueOf(l2 + (l3 != null ? l3 : 1L)));
                }
                n += sQLiteDatabase.update(TABLE_HISTORY, contentValues, "_id = ?", new String[]{Long.toString(l)});
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return n;
    }

    private void updateFaviconIdsForUrl(SQLiteDatabase sQLiteDatabase, String string2, Long l) {
        ContentValues contentValues = new ContentValues(1);
        contentValues.put("favicon_id", l);
        sQLiteDatabase.update(TABLE_HISTORY, contentValues, "url = ?", new String[]{string2});
        sQLiteDatabase.update(TABLE_BOOKMARKS, contentValues, "url = ?", new String[]{string2});
    }

    long insertFavicon(Uri uri, ContentValues contentValues) {
        return this.insertFavicon(this.getWritableDatabase(uri), contentValues);
    }

    long insertFavicon(SQLiteDatabase sQLiteDatabase, ContentValues contentValues) {
        String string2 = contentValues.getAsString("url");
        String string3 = null;
        BrowserProvider.trace("Inserting favicon for URL: " + string2);
        this.stripEmptyByteArray(contentValues, "data");
        if (contentValues.containsKey("page_url")) {
            string3 = contentValues.getAsString("page_url");
            contentValues.remove("page_url");
        }
        if (TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string3)) {
            contentValues.put("url", Favicons.guessDefaultFaviconUrl(string3));
        }
        long l = System.currentTimeMillis();
        contentValues.put("created", Long.valueOf(l));
        contentValues.put("modified", Long.valueOf(l));
        long l2 = sQLiteDatabase.insertOrThrow(TABLE_FAVICONS, null, contentValues);
        if (string3 != null) {
            this.updateFaviconIdsForUrl(sQLiteDatabase, string3, l2);
        }
        return l2;
    }

    int updateOrInsertFavicon(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        return this.updateFavicon(uri, contentValues, string2, stringArray, true);
    }

    int updateExistingFavicon(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        return this.updateFavicon(uri, contentValues, string2, stringArray, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    int updateFavicon(Uri var1_1, ContentValues var2_2, String var3_3, String[] var4_4, boolean var5_5) {
        var6_6 = var2_2.getAsString("url");
        var7_7 = null;
        var8_8 = 0;
        var9_9 = this.getWritableDatabase(var1_1);
        var10_10 = null;
        var11_11 = null;
        var12_12 = System.currentTimeMillis();
        BrowserProvider.trace("Updating favicon for URL: " + var6_6);
        this.stripEmptyByteArray(var2_2, "data");
        if (var2_2.containsKey("page_url")) {
            var7_7 = var2_2.getAsString("page_url");
            var2_2.remove("page_url");
        }
        var2_2.put("modified", Long.valueOf(var12_12));
        if (!var5_5 || var6_6 != null) {
            var8_8 = var9_9.update("favicons", var2_2, var3_3, var4_4);
        }
        if (var8_8 > 0) {
            if (var6_6 != null && var7_7 != null) {
                try {
                    var10_10 = var9_9.query("favicons", new String[]{"_id"}, "url = ?", new String[]{var6_6}, null, null, null);
                    if (!var10_10.moveToFirst()) ** GOTO lbl33
                    var11_11 = var10_10.getLong(var10_10.getColumnIndexOrThrow("_id"));
                }
                finally {
                    if (var10_10 != null) {
                        var10_10.close();
                    }
                }
            }
        } else if (var5_5) {
            var2_2.put("created", Long.valueOf(var12_12));
            BrowserProvider.trace("No update, inserting favicon for URL: " + var6_6);
            var11_11 = var9_9.insert("favicons", null, var2_2);
            var8_8 = 1;
        }
lbl33:
        // 6 sources

        if (var7_7 != null) {
            this.updateFaviconIdsForUrl(var9_9, var7_7, var11_11);
        }
        return var8_8;
    }

    long insertThumbnail(Uri uri, ContentValues contentValues) {
        String string2 = contentValues.getAsString("url");
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        BrowserProvider.trace("Inserting thumbnail for URL: " + string2);
        this.stripEmptyByteArray(contentValues, "data");
        return sQLiteDatabase.insertOrThrow(TABLE_THUMBNAILS, null, contentValues);
    }

    int updateOrInsertThumbnail(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        return this.updateThumbnail(uri, contentValues, string2, stringArray, true);
    }

    int updateExistingThumbnail(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        return this.updateThumbnail(uri, contentValues, string2, stringArray, false);
    }

    int updateThumbnail(Uri uri, ContentValues contentValues, String string2, String[] stringArray, boolean bl) {
        String string3 = contentValues.getAsString("url");
        int n = 0;
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        this.stripEmptyByteArray(contentValues, "data");
        BrowserProvider.trace("Updating thumbnail for URL: " + string3);
        n = sQLiteDatabase.update(TABLE_THUMBNAILS, contentValues, string2, stringArray);
        if (n == 0 && bl) {
            BrowserProvider.trace("No update, inserting thumbnail for URL: " + string3);
            sQLiteDatabase.insert(TABLE_THUMBNAILS, null, contentValues);
            n = 1;
        }
        return n;
    }

    private void stripEmptyByteArray(ContentValues contentValues, String string2) {
        byte[] byArray;
        if (contentValues.containsKey(string2) && ((byArray = contentValues.getAsByteArray(string2)) == null || byArray.length == 0)) {
            Log.w((String)LOGTAG, (String)"Tried to insert an empty or non-byte-array image. Ignoring.");
            contentValues.putNull(string2);
        }
    }

    int deleteHistory(Uri uri, String string2, String[] stringArray) {
        BrowserProvider.debug("Deleting history entry for URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        if (this.isCallerSync(uri)) {
            return sQLiteDatabase.delete(TABLE_HISTORY, string2, stringArray);
        }
        BrowserProvider.debug("Marking history entry as deleted for URI: " + uri);
        ContentValues contentValues = new ContentValues();
        contentValues.put("deleted", Integer.valueOf(1));
        contentValues.putNull("title");
        contentValues.put("url", "");
        contentValues.put("created", Integer.valueOf(0));
        contentValues.put("date", Integer.valueOf(0));
        contentValues.put("visits", Integer.valueOf(0));
        contentValues.put("modified", Long.valueOf(System.currentTimeMillis()));
        this.cleanupSomeDeletedRecords(uri, BrowserContract.History.CONTENT_URI, TABLE_HISTORY);
        return sQLiteDatabase.update(TABLE_HISTORY, contentValues, string2, stringArray);
    }

    int deleteBookmarks(Uri uri, String string2, String[] stringArray) {
        BrowserProvider.debug("Deleting bookmarks for URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        if (this.isCallerSync(uri)) {
            return sQLiteDatabase.delete(TABLE_BOOKMARKS, string2, stringArray);
        }
        BrowserProvider.debug("Marking bookmarks as deleted for URI: " + uri);
        ContentValues contentValues = new ContentValues();
        contentValues.put("deleted", Integer.valueOf(1));
        this.cleanupSomeDeletedRecords(uri, BrowserContract.Bookmarks.CONTENT_URI, TABLE_BOOKMARKS);
        return this.updateBookmarks(uri, contentValues, string2, stringArray);
    }

    int deleteFavicons(Uri uri, String string2, String[] stringArray) {
        BrowserProvider.debug("Deleting favicons for URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        return sQLiteDatabase.delete(TABLE_FAVICONS, string2, stringArray);
    }

    int deleteThumbnails(Uri uri, String string2, String[] stringArray) {
        BrowserProvider.debug("Deleting thumbnails for URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        return sQLiteDatabase.delete(TABLE_THUMBNAILS, string2, stringArray);
    }

    int deleteUnusedImages(Uri uri) {
        BrowserProvider.debug("Deleting all unused favicons and thumbnails for URI: " + uri);
        String string2 = "_id NOT IN (SELECT favicon_id FROM history WHERE deleted = 0 AND favicon_id IS NOT NULL UNION ALL SELECT favicon_id FROM bookmarks WHERE deleted = 0 AND favicon_id IS NOT NULL)";
        String string3 = "url NOT IN (SELECT url FROM history WHERE deleted = 0 AND url IS NOT NULL UNION ALL SELECT url FROM bookmarks WHERE deleted = 0 AND url IS NOT NULL)";
        return this.deleteFavicons(uri, string2, null) + this.deleteThumbnails(uri, string3, null);
    }

    public ContentProviderResult[] applyBatch(ArrayList<ContentProviderOperation> arrayList) throws OperationApplicationException {
        int n = arrayList.size();
        ContentProviderResult[] contentProviderResultArray = new ContentProviderResult[n];
        boolean bl = false;
        SQLiteDatabase sQLiteDatabase = null;
        if (n < 1) {
            return contentProviderResultArray;
        }
        sQLiteDatabase = this.getWritableDatabase(arrayList.get(0).getUri());
        sQLiteDatabase.beginTransaction();
        for (int i = 0; i < n; ++i) {
            try {
                contentProviderResultArray[i] = arrayList.get(i).apply((ContentProvider)this, contentProviderResultArray, i);
                continue;
            }
            catch (SQLException sQLException) {
                Log.w((String)LOGTAG, (String)"SQLite Exception during applyBatch: ", (Throwable)sQLException);
                contentProviderResultArray[i] = new ContentProviderResult(0);
                bl = true;
                sQLiteDatabase.setTransactionSuccessful();
                sQLiteDatabase.endTransaction();
                sQLiteDatabase.beginTransaction();
                continue;
            }
            catch (OperationApplicationException operationApplicationException) {
                contentProviderResultArray[i] = new ContentProviderResult(0);
                bl = true;
                sQLiteDatabase.setTransactionSuccessful();
                sQLiteDatabase.endTransaction();
                sQLiteDatabase.beginTransaction();
            }
        }
        BrowserProvider.trace("Flushing DB applyBatch...");
        sQLiteDatabase.setTransactionSuccessful();
        sQLiteDatabase.endTransaction();
        if (bl) {
            throw new OperationApplicationException();
        }
        return contentProviderResultArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int bulkInsert(Uri uri, ContentValues[] contentValuesArray) {
        if (contentValuesArray == null) {
            return 0;
        }
        int n = contentValuesArray.length;
        int n2 = 0;
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        sQLiteDatabase.beginTransaction();
        try {
            for (int i = 0; i < n; ++i) {
                this.insertInTransaction(uri, contentValuesArray[i]);
                ++n2;
            }
            BrowserProvider.trace("Flushing DB bulkinsert...");
            sQLiteDatabase.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
        if (n2 > 0) {
            this.mContext.getContentResolver().notifyChange(uri, null);
        }
        return n2;
    }

    static {
        URI_MATCHER.addURI("org.mozilla.fennec.db.browser", TABLE_BOOKMARKS, 100);
        URI_MATCHER.addURI("org.mozilla.fennec.db.browser", "bookmarks/#", 101);
        URI_MATCHER.addURI("org.mozilla.fennec.db.browser", "bookmarks/parents", 103);
        URI_MATCHER.addURI("org.mozilla.fennec.db.browser", "bookmarks/positions", 104);
        URI_MATCHER.addURI("org.mozilla.fennec.db.browser", "bookmarks/folder/#", 102);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("_id", "_id");
        hashMap.put("title", "title");
        hashMap.put("url", "url");
        hashMap.put("favicon", "favicon");
        hashMap.put("favicon_id", "favicon_id");
        hashMap.put("favicon_url", "favicon_url");
        hashMap.put("type", "type");
        hashMap.put("parent", "parent");
        hashMap.put("position", "position");
        hashMap.put("tags", "tags");
        hashMap.put("description", "description");
        hashMap.put("keyword", "keyword");
        hashMap.put("created", "created");
        hashMap.put("modified", "modified");
        hashMap.put("guid", "guid");
        hashMap.put("deleted", "deleted");
        BOOKMARKS_PROJECTION_MAP = Collections.unmodifiableMap(hashMap);
        URI_MATCHER.addURI("org.mozilla.fennec.db.browser", TABLE_HISTORY, 200);
        URI_MATCHER.addURI("org.mozilla.fennec.db.browser", "history/#", 201);
        URI_MATCHER.addURI("org.mozilla.fennec.db.browser", "history/old", 202);
        hashMap = new HashMap();
        hashMap.put("_id", "_id");
        hashMap.put("title", "title");
        hashMap.put("url", "url");
        hashMap.put("favicon", "favicon");
        hashMap.put("favicon_id", "favicon_id");
        hashMap.put("favicon_url", "favicon_url");
        hashMap.put("visits", "visits");
        hashMap.put("date", "date");
        hashMap.put("created", "created");
        hashMap.put("modified", "modified");
        hashMap.put("guid", "guid");
        hashMap.put("deleted", "deleted");
        HISTORY_PROJECTION_MAP = Collections.unmodifiableMap(hashMap);
        URI_MATCHER.addURI("org.mozilla.fennec.db.browser", TABLE_FAVICONS, 300);
        URI_MATCHER.addURI("org.mozilla.fennec.db.browser", "favicons/#", 301);
        hashMap = new HashMap();
        hashMap.put("_id", "_id");
        hashMap.put("url", "url");
        hashMap.put("data", "data");
        hashMap.put("created", "created");
        hashMap.put("modified", "modified");
        FAVICONS_PROJECTION_MAP = Collections.unmodifiableMap(hashMap);
        URI_MATCHER.addURI("org.mozilla.fennec.db.browser", TABLE_THUMBNAILS, 800);
        URI_MATCHER.addURI("org.mozilla.fennec.db.browser", "thumbnails/#", 801);
        hashMap = new HashMap();
        hashMap.put("_id", "_id");
        hashMap.put("url", "url");
        hashMap.put("data", "data");
        THUMBNAILS_PROJECTION_MAP = Collections.unmodifiableMap(hashMap);
        URI_MATCHER.addURI("org.mozilla.fennec.db.browser", VIEW_COMBINED, 500);
        hashMap = new HashMap();
        hashMap.put("_id", "_id");
        hashMap.put("bookmark_id", "bookmark_id");
        hashMap.put("history_id", "history_id");
        hashMap.put("display", "MAX(display) AS display");
        hashMap.put("url", "url");
        hashMap.put("title", "title");
        hashMap.put("visits", "visits");
        hashMap.put("date", "date");
        hashMap.put("favicon", "favicon");
        hashMap.put("favicon_id", "favicon_id");
        hashMap.put("favicon_url", "favicon_url");
        COMBINED_PROJECTION_MAP = Collections.unmodifiableMap(hashMap);
        URI_MATCHER.addURI("org.mozilla.fennec.db.browser", "schema", 400);
        hashMap = new HashMap();
        hashMap.put("version", "version");
        SCHEMA_PROJECTION_MAP = Collections.unmodifiableMap(hashMap);
        URI_MATCHER.addURI("org.mozilla.fennec.db.browser", "control", 600);
        URI_MATCHER.addURI("org.mozilla.fennec.db.browser", "search_suggest_query/*", 700);
        hashMap = new HashMap();
        hashMap.put("suggest_text_1", "title AS suggest_text_1");
        hashMap.put("suggest_text_2_url", "url AS suggest_text_2_url");
        hashMap.put("suggest_intent_data", "url AS suggest_intent_data");
        SEARCH_SUGGEST_PROJECTION_MAP = Collections.unmodifiableMap(hashMap);
        logDebug = Log.isLoggable((String)LOGTAG, (int)3);
        logVerbose = Log.isLoggable((String)LOGTAG, (int)2);
        mobileIdColumns = new String[]{"_id"};
        mobileIdSelectionArgs = new String[]{"mobile"};
    }

    final class BrowserDatabaseHelper
    extends SQLiteOpenHelper {
        public BrowserDatabaseHelper(Context context, String string2) {
            super(context, string2, null, 17);
        }

        private void createBookmarksTable(SQLiteDatabase sQLiteDatabase) {
            BrowserProvider.debug("Creating bookmarks table");
            String string2 = null;
            if (Build.VERSION.SDK_INT >= 8) {
                string2 = ", FOREIGN KEY (parent) REFERENCES bookmarks(_id)";
            }
            sQLiteDatabase.execSQL("CREATE TABLE bookmarks(_id INTEGER PRIMARY KEY AUTOINCREMENT,title TEXT,url TEXT,type INTEGER NOT NULL DEFAULT 1,parent INTEGER,position INTEGER NOT NULL,keyword TEXT,description TEXT,tags TEXT,created INTEGER,modified INTEGER,guid TEXT NOT NULL,deleted INTEGER NOT NULL DEFAULT 0" + (string2 != null ? string2 : "") + ");");
            sQLiteDatabase.execSQL("CREATE INDEX bookmarks_url_index ON bookmarks(url)");
            sQLiteDatabase.execSQL("CREATE INDEX bookmarks_type_deleted_index ON bookmarks(type, deleted)");
            sQLiteDatabase.execSQL("CREATE UNIQUE INDEX bookmarks_guid_index ON bookmarks(guid)");
            sQLiteDatabase.execSQL("CREATE INDEX bookmarks_modified_index ON bookmarks(modified)");
        }

        private void createBookmarksTableOn13(SQLiteDatabase sQLiteDatabase) {
            BrowserProvider.debug("Creating bookmarks table");
            String string2 = null;
            if (Build.VERSION.SDK_INT >= 8) {
                string2 = ", FOREIGN KEY (parent) REFERENCES bookmarks(_id)";
            }
            sQLiteDatabase.execSQL("CREATE TABLE bookmarks(_id INTEGER PRIMARY KEY AUTOINCREMENT,title TEXT,url TEXT,type INTEGER NOT NULL DEFAULT 1,parent INTEGER,position INTEGER NOT NULL,keyword TEXT,description TEXT,tags TEXT,favicon_id INTEGER,created INTEGER,modified INTEGER,guid TEXT NOT NULL,deleted INTEGER NOT NULL DEFAULT 0" + (string2 != null ? string2 : "") + ");");
            sQLiteDatabase.execSQL("CREATE INDEX bookmarks_url_index ON bookmarks(url)");
            sQLiteDatabase.execSQL("CREATE INDEX bookmarks_type_deleted_index ON bookmarks(type, deleted)");
            sQLiteDatabase.execSQL("CREATE UNIQUE INDEX bookmarks_guid_index ON bookmarks(guid)");
            sQLiteDatabase.execSQL("CREATE INDEX bookmarks_modified_index ON bookmarks(modified)");
        }

        private void createHistoryTable(SQLiteDatabase sQLiteDatabase) {
            BrowserProvider.debug("Creating history table");
            sQLiteDatabase.execSQL("CREATE TABLE history(_id INTEGER PRIMARY KEY AUTOINCREMENT,title TEXT,url TEXT NOT NULL,visits INTEGER NOT NULL DEFAULT 0,date INTEGER,created INTEGER,modified INTEGER,guid TEXT NOT NULL,deleted INTEGER NOT NULL DEFAULT 0);");
            sQLiteDatabase.execSQL("CREATE INDEX history_url_index ON history(url)");
            sQLiteDatabase.execSQL("CREATE UNIQUE INDEX history_guid_index ON history(guid)");
            sQLiteDatabase.execSQL("CREATE INDEX history_modified_index ON history(modified)");
            sQLiteDatabase.execSQL("CREATE INDEX history_visited_index ON history(date)");
        }

        private void createHistoryTableOn13(SQLiteDatabase sQLiteDatabase) {
            BrowserProvider.debug("Creating history table");
            sQLiteDatabase.execSQL("CREATE TABLE history(_id INTEGER PRIMARY KEY AUTOINCREMENT,title TEXT,url TEXT NOT NULL,visits INTEGER NOT NULL DEFAULT 0,favicon_id INTEGER,date INTEGER,created INTEGER,modified INTEGER,guid TEXT NOT NULL,deleted INTEGER NOT NULL DEFAULT 0);");
            sQLiteDatabase.execSQL("CREATE INDEX history_url_index ON history(url)");
            sQLiteDatabase.execSQL("CREATE UNIQUE INDEX history_guid_index ON history(guid)");
            sQLiteDatabase.execSQL("CREATE INDEX history_modified_index ON history(modified)");
            sQLiteDatabase.execSQL("CREATE INDEX history_visited_index ON history(date)");
        }

        private void createImagesTable(SQLiteDatabase sQLiteDatabase) {
            BrowserProvider.debug("Creating images table");
            sQLiteDatabase.execSQL("CREATE TABLE images (_id INTEGER PRIMARY KEY AUTOINCREMENT,url_key TEXT UNIQUE NOT NULL,favicon BLOB,favicon_url TEXT,thumbnail BLOB,created INTEGER,modified INTEGER,guid TEXT NOT NULL,deleted INTEGER NOT NULL DEFAULT 0);");
            sQLiteDatabase.execSQL("CREATE INDEX images_url_index ON images(url_key)");
            sQLiteDatabase.execSQL("CREATE UNIQUE INDEX images_guid_index ON images(guid)");
            sQLiteDatabase.execSQL("CREATE INDEX images_modified_index ON images(modified)");
        }

        private void createFaviconsTable(SQLiteDatabase sQLiteDatabase) {
            BrowserProvider.debug("Creating favicons table");
            sQLiteDatabase.execSQL("CREATE TABLE favicons (_id INTEGER PRIMARY KEY AUTOINCREMENT,url TEXT UNIQUE,data BLOB,created INTEGER,modified INTEGER);");
            sQLiteDatabase.execSQL("CREATE INDEX favicons_url_index ON favicons(url)");
            sQLiteDatabase.execSQL("CREATE INDEX favicons_modified_index ON favicons(modified)");
        }

        private void createThumbnailsTable(SQLiteDatabase sQLiteDatabase) {
            BrowserProvider.debug("Creating thumbnails table");
            sQLiteDatabase.execSQL("CREATE TABLE thumbnails (_id INTEGER PRIMARY KEY AUTOINCREMENT,url TEXT UNIQUE,data BLOB);");
            sQLiteDatabase.execSQL("CREATE INDEX thumbnails_url_index ON thumbnails(url)");
        }

        private void createBookmarksWithImagesView(SQLiteDatabase sQLiteDatabase) {
            BrowserProvider.debug("Creating bookmarks_with_images view");
            sQLiteDatabase.execSQL("CREATE VIEW IF NOT EXISTS bookmarks_with_images AS SELECT " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "*") + ", " + "favicon" + ", " + "thumbnail" + " FROM " + Obsolete.TABLE_BOOKMARKS_JOIN_IMAGES);
        }

        private void createBookmarksWithFaviconsView(SQLiteDatabase sQLiteDatabase) {
            BrowserProvider.debug("Creating bookmarks_with_favicons view");
            sQLiteDatabase.execSQL("CREATE VIEW IF NOT EXISTS bookmarks_with_favicons AS SELECT " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "*") + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_FAVICONS, "data") + " AS " + "favicon" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_FAVICONS, "url") + " AS " + "favicon_url" + " FROM " + TABLE_BOOKMARKS_JOIN_FAVICONS);
        }

        private void createHistoryWithImagesView(SQLiteDatabase sQLiteDatabase) {
            BrowserProvider.debug("Creating history_with_images view");
            sQLiteDatabase.execSQL("CREATE VIEW IF NOT EXISTS history_with_images AS SELECT " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "*") + ", " + "favicon" + ", " + "thumbnail" + " FROM " + Obsolete.TABLE_HISTORY_JOIN_IMAGES);
        }

        private void createHistoryWithFaviconsView(SQLiteDatabase sQLiteDatabase) {
            BrowserProvider.debug("Creating history_with_favicons view");
            sQLiteDatabase.execSQL("CREATE VIEW IF NOT EXISTS history_with_favicons AS SELECT " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "*") + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_FAVICONS, "data") + " AS " + "favicon" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_FAVICONS, "url") + " AS " + "favicon_url" + " FROM " + TABLE_HISTORY_JOIN_FAVICONS);
        }

        private void createCombinedWithImagesView(SQLiteDatabase sQLiteDatabase) {
            BrowserProvider.debug("Creating combined_with_images view");
            sQLiteDatabase.execSQL("CREATE VIEW IF NOT EXISTS combined_with_images AS SELECT bookmark_id, history_id, 0 AS _id, url, title, visits, date, " + BrowserProvider.qualifyColumn("images", "favicon") + " AS " + "favicon" + ", " + BrowserProvider.qualifyColumn("images", "thumbnail") + " AS " + "thumbnail" + " FROM (" + " SELECT " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "_id") + " AS " + "bookmark_id" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "url") + " AS " + "url" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "title") + " AS " + "title" + ", " + "-1 AS " + "history_id" + ", " + "-1 AS " + "visits" + ", " + "-1 AS " + "date" + " FROM " + BrowserProvider.TABLE_BOOKMARKS + " WHERE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "type") + " = " + 1 + " AND " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "deleted") + " = 0 AND " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "url") + " NOT IN (SELECT " + "url" + " FROM " + BrowserProvider.TABLE_HISTORY + ")" + " UNION ALL" + " SELECT " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "_id") + " AS " + "bookmark_id" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "url") + " AS " + "url" + ", " + "COALESCE(" + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "title") + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "title") + ")" + " AS " + "title" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "_id") + " AS " + "history_id" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "visits") + " AS " + "visits" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "date") + " AS " + "date" + " FROM " + BrowserProvider.TABLE_HISTORY + " LEFT OUTER JOIN " + BrowserProvider.TABLE_BOOKMARKS + " ON " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "url") + " = " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "url") + " WHERE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "url") + " IS NOT NULL AND " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "deleted") + " = 0 AND (" + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "type") + " IS NULL OR " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "type") + " = " + 1 + ")" + ") LEFT OUTER JOIN " + "images" + " ON " + "url" + " = " + BrowserProvider.qualifyColumn("images", "url_key"));
        }

        private void createCombinedWithImagesViewOn9(SQLiteDatabase sQLiteDatabase) {
            BrowserProvider.debug("Creating combined_with_images view");
            sQLiteDatabase.execSQL("CREATE VIEW IF NOT EXISTS combined_with_images AS SELECT bookmark_id, history_id, 0 AS _id, url, title, visits, display, date, " + BrowserProvider.qualifyColumn("images", "favicon") + " AS " + "favicon" + ", " + BrowserProvider.qualifyColumn("images", "thumbnail") + " AS " + "thumbnail" + " FROM (" + " SELECT " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "_id") + " AS " + "bookmark_id" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "url") + " AS " + "url" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "title") + " AS " + "title" + ", " + "CASE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "parent") + " WHEN " + -2 + " THEN " + 1 + " ELSE " + 0 + " END AS " + "display" + ", " + "-1 AS " + "history_id" + ", " + "-1 AS " + "visits" + ", " + "-1 AS " + "date" + " FROM " + BrowserProvider.TABLE_BOOKMARKS + " WHERE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "type") + " = " + 1 + " AND " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "deleted") + " = 0 AND " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "url") + " NOT IN (SELECT " + "url" + " FROM " + BrowserProvider.TABLE_HISTORY + ")" + " UNION ALL" + " SELECT " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "_id") + " AS " + "bookmark_id" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "url") + " AS " + "url" + ", " + "COALESCE(" + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "title") + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "title") + ")" + " AS " + "title" + ", " + "CASE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "parent") + " WHEN " + -2 + " THEN " + 1 + " ELSE " + 0 + " END AS " + "display" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "_id") + " AS " + "history_id" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "visits") + " AS " + "visits" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "date") + " AS " + "date" + " FROM " + BrowserProvider.TABLE_HISTORY + " LEFT OUTER JOIN " + BrowserProvider.TABLE_BOOKMARKS + " ON " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "url") + " = " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "url") + " WHERE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "url") + " IS NOT NULL AND " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "deleted") + " = 0 AND (" + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "type") + " IS NULL OR " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "type") + " = " + 1 + ")" + ") LEFT OUTER JOIN " + "images" + " ON " + "url" + " = " + BrowserProvider.qualifyColumn("images", "url_key"));
        }

        private void createCombinedWithImagesViewOn10(SQLiteDatabase sQLiteDatabase) {
            BrowserProvider.debug("Creating combined_with_images view");
            sQLiteDatabase.execSQL("CREATE VIEW IF NOT EXISTS combined_with_images AS SELECT bookmark_id, history_id, 0 AS _id, url, title, visits, display, date, " + BrowserProvider.qualifyColumn("images", "favicon") + " AS " + "favicon" + ", " + BrowserProvider.qualifyColumn("images", "thumbnail") + " AS " + "thumbnail" + " FROM (" + " SELECT " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "_id") + " AS " + "bookmark_id" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "url") + " AS " + "url" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "title") + " AS " + "title" + ", " + "CASE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "parent") + " WHEN " + -2 + " THEN " + 1 + " ELSE " + 0 + " END AS " + "display" + ", " + "-1 AS " + "history_id" + ", " + "-1 AS " + "visits" + ", " + "-1 AS " + "date" + " FROM " + BrowserProvider.TABLE_BOOKMARKS + " WHERE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "type") + " = " + 1 + " AND " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "deleted") + " = 0 AND " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "url") + " NOT IN (SELECT " + "url" + " FROM " + BrowserProvider.TABLE_HISTORY + ")" + " UNION ALL" + " SELECT " + "CASE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "deleted") + " WHEN 0 THEN " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "_id") + " ELSE NULL END AS " + "bookmark_id" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "url") + " AS " + "url" + ", " + "COALESCE(" + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "title") + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "title") + ")" + " AS " + "title" + ", " + "CASE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "parent") + " WHEN " + -2 + " THEN " + 1 + " ELSE " + 0 + " END AS " + "display" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "_id") + " AS " + "history_id" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "visits") + " AS " + "visits" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "date") + " AS " + "date" + " FROM " + BrowserProvider.TABLE_HISTORY + " LEFT OUTER JOIN " + BrowserProvider.TABLE_BOOKMARKS + " ON " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "url") + " = " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "url") + " WHERE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "url") + " IS NOT NULL AND " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "deleted") + " = 0 AND (" + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "type") + " IS NULL OR " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "type") + " = " + 1 + ")" + ") LEFT OUTER JOIN " + "images" + " ON " + "url" + " = " + BrowserProvider.qualifyColumn("images", "url_key"));
        }

        private void createCombinedWithImagesViewOn11(SQLiteDatabase sQLiteDatabase) {
            BrowserProvider.debug("Creating combined_with_images view");
            sQLiteDatabase.execSQL("CREATE VIEW IF NOT EXISTS combined_with_images AS SELECT bookmark_id, history_id, 0 AS _id, url, title, visits, display, date, " + BrowserProvider.qualifyColumn("images", "favicon") + " AS " + "favicon" + ", " + BrowserProvider.qualifyColumn("images", "thumbnail") + " AS " + "thumbnail" + " FROM (" + " SELECT " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "_id") + " AS " + "bookmark_id" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "url") + " AS " + "url" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "title") + " AS " + "title" + ", " + "CASE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "parent") + " WHEN " + -2 + " THEN " + 1 + " ELSE " + 0 + " END AS " + "display" + ", " + "-1 AS " + "history_id" + ", " + "-1 AS " + "visits" + ", " + "-1 AS " + "date" + " FROM " + BrowserProvider.TABLE_BOOKMARKS + " WHERE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "type") + " = " + 1 + " AND " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "deleted") + " = 0 AND " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "url") + " NOT IN (SELECT " + "url" + " FROM " + BrowserProvider.TABLE_HISTORY + ")" + " UNION ALL" + " SELECT " + "CASE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "deleted") + " WHEN 0 THEN " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "_id") + " ELSE NULL END AS " + "bookmark_id" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "url") + " AS " + "url" + ", " + "COALESCE(" + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "title") + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "title") + ")" + " AS " + "title" + ", " + "CASE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "deleted") + " WHEN 0 THEN CASE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "parent") + " WHEN " + -2 + " THEN " + 1 + " ELSE " + 0 + " END ELSE " + 0 + " END AS " + "display" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "_id") + " AS " + "history_id" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "visits") + " AS " + "visits" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "date") + " AS " + "date" + " FROM " + BrowserProvider.TABLE_HISTORY + " LEFT OUTER JOIN " + BrowserProvider.TABLE_BOOKMARKS + " ON " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "url") + " = " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "url") + " WHERE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "url") + " IS NOT NULL AND " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "deleted") + " = 0 AND (" + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "type") + " IS NULL OR " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "type") + " = " + 1 + ") " + ") LEFT OUTER JOIN " + "images" + " ON " + "url" + " = " + BrowserProvider.qualifyColumn("images", "url_key"));
        }

        private void createCombinedViewOn12(SQLiteDatabase sQLiteDatabase) {
            BrowserProvider.debug("Creating combined view");
            sQLiteDatabase.execSQL("CREATE VIEW IF NOT EXISTS combined AS SELECT bookmark_id, history_id, 0 AS _id, url, title, visits, display, date FROM ( SELECT " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "_id") + " AS " + "bookmark_id" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "url") + " AS " + "url" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "title") + " AS " + "title" + ", " + "CASE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "parent") + " WHEN " + -2 + " THEN " + 1 + " ELSE " + 0 + " END AS " + "display" + ", " + "-1 AS " + "history_id" + ", " + "-1 AS " + "visits" + ", " + "-1 AS " + "date" + " FROM " + BrowserProvider.TABLE_BOOKMARKS + " WHERE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "type") + " = " + 1 + " AND " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "deleted") + " = 0 AND " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "url") + " NOT IN (SELECT " + "url" + " FROM " + BrowserProvider.TABLE_HISTORY + ")" + " UNION ALL" + " SELECT " + "CASE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "deleted") + " WHEN 0 THEN " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "_id") + " ELSE NULL END AS " + "bookmark_id" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "url") + " AS " + "url" + ", " + "COALESCE(" + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "title") + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "title") + ")" + " AS " + "title" + ", " + "CASE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "deleted") + " WHEN 0 THEN CASE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "parent") + " WHEN " + -2 + " THEN " + 1 + " ELSE " + 0 + " END ELSE " + 0 + " END AS " + "display" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "_id") + " AS " + "history_id" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "visits") + " AS " + "visits" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "date") + " AS " + "date" + " FROM " + BrowserProvider.TABLE_HISTORY + " LEFT OUTER JOIN " + BrowserProvider.TABLE_BOOKMARKS + " ON " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "url") + " = " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "url") + " WHERE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "url") + " IS NOT NULL AND " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "deleted") + " = 0 AND (" + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "type") + " IS NULL OR " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "type") + " = " + 1 + ") " + ")");
            BrowserProvider.debug("Creating combined_with_images view");
            sQLiteDatabase.execSQL("CREATE VIEW IF NOT EXISTS combined_with_images AS SELECT *, " + BrowserProvider.qualifyColumn("images", "favicon") + " AS " + "favicon" + ", " + BrowserProvider.qualifyColumn("images", "thumbnail") + " AS " + "thumbnail" + " FROM " + BrowserProvider.VIEW_COMBINED + " LEFT OUTER JOIN " + "images" + " ON " + "url" + " = " + BrowserProvider.qualifyColumn("images", "url_key"));
        }

        private void createCombinedViewOn13(SQLiteDatabase sQLiteDatabase) {
            BrowserProvider.debug("Creating combined view");
            sQLiteDatabase.execSQL("CREATE VIEW IF NOT EXISTS combined AS SELECT bookmark_id, history_id, 0 AS _id, url, title, visits, display, date, favicon_id FROM ( SELECT " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "_id") + " AS " + "bookmark_id" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "url") + " AS " + "url" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "title") + " AS " + "title" + ", " + "CASE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "parent") + " WHEN " + -2 + " THEN " + 1 + " ELSE " + 0 + " END AS " + "display" + ", " + "-1 AS " + "history_id" + ", " + "-1 AS " + "visits" + ", " + "-1 AS " + "date" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "favicon_id") + " AS " + "favicon_id" + " FROM " + BrowserProvider.TABLE_BOOKMARKS + " WHERE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "type") + " = " + 1 + " AND " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "deleted") + " = 0 AND " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "url") + " NOT IN (SELECT " + "url" + " FROM " + BrowserProvider.TABLE_HISTORY + ")" + " UNION ALL" + " SELECT " + "CASE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "deleted") + " WHEN 0 THEN " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "_id") + " ELSE NULL END AS " + "bookmark_id" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "url") + " AS " + "url" + ", " + "COALESCE(" + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "title") + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "title") + ")" + " AS " + "title" + ", " + "CASE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "deleted") + " WHEN 0 THEN CASE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "parent") + " WHEN " + -2 + " THEN " + 1 + " ELSE " + 0 + " END ELSE " + 0 + " END AS " + "display" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "_id") + " AS " + "history_id" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "visits") + " AS " + "visits" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "date") + " AS " + "date" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "favicon_id") + " AS " + "favicon_id" + " FROM " + BrowserProvider.TABLE_HISTORY + " LEFT OUTER JOIN " + BrowserProvider.TABLE_BOOKMARKS + " ON " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "url") + " = " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "url") + " WHERE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "url") + " IS NOT NULL AND " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "deleted") + " = 0 AND (" + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "type") + " IS NULL OR " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "type") + " = " + 1 + ") " + ")");
            BrowserProvider.debug("Creating combined_with_favicons view");
            sQLiteDatabase.execSQL("CREATE VIEW IF NOT EXISTS combined_with_favicons AS SELECT " + BrowserProvider.qualifyColumn(BrowserProvider.VIEW_COMBINED, "*") + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_FAVICONS, "url") + " AS " + "favicon_url" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_FAVICONS, "data") + " AS " + "favicon" + " FROM " + BrowserProvider.VIEW_COMBINED + " LEFT OUTER JOIN " + BrowserProvider.TABLE_FAVICONS + " ON " + "favicon_id" + " = " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_FAVICONS, "_id"));
        }

        private void createCombinedViewOn16(SQLiteDatabase sQLiteDatabase) {
            BrowserProvider.debug("Creating combined view");
            sQLiteDatabase.execSQL("CREATE VIEW IF NOT EXISTS combined AS SELECT bookmark_id, history_id, 0 AS _id, url, title, visits, display, date, favicon_id FROM ( SELECT " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "_id") + " AS " + "bookmark_id" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "url") + " AS " + "url" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "title") + " AS " + "title" + ", " + "CASE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "parent") + " WHEN " + -2 + " THEN " + 1 + " ELSE " + 0 + " END AS " + "display" + ", " + "-1 AS " + "history_id" + ", " + "-1 AS " + "visits" + ", " + "-1 AS " + "date" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "favicon_id") + " AS " + "favicon_id" + " FROM " + BrowserProvider.TABLE_BOOKMARKS + " WHERE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "type") + " = " + 1 + " AND " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "parent") + " <> " + -3 + " AND " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "deleted") + " = 0 AND " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "url") + " NOT IN (SELECT " + "url" + " FROM " + BrowserProvider.TABLE_HISTORY + ")" + " UNION ALL" + " SELECT " + "CASE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "deleted") + " WHEN 0 THEN " + "CASE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "parent") + " WHEN " + -3 + " THEN NULL ELSE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "_id") + " END " + "ELSE NULL END AS " + "bookmark_id" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "url") + " AS " + "url" + ", " + "COALESCE(" + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "title") + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "title") + ")" + " AS " + "title" + ", " + "CASE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "deleted") + " WHEN 0 THEN CASE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "parent") + " WHEN " + -2 + " THEN " + 1 + " ELSE " + 0 + " END ELSE " + 0 + " END AS " + "display" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "_id") + " AS " + "history_id" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "visits") + " AS " + "visits" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "date") + " AS " + "date" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "favicon_id") + " AS " + "favicon_id" + " FROM " + BrowserProvider.TABLE_HISTORY + " LEFT OUTER JOIN " + BrowserProvider.TABLE_BOOKMARKS + " ON " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "url") + " = " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "url") + " WHERE " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "url") + " IS NOT NULL AND " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "deleted") + " = 0 AND (" + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "type") + " IS NULL OR " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_BOOKMARKS, "type") + " = " + 1 + ") " + ")");
            BrowserProvider.debug("Creating combined_with_favicons view");
            sQLiteDatabase.execSQL("CREATE VIEW IF NOT EXISTS combined_with_favicons AS SELECT " + BrowserProvider.qualifyColumn(BrowserProvider.VIEW_COMBINED, "*") + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_FAVICONS, "url") + " AS " + "favicon_url" + ", " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_FAVICONS, "data") + " AS " + "favicon" + " FROM " + BrowserProvider.VIEW_COMBINED + " LEFT OUTER JOIN " + BrowserProvider.TABLE_FAVICONS + " ON " + "favicon_id" + " = " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_FAVICONS, "_id"));
        }

        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            BrowserProvider.debug("Creating browser.db: " + sQLiteDatabase.getPath());
            this.createBookmarksTableOn13(sQLiteDatabase);
            this.createHistoryTableOn13(sQLiteDatabase);
            this.createFaviconsTable(sQLiteDatabase);
            this.createThumbnailsTable(sQLiteDatabase);
            this.createBookmarksWithFaviconsView(sQLiteDatabase);
            this.createHistoryWithFaviconsView(sQLiteDatabase);
            this.createCombinedViewOn16(sQLiteDatabase);
            this.createOrUpdateSpecialFolder(sQLiteDatabase, "places", R.string.bookmarks_folder_places, 0);
            this.createOrUpdateAllSpecialFolders(sQLiteDatabase);
            int n = this.createDistributionBookmarks(sQLiteDatabase);
            this.createDefaultBookmarks(sQLiteDatabase, n);
        }

        private String getLocalizedProperty(JSONObject jSONObject, String string2, Locale locale) throws JSONException {
            String string3;
            String string4 = string2 + "." + locale.toString();
            if (jSONObject.has(string4)) {
                return jSONObject.getString(string4);
            }
            if (!TextUtils.isEmpty((CharSequence)locale.getVariant()) && jSONObject.has(string3 = string4.substring(0, string4.lastIndexOf("_")))) {
                return jSONObject.getString(string3);
            }
            string3 = string2 + "." + locale.getLanguage();
            if (jSONObject.has(string3)) {
                return jSONObject.getString(string3);
            }
            return jSONObject.getString(string2);
        }

        private int createDistributionBookmarks(SQLiteDatabase sQLiteDatabase) {
            JSONArray jSONArray = Distribution.getBookmarks(BrowserProvider.this.mContext);
            if (jSONArray == null) {
                return 0;
            }
            Locale locale = Locale.getDefault();
            int n = 0;
            Integer n2 = BrowserProvider.this.getMobileFolderId(sQLiteDatabase);
            if (n2 == null) {
                Log.e((String)BrowserProvider.LOGTAG, (String)"Error creating distribution bookmarks: mobileFolderId is null");
                return 0;
            }
            for (int i = 0; i < jSONArray.length(); ++i) {
                try {
                    final JSONObject jSONObject = jSONArray.getJSONObject(i);
                    String string2 = this.getLocalizedProperty(jSONObject, "title", locale);
                    final String string3 = this.getLocalizedProperty(jSONObject, "url", locale);
                    this.createBookmark(sQLiteDatabase, string2, string3, n, n2);
                    if (jSONObject.has("pinned")) {
                        try {
                            if (jSONObject.getBoolean("pinned")) {
                                this.createBookmark(sQLiteDatabase, string2, string3, n, -3);
                            }
                        }
                        catch (JSONException jSONException) {
                            Log.e((String)BrowserProvider.LOGTAG, (String)"Error pinning bookmark to top sites", (Throwable)jSONException);
                        }
                    }
                    ++n;
                    if (!jSONObject.has("icon")) continue;
                    ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                        public void run() {
                            SQLiteDatabase sQLiteDatabase = BrowserDatabaseHelper.this.getWritableDatabase();
                            try {
                                String string2 = jSONObject.getString("icon");
                                Bitmap bitmap = BitmapUtils.getBitmapFromDataURI(string2);
                                if (bitmap != null) {
                                    BrowserDatabaseHelper.this.createFavicon(sQLiteDatabase, string3, bitmap);
                                }
                            }
                            catch (JSONException jSONException) {
                                Log.e((String)BrowserProvider.LOGTAG, (String)"Error creating distribution bookmark icon", (Throwable)jSONException);
                            }
                        }
                    });
                    continue;
                }
                catch (JSONException jSONException) {
                    Log.e((String)BrowserProvider.LOGTAG, (String)"Error creating distribution bookmark", (Throwable)jSONException);
                }
            }
            return n;
        }

        private void createDefaultBookmarks(SQLiteDatabase sQLiteDatabase, int n) {
            Class<R.string> clazz = R.string.class;
            Field[] fieldArray = clazz.getFields();
            Pattern pattern = Pattern.compile("^bookmarkdefaults_title_");
            Integer n2 = BrowserProvider.this.getMobileFolderId(sQLiteDatabase);
            if (n2 == null) {
                Log.e((String)BrowserProvider.LOGTAG, (String)"Error creating default bookmarks: mobileFolderId is null");
                return;
            }
            for (int i = 0; i < fieldArray.length; ++i) {
                final String string2 = fieldArray[i].getName();
                Matcher matcher = pattern.matcher(string2);
                if (!matcher.find()) continue;
                try {
                    int n3 = fieldArray[i].getInt(null);
                    String string3 = BrowserProvider.this.mContext.getString(n3);
                    Field field = clazz.getField(string2.replace("_title_", "_url_"));
                    int n4 = field.getInt(null);
                    final String string4 = BrowserProvider.this.mContext.getString(n4);
                    this.createBookmark(sQLiteDatabase, string3, string4, n, n2);
                    ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                        public void run() {
                            SQLiteDatabase sQLiteDatabase = BrowserDatabaseHelper.this.getWritableDatabase();
                            Bitmap bitmap = BrowserDatabaseHelper.this.getDefaultFaviconFromPath(string2);
                            if (bitmap == null) {
                                bitmap = BrowserDatabaseHelper.this.getDefaultFaviconFromDrawable(string2);
                            }
                            if (bitmap != null) {
                                BrowserDatabaseHelper.this.createFavicon(sQLiteDatabase, string4, bitmap);
                            }
                        }
                    });
                    ++n;
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    Log.e((String)BrowserProvider.LOGTAG, (String)("Can't create bookmark " + string2), (Throwable)illegalAccessException);
                    continue;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    Log.e((String)BrowserProvider.LOGTAG, (String)("Can't create bookmark " + string2), (Throwable)noSuchFieldException);
                }
            }
        }

        private void createBookmark(SQLiteDatabase sQLiteDatabase, String string2, String string3, int n, int n2) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("parent", Integer.valueOf(n2));
            long l = System.currentTimeMillis();
            contentValues.put("created", Long.valueOf(l));
            contentValues.put("modified", Long.valueOf(l));
            contentValues.put("title", string2);
            contentValues.put("url", string3);
            contentValues.put("guid", Utils.generateGuid());
            contentValues.put("position", Integer.valueOf(n));
            sQLiteDatabase.insertOrThrow(BrowserProvider.TABLE_BOOKMARKS, "title", contentValues);
        }

        private void createFavicon(SQLiteDatabase sQLiteDatabase, String string2, Bitmap bitmap) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ContentValues contentValues = new ContentValues();
            contentValues.put("page_url", string2);
            byte[] byArray = null;
            if (bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream)) {
                byArray = byteArrayOutputStream.toByteArray();
            } else {
                Log.w((String)BrowserProvider.LOGTAG, (String)"Favicon compression failed.");
            }
            contentValues.put("data", byArray);
            BrowserProvider.this.insertFavicon(sQLiteDatabase, contentValues);
        }

        private Bitmap getDefaultFaviconFromPath(String string2) {
            Class<R.string> clazz = R.string.class;
            try {
                Field field = clazz.getField(string2.replace("_title_", "_favicon_"));
                if (field == null) {
                    return null;
                }
                int n = field.getInt(null);
                String string3 = BrowserProvider.this.mContext.getString(n);
                String string4 = BrowserProvider.this.mContext.getPackageResourcePath();
                File file = new File(string4);
                String string5 = "jar:jar:" + file.toURI() + "!/" + "assets/omni.ja" + "!/" + string3;
                return GeckoJarReader.getBitmap((Resources)BrowserProvider.this.mContext.getResources(), (String)string5);
            }
            catch (IllegalAccessException illegalAccessException) {
                Log.e((String)BrowserProvider.LOGTAG, (String)("[Path] Can't create favicon " + string2), (Throwable)illegalAccessException);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            return null;
        }

        private Bitmap getDefaultFaviconFromDrawable(String string2) {
            Class<R.drawable> clazz = R.drawable.class;
            try {
                Field field = clazz.getField(string2.replace("_title_", "_favicon_"));
                if (field == null) {
                    return null;
                }
                int n = field.getInt(null);
                return BitmapUtils.decodeResource(BrowserProvider.this.mContext, n);
            }
            catch (IllegalAccessException illegalAccessException) {
                Log.e((String)BrowserProvider.LOGTAG, (String)("[Drawable] Can't create favicon " + string2), (Throwable)illegalAccessException);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            return null;
        }

        private void createOrUpdateAllSpecialFolders(SQLiteDatabase sQLiteDatabase) {
            this.createOrUpdateSpecialFolder(sQLiteDatabase, "mobile", R.string.bookmarks_folder_mobile, 0);
            this.createOrUpdateSpecialFolder(sQLiteDatabase, "toolbar", R.string.bookmarks_folder_toolbar, 1);
            this.createOrUpdateSpecialFolder(sQLiteDatabase, "menu", R.string.bookmarks_folder_menu, 2);
            this.createOrUpdateSpecialFolder(sQLiteDatabase, "tags", R.string.bookmarks_folder_tags, 3);
            this.createOrUpdateSpecialFolder(sQLiteDatabase, "unfiled", R.string.bookmarks_folder_unfiled, 4);
            this.createOrUpdateSpecialFolder(sQLiteDatabase, "readinglist", R.string.bookmarks_folder_reading_list, 5);
            this.createOrUpdateSpecialFolder(sQLiteDatabase, "pinned", R.string.bookmarks_folder_pinned, 6);
        }

        private void createOrUpdateSpecialFolder(SQLiteDatabase sQLiteDatabase, String string2, int n, int n2) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("guid", string2);
            contentValues.put("type", Integer.valueOf(0));
            contentValues.put("position", Integer.valueOf(n2));
            if (string2.equals("places")) {
                contentValues.put("_id", Integer.valueOf(0));
            } else if (string2.equals("readinglist")) {
                contentValues.put("_id", Integer.valueOf(-2));
            } else if (string2.equals("pinned")) {
                contentValues.put("_id", Integer.valueOf(-3));
            }
            contentValues.put("parent", Integer.valueOf(0));
            String string3 = BrowserProvider.this.mContext.getResources().getString(n);
            contentValues.put("title", string3);
            long l = System.currentTimeMillis();
            contentValues.put("created", Long.valueOf(l));
            contentValues.put("modified", Long.valueOf(l));
            int n3 = sQLiteDatabase.update(BrowserProvider.TABLE_BOOKMARKS, contentValues, "guid = ?", new String[]{string2});
            if (n3 == 0) {
                sQLiteDatabase.insert(BrowserProvider.TABLE_BOOKMARKS, "guid", contentValues);
                BrowserProvider.debug("Inserted special folder: " + string2);
            } else {
                BrowserProvider.debug("Updated special folder: " + string2);
            }
        }

        private boolean isSpecialFolder(ContentValues contentValues) {
            String string2 = contentValues.getAsString("guid");
            if (string2 == null) {
                return false;
            }
            return string2.equals("mobile") || string2.equals("menu") || string2.equals("toolbar") || string2.equals("unfiled") || string2.equals("tags");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void migrateBookmarkFolder(SQLiteDatabase sQLiteDatabase, int n, BookmarkMigrator bookmarkMigrator) {
            boolean bl;
            Cursor cursor = null;
            BrowserProvider.debug("Migrating bookmark folder with id = " + n);
            String string2 = "parent = " + n;
            String[] stringArray = null;
            boolean bl2 = bl = n == 0;
            if (bl) {
                string2 = "guid != ? AND (" + string2 + " OR " + "parent" + " = NULL)";
                stringArray = new String[]{"places"};
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<ContentValues> arrayList2 = new ArrayList<ContentValues>();
            try {
                cursor = sQLiteDatabase.query(BrowserProvider.TABLE_BOOKMARKS_TMP, null, string2, stringArray, null, null, null);
                while (cursor.moveToNext()) {
                    ContentValues contentValues = new ContentValues();
                    DatabaseUtils.cursorRowToContentValues((Cursor)cursor, (ContentValues)contentValues);
                    boolean bl3 = this.isSpecialFolder(contentValues);
                    if (contentValues.getAsLong("parent") == null && bl3) {
                        contentValues.put("parent", Integer.valueOf(0));
                    }
                    if (bl && !bl3) {
                        arrayList2.add(contentValues);
                        continue;
                    }
                    if (bookmarkMigrator != null) {
                        bookmarkMigrator.updateForNewTable(contentValues);
                    }
                    BrowserProvider.debug("Migrating bookmark: " + contentValues.getAsString("title"));
                    sQLiteDatabase.insert(BrowserProvider.TABLE_BOOKMARKS, "url", contentValues);
                    Integer n2 = contentValues.getAsInteger("type");
                    if (n2 == null || n2 != 0) continue;
                    arrayList.add(contentValues.getAsInteger("_id"));
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            int n3 = arrayList2.size();
            if (n3 > 0) {
                Integer n4 = BrowserProvider.this.getMobileFolderId(sQLiteDatabase);
                if (n4 == null) {
                    Log.e((String)BrowserProvider.LOGTAG, (String)"Error migrating invalid special folder entries: mobile folder id is null");
                    return;
                }
                BrowserProvider.debug("Found " + n3 + " invalid special folder entries");
                for (int i = 0; i < n3; ++i) {
                    ContentValues contentValues = (ContentValues)arrayList2.get(i);
                    contentValues.put("parent", n4);
                    sQLiteDatabase.insert(BrowserProvider.TABLE_BOOKMARKS, "url", contentValues);
                }
            }
            int n5 = arrayList.size();
            for (int i = 0; i < n5; ++i) {
                int n6 = (Integer)arrayList.get(i);
                this.migrateBookmarkFolder(sQLiteDatabase, n6, bookmarkMigrator);
            }
        }

        private void migrateBookmarksTable(SQLiteDatabase sQLiteDatabase) {
            this.migrateBookmarksTable(sQLiteDatabase, null);
        }

        private void migrateBookmarksTable(SQLiteDatabase sQLiteDatabase, BookmarkMigrator bookmarkMigrator) {
            BrowserProvider.debug("Renaming bookmarks table to bookmarks_tmp");
            sQLiteDatabase.execSQL("ALTER TABLE bookmarks RENAME TO bookmarks_tmp");
            BrowserProvider.debug("Dropping views and indexes related to bookmarks");
            sQLiteDatabase.execSQL("DROP VIEW IF EXISTS bookmarks_with_images");
            sQLiteDatabase.execSQL("DROP INDEX IF EXISTS bookmarks_url_index");
            sQLiteDatabase.execSQL("DROP INDEX IF EXISTS bookmarks_guid_index");
            sQLiteDatabase.execSQL("DROP INDEX IF EXISTS bookmarks_modified_index");
            this.createBookmarksTable(sQLiteDatabase);
            this.createBookmarksWithImagesView(sQLiteDatabase);
            this.createOrUpdateSpecialFolder(sQLiteDatabase, "places", R.string.bookmarks_folder_places, 0);
            this.migrateBookmarkFolder(sQLiteDatabase, 0, bookmarkMigrator);
            this.createOrUpdateAllSpecialFolders(sQLiteDatabase);
            BrowserProvider.debug("Dropping bookmarks temporary table");
            sQLiteDatabase.execSQL("DROP TABLE IF EXISTS bookmarks_tmp");
        }

        private void migrateHistoryTable(SQLiteDatabase sQLiteDatabase) {
            BrowserProvider.debug("Renaming history table to history_tmp");
            sQLiteDatabase.execSQL("ALTER TABLE history RENAME TO history_tmp");
            BrowserProvider.debug("Dropping views and indexes related to history");
            sQLiteDatabase.execSQL("DROP VIEW IF EXISTS history_with_images");
            sQLiteDatabase.execSQL("DROP VIEW IF EXISTS combined_with_images");
            sQLiteDatabase.execSQL("DROP INDEX IF EXISTS history_url_index");
            sQLiteDatabase.execSQL("DROP INDEX IF EXISTS history_guid_index");
            sQLiteDatabase.execSQL("DROP INDEX IF EXISTS history_modified_index");
            sQLiteDatabase.execSQL("DROP INDEX IF EXISTS history_visited_index");
            this.createHistoryTable(sQLiteDatabase);
            this.createHistoryWithImagesView(sQLiteDatabase);
            this.createCombinedWithImagesView(sQLiteDatabase);
            sQLiteDatabase.execSQL("INSERT INTO history SELECT * FROM history_tmp");
            BrowserProvider.debug("Dropping history temporary table");
            sQLiteDatabase.execSQL("DROP TABLE IF EXISTS history_tmp");
        }

        private void migrateImagesTable(SQLiteDatabase sQLiteDatabase) {
            BrowserProvider.debug("Renaming images table to images_tmp");
            sQLiteDatabase.execSQL("ALTER TABLE images RENAME TO images_tmp");
            BrowserProvider.debug("Dropping views and indexes related to images");
            sQLiteDatabase.execSQL("DROP VIEW IF EXISTS history_with_images");
            sQLiteDatabase.execSQL("DROP VIEW IF EXISTS combined_with_images");
            sQLiteDatabase.execSQL("DROP INDEX IF EXISTS images_url_index");
            sQLiteDatabase.execSQL("DROP INDEX IF EXISTS images_guid_index");
            sQLiteDatabase.execSQL("DROP INDEX IF EXISTS images_modified_index");
            this.createImagesTable(sQLiteDatabase);
            this.createHistoryWithImagesView(sQLiteDatabase);
            this.createCombinedWithImagesView(sQLiteDatabase);
            sQLiteDatabase.execSQL("INSERT INTO images SELECT * FROM images_tmp");
            BrowserProvider.debug("Dropping images temporary table");
            sQLiteDatabase.execSQL("DROP TABLE IF EXISTS images_tmp");
        }

        private void upgradeDatabaseFrom1to2(SQLiteDatabase sQLiteDatabase) {
            this.migrateBookmarksTable(sQLiteDatabase);
        }

        private void upgradeDatabaseFrom2to3(SQLiteDatabase sQLiteDatabase) {
            BrowserProvider.debug("Dropping view: bookmarks_with_images");
            sQLiteDatabase.execSQL("DROP VIEW IF EXISTS bookmarks_with_images");
            this.createBookmarksWithImagesView(sQLiteDatabase);
            BrowserProvider.debug("Dropping view: history_with_images");
            sQLiteDatabase.execSQL("DROP VIEW IF EXISTS history_with_images");
            this.createHistoryWithImagesView(sQLiteDatabase);
        }

        private void upgradeDatabaseFrom3to4(SQLiteDatabase sQLiteDatabase) {
            this.migrateBookmarksTable(sQLiteDatabase, new BookmarkMigrator3to4());
        }

        private void upgradeDatabaseFrom4to5(SQLiteDatabase sQLiteDatabase) {
            this.createCombinedWithImagesView(sQLiteDatabase);
        }

        private void upgradeDatabaseFrom5to6(SQLiteDatabase sQLiteDatabase) {
            BrowserProvider.debug("Dropping view: combined_with_images");
            sQLiteDatabase.execSQL("DROP VIEW IF EXISTS combined_with_images");
            this.createCombinedWithImagesView(sQLiteDatabase);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void upgradeDatabaseFrom6to7(SQLiteDatabase sQLiteDatabase) {
            BrowserProvider.debug("Removing history visits with NULL GUIDs");
            sQLiteDatabase.execSQL("DELETE FROM history WHERE guid IS NULL");
            BrowserProvider.debug("Update images with NULL GUIDs");
            String[] stringArray = new String[]{"_id"};
            Cursor cursor = null;
            try {
                cursor = sQLiteDatabase.query("images", stringArray, "guid IS NULL", null, null, null, null, null);
                ContentValues contentValues = new ContentValues();
                if (cursor.moveToFirst()) {
                    do {
                        contentValues.put("guid", Utils.generateGuid());
                        sQLiteDatabase.update("images", contentValues, "_id = ?", new String[]{cursor.getString(cursor.getColumnIndexOrThrow("_id"))});
                    } while (cursor.moveToNext());
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            this.migrateBookmarksTable(sQLiteDatabase);
            this.migrateHistoryTable(sQLiteDatabase);
            this.migrateImagesTable(sQLiteDatabase);
        }

        private void upgradeDatabaseFrom7to8(SQLiteDatabase sQLiteDatabase) {
            BrowserProvider.debug("Combining history entries with the same URL");
            sQLiteDatabase.execSQL("CREATE TEMP TABLE duped_urls AS SELECT url, SUM(visits) AS total, MAX(modified) AS latest, MAX(_id) AS winner FROM history GROUP BY url HAVING count(url) > 1");
            sQLiteDatabase.execSQL("CREATE UNIQUE INDEX duped_urls_url_index ON duped_urls (url)");
            String string2 = " FROM duped_urls WHERE " + BrowserProvider.qualifyColumn("duped_urls", "url") + " = " + BrowserProvider.qualifyColumn(BrowserProvider.TABLE_HISTORY, "url");
            sQLiteDatabase.execSQL("UPDATE history SET visits = (SELECT total" + string2 + "), " + "modified" + " = (SELECT " + "latest" + string2 + "), " + "deleted" + " = " + "(" + "_id" + " <> (SELECT " + "winner" + string2 + "))" + " WHERE " + "url" + " IN (SELECT " + "url" + " FROM " + "duped_urls" + ")");
            sQLiteDatabase.execSQL("DROP TABLE duped_urls");
        }

        private void upgradeDatabaseFrom8to9(SQLiteDatabase sQLiteDatabase) {
            this.createOrUpdateSpecialFolder(sQLiteDatabase, "readinglist", R.string.bookmarks_folder_reading_list, 5);
            BrowserProvider.debug("Dropping view: combined_with_images");
            sQLiteDatabase.execSQL("DROP VIEW IF EXISTS combined_with_images");
            this.createCombinedWithImagesViewOn9(sQLiteDatabase);
        }

        private void upgradeDatabaseFrom9to10(SQLiteDatabase sQLiteDatabase) {
            BrowserProvider.debug("Dropping view: combined_with_images");
            sQLiteDatabase.execSQL("DROP VIEW IF EXISTS combined_with_images");
            this.createCombinedWithImagesViewOn10(sQLiteDatabase);
        }

        private void upgradeDatabaseFrom10to11(SQLiteDatabase sQLiteDatabase) {
            BrowserProvider.debug("Dropping view: combined_with_images");
            sQLiteDatabase.execSQL("DROP VIEW IF EXISTS combined_with_images");
            sQLiteDatabase.execSQL("CREATE INDEX bookmarks_type_deleted_index ON bookmarks(type, deleted)");
            this.createCombinedWithImagesViewOn11(sQLiteDatabase);
        }

        private void upgradeDatabaseFrom11to12(SQLiteDatabase sQLiteDatabase) {
            BrowserProvider.debug("Dropping view: combined_with_images");
            sQLiteDatabase.execSQL("DROP VIEW IF EXISTS combined_with_images");
            this.createCombinedViewOn12(sQLiteDatabase);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void upgradeDatabaseFrom12to13(SQLiteDatabase sQLiteDatabase) {
            String[] stringArray;
            String string2;
            SQLiteDatabase sQLiteDatabase2 = null;
            Cursor cursor = null;
            try {
                string2 = BrowserProvider.this.mContext.getDatabasePath("favicon_urls.db").getPath();
                sQLiteDatabase2 = SQLiteDatabase.openDatabase((String)string2, null, (int)1);
                stringArray = new String[]{"favicon_url", "page_url"};
                cursor = sQLiteDatabase2.query("favicon_urls", stringArray, null, null, null, null, null, null);
                int n = cursor.getColumnIndexOrThrow("favicon_url");
                int n2 = cursor.getColumnIndexOrThrow("page_url");
                while (cursor.moveToNext()) {
                    ContentValues contentValues = new ContentValues(1);
                    String string3 = cursor.getString(n);
                    String string4 = cursor.getString(n2);
                    contentValues.put("favicon_url", string3);
                    sQLiteDatabase.update("images", contentValues, "url_key = ?", new String[]{string4});
                }
            }
            catch (SQLException sQLException) {
                Log.e((String)BrowserProvider.LOGTAG, (String)"Exception importing from favicon_urls.db", (Throwable)sQLException);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
                if (sQLiteDatabase2 != null) {
                    sQLiteDatabase2.close();
                }
            }
            this.createFaviconsTable(sQLiteDatabase);
            sQLiteDatabase.execSQL("ALTER TABLE history ADD COLUMN favicon_id INTEGER");
            sQLiteDatabase.execSQL("ALTER TABLE bookmarks ADD COLUMN favicon_id INTEGER");
            try {
                cursor = sQLiteDatabase.query("images", new String[]{"url_key", "favicon_url", "favicon", "modified", "created"}, "favicon IS NOT NULL", null, null, null, null);
                while (cursor.moveToNext()) {
                    long l = -1L;
                    int n = cursor.getColumnIndexOrThrow("favicon_url");
                    string2 = null;
                    if (!cursor.isNull(n)) {
                        string2 = cursor.getString(n);
                        stringArray = null;
                        try {
                            stringArray = sQLiteDatabase.query(BrowserProvider.TABLE_FAVICONS, new String[]{"_id"}, "url = ?", new String[]{string2}, null, null, null);
                            if (stringArray.moveToFirst()) {
                                l = stringArray.getLong(stringArray.getColumnIndexOrThrow("_id"));
                            }
                        }
                        finally {
                            if (stringArray != null) {
                                stringArray.close();
                            }
                        }
                    }
                    if (l == -1L) {
                        stringArray = new ContentValues(4);
                        stringArray.put("url", string2);
                        stringArray.put("data", cursor.getBlob(cursor.getColumnIndexOrThrow("favicon")));
                        stringArray.put("modified", Long.valueOf(cursor.getLong(cursor.getColumnIndexOrThrow("modified"))));
                        stringArray.put("created", Long.valueOf(cursor.getLong(cursor.getColumnIndexOrThrow("created"))));
                        l = sQLiteDatabase.insert(BrowserProvider.TABLE_FAVICONS, null, (ContentValues)stringArray);
                    }
                    stringArray = new ContentValues(1);
                    stringArray.put("favicon_id", Long.valueOf(l));
                    sQLiteDatabase.update(BrowserProvider.TABLE_HISTORY, (ContentValues)stringArray, "url = ?", new String[]{cursor.getString(cursor.getColumnIndexOrThrow("url_key"))});
                    sQLiteDatabase.update(BrowserProvider.TABLE_BOOKMARKS, (ContentValues)stringArray, "url = ?", new String[]{cursor.getString(cursor.getColumnIndexOrThrow("url_key"))});
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            this.createThumbnailsTable(sQLiteDatabase);
            sQLiteDatabase.execSQL("INSERT INTO thumbnails (url, data) SELECT url_key, thumbnail FROM images WHERE thumbnail IS NOT NULL");
            sQLiteDatabase.execSQL("DROP VIEW IF EXISTS bookmarks_with_images");
            sQLiteDatabase.execSQL("DROP VIEW IF EXISTS history_with_images");
            sQLiteDatabase.execSQL("DROP VIEW IF EXISTS combined_with_images");
            sQLiteDatabase.execSQL("DROP VIEW IF EXISTS combined");
            this.createBookmarksWithFaviconsView(sQLiteDatabase);
            this.createHistoryWithFaviconsView(sQLiteDatabase);
            this.createCombinedViewOn13(sQLiteDatabase);
            sQLiteDatabase.execSQL("DROP TABLE IF EXISTS images");
        }

        private void upgradeDatabaseFrom13to14(SQLiteDatabase sQLiteDatabase) {
            this.createOrUpdateSpecialFolder(sQLiteDatabase, "pinned", R.string.bookmarks_folder_pinned, 6);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void upgradeDatabaseFrom14to15(SQLiteDatabase sQLiteDatabase) {
            Cursor cursor = null;
            try {
                cursor = sQLiteDatabase.query(BrowserProvider.TABLE_BOOKMARKS, new String[]{"_id", "url"}, "parent = ?", new String[]{Integer.toString(-3)}, null, null, null);
                while (cursor.moveToNext()) {
                    String string2 = cursor.getString(cursor.getColumnIndexOrThrow("url"));
                    if (Uri.parse((String)string2).getScheme() != null) continue;
                    ContentValues contentValues = new ContentValues(1);
                    String string3 = Uri.fromParts((String)"user-entered", (String)string2, null).toString();
                    contentValues.put("url", string3);
                    sQLiteDatabase.update(BrowserProvider.TABLE_BOOKMARKS, contentValues, "_id = ?", new String[]{Integer.toString(cursor.getInt(cursor.getColumnIndexOrThrow("_id")))});
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }

        private void upgradeDatabaseFrom15to16(SQLiteDatabase sQLiteDatabase) {
            sQLiteDatabase.execSQL("DROP VIEW IF EXISTS combined");
            sQLiteDatabase.execSQL("DROP VIEW IF EXISTS combined_with_favicons");
            this.createCombinedViewOn16(sQLiteDatabase);
        }

        private void upgradeDatabaseFrom16to17(SQLiteDatabase sQLiteDatabase) {
            try {
                sQLiteDatabase.execSQL("DELETE FROM favicons WHERE length(data) = 0");
                sQLiteDatabase.execSQL("DELETE FROM thumbnails WHERE length(data) = 0");
            }
            catch (SQLException sQLException) {
                Log.e((String)BrowserProvider.LOGTAG, (String)"Error purging invalid favicons or thumbnails", (Throwable)sQLException);
            }
        }

        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
            BrowserProvider.debug("Upgrading browser.db: " + sQLiteDatabase.getPath() + " from " + n + " to " + n2);
            block18: for (int i = n + 1; i <= n2; ++i) {
                switch (i) {
                    case 2: {
                        this.upgradeDatabaseFrom1to2(sQLiteDatabase);
                        continue block18;
                    }
                    case 3: {
                        this.upgradeDatabaseFrom2to3(sQLiteDatabase);
                        continue block18;
                    }
                    case 4: {
                        this.upgradeDatabaseFrom3to4(sQLiteDatabase);
                        continue block18;
                    }
                    case 5: {
                        this.upgradeDatabaseFrom4to5(sQLiteDatabase);
                        continue block18;
                    }
                    case 6: {
                        this.upgradeDatabaseFrom5to6(sQLiteDatabase);
                        continue block18;
                    }
                    case 7: {
                        this.upgradeDatabaseFrom6to7(sQLiteDatabase);
                        continue block18;
                    }
                    case 8: {
                        this.upgradeDatabaseFrom7to8(sQLiteDatabase);
                        continue block18;
                    }
                    case 9: {
                        this.upgradeDatabaseFrom8to9(sQLiteDatabase);
                        continue block18;
                    }
                    case 10: {
                        this.upgradeDatabaseFrom9to10(sQLiteDatabase);
                        continue block18;
                    }
                    case 11: {
                        this.upgradeDatabaseFrom10to11(sQLiteDatabase);
                        continue block18;
                    }
                    case 12: {
                        this.upgradeDatabaseFrom11to12(sQLiteDatabase);
                        continue block18;
                    }
                    case 13: {
                        this.upgradeDatabaseFrom12to13(sQLiteDatabase);
                        continue block18;
                    }
                    case 14: {
                        this.upgradeDatabaseFrom13to14(sQLiteDatabase);
                        continue block18;
                    }
                    case 15: {
                        this.upgradeDatabaseFrom14to15(sQLiteDatabase);
                        continue block18;
                    }
                    case 16: {
                        this.upgradeDatabaseFrom15to16(sQLiteDatabase);
                        continue block18;
                    }
                    case 17: {
                        this.upgradeDatabaseFrom16to17(sQLiteDatabase);
                    }
                }
            }
            if (n < 13 && n2 >= 13 && BrowserProvider.this.mContext.getDatabasePath("favicon_urls.db").exists() && !BrowserProvider.this.mContext.deleteDatabase("favicon_urls.db")) {
                throw new SQLException("Could not delete favicon_urls.db");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOpen(SQLiteDatabase sQLiteDatabase) {
            BrowserProvider.debug("Opening browser.db: " + sQLiteDatabase.getPath());
            Cursor cursor = null;
            try {
                cursor = sQLiteDatabase.rawQuery("PRAGMA foreign_keys=ON", null);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            cursor = null;
            try {
                cursor = sQLiteDatabase.rawQuery("PRAGMA synchronous=NORMAL", null);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            if (Build.VERSION.SDK_INT >= 11) {
                sQLiteDatabase.enableWriteAheadLogging();
                sQLiteDatabase.setLockingEnabled(false);
            } else {
                cursor = null;
                try {
                    cursor = sQLiteDatabase.rawQuery("PRAGMA journal_mode=PERSIST", null);
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
        }
    }

    private class BookmarkMigrator3to4
    implements BookmarkMigrator {
        private BookmarkMigrator3to4() {
        }

        public void updateForNewTable(ContentValues contentValues) {
            Integer n = contentValues.getAsInteger("folder");
            if (n == null || n != 1) {
                contentValues.put("type", Integer.valueOf(1));
            } else {
                contentValues.put("type", Integer.valueOf(0));
            }
            contentValues.remove("folder");
        }
    }

    private static interface BookmarkMigrator {
        public void updateForNewTable(ContentValues var1);
    }

    static final class Obsolete {
        public static final String TABLE_IMAGES = "images";
        public static final String VIEW_BOOKMARKS_WITH_IMAGES = "bookmarks_with_images";
        public static final String VIEW_HISTORY_WITH_IMAGES = "history_with_images";
        public static final String VIEW_COMBINED_WITH_IMAGES = "combined_with_images";
        static final String TABLE_BOOKMARKS_JOIN_IMAGES = "bookmarks LEFT OUTER JOIN images ON " + BrowserProvider.qualifyColumn("bookmarks", "url") + " = " + BrowserProvider.qualifyColumn("images", "url_key");
        static final String TABLE_HISTORY_JOIN_IMAGES = "history LEFT OUTER JOIN images ON " + BrowserProvider.qualifyColumn("history", "url") + " = " + BrowserProvider.qualifyColumn("images", "url_key");
        static final String FAVICON_DB = "favicon_urls.db";

        Obsolete() {
        }

        public static final class Combined {
            public static final String THUMBNAIL = "thumbnail";

            private Combined() {
            }
        }

        public static final class Images
        implements BrowserContract.CommonColumns,
        BrowserContract.SyncColumns {
            public static final String URL = "url_key";
            public static final String FAVICON_URL = "favicon_url";
            public static final String FAVICON = "favicon";
            public static final String THUMBNAIL = "thumbnail";
            public static final String _ID = "_id";
            public static final String GUID = "guid";
            public static final String DATE_CREATED = "created";
            public static final String DATE_MODIFIED = "modified";
            public static final String IS_DELETED = "deleted";

            private Images() {
            }
        }
    }
}

