/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.gfx.IntSize;
import org.mozilla.gecko.util.FloatUtils;

public class FloatSize {
    public final float width;
    public final float height;

    public FloatSize(FloatSize floatSize) {
        this.width = floatSize.width;
        this.height = floatSize.height;
    }

    public FloatSize(IntSize intSize) {
        this.width = intSize.width;
        this.height = intSize.height;
    }

    public FloatSize(float f, float f2) {
        this.width = f;
        this.height = f2;
    }

    public FloatSize(JSONObject jSONObject) {
        try {
            this.width = (float)jSONObject.getDouble("width");
            this.height = (float)jSONObject.getDouble("height");
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    public String toString() {
        return "(" + this.width + "," + this.height + ")";
    }

    public boolean isPositive() {
        return this.width > 0.0f && this.height > 0.0f;
    }

    public boolean fuzzyEquals(FloatSize floatSize) {
        return FloatUtils.fuzzyEquals((float)floatSize.width, (float)this.width) && FloatUtils.fuzzyEquals((float)floatSize.height, (float)this.height);
    }

    public FloatSize scale(float f) {
        return new FloatSize(this.width * f, this.height * f);
    }

    public FloatSize interpolate(FloatSize floatSize, float f) {
        return new FloatSize(FloatUtils.interpolate((float)this.width, (float)floatSize.width, (float)f), FloatUtils.interpolate((float)this.height, (float)floatSize.height, (float)f));
    }
}

