/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.R;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.util.HardwareUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HomeConfigPrefsBackend
implements HomeConfig.HomeConfigBackend {
    private static final String LOGTAG = "GeckoHomeConfigBackend";
    private static final String PREFS_KEY = "home_panels";
    private static final String JSON_KEY_TYPE = "type";
    private static final String JSON_KEY_TITLE = "title";
    private static final String JSON_KEY_ID = "id";
    private static final String JSON_KEY_DEFAULT = "default";
    private static final int IS_DEFAULT = 1;
    private final Context mContext;
    private PrefsListener mPrefsListener;
    private HomeConfig.OnChangeListener mChangeListener;

    public HomeConfigPrefsBackend(Context context) {
        this.mContext = context;
    }

    private SharedPreferences getSharedPreferences() {
        return PreferenceManager.getDefaultSharedPreferences((Context)this.mContext);
    }

    private List<HomeConfig.PageEntry> loadDefaultConfig() {
        ArrayList<HomeConfig.PageEntry> arrayList = new ArrayList<HomeConfig.PageEntry>();
        arrayList.add(new HomeConfig.PageEntry(HomeConfig.PageType.TOP_SITES, this.mContext.getString(R.string.home_top_sites_title), EnumSet.of(HomeConfig.PageEntry.Flags.DEFAULT_PAGE)));
        arrayList.add(new HomeConfig.PageEntry(HomeConfig.PageType.BOOKMARKS, this.mContext.getString(R.string.bookmarks_title)));
        if (!HardwareUtils.isLowMemoryPlatform()) {
            arrayList.add(new HomeConfig.PageEntry(HomeConfig.PageType.READING_LIST, this.mContext.getString(R.string.reading_list_title)));
        }
        HomeConfig.PageEntry pageEntry = new HomeConfig.PageEntry(HomeConfig.PageType.HISTORY, this.mContext.getString(R.string.home_history_title));
        if (HardwareUtils.isTablet()) {
            arrayList.add(pageEntry);
        } else {
            arrayList.add(0, pageEntry);
        }
        return arrayList;
    }

    private List<HomeConfig.PageEntry> loadConfigFromString(String string2) {
        JSONArray jSONArray;
        try {
            jSONArray = new JSONArray(string2);
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Error loading the list of home pages from JSON prefs", (Throwable)jSONException);
            return this.loadDefaultConfig();
        }
        ArrayList<HomeConfig.PageEntry> arrayList = new ArrayList<HomeConfig.PageEntry>();
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            try {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                HomeConfig.PageEntry pageEntry = this.loadPageEntryFromJSON(jSONObject);
                arrayList.add(pageEntry);
                continue;
            }
            catch (Exception exception) {
                Log.e((String)LOGTAG, (String)"Exception loading page entry from JSON", (Throwable)exception);
            }
        }
        return arrayList;
    }

    private HomeConfig.PageEntry loadPageEntryFromJSON(JSONObject jSONObject) throws JSONException, IllegalArgumentException {
        boolean bl;
        HomeConfig.PageType pageType = HomeConfig.PageType.fromId(jSONObject.getString(JSON_KEY_TYPE));
        String string2 = jSONObject.getString(JSON_KEY_TITLE);
        String string3 = jSONObject.getString(JSON_KEY_ID);
        EnumSet<HomeConfig.PageEntry.Flags> enumSet = EnumSet.noneOf(HomeConfig.PageEntry.Flags.class);
        boolean bl2 = bl = jSONObject.optInt(JSON_KEY_DEFAULT, -1) == 1;
        if (bl) {
            enumSet.add(HomeConfig.PageEntry.Flags.DEFAULT_PAGE);
        }
        return new HomeConfig.PageEntry(pageType, string2, string3, enumSet);
    }

    @Override
    public List<HomeConfig.PageEntry> load() {
        SharedPreferences sharedPreferences = this.getSharedPreferences();
        String string2 = sharedPreferences.getString(PREFS_KEY, null);
        List<HomeConfig.PageEntry> list = TextUtils.isEmpty((CharSequence)string2) ? this.loadDefaultConfig() : this.loadConfigFromString(string2);
        return Collections.unmodifiableList(list);
    }

    private JSONObject convertPageEntryToJSON(HomeConfig.PageEntry pageEntry) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(JSON_KEY_TYPE, (Object)pageEntry.getType().toString());
        jSONObject.put(JSON_KEY_TITLE, (Object)pageEntry.getTitle());
        jSONObject.put(JSON_KEY_ID, (Object)pageEntry.getId());
        if (pageEntry.isDefault()) {
            jSONObject.put(JSON_KEY_DEFAULT, 1);
        }
        return jSONObject;
    }

    @Override
    public void save(List<HomeConfig.PageEntry> list) {
        String string2;
        HomeConfig.PageEntry pageEntry;
        JSONArray jSONArray = new JSONArray();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            try {
                pageEntry = list.get(i);
                string2 = this.convertPageEntryToJSON(pageEntry);
                jSONArray.put((Object)string2);
                continue;
            }
            catch (Exception exception) {
                Log.e((String)LOGTAG, (String)"Exception loading page entry from JSON", (Throwable)exception);
            }
        }
        SharedPreferences sharedPreferences = this.getSharedPreferences();
        pageEntry = sharedPreferences.edit();
        string2 = jSONArray.toString();
        pageEntry.putString(PREFS_KEY, string2);
        pageEntry.commit();
    }

    @Override
    public void setOnChangeListener(HomeConfig.OnChangeListener onChangeListener) {
        SharedPreferences sharedPreferences = this.getSharedPreferences();
        if (this.mChangeListener != null) {
            sharedPreferences.unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this.mPrefsListener);
            this.mPrefsListener = null;
        }
        this.mChangeListener = onChangeListener;
        if (this.mChangeListener != null) {
            this.mPrefsListener = new PrefsListener();
            sharedPreferences.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this.mPrefsListener);
        }
    }

    private class PrefsListener
    implements SharedPreferences.OnSharedPreferenceChangeListener {
        private PrefsListener() {
        }

        public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String string2) {
            if (TextUtils.equals((CharSequence)string2, (CharSequence)HomeConfigPrefsBackend.PREFS_KEY)) {
                HomeConfigPrefsBackend.this.mChangeListener.onChange();
            }
        }
    }
}

