/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Configuration;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.AsyncTaskLoader;
import android.support.v4.content.Loader;
import android.support.v4.widget.CursorAdapter;
import android.text.TextUtils;
import android.util.Log;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.Toast;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.animation.ViewHelper;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.favicons.OnFaviconLoadedListener;
import org.mozilla.gecko.gfx.BitmapUtils;
import org.mozilla.gecko.home.HomeBanner;
import org.mozilla.gecko.home.HomeFragment;
import org.mozilla.gecko.home.HomeListView;
import org.mozilla.gecko.home.HomePager;
import org.mozilla.gecko.home.PinSiteDialog;
import org.mozilla.gecko.home.SimpleCursorLoader;
import org.mozilla.gecko.home.TopSitesGridItemView;
import org.mozilla.gecko.home.TopSitesGridView;
import org.mozilla.gecko.home.TwoLinePageRow;
import org.mozilla.gecko.util.ThreadUtils;

public class TopSitesPage
extends HomeFragment {
    private static final String LOGTAG = "GeckoTopSitesPage";
    private static final int LOADER_ID_TOP_SITES = 0;
    private static final int LOADER_ID_THUMBNAILS = 1;
    private static final String THUMBNAILS_URLS_KEY = "urls";
    private VisitedAdapter mListAdapter;
    private TopSitesGridAdapter mGridAdapter;
    private ListView mList;
    private TopSitesGridView mGrid;
    private HomeBanner mBanner;
    private float mListTouchY = -1.0f;
    private boolean mSnapBannerToTop;
    private CursorLoaderCallbacks mCursorLoaderCallbacks;
    private ThumbnailsLoaderCallbacks mThumbnailsLoaderCallbacks;
    private EditPinnedSiteListener mEditPinnedSiteListener;
    private HomePager.OnUrlOpenListener mUrlOpenListener = null;
    private int mMaxGridEntries;
    private static final long PRIORITY_RESET_TIMEOUT = 10000L;
    private static boolean logDebug = Log.isLoggable((String)"GeckoTopSitesPage", (int)3);
    private static boolean logVerbose = Log.isLoggable((String)"GeckoTopSitesPage", (int)2);

    public static TopSitesPage newInstance() {
        return new TopSitesPage();
    }

    private static void debug(String string2) {
        if (logDebug) {
            Log.d((String)LOGTAG, (String)string2);
        }
    }

    private static void trace(String string2) {
        if (logVerbose) {
            Log.v((String)LOGTAG, (String)string2);
        }
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.mMaxGridEntries = activity.getResources().getInteger(R.integer.number_of_top_sites);
        try {
            this.mUrlOpenListener = (HomePager.OnUrlOpenListener)activity;
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException(activity.toString() + " must implement HomePager.OnUrlOpenListener");
        }
    }

    public void onDetach() {
        super.onDetach();
        this.mUrlOpenListener = null;
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = layoutInflater.inflate(R.layout.home_top_sites_page, viewGroup, false);
        this.mList = (HomeListView)view.findViewById(R.id.list);
        this.mGrid = new TopSitesGridView((Context)this.getActivity());
        this.mList.addHeaderView((View)this.mGrid);
        return view;
    }

    public void onViewCreated(View view, Bundle bundle) {
        this.mEditPinnedSiteListener = new EditPinnedSiteListener();
        this.mList.setTag((Object)"top_sites");
        this.mList.setHeaderDividersEnabled(false);
        this.mList.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                ListView listView = (ListView)adapterView;
                int n2 = listView.getHeaderViewsCount();
                if (n < n2) {
                    return;
                }
                Cursor cursor = TopSitesPage.this.mListAdapter.getCursor();
                if (cursor == null || !cursor.moveToPosition(n += TopSitesPage.this.mGridAdapter.getCount() - n2)) {
                    return;
                }
                String string2 = cursor.getString(cursor.getColumnIndexOrThrow("url"));
                TopSitesPage.this.mUrlOpenListener.onUrlOpen(string2, EnumSet.of(HomePager.OnUrlOpenListener.Flags.ALLOW_SWITCH_TO_TAB));
            }
        });
        this.mGrid.setOnUrlOpenListener(this.mUrlOpenListener);
        this.mGrid.setOnEditPinnedSiteListener(this.mEditPinnedSiteListener);
        this.registerForContextMenu((View)this.mList);
        this.registerForContextMenu((View)this.mGrid);
        this.mBanner = (HomeBanner)view.findViewById(R.id.home_banner);
        this.mList.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                TopSitesPage.this.handleListTouchEvent(motionEvent);
                return false;
            }
        });
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mList = null;
        this.mGrid = null;
        this.mListAdapter = null;
        this.mGridAdapter = null;
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        if (this.isVisible()) {
            this.getFragmentManager().beginTransaction().detach((Fragment)this).attach((Fragment)this).commitAllowingStateLoss();
        }
    }

    public void onActivityCreated(Bundle bundle) {
        super.onActivityCreated(bundle);
        FragmentActivity fragmentActivity = this.getActivity();
        this.mGridAdapter = new TopSitesGridAdapter((Context)fragmentActivity, null);
        this.mGrid.setAdapter((ListAdapter)this.mGridAdapter);
        this.mListAdapter = new VisitedAdapter((Context)fragmentActivity, null);
        this.mList.setAdapter((ListAdapter)this.mListAdapter);
        this.mCursorLoaderCallbacks = new CursorLoaderCallbacks();
        this.mThumbnailsLoaderCallbacks = new ThumbnailsLoaderCallbacks();
        this.loadIfVisible();
    }

    public void onCreateContextMenu(ContextMenu contextMenu, View view, ContextMenu.ContextMenuInfo contextMenuInfo) {
        if (contextMenuInfo == null) {
            return;
        }
        if (contextMenuInfo instanceof HomeListView.HomeContextMenuInfo) {
            super.onCreateContextMenu(contextMenu, view, contextMenuInfo);
        }
        if (!(contextMenuInfo instanceof TopSitesGridView.TopSitesGridContextMenuInfo)) {
            return;
        }
        MenuInflater menuInflater = new MenuInflater(view.getContext());
        menuInflater.inflate(R.menu.top_sites_contextmenu, (Menu)contextMenu);
        TopSitesGridView.TopSitesGridContextMenuInfo topSitesGridContextMenuInfo = (TopSitesGridView.TopSitesGridContextMenuInfo)contextMenuInfo;
        contextMenu.setHeaderTitle((CharSequence)topSitesGridContextMenuInfo.getDisplayTitle());
        if (!TextUtils.isEmpty((CharSequence)topSitesGridContextMenuInfo.url)) {
            if (topSitesGridContextMenuInfo.isPinned) {
                contextMenu.findItem(R.id.top_sites_pin).setVisible(false);
            } else {
                contextMenu.findItem(R.id.top_sites_unpin).setVisible(false);
            }
        } else {
            contextMenu.findItem(R.id.top_sites_open_new_tab).setVisible(false);
            contextMenu.findItem(R.id.top_sites_open_private_tab).setVisible(false);
            contextMenu.findItem(R.id.top_sites_pin).setVisible(false);
            contextMenu.findItem(R.id.top_sites_unpin).setVisible(false);
        }
    }

    public boolean onContextItemSelected(MenuItem menuItem) {
        ContextMenu.ContextMenuInfo contextMenuInfo = menuItem.getMenuInfo();
        if (contextMenuInfo == null || !(contextMenuInfo instanceof TopSitesGridView.TopSitesGridContextMenuInfo)) {
            return false;
        }
        TopSitesGridView.TopSitesGridContextMenuInfo topSitesGridContextMenuInfo = (TopSitesGridView.TopSitesGridContextMenuInfo)contextMenuInfo;
        FragmentActivity fragmentActivity = this.getActivity();
        int n = menuItem.getItemId();
        if (n == R.id.top_sites_open_new_tab || n == R.id.top_sites_open_private_tab) {
            if (topSitesGridContextMenuInfo.url == null) {
                Log.e((String)LOGTAG, (String)"Can't open in new tab because URL is null");
                return false;
            }
            int n2 = 65;
            if (menuItem.getItemId() == R.id.top_sites_open_private_tab) {
                n2 |= 4;
            }
            Tabs.getInstance().loadUrl(TopSitesPage.decodeUserEnteredUrl(topSitesGridContextMenuInfo.url), n2);
            Toast.makeText((Context)fragmentActivity, (int)R.string.new_tab_opened, (int)0).show();
            return true;
        }
        if (n == R.id.top_sites_pin) {
            final String string2 = topSitesGridContextMenuInfo.url;
            final String string3 = topSitesGridContextMenuInfo.title;
            final int n3 = topSitesGridContextMenuInfo.position;
            final Context context = this.getActivity().getApplicationContext();
            ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                public void run() {
                    BrowserDB.pinSite(context.getContentResolver(), string2, string3, n3);
                }
            });
            return true;
        }
        if (n == R.id.top_sites_unpin) {
            final int n4 = topSitesGridContextMenuInfo.position;
            final Context context = this.getActivity().getApplicationContext();
            ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                public void run() {
                    BrowserDB.unpinSite(context.getContentResolver(), n4);
                }
            });
            return true;
        }
        if (n == R.id.top_sites_edit) {
            this.mEditPinnedSiteListener.onEditPinnedSite(topSitesGridContextMenuInfo.position, TopSitesPage.decodeUserEnteredUrl(topSitesGridContextMenuInfo.url));
            return true;
        }
        if (n == R.id.home_share) {
            if (topSitesGridContextMenuInfo.url == null) {
                Log.w((String)LOGTAG, (String)"Share not enabled for context menu because URL is null.");
                return false;
            }
            GeckoAppShell.openUriExternal(topSitesGridContextMenuInfo.url, "text/plain", "", "", "android.intent.action.SEND", topSitesGridContextMenuInfo.getDisplayTitle());
            return true;
        }
        if (n == R.id.home_add_to_launcher) {
            if (topSitesGridContextMenuInfo.url == null) {
                Log.w((String)LOGTAG, (String)"Not enabling 'Add to home page' because URL is null.");
                return false;
            }
            Favicons.getLargestFaviconForPage(topSitesGridContextMenuInfo.url, new GeckoAppShell.CreateShortcutFaviconLoadedListener(topSitesGridContextMenuInfo.url, topSitesGridContextMenuInfo.getDisplayTitle()));
            return true;
        }
        return false;
    }

    protected void load() {
        this.getLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)this.mCursorLoaderCallbacks);
        ThreadUtils.reduceGeckoPriority((long)10000L);
    }

    static String encodeUserEnteredUrl(String string2) {
        return Uri.fromParts((String)"user-entered", (String)string2, null).toString();
    }

    static String decodeUserEnteredUrl(String string2) {
        Uri uri = Uri.parse((String)string2);
        if ("user-entered".equals(uri.getScheme())) {
            return uri.getSchemeSpecificPart();
        }
        return string2;
    }

    private void handleListTouchEvent(MotionEvent motionEvent) {
        if (this.mBanner.isDismissed()) {
            return;
        }
        switch (motionEvent.getActionMasked()) {
            case 0: {
                this.mListTouchY = motionEvent.getRawY();
                break;
            }
            case 2: {
                if (this.mListTouchY == -1.0f) {
                    this.mListTouchY = motionEvent.getRawY();
                    return;
                }
                float f = motionEvent.getRawY();
                float f2 = this.mListTouchY - f;
                this.mSnapBannerToTop = !(f2 > 0.0f);
                float f3 = this.mBanner.getHeight();
                float f4 = ViewHelper.getTranslationY((View)this.mBanner) + f2;
                if (f4 < 0.0f) {
                    f4 = 0.0f;
                } else if (f4 > f3) {
                    f4 = f3;
                }
                ViewHelper.setTranslationY((View)this.mBanner, f4);
                this.mListTouchY = f;
                break;
            }
            case 1: 
            case 3: {
                this.mListTouchY = -1.0f;
                float f = ViewHelper.getTranslationY((View)this.mBanner);
                float f5 = this.mBanner.getHeight();
                if (!(f > 0.0f) || !(f < f5)) break;
                PropertyAnimator propertyAnimator = new PropertyAnimator(100L);
                propertyAnimator.attach((View)this.mBanner, PropertyAnimator.Property.TRANSLATION_Y, this.mSnapBannerToTop ? 0.0f : f5);
                propertyAnimator.start();
                break;
            }
        }
    }

    private void updateUiFromCursor(Cursor cursor) {
        this.mList.setHeaderDividersEnabled(cursor != null && cursor.getCount() > this.mMaxGridEntries);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ThumbnailsLoaderCallbacks
    implements LoaderManager.LoaderCallbacks<Map<String, Bitmap>> {
        private ThumbnailsLoaderCallbacks() {
        }

        public Loader<Map<String, Bitmap>> onCreateLoader(int n, Bundle bundle) {
            return new ThumbnailsLoader((Context)TopSitesPage.this.getActivity(), bundle.getStringArrayList(TopSitesPage.THUMBNAILS_URLS_KEY));
        }

        public void onLoadFinished(Loader<Map<String, Bitmap>> loader, Map<String, Bitmap> map) {
            if (TopSitesPage.this.mGridAdapter != null) {
                TopSitesPage.this.mGridAdapter.updateThumbnails(map);
            }
            ThreadUtils.resetGeckoPriority();
        }

        public void onLoaderReset(Loader<Map<String, Bitmap>> loader) {
            if (TopSitesPage.this.mGridAdapter != null) {
                TopSitesPage.this.mGridAdapter.updateThumbnails(null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThumbnailsLoader
    extends AsyncTaskLoader<Map<String, Bitmap>> {
        private Map<String, Bitmap> mThumbnails;
        private ArrayList<String> mUrls;

        public ThumbnailsLoader(Context context, ArrayList<String> arrayList) {
            super(context);
            this.mUrls = arrayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, Bitmap> loadInBackground() {
            if (this.mUrls == null || this.mUrls.size() == 0) {
                return null;
            }
            ContentResolver contentResolver = this.getContext().getContentResolver();
            Cursor cursor = BrowserDB.getThumbnailsForUrls(contentResolver, this.mUrls);
            if (cursor == null) {
                return null;
            }
            HashMap<String, Bitmap> hashMap = new HashMap<String, Bitmap>();
            try {
                int n = cursor.getColumnIndexOrThrow("url");
                int n2 = cursor.getColumnIndexOrThrow("data");
                while (cursor.moveToNext()) {
                    String string2 = cursor.getString(n);
                    byte[] byArray = cursor.getBlob(n2);
                    if (byArray == null) continue;
                    Bitmap bitmap = BitmapUtils.decodeByteArray(byArray);
                    if (bitmap == null) {
                        Log.w((String)TopSitesPage.LOGTAG, (String)"Aborting thumbnail load; decode failed.");
                        break;
                    }
                    hashMap.put(string2, bitmap);
                }
            }
            finally {
                cursor.close();
            }
            return hashMap;
        }

        public void deliverResult(Map<String, Bitmap> map) {
            if (this.isReset()) {
                this.mThumbnails = null;
                return;
            }
            this.mThumbnails = map;
            if (this.isStarted()) {
                super.deliverResult(map);
            }
        }

        protected void onStartLoading() {
            if (this.mThumbnails != null) {
                this.deliverResult(this.mThumbnails);
            }
            if (this.takeContentChanged() || this.mThumbnails == null) {
                this.forceLoad();
            }
        }

        protected void onStopLoading() {
            this.cancelLoad();
        }

        public void onCanceled(Map<String, Bitmap> map) {
            this.mThumbnails = null;
        }

        protected void onReset() {
            super.onReset();
            this.onStopLoading();
            this.mThumbnails = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CursorLoaderCallbacks
    implements LoaderManager.LoaderCallbacks<Cursor> {
        private CursorLoaderCallbacks() {
        }

        public Loader<Cursor> onCreateLoader(int n, Bundle bundle) {
            TopSitesPage.trace("Creating TopSitesLoader: " + n);
            return new TopSitesLoader((Context)TopSitesPage.this.getActivity());
        }

        public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
            TopSitesPage.debug("onLoadFinished: " + cursor.getCount() + " rows.");
            TopSitesPage.this.mListAdapter.swapCursor(cursor);
            TopSitesPage.this.mGridAdapter.swapCursor(cursor);
            TopSitesPage.this.updateUiFromCursor(cursor);
            int n = cursor.getColumnIndexOrThrow("url");
            if (!cursor.moveToFirst()) {
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = 1;
            do {
                arrayList.add(cursor.getString(n));
            } while (n2++ < TopSitesPage.this.mMaxGridEntries && cursor.moveToNext());
            if (arrayList.isEmpty()) {
                return;
            }
            Bundle bundle = new Bundle();
            bundle.putStringArrayList(TopSitesPage.THUMBNAILS_URLS_KEY, arrayList);
            TopSitesPage.this.getLoaderManager().restartLoader(1, bundle, (LoaderManager.LoaderCallbacks)TopSitesPage.this.mThumbnailsLoaderCallbacks);
        }

        public void onLoaderReset(Loader<Cursor> loader) {
            if (TopSitesPage.this.mListAdapter != null) {
                TopSitesPage.this.mListAdapter.swapCursor(null);
            }
            if (TopSitesPage.this.mGridAdapter != null) {
                TopSitesPage.this.mGridAdapter.swapCursor(null);
            }
        }
    }

    private static class LoadIDAwareFaviconLoadedListener
    implements OnFaviconLoadedListener {
        private volatile int loadId = 0;
        private final TopSitesGridItemView view;

        public LoadIDAwareFaviconLoadedListener(TopSitesGridItemView topSitesGridItemView) {
            this.view = topSitesGridItemView;
        }

        public void setLoadId(int n) {
            this.loadId = n;
        }

        public void onFaviconLoaded(String string2, String string3, Bitmap bitmap) {
            if (TextUtils.equals((CharSequence)this.view.getUrl(), (CharSequence)string2)) {
                this.view.displayFavicon(bitmap, string3, this.loadId);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TopSitesGridAdapter
    extends CursorAdapter {
        private Map<String, Bitmap> mThumbnails;

        public TopSitesGridAdapter(Context context, Cursor cursor) {
            super(context, cursor, 0);
        }

        public int getCount() {
            return Math.min(TopSitesPage.this.mMaxGridEntries, super.getCount());
        }

        protected void onContentChanged() {
        }

        public void updateThumbnails(Map<String, Bitmap> map) {
            this.mThumbnails = map;
            int n = TopSitesPage.this.mGrid.getChildCount();
            for (int i = 0; i < n; ++i) {
                TopSitesGridItemView topSitesGridItemView = (TopSitesGridItemView)TopSitesPage.this.mGrid.getChildAt(i);
                topSitesGridItemView.markAsDirty();
            }
            this.notifyDataSetChanged();
        }

        public void bindView(View view, Context context, Cursor cursor) {
            String string2 = "";
            String string3 = "";
            boolean bl = false;
            if (!cursor.isAfterLast()) {
                string2 = cursor.getString(cursor.getColumnIndexOrThrow("url"));
                string3 = cursor.getString(cursor.getColumnIndexOrThrow("title"));
                bl = ((BrowserDB.TopSitesCursorWrapper)cursor).isPinned();
            }
            TopSitesGridItemView topSitesGridItemView = (TopSitesGridItemView)view;
            if (TextUtils.isEmpty((CharSequence)string2)) {
                if (this.mThumbnails != null) {
                    topSitesGridItemView.blankOut();
                }
                return;
            }
            Bitmap bitmap = this.mThumbnails != null ? this.mThumbnails.get(string2) : null;
            boolean bl2 = topSitesGridItemView.updateState(string3, string2, bl, bitmap);
            if (this.mThumbnails == null || bitmap != null) {
                return;
            }
            if (!bl2) {
                TopSitesPage.debug("bindView called twice for same values; short-circuiting.");
                return;
            }
            LoadIDAwareFaviconLoadedListener loadIDAwareFaviconLoadedListener = new LoadIDAwareFaviconLoadedListener(topSitesGridItemView);
            int n = Favicons.getSizedFaviconForPageFromLocal(string2, loadIDAwareFaviconLoadedListener);
            if (n == 1) {
                return;
            }
            topSitesGridItemView.displayThumbnail(R.drawable.favicon);
            loadIDAwareFaviconLoadedListener.setLoadId(n);
            topSitesGridItemView.setLoadId(n);
        }

        public View newView(Context context, Cursor cursor, ViewGroup viewGroup) {
            return new TopSitesGridItemView(context);
        }
    }

    private class VisitedAdapter
    extends CursorAdapter {
        public VisitedAdapter(Context context, Cursor cursor) {
            super(context, cursor, 0);
        }

        public int getCount() {
            return Math.max(0, super.getCount() - TopSitesPage.this.mMaxGridEntries);
        }

        public Object getItem(int n) {
            return super.getItem(n + TopSitesPage.this.mMaxGridEntries);
        }

        public void bindView(View view, Context context, Cursor cursor) {
            int n = cursor.getPosition();
            cursor.moveToPosition(n + TopSitesPage.this.mMaxGridEntries);
            TwoLinePageRow twoLinePageRow = (TwoLinePageRow)view;
            twoLinePageRow.updateFromCursor(cursor);
        }

        public View newView(Context context, Cursor cursor, ViewGroup viewGroup) {
            return LayoutInflater.from((Context)context).inflate(R.layout.bookmark_item_row, viewGroup, false);
        }
    }

    private static class TopSitesLoader
    extends SimpleCursorLoader {
        private static final int SEARCH_LIMIT = 30;
        private int mMaxGridEntries;

        public TopSitesLoader(Context context) {
            super(context);
            this.mMaxGridEntries = context.getResources().getInteger(R.integer.number_of_top_sites);
        }

        public Cursor loadCursor() {
            TopSitesPage.trace("TopSitesLoader.loadCursor()");
            return BrowserDB.getTopSites(this.getContext().getContentResolver(), this.mMaxGridEntries, 30);
        }
    }

    private class EditPinnedSiteListener
    implements TopSitesGridView.OnEditPinnedSiteListener,
    PinSiteDialog.OnSiteSelectedListener {
        private static final String TAG_PIN_SITE = "pin_site";
        private int mPosition;

        private EditPinnedSiteListener() {
        }

        public void onEditPinnedSite(int n, String string2) {
            this.mPosition = n;
            FragmentManager fragmentManager = TopSitesPage.this.getActivity().getSupportFragmentManager();
            PinSiteDialog pinSiteDialog = (PinSiteDialog)fragmentManager.findFragmentByTag(TAG_PIN_SITE);
            if (pinSiteDialog == null) {
                pinSiteDialog = PinSiteDialog.newInstance();
            }
            pinSiteDialog.setOnSiteSelectedListener(this);
            pinSiteDialog.setSearchTerm(string2);
            pinSiteDialog.show(fragmentManager, TAG_PIN_SITE);
        }

        public void onSiteSelected(final String string2, final String string3) {
            final int n = this.mPosition;
            final Context context = TopSitesPage.this.getActivity().getApplicationContext();
            ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                public void run() {
                    BrowserDB.pinSite(context.getContentResolver(), string2, string3, n);
                }
            });
        }
    }
}

